/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.geom;

import com.comsol.geommesh.geom.GeomPrimAnalytic;
import com.comsol.geommesh.geom.GeomPrimFeature;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.util.DoublePropExpressionInfo;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.geom.Geom3;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.UnitCheck;
import com.comsol.nativeutil.properties.ac;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.ao;
import com.comsol.nativeutil.properties.aw;
import com.comsol.nativeutil.properties.bs;
import com.comsol.nativeutil.properties.ch;
import com.comsol.nativeutil.properties.cj;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.p;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.w;
import com.comsol.util.methods.FlStringUtil;

public class PrimParametricSurface
extends GeomPrimAnalytic {
    public PrimParametricSurface(String string) {
        super(string);
    }

    @Override
    protected GeomPrimFeature.TYPE a(int n2) {
        return GeomPrimFeature.TYPE.b;
    }

    @Override
    public de createPropSet(IGeomOperation.SequenceInfo sequenceInfo) {
        de de2 = super.createPropSet(sequenceInfo);
        de2.setCurrentGroupDescription("First_parameter");
        ac ac2 = new ac(0.0);
        Object object = new ds("parname1", "Name", "s1");
        object.addSideEffect(property -> this.e.getPropValueInternal("coord").internalReEvaluate());
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmin1", "Minimum", 0.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmax1", "Maximum", 1.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        de2.setCurrentGroupDescription("Second_parameter");
        object = new ds("parname2", "Name", "s2");
        object.addSideEffect(property -> this.e.getPropValueInternal("coord").internalReEvaluate());
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmin2", "Minimum", 0.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        object = new ag("parmax2", "Maximum", 1.0);
        object.annotate().bc();
        de2.registerProp((Property)object);
        de2.setCurrentGroupDescription("Expressions");
        ao ao2 = new ao(sequenceInfo.sdim, (PropAnnotationInfo.af)this.getDynamicCoordNames());
        ao2.setAllowedValuesDependProps(new String[]{"workplanesrc", "workplane"});
        UnitCheck unitCheck = new UnitCheck(PhysicalQuantityID.LENGTH.dimension(), sequenceInfo.uConv, (w)this.e);
        p p2 = new p();
        p2.add((dd)ao2);
        p2.add((dd)unitCheck);
        String[] stringArray = new String[]{"", "", ""};
        object = new aw("coord", "Expressions", stringArray, (dd)p2){

            protected String[] c() {
                return new String[]{PrimParametricSurface.this.e.getString("parname1"), PrimParametricSurface.this.e.getString("parname2")};
            }

            public void evaluate(bs bs2) {
                super.evaluate(bs2);
                if (PrimParametricSurface.this.e.isBuilt() && !PrimParametricSurface.this.e.isInitializing() && !PrimParametricSurface.this.e.getModel().isReinitializing() && !PrimParametricSurface.this.e.getModel().isClusterReinitializing()) {
                    PrimParametricSurface.this.e.setBuildStatusGen(FEATURE_STATUS.EDITED);
                    PrimParametricSurface.this.e.notifyPropertyChanged(null);
                }
            }
        };
        object.annotate().a((PropAnnotationInfo.p)new DoublePropExpressionInfo());
        de2.registerProp((Property)object);
        p2 = new p();
        p2.add((dd)ac2);
        p2.add((dd)new UnitCheck(sequenceInfo.uConv, (w)this.e));
        de2.registerProp((Property)new ag("rtol", "Relative_tolerance", 1.0E-6, (dd)p2));
        de2.registerProp((Property)new cj("maxknots", "Maximum_number_of_knots", 20, (dd)new ch(2)));
        return de2;
    }

    @Override
    public Geom doExecutePrimitive() {
        String string = this.e.getString("parname1");
        double d2 = this.e.getDouble("parmin1");
        double d3 = this.e.getDouble("parmax1");
        String string2 = this.e.getString("parname2");
        double d4 = this.e.getDouble("parmin2");
        double d5 = this.e.getDouble("parmax2");
        if (d3 <= d2 || d5 <= d4) {
            FlException flException = new FlException("Parameter_minimum_must_be_less_than_parameter_maximum");
            throw flException;
        }
        if (string.equals(string2)) {
            FlException flException = new FlException("Parameter_names_must_be_unique");
            throw flException;
        }
        String[] stringArray = this.e.getStringArray("coord");
        double d6 = this.e.getDouble("rtol");
        int n2 = this.e.getInt("maxknots");
        int n3 = 3;
        double[][][][] dArray = this.d.createSplineApproximation(string, d2, d3, string2, d4, d5, stringArray, n3, d6, n2, this.C());
        double[] dArray2 = dArray[0][0][0];
        double[] dArray3 = dArray[0][0][1];
        double[][][] dArray4 = dArray[1];
        double[] dArray5 = this.e.getDoubleArray("pos");
        double[] dArray6 = PrimParametricSurface.a(this.e);
        double d7 = PrimParametricSurface.b(this.e);
        double d8 = dArray[0][1][0][0];
        if (d8 > d6) {
            String string3 = "Maximum_relative_error_of_parametric_surface_representation_is_X#" + FlStringUtil.valueOf((double)d8);
            this.e.problem().create("warning1", "GeomWarning").set("message", string3);
        }
        double d9 = Math.max(d8, d6);
        double[][] dArray7 = PrimParametricSurface.getInputWorkPlaneTransformation((PropFeature)this.e, "workplanesrc", "workplane");
        return Geom3.a((int)n3, (double[])dArray2, (double[])dArray3, (double[][][])dArray4, (double[])dArray5, (double[])dArray6, (double)d7, (double)d9, (double[][])dArray7);
    }

    @Override
    public int maxEDimFeatureSelections(IGeomOperation.SequenceInfo sequenceInfo) {
        return 2;
    }
}

