/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.map;

import com.comsol.geommesh.map.EntityMap;
import com.comsol.geommesh.mesh.MeshOperationID;
import com.comsol.model.dbimodel.Cpl;
import com.comsol.model.dbimodel.Element;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.operations.SelectionProperty;
import com.comsol.model.operations.cpl.CplOperation;
import com.comsol.model.operations.cpl.CplOperationID;
import com.comsol.model.operations.cpl.ICplOperation;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.w;
import com.comsol.util.interfaces.IUnitConverter;
import java.util.Vector;

public class EdgeMap
extends EntityMap
implements ICplOperation {
    public EdgeMap(String string) {
        super(string);
    }

    public EdgeMap(MeshOperationID.ID iD) {
        super(iD);
    }

    public EdgeMap(CplOperationID.ID iD) {
        super(iD);
    }

    public String getDescription() {
        return "Edge_map";
    }

    public void initialize(MeshSequence meshSequence, MeshFeature meshFeature) {
        this.e = this.a(meshSequence.getGeom(), meshSequence.getSDim());
    }

    public void postCreateInitGUI(Cpl cpl) {
    }

    public void initialize(Cpl cpl) {
        this.g = cpl;
        GeomSequence geomSequence = null;
        int n2 = 3;
        if (cpl != null) {
            Cpl cpl2 = (Cpl)cpl.getContainer().getContainer();
            Model model = cpl.getModel();
            String[] stringArray = cpl2.selection().getSelectionFilter().getAllowedGeometries();
            if (stringArray.length != 1) {
                throw new RuntimeException("Internal error in similarity initialize.");
            }
            geomSequence = model.geom(stringArray[0]);
            n2 = geomSequence.getSDim();
        }
        this.e = this.a(geomSequence, n2);
        if (cpl != null) {
            this.e.setUnitConverter(cpl.getConverter());
        }
    }

    public de createPropSet(MeshFeature meshFeature, IUnitConverter iUnitConverter, int n2) {
        return this.a(meshFeature != null ? meshFeature.getSequence().getGeom() : null, n2);
    }

    private de a(GeomSequence geomSequence, int n2) {
        de de2 = new de("mapprop", "Map_properties");
        if (n2 < 2) {
            throw new RuntimeException("Unsupported dimension");
        }
        this.a(de2, geomSequence);
        return de2;
    }

    private void a(de de2, GeomSequence geomSequence) {
        GeometrySelectionFilter geometrySelectionFilter = new GeometrySelectionFilter((IGeomSequence)geomSequence, new int[]{1});
        geometrySelectionFilter.setSingleSelection(true);
        SelectionProperty selectionProperty = new SelectionProperty("srcedge", "Source_edge", (ISelectionFilter)geometrySelectionFilter);
        selectionProperty.annotate().ad();
        de2.registerProp((Property)selectionProperty);
        de2.registerProp((Property)new SelectionProperty("dstedge", "Destination_edge", (ISelectionFilter)geometrySelectionFilter));
        de2.registerProp((Property)EdgeMap.getDirectionProp());
    }

    public static ds getDirectionProp() {
        ds ds2 = new ds("direction", "Direction", "auto", (dd)new di(new String[]{"auto", "same", "opposite"}, new String[]{"Automatic_orientation", "Same_orientation", "Opposite_orientation"}));
        return ds2;
    }

    @Override
    public void getMappingProp(PropFeature propFeature, w w2) {
        String string = propFeature.getString("direction");
        int[] nArray = ((Selection)propFeature.selection("srcedge")).entities(1);
        int[] nArray2 = ((Selection)propFeature.selection("dstedge")).entities(1);
        this.a(nArray);
        this.a(nArray2);
        if (nArray2.length > 0) {
            w2.a("targetedg", nArray2);
        }
        if (nArray.length > 0) {
            w2.a("sourceedg", nArray);
        }
        w2.a("direction", string);
    }

    @Override
    public void initDefaults(GeomSequence geomSequence, PropFeature propFeature, int n2, Selection selection, Selection selection2) {
        EntityMap.a a2 = this.a(geomSequence, n2, selection, selection2);
        if (a2 != null && a2.b != null) {
            int n3 = 0;
            while (n3 < a2.b.length) {
                int[] nArray = a2.b[n3];
                if (nArray.length == 2) {
                    ((LocalSelection)propFeature.selection("srcedge")).set(new int[]{nArray[0] + 1});
                    ((LocalSelection)propFeature.selection("dstedge")).set(new int[]{n3 + 1});
                    String string = nArray[1] == 1 ? "same" : "opposite";
                    propFeature.set("direction", string);
                    break;
                }
                ++n3;
            }
        }
    }

    public Vector<Vector<String>> getPropGroups() {
        return CplOperation.getStdPropGroups((Cpl)((Cpl)this.g), (String)"Edges");
    }

    public Element toElementSyntax() {
        return null;
    }

    public void postCreateInit(MeshFeature meshFeature) {
    }

    @Override
    public void switchSelections(PropFeature propFeature) {
        int[] nArray = ((Selection)propFeature.selection("dstedge")).entities(1);
        ((LocalSelection)propFeature.selection("dstedge")).set(((Selection)propFeature.selection("srcedge")).entities(1));
        ((LocalSelection)propFeature.selection("srcedge")).set(nArray);
    }

    public void addCustomPlotProperties(de de2) {
        ds ds2 = new ds("selection", "Selection", "srcanddst", (dd)new di(new String[]{"srcanddst", "source", "destination"}, new String[]{"Source_and_destination", "Source", "Destination"}));
        ds2.annotate().i(true);
        de2.registerProp((Property)ds2);
    }

    public Selection[] getConfirmedSelectionsToPlot(de de2, PropFeature propFeature) {
        switch (de2.getFromAllProperty("selection").getString()) {
            case "source": {
                return new Selection[]{(Selection)propFeature.selection("srcedge")};
            }
            case "destination": {
                return new Selection[]{(Selection)propFeature.selection("dstedge")};
            }
        }
        return null;
    }

    public Selection[][] getFeatureSelectionsToPlot(de de2, PropFeature propFeature) {
        if ("srcanddst".equals(de2.getFromAllProperty("selection").getString())) {
            return new Selection[][]{{(Selection)propFeature.selection("srcedge")}, {(Selection)propFeature.selection("dstedge")}};
        }
        return null;
    }

    public void clearOutputSelections(boolean bl2) {
    }
}

