/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.map;

import com.comsol.geommesh.map.EntityMap;
import com.comsol.geommesh.mesh.MeshOperationID;
import com.comsol.model.dbimodel.Cpl;
import com.comsol.model.dbimodel.Element;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.LocalSelection;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.operations.SelectionProperty;
import com.comsol.model.operations.cpl.CplOperation;
import com.comsol.model.operations.cpl.CplOperationID;
import com.comsol.model.operations.cpl.ICplOperation;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.selections.GeometrySelectionFilter;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.w;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import java.util.Vector;

public class PointMap
extends EntityMap
implements ICplOperation {
    private int a;

    public PointMap(String string) {
        super(string);
        this.a = 1;
    }

    public PointMap(MeshOperationID.ID iD) {
        super(iD);
        String string = iD.c();
        if (string.equals("OnePointMap")) {
            this.a = 1;
        } else if (string.equals("TwoPointMap")) {
            this.a = 2;
        } else {
            throw new RuntimeException("Wrong ID");
        }
    }

    public PointMap(CplOperationID.ID iD) {
        super(iD);
        String string = iD.getName();
        if (string.equals("OnePointMap")) {
            this.a = 1;
        } else if (string.equals("TwoPointMap")) {
            this.a = 2;
        } else {
            throw new RuntimeException("Wrong ID");
        }
    }

    public String getDescription() {
        if (this.a == 1) {
            return "One-point_map";
        }
        if (this.a == 2) {
            return "Two-point_map";
        }
        return "Point_map";
    }

    public void initialize(MeshSequence meshSequence, MeshFeature meshFeature) {
        this.e = this.a(meshSequence.getGeom());
    }

    public void postCreateInitGUI(Cpl cpl) {
    }

    public void initialize(Cpl cpl) {
        this.g = cpl;
        GeomSequence geomSequence = null;
        if (cpl != null) {
            Cpl cpl2 = (Cpl)cpl.getContainer().getContainer();
            Model model = cpl.getModel();
            String[] stringArray = cpl2.selection().getSelectionFilter().getAllowedGeometries();
            if (stringArray.length != 1) {
                throw new RuntimeException("Internal error in similarity initialize.");
            }
            geomSequence = model.geom(stringArray[0]);
        }
        this.e = this.a(geomSequence);
        if (cpl != null) {
            this.e.setUnitConverter(cpl.getConverter());
        }
    }

    private de a(GeomSequence geomSequence) {
        de de2 = new de("mapprop", "Map_properties");
        this.a(de2, geomSequence);
        return de2;
    }

    public de createPropSet(MeshFeature meshFeature, IUnitConverter iUnitConverter, int n2) {
        if (meshFeature != null) {
            return this.a(meshFeature.getSequence().getGeom());
        }
        return this.a((GeomSequence)null);
    }

    private void a(de de2, GeomSequence geomSequence) {
        GeometrySelectionFilter geometrySelectionFilter = new GeometrySelectionFilter((IGeomSequence)geomSequence, new int[1]);
        geometrySelectionFilter.setSingleSelection(true);
        if (this.a == 1) {
            SelectionProperty selectionProperty = new SelectionProperty("srcpoint1", "Point_on_source", (ISelectionFilter)geometrySelectionFilter);
            selectionProperty.annotate().ad();
            SelectionProperty selectionProperty2 = new SelectionProperty("dstpoint1", "Point_on_destination", (ISelectionFilter)geometrySelectionFilter);
            de2.registerProp((Property)selectionProperty);
            de2.registerProp((Property)selectionProperty2);
        } else if (this.a == 2) {
            SelectionProperty selectionProperty = new SelectionProperty("srcpoint1", "First_point_on_source", (ISelectionFilter)geometrySelectionFilter);
            selectionProperty.annotate().ad().h("source");
            SelectionProperty selectionProperty3 = new SelectionProperty("dstpoint1", "First_point_on_destination", (ISelectionFilter)geometrySelectionFilter);
            selectionProperty3.annotate().h("destination");
            de2.registerProp((Property)selectionProperty);
            de2.registerProp((Property)selectionProperty3);
            selectionProperty = new SelectionProperty("srcpoint2", "Second_point_on_source", (ISelectionFilter)geometrySelectionFilter);
            selectionProperty.annotate().h("source");
            selectionProperty3 = new SelectionProperty("dstpoint2", "Second_point_on_destination", (ISelectionFilter)geometrySelectionFilter);
            selectionProperty3.annotate().h("destination");
            de2.registerProp((Property)selectionProperty);
            de2.registerProp((Property)selectionProperty3);
        } else {
            int n2 = 1;
            while (n2 <= this.a) {
                SelectionProperty selectionProperty = new SelectionProperty("srcpoint" + n2, "Point_X_on_source" + n2, (ISelectionFilter)geometrySelectionFilter);
                if (n2 == 1) {
                    selectionProperty.annotate().ad();
                }
                selectionProperty.annotate().h("source");
                SelectionProperty selectionProperty4 = new SelectionProperty("dstpoint" + n2, "Point_X_on_destination" + n2, (ISelectionFilter)geometrySelectionFilter);
                selectionProperty4.annotate().h("destination");
                de2.registerProp((Property)selectionProperty);
                de2.registerProp((Property)selectionProperty4);
                ++n2;
            }
        }
    }

    @Override
    public void getMappingProp(PropFeature propFeature, w w2) {
        int[] nArray = new int[this.a];
        int[] nArray2 = new int[this.a];
        int n2 = 1;
        while (n2 <= this.a) {
            int[] nArray3 = ((Selection)propFeature.selection("srcpoint" + n2)).entities(0);
            int[] nArray4 = ((Selection)propFeature.selection("dstpoint" + n2)).entities(0);
            if (nArray3.length != 1) {
                throw new FlException(this.a == 1 ? "You_must_specify_the_source_point" : "You_must_specify_all_source_points");
            }
            if (nArray4.length != 1) {
                throw new FlException(this.a == 1 ? "You_must_specify_the_destination_point" : "You_must_specify_all_destination_points");
            }
            nArray[n2 - 1] = nArray3[0];
            nArray2[n2 - 1] = nArray4[0];
            ++n2;
        }
        this.a(nArray);
        this.a(nArray2);
        w2.a("sourcevtx", nArray);
        w2.a("destinationvtx", nArray2);
    }

    @Override
    public void initDefaults(GeomSequence geomSequence, PropFeature propFeature, int n2, Selection selection, Selection selection2) {
        int n3 = 0;
        EntityMap.a a2 = this.a(geomSequence, n2, selection, selection2);
        if (a2 != null && a2.a != null) {
            int n4 = 0;
            while (n4 < a2.a.length) {
                if (a2.a[n4] >= 0) {
                    ((LocalSelection)propFeature.selection("srcpoint" + (n3 + 1))).set(new int[]{a2.a[n4] + 1});
                    ((LocalSelection)propFeature.selection("dstpoint" + (n3 + 1))).set(new int[]{n4 + 1});
                    if (++n3 >= this.a) break;
                }
                ++n4;
            }
        }
    }

    public Vector<Vector<String>> getPropGroups() {
        if (!this.getID().equals(CplOperationID.ID.POINTMAP2.getName())) {
            return CplOperation.getStdPropGroups((Cpl)((Cpl)this.g), (String)"Points");
        }
        Vector<Vector<String>> vector = new Vector<Vector<String>>();
        Vector<String> vector2 = new Vector<String>();
        vector2.add("Source_points");
        vector2.add("true");
        vector2.add("true");
        vector2.add("srcpoint1");
        vector2.add("srcpoint2");
        vector.add(vector2);
        vector2 = new Vector();
        vector2.add("Destination_points");
        vector2.add("true");
        vector2.add("true");
        vector2.add("dstpoint1");
        vector2.add("dstpoint2");
        vector.add(vector2);
        return vector;
    }

    public Element toElementSyntax() {
        return null;
    }

    public void postCreateInit(MeshFeature meshFeature) {
    }

    @Override
    public void switchSelections(PropFeature propFeature) {
        int n2 = 1;
        while (n2 <= this.a) {
            int[] nArray = ((Selection)propFeature.selection("dstpoint" + n2)).entities(0);
            ((LocalSelection)propFeature.selection("dstpoint" + n2)).set(((Selection)propFeature.selection("srcpoint" + n2)).entities(0));
            ((LocalSelection)propFeature.selection("srcpoint" + n2)).set(nArray);
            ++n2;
        }
    }

    public void addCustomPlotProperties(de de2) {
        ds ds2 = new ds("selection", "Selection", "srcanddst", (dd)new di(new String[]{"srcanddst", "source", "destination"}, new String[]{"Source_and_destination", "Source", "Destination"}));
        ds2.annotate().i(true);
        de2.registerProp((Property)ds2);
    }

    public Selection[] getConfirmedSelectionsToPlot(de de2, PropFeature propFeature) {
        switch (de2.getFromAllProperty("selection").getString()) {
            case "source": {
                Selection[] selectionArray;
                if ("OnePointMap".equals(this.c)) {
                    Selection[] selectionArray2 = new Selection[1];
                    selectionArray = selectionArray2;
                    selectionArray2[0] = (Selection)propFeature.selection("srcpoint1");
                } else {
                    Selection[] selectionArray3 = new Selection[2];
                    selectionArray3[0] = (Selection)propFeature.selection("srcpoint1");
                    selectionArray = selectionArray3;
                    selectionArray3[1] = (Selection)propFeature.selection("srcpoint2");
                }
                return selectionArray;
            }
            case "destination": {
                Selection[] selectionArray;
                if ("OnePointMap".equals(this.c)) {
                    Selection[] selectionArray4 = new Selection[1];
                    selectionArray = selectionArray4;
                    selectionArray4[0] = (Selection)propFeature.selection("dstpoint1");
                } else {
                    Selection[] selectionArray5 = new Selection[2];
                    selectionArray5[0] = (Selection)propFeature.selection("dstpoint1");
                    selectionArray = selectionArray5;
                    selectionArray5[1] = (Selection)propFeature.selection("dstpoint2");
                }
                return selectionArray;
            }
        }
        return null;
    }

    public Selection[][] getFeatureSelectionsToPlot(de de2, PropFeature propFeature) {
        if ("srcanddst".equals(de2.getFromAllProperty("selection").getString())) {
            if ("OnePointMap".equals(this.c)) {
                return new Selection[][]{{(Selection)propFeature.selection("srcpoint1")}, {(Selection)propFeature.selection("dstpoint1")}};
            }
            return new Selection[][]{{(Selection)propFeature.selection("srcpoint1"), (Selection)propFeature.selection("srcpoint2")}, {(Selection)propFeature.selection("dstpoint1"), (Selection)propFeature.selection("dstpoint2")}};
        }
        return null;
    }

    public void clearOutputSelections(boolean bl2) {
    }
}

