/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.mesh;

import com.comsol.core.t;
import com.comsol.geommesh.mesh.MeshOperation;
import com.comsol.geommesh.mesh.MeshOperationID;
import com.comsol.geommesh.mesh.MeshProblemOperation;
import com.comsol.geommesh.mesh.SolutionDependentOperation;
import com.comsol.geommesh.mesh.p;
import com.comsol.geommesh.mesh.q;
import com.comsol.geommesh.mesh.s;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.data.Primitives;
import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.data.events.NAMED_EVENT;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.GeomInfo;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshProblemFeature;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SOLVER_MODE;
import com.comsol.model.dbimodel.SolutionInfo;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.SolverSequenceList;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.XMeshNative;
import com.comsol.model.operations.MeshBuildData;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.EventWrapper;
import com.comsol.model.util.MetaModelUtil;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.mesh.InterpolationMatrix;
import com.comsol.nativemph.mesh.Mesh;
import com.comsol.nativemph.mesh.MeshLibOperation;
import com.comsol.nativemph.mesh.h;
import com.comsol.nativemph.util.f;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.nativeutil.constants.b;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.w;
import com.comsol.util.classes.bg;
import com.comsol.util.cluster.a;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlNumberUtil;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;

public class MeshAdapt
extends SolutionDependentOperation {
    static final MeshOperation.c a = new MeshOperation.c(new int[]{1, 2, 3}, new int[]{1, 2, 3});

    public MeshAdapt(MeshOperationID.ID iD) {
        super(iD);
    }

    public String getDescription() {
        return "Adapt";
    }

    @Override
    public de createPropSet(MeshFeature meshFeature, IUnitConverter iUnitConverter, int n2) {
        de de2 = new de("meshadaptprop", "Mesh_adapt_properties");
        com.comsol.geommesh.mesh.q.a(meshFeature, n2, de2);
        return de2;
    }

    @Override
    public void addEventHandlers(EventManagerWrapper eventManagerWrapper, MeshSequence meshSequence, MeshFeature meshFeature) {
        super.addEventHandlers(eventManagerWrapper, meshSequence, meshFeature);
        String string = meshFeature.getString("solution");
        if (!"none".equals(string)) {
            SolverSequence solverSequence = (SolverSequence)meshFeature.getPropertyReference("solution");
            SolutionInfo solutionInfo = solverSequence.getSolutioninfo();
            eventManagerWrapper.addTouchedEventHandler((ModelEntity)solutionInfo, "solutionTouched", (IEventHandler)meshFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
        }
        eventManagerWrapper.addPropertyEventHandler((PropFeature)meshFeature, "solutionChanged", (IEventHandler)meshFeature, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, new String[]{"solution"});
        eventManagerWrapper.addNamedEventHandler((ModelEntity)meshFeature.getSequence().getGeom(), "geomUnitChanged", (IEventHandler)meshFeature, NAMED_EVENT.REFRESH_GEOM_UNIT_CONVERTER, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT, new String[0]);
    }

    @Override
    public void handleEvent(EventWrapper eventWrapper) {
        super.handleEvent(eventWrapper);
        String string = eventWrapper.getTag();
        if ("solutionTouched".equals(string)) {
            Model model = this.p.getModel();
            if (model != null && model.isClusterReinitializing()) {
                return;
            }
            SolverSequence solverSequence = (SolverSequence)this.p.getPropertyReference("solution");
            if (!com.comsol.core.t.a((SolverSequence)solverSequence, (int)this.r)) {
                this.p.set("solution", "none");
            }
            if (solverSequence != null && solverSequence.getSolverMode() != SOLVER_MODE.RUNNING) {
                if (MeshAdapt.a(eventWrapper, solverSequence, this.q)) {
                    return;
                }
                this.p.set("solupdatenum", this.p.getInt("solupdatenum") + 1);
            }
        } else if ("solutionChanged".equals(string)) {
            SolutionInfo solutionInfo;
            EventManagerWrapper eventManagerWrapper = new EventManagerWrapper((PrimitiveModelEntity)this.p);
            SolverSequence solverSequence = (SolverSequence)eventWrapper.getOldPropertyValue();
            if (solverSequence != null) {
                solutionInfo = solverSequence.getSolutioninfo();
                eventManagerWrapper.removeTouchedEventHandler((ModelEntity)solutionInfo, "solutionTouched", (IEventHandler)this.p, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
            }
            if ((solutionInfo = (SolverSequence)eventWrapper.getNewPropertyValue()) != null) {
                SolutionInfo solutionInfo2 = solutionInfo.getSolutioninfo();
                eventManagerWrapper.addTouchedEventHandler((ModelEntity)solutionInfo2, "solutionTouched", (IEventHandler)this.p, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
            }
        }
        if ("geomUnitChanged".equals(string)) {
            this.p.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            this.disposeOperation();
        }
    }

    static boolean a(EventWrapper eventWrapper, SolverSequence solverSequence, MeshSequence meshSequence) {
        Study study = solverSequence.getStudyFeature();
        Study study2 = meshSequence.getAdaptionStudy();
        if (study2 != null && study == study2 && eventWrapper.getNewValue() instanceof String) {
            String string = (String)eventWrapper.getNewValue();
            for (PropFeature propFeature : solverSequence.feature()) {
                for (PropFeature propFeature2 : propFeature.getFeature()) {
                    if (!propFeature2.isActive() || !propFeature2.getOperationID().equals("Adaption")) continue;
                    return true;
                }
                if (propFeature.tag().equals(string)) break;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected Mesh a(MeshBuildData meshBuildData, p p2, boolean bl2) {
        String string;
        Object object;
        int n2;
        Object object2;
        Object object3;
        Mesh mesh = meshBuildData.mesh;
        this.c = true;
        if (this.r > 2 && this.q.isImportSequence()) {
            HashSet<Integer> hashSet = new HashSet<Integer>();
            if (this.p.selection().isGeom()) {
                int n4 = this.d()[2];
                while (n4 > 0) {
                    hashSet.add(n4);
                    --n4;
                }
            } else {
                void var9_20;
                void var9_18;
                int n3;
                Object object4;
                void var9_16;
                int n4;
                void var9_14;
                GeomInfo geomInfo = this.q.infoCurrent();
                object3 = this.p.selection().entities(2);
                int n7 = ((int[])object3).length;
                boolean n32 = false;
                while (var9_14 < n7) {
                    n4 = object3[var9_14];
                    hashSet.add(n4);
                    ++var9_14;
                }
                object2 = geomInfo.getAdjMesh(3, 2);
                object3 = this.p.selection().entities(3);
                n7 = ((int[])object3).length;
                boolean bl3 = false;
                while (var9_16 < n7) {
                    n4 = object3[var9_16];
                    object4 = object2[n4];
                    n2 = ((Object)object4).length;
                    n3 = 0;
                    while (n3 < n2) {
                        object = object4[n3];
                        hashSet.add((Integer)object);
                        ++n3;
                    }
                    ++var9_16;
                }
                object2 = geomInfo.getAdjMesh(2, 2);
                Integer[] integerArray = hashSet.toArray(new Integer[0]);
                object3 = integerArray;
                n7 = integerArray.length;
                boolean bl4 = false;
                while (var9_18 < n7) {
                    n4 = object3[var9_18].intValue();
                    object4 = object2[n4];
                    n2 = ((Object)object4).length;
                    n3 = 0;
                    while (n3 < n2) {
                        object = object4[n3];
                        hashSet.add((Integer)object);
                        ++n3;
                    }
                    ++var9_18;
                }
                object2 = geomInfo.getAdjMesh(1, 2);
                object3 = this.p.selection().entities(1);
                n7 = ((int[])object3).length;
                boolean bl5 = false;
                while (var9_20 < n7) {
                    n4 = object3[var9_20];
                    object4 = object2[n4];
                    n2 = ((Object)object4).length;
                    n3 = 0;
                    while (n3 < n2) {
                        object = object4[n3];
                        hashSet.add((Integer)object);
                        ++n3;
                    }
                    ++var9_20;
                }
            }
            MeshProblemFeature meshProblemFeature = this.b(hashSet);
            if (meshProblemFeature != null) {
                throw ((MeshProblemOperation)meshProblemFeature.getOperation()).createException();
            }
        }
        double d2 = 1.0;
        object2 = this.p.getString("exprtype");
        String string2 = string = this.r > 1 ? this.p.getString("method") : "regular";
        if (((String)object2).equals("metric")) {
            string = "modify";
        }
        boolean bl6 = ((String)object2).equals("error");
        String string3 = this.p.getString("solution");
        if ("none".equals(string3) && bl6) {
            throw new FlException("No_solution_data_available");
        }
        object3 = new f();
        this.o.toLibProp((w)object3, new String[]{"errorexpr"});
        this.a((w)object3, mesh);
        object = this.a(this.p);
        object3.b("adapedim", new int[]{object});
        f f2 = new f();
        n2 = "size".equals(object2) && "modify".equals(string) ? 1 : 0;
        boolean bl7 = false;
        double d3 = 0.0;
        SolverSequence solverSequence = (SolverSequence)this.p.getPropertyReference("solution");
        boolean bl8 = false;
        if ("none".equals(string3)) {
            double d4 = this.p.getDouble("updatecondition");
            double d5 = this.q();
            long l2 = mesh.A();
            if (this.p() != l2 || d4 != d5) {
                this.o();
            }
            if (n2 != 0) {
                try {
                    String string4 = this.p.getString("sizeexpr");
                    IUnitConverter iUnitConverter = this.p.getModel().modelNode(this.p.model()).getStoredConverter();
                    b.b[] bArray = this.p.getParamDatabaseForEval().a(null, string4, iUnitConverter, this.p.scopeDot());
                    if (bArray.length == 1) {
                        d3 = bArray[0].a() / this.q.getGeom().geomScaleFactor();
                        bl7 = true;
                    }
                }
                catch (FlException flException) {}
                if (bl7 && !(d3 > 0.0)) {
                    throw new FlException("Negative_or_zero_mesh_element_size_not_allowed").addParameterPair("Value", d3);
                }
            }
            if (!bl7) {
                com.comsol.nativeutil.runnable.s.a((String)"Adapting_mesh", (double)0.0, (double)0.1, (String[])new String[0], (String)"Adapt", (String)"", (double)0.0, (boolean)false, (String)"", (boolean)false, (boolean)false);
                try {
                    this.c((f)object3, meshBuildData);
                }
                finally {
                    com.comsol.nativeutil.runnable.s.a();
                }
                d2 = 0.9;
            }
            solverSequence = this.n();
            this.c(l2);
            this.a(d4);
            bl8 = true;
        } else {
            this.o();
        }
        if (this.a(mesh)) {
            this.a(mesh.x());
            this.p.setCacheTagImported(0L);
            return mesh;
        }
        SolverSequence solverSequence2 = solverSequence;
        if ("modify".equals(string)) {
            f f3;
            if (!bl8) {
                f3 = new f();
                object = this.a(this.p);
                f3.b("adapedim", new int[]{object});
                this.a(f3, (f)object3, solverSequence2);
            }
            if (!this.p.getBoolean("allowcoarsening") && !this.p.getString("exprtype").equals("metric")) {
                object3.e("nocoarsen", 1);
            } else {
                object3.d("maxcoarsening", this.p.getDouble("maxcoarsening"));
            }
            object3.d("maxrefinement", this.p.getDouble("maxrefinement"));
            f3 = null;
            if (!this.q.isImportSequence()) {
                f3 = meshBuildData.geom.getGeom();
            }
            this.a((f)object3);
            if (bl7) {
                object3.c("constantsize", d3);
            }
            mesh = h.a((Mesh)mesh, (Geom)f3, (w)object3, (w)f2, (MeshLibOperation)MeshLibOperation.f).e();
            this.a(f2.N("mesheddom"));
        } else {
            if (this.c && (solverSequence2 == null || solverSequence2.getSolution() == null)) {
                throw new FlException("No_solution_data_available");
            }
            com.comsol.geommesh.mesh.s.a((w)object3, this.p);
            f f4 = new f();
            object = this.a(this.p);
            f4.b("adapedim", new int[]{object});
            Integer n5 = (Integer)this.p.getNode().dGet("timeadapt");
            int n6 = n5 != null ? n5 : -1;
            f4.d("timeadap", n6);
            if (n6 > 0) {
                f4.f("pattern", "gp");
                f4.e("gporder", 2);
            }
            Xmesh[] xmeshArray = new Xmesh[1];
            Mesh mesh2 = mesh;
            ModelInternalUtil.clusterRootOnlyOperation((String)"Error", () -> this.b(solverSequence2, mesh2, (f)object3, f4, xmeshArray));
            com.comsol.geommesh.mesh.s.a((w)f4, this.p);
            int n7 = 0;
            int n8 = 1;
            n7 = this.r == 1 ? (int)Math.round(this.p.getDouble("maxrefinement")) : (this.p.getString("rmethod").equals("longest") ? (int)Math.round(this.p.getDouble("maxrefinement") * 2.0) : (int)Math.round(this.p.getDouble("maxrefinement")));
            if (bl6) {
                n8 = n7;
                n7 = 1;
                object3.c("maxrefinement", (double)n8);
            }
            this.s = null;
            int n9 = 0;
            while (n9 < n7) {
                com.comsol.nativeutil.runnable.s.a((String)"Adapting_mesh", (double)(1.0 - d2), (double)(d2 / 3.0), (String[])new String[0], (String)"Adapt", (String)"", (double)0.0, (boolean)false, (String)"", (boolean)false, (boolean)false);
                d2 -= d2 / 3.0;
                try {
                    Mesh[] meshArray = new Mesh[]{mesh};
                    Double d6 = (Double)this.p.getNode().dGet("elfrac");
                    if (d6 != null && d6 > -1.0) {
                        object3.d("elfrac", d6.doubleValue());
                    } else {
                        object3.d("elfrac", -1.0);
                    }
                    if (!this.a(f4, (f)object3, (String)object2, xmeshArray[0], meshArray)) break;
                    mesh = meshArray[0];
                    Geom geom = null;
                    if (!this.q.isImportSequence()) {
                        geom = meshBuildData.geom.getGeom();
                    }
                    mesh = h.a((Mesh)mesh, (Geom)geom, (w)object3, (w)f2, (MeshLibOperation)MeshLibOperation.e).e();
                    int[][] nArray = f2.N("mesheddom");
                    if (this.s == null) {
                        this.a(nArray);
                    } else {
                        int n10 = 0;
                        while (n10 < nArray.length) {
                            int n11 = 0;
                            while (n11 < nArray[n10].length) {
                                if (nArray[n10][n11] != 0) {
                                    this.s[n10][n11] = 1;
                                }
                                ++n11;
                            }
                            ++n10;
                        }
                    }
                }
                finally {
                    com.comsol.nativeutil.runnable.s.a();
                }
                ++n9;
            }
        }
        this.p.setCacheTagImported(mesh.A());
        return mesh;
    }

    private void a(f f2) {
        String string = this.p.getString("exprtype");
        boolean bl2 = string.equals("error");
        if (bl2) {
            f2.e("sizefield", 1);
        } else {
            boolean bl3 = string.equals("metric");
            f2.e("sizefield", bl3 ? 0 : 1);
        }
    }

    private void a(f f2, f f3, SolverSequence solverSequence) {
        Mesh[] meshArray = new Mesh[]{new Mesh()};
        InterpolationMatrix[] interpolationMatrixArray = new InterpolationMatrix[]{new InterpolationMatrix()};
        boolean[] blArray = new boolean[]{true};
        ModelInternalUtil.clusterRootOnlyOperation((String)"No_solution_data_available", () -> {
            this.b(f2, f3, solverSequence);
            f3.k("mesh");
            f3.k("interpolationmatrix");
            meshArray[0] = f3.a("mesh");
            interpolationMatrixArray[0] = f3.b("interpolationmatrix");
            blArray[0] = false;
        });
        com.comsol.util.cluster.a.c((Object)meshArray[0], (int)0);
        com.comsol.util.cluster.a.c((Object)interpolationMatrixArray[0], (int)0);
        if (blArray[0]) {
            f3.a("mesh", meshArray[0]);
            f3.a("interpolationmatrix", interpolationMatrixArray[0]);
        }
    }

    private void b(f f2, f f3, SolverSequence solverSequence) {
        if (solverSequence == null || solverSequence.getSolution() == null) {
            throw new FlException("No_solution_data_available");
        }
        String string = this.p.getString("exprtype");
        boolean bl2 = string.equals("error");
        XMeshNative xMeshNative = solverSequence.getXmesh();
        if (xMeshNative == null) {
            throw new FlException("No_solution_data_available");
        }
        Xmesh xmesh = xMeshNative.getXmesh();
        int n2 = 0;
        GeomSequence geomSequence = this.q.getGeom();
        int n3 = com.comsol.geommesh.mesh.s.a(xmesh, geomSequence.tag(), geomSequence.getSDim());
        String string2 = xmesh.i()[n3 - 1];
        Mesh mesh = xmesh.b(n3, n2);
        f f4 = new f();
        f4.f("geom", string2);
        f4.a("u", solverSequence.getSolution());
        f4.d("geomnum", n3);
        int n4 = this.a(this.p);
        f4.b("adapedim", new int[]{n4});
        if (bl2) {
            com.comsol.geommesh.mesh.s.a((w)f2, this.p, n3);
            f4.e("refine", 0);
            InterpolationMatrix interpolationMatrix = new InterpolationMatrix();
            f3.a("interpolationmatrix", interpolationMatrix);
            xmesh.a((w)f2, (w)f3, (w)f4);
        } else {
            String[] stringArray;
            f4.a("frame", new String[]{"mesh"});
            boolean bl3 = string.equals("metric");
            if (bl3) {
                stringArray = MeshAdapt.a(this.p.getStringMatrix("metric"));
            } else {
                String[] stringArray2 = new String[1];
                stringArray = stringArray2;
                stringArray2[0] = this.p.getString("sizeexpr");
            }
            String[] stringArray3 = stringArray;
            MeshAdapt.a(this.p, f4, stringArray3, solverSequence, xmesh, mesh, f3);
        }
    }

    private static String[] a(String[][] stringArray) {
        int n2 = stringArray.length;
        String[] stringArray2 = new String[n2 * (n2 + 1) / 2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = 0;
            while (n5 < n2 - n4) {
                stringArray2[n3++] = stringArray[n5][n5 + n4];
                ++n5;
            }
            ++n4;
        }
        return stringArray2;
    }

    void a(SolverSequence solverSequence, Mesh mesh, f f2, f f3, Xmesh[] xmeshArray) {
        XMeshNative xMeshNative = solverSequence.getXmesh();
        if (xMeshNative == null) {
            throw new FlException("No_solution_data_available");
        }
        xmeshArray[0] = xMeshNative.getXmesh();
        int n2 = com.comsol.geommesh.mesh.s.a(xmeshArray[0], this.q.geom(), this.q.getSDim());
        double d2 = this.q.getGeom().geomScaleFactor() / xmeshArray[0].a().getGeometryScale(n2);
        if (Math.abs(1.0 - d2) > 1.0E-6) {
            throw new FlException("No_solution_data_available");
        }
        long l2 = mesh.A();
        Mesh mesh2 = xmeshArray[0].b(n2, 0);
        boolean bl2 = l2 != 0L && mesh2.A() != l2;
        Xmesh xmesh = com.comsol.geommesh.mesh.s.a(solverSequence, f3, this.p, n2, xmeshArray[0], l2, mesh, bl2);
        if (xmesh != null) {
            xmeshArray[0] = xmesh;
        }
        com.comsol.geommesh.mesh.s.a((w)f2, this.p);
        String string = this.p.getString("exprtype");
        if ("error".equals(string)) {
            com.comsol.geommesh.mesh.s.a((w)f2, this.p, n2);
        } else if ("size".equals(string)) {
            f3.a("postallowfailingblocks", "on");
            double[] dArray = com.comsol.geommesh.mesh.s.a((PropFeature)this.p, solverSequence, true);
            f3.c("weights", dArray);
            String string2 = this.p.getString("sizeexpr");
            String[] stringArray = new String[]{string2};
            IVariableData iVariableData = this.p.getModel().physics().getVarData();
            stringArray[0] = iVariableData.replaceWithCompleteNames(stringArray[0], this.p.scopeDot());
            stringArray[0] = iVariableData.checkRemoveRoot(stringArray[0]);
            IUnitConverter iUnitConverter = this.p.getModel().modelNode(this.p.model()).getStoredConverter();
            stringArray = Xmesh.b((String[])stringArray, (w)f3, (IUnitConverter)iUnitConverter);
            f3.f("sizeexpr", stringArray);
            com.comsol.geommesh.mesh.s.a((w)f3, this.p);
        }
        this.b((w)f3, mesh);
    }

    private boolean a(f f2, f f3, String string, Xmesh xmesh, Mesh[] meshArray) {
        Object object;
        boolean[] blArray = new boolean[]{true};
        InterpolationMatrix interpolationMatrix = new InterpolationMatrix();
        f3.a("elementmatrix", interpolationMatrix);
        ModelInternalUtil.clusterRootOnlyOperation((String)"Error", () -> this.a(f2, f3, string, xmesh, meshArray, blArray));
        Boolean bl2 = blArray[0];
        Object[] objectArray = com.comsol.util.cluster.a.b((Object)bl2);
        boolean bl3 = false;
        Object[] objectArray2 = objectArray;
        int n2 = objectArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = objectArray2[n3];
            if (!((Boolean)object).booleanValue()) {
                bl3 = true;
            }
            ++n3;
        }
        if (bl3) {
            com.comsol.util.cluster.a.c((Object)interpolationMatrix, (int)0);
            f3.a("elementmatrix", interpolationMatrix);
            object = interpolationMatrix.b();
            assert (((Object)object).length <= 1);
            if (((Object)object).length == 1) {
                Object object2 = object[0][0];
                this.p.getNode().dSet("elfrac", (Object)((double)object2));
            }
            return true;
        }
        return false;
    }

    private void a(f f2, f f3, String string, Xmesh xmesh, Mesh[] meshArray, boolean[] blArray) {
        if ("error".equals(string)) {
            f2.a("postallowfailingblocks", "on");
            xmesh.a((w)f3, (w)f2, meshArray[0]);
            if (!f3.l("elementmatrix")) {
                blArray[0] = true;
                return;
            }
        } else if ("size".equals(string)) {
            this.a((w)f2, meshArray[0]);
            boolean bl2 = xmesh.a(meshArray[0], (w)f2, (w)f3);
            if (!bl2) {
                blArray[0] = true;
                return;
            }
        }
        blArray[0] = false;
    }

    @Override
    MeshOperation.c a() {
        return a;
    }

    @Override
    public double getWorkEstimate() {
        return 5.0;
    }

    public boolean isCacheCriticalOperation() {
        return this.q.isImportSequence() && this.q.getImportAssoc().getAssoc().h();
    }

    public boolean preCreateReset(MeshFeature meshFeature, boolean bl2) {
        super.preCreateReset(meshFeature, bl2);
        MeshAdapt.a(this.p, meshFeature, bl2);
        return false;
    }

    static void a(MeshFeature meshFeature, MeshFeature meshFeature2, boolean bl2) {
        ModelEntity modelEntity;
        if (!bl2 && (modelEntity = meshFeature.getPropertyReference("solution")) != null) {
            SolverSequenceList solverSequenceList = meshFeature2.getModel().sol();
            if (!solverSequenceList.hasTag(modelEntity.tag())) {
                solverSequenceList.create(modelEntity.tag());
            }
            meshFeature2.getModel().mesh().autorunResetSequence(meshFeature2.getSequence().tag(), false);
        }
    }

    @Override
    public void postCreateInit(MeshFeature meshFeature) {
        super.postCreateInit(meshFeature);
        double d2 = meshFeature.getSequence().getGeomDimension()[0];
        double d3 = this.q.getGeom().lengthUnitValue();
        IUnitConverter iUnitConverter = meshFeature.getModel().modelNode(meshFeature.model()).getStoredConverter();
        double d4 = iUnitConverter.convertToUnit(1.0, "m");
        double d5 = d3 / d4;
        double d6 = this.r == 3 ? 10 : 15;
        String string = FlNumberUtil.b((double)(d2 *= d5 / d6), (int)2, (double)(d2 * 1.0E-10));
        this.o.mute();
        try {
            meshFeature.set("sizeexpr", string);
        }
        finally {
            this.o.unmute();
        }
        com.comsol.nativeutil.properties.q q2 = (com.comsol.nativeutil.properties.q)this.o.getProperty("solution");
        q2.activateSideEffects();
        meshFeature.setKey(meshFeature.generateKey());
        meshFeature.setStatus(FEATURE_STATUS.NEEDS_REBUILD);
    }

    @Override
    protected void a(f f2, MeshBuildData meshBuildData) {
        boolean bl2;
        boolean bl3 = true;
        boolean bl4 = !this.k() || this.n() == null && this.n().getXmesh() == null;
        boolean bl5 = bl2 = bl3 && bl4;
        if (bl2) {
            this.a(meshBuildData);
        }
        this.b(f2, meshBuildData);
    }

    private void a(MeshBuildData meshBuildData) {
        this.disposeOperation();
        try {
            Model model = this.l();
            MeshSequence meshSequence = this.p.getSequence();
            MeshSequence meshSequence2 = model.mesh(meshSequence.tag());
            if (!meshSequence.isImportSequence()) {
                Mesh mesh = meshBuildData.mesh;
                meshSequence2.setMesh(mesh.C(), mesh.getIdentifyingTag());
                meshSequence2.setLockedMesh(true);
            } else {
                for (MeshSequence meshSequence3 : model.mesh().getActiveList()) {
                    if (!meshSequence3.geom().equals(meshSequence2.geom())) continue;
                    if (meshSequence3 != meshSequence2) {
                        model.mesh().remove(meshSequence3.tag());
                        continue;
                    }
                    Mesh mesh = meshSequence.getMeshCurrent();
                    if (mesh.f()) {
                        mesh = mesh.P();
                    }
                    String[] stringArray = meshSequence3.feature().tags();
                    int n2 = 0;
                    while (n2 < stringArray.length - 1) {
                        meshSequence3.feature(stringArray[n2]).active(false);
                        ++n2;
                    }
                    MeshFeature meshFeature = meshSequence3.create("imp", "Import");
                    meshFeature.set("filename", "~none~.mphbin");
                    meshFeature.setImportedMesh(mesh.C());
                    meshFeature.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
                    meshFeature.setKey(meshFeature.generateKey());
                }
                meshSequence2.run();
            }
            MeshAdapt.a(this.m(), meshSequence2.tag(), "none");
        }
        catch (FlException flException) {
            this.o();
            throw flException;
        }
    }

    void b(f f2, MeshBuildData meshBuildData) {
        SolverSequence solverSequence = this.n();
        if (solverSequence == null) {
            this.a(meshBuildData);
            solverSequence = this.n();
        }
        f f3 = new f();
        this.b(f3, f2, solverSequence);
    }

    @Override
    protected void a(MeshBuildData meshBuildData, boolean bl2) {
        double d2;
        double d3;
        super.a(meshBuildData, bl2);
        String string = this.p.getString("solution");
        if ("none".equals(string) && (d3 = this.q()) != (d2 = this.p.getDouble("updatecondition"))) {
            this.p.setCacheTagImported(0L);
        }
    }

    public void forceUpdate() {
        if (this.p != null) {
            double d2 = this.q();
            this.a(1.0 - d2);
            this.p.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            this.p.setCacheTagImported(0L);
        }
        this.o();
        this.c(0L);
    }

    public void disposeOperation() {
        super.disposeOperation();
        this.o();
    }

    @Override
    public void importData(MeshSequence meshSequence, MeshFeature meshFeature) {
        this.forceUpdate();
    }

    @Override
    public List<bg<String, Primitives>> getExtraTransientAttributes() {
        ArrayList<bg<String, Primitives>> arrayList = new ArrayList<bg<String, Primitives>>(super.getExtraTransientAttributes());
        arrayList.add((bg<String, Primitives>)bg.a((Object)"elfrac", (Object)Primitives.DOUBLE));
        arrayList.add((bg<String, Primitives>)bg.a((Object)"timeadapt", (Object)Primitives.INT));
        return arrayList;
    }

    private /* synthetic */ void b(SolverSequence solverSequence, Mesh mesh, f f2, f f3, Xmesh[] xmeshArray) {
        this.a(solverSequence, mesh, f2, f3, xmeshArray);
    }
}

