/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni.util;

import com.comsol.nativejni.CPointer;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeObject;
import com.comsol.nativejni.util.Prop;
import com.comsol.util.exceptions.FlException;

public class SparseExch
extends FlNativeObject {
    public boolean isReal() throws FlNativeException {
        return this.isReal(this.getCPointer());
    }

    public int getN() throws FlNativeException {
        return this.getN(this.getCPointer());
    }

    public int getM() throws FlNativeException {
        return this.getM(this.getCPointer());
    }

    public int getNnz() throws FlNativeException {
        return this.getNnz(this.getCPointer());
    }

    public int[][] getIdx() throws FlNativeException {
        int n = this.getNnz(this.getCPointer());
        int[][] nArray = new int[2][n];
        this.getIdx(this.getCPointer(), nArray);
        return nArray;
    }

    public int[][] getIdxBlock(int n, int n2) throws FlNativeException {
        if (n < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n2 < 1) {
            throw new FlException("Stop_index_must_be_greater_than_0");
        }
        if (n2 < n) {
            throw new FlException("Stop_index_must_be_greater_than_or_equal_to_start_index");
        }
        int n3 = this.getNnz(this.getCPointer());
        int n4 = n3 >= n ? n : n3 + 1;
        int n5 = n3 >= n2 ? n2 : n3;
        int n6 = n5 - n4 + 1;
        int[][] nArray = new int[2][n6];
        this.getIdxBlock(this.getCPointer(), nArray, n, n2);
        return nArray;
    }

    public double[] getReal() throws FlNativeException {
        int n = this.getNnz(this.getCPointer());
        double[] dArray = new double[n];
        this.getReal(this.getCPointer(), dArray);
        return dArray;
    }

    public double[] getRealBlock(int n, int n2) throws FlNativeException {
        if (n < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n2 < 1) {
            throw new FlException("Stop_index_must_be_greater_than_0");
        }
        if (n2 < n) {
            throw new FlException("Stop_index_must_be_greater_than_or_equal_to_start_index");
        }
        int n3 = this.getNnz(this.getCPointer());
        int n4 = n3 >= n ? n : n3 + 1;
        int n5 = n3 >= n2 ? n2 : n3;
        int n6 = n5 - n4 + 1;
        double[] dArray = new double[n6];
        this.getRealBlock(this.getCPointer(), dArray, n, n2);
        return dArray;
    }

    public double[] getImag() throws FlNativeException {
        int n = this.getNnz(this.getCPointer());
        double[] dArray = new double[n];
        this.getImag(this.getCPointer(), dArray);
        return dArray;
    }

    public double[] getImagBlock(int n, int n2) throws FlNativeException {
        if (n < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n2 < 1) {
            throw new FlException("Stop_index_must_be_greater_than_0");
        }
        if (n2 < n) {
            throw new FlException("Stop_index_must_be_greater_than_or_equal_to_start_index");
        }
        int n3 = this.getNnz(this.getCPointer());
        int n4 = n3 >= n ? n : n3 + 1;
        int n5 = n3 >= n2 ? n2 : n3;
        int n6 = n5 - n4 + 1;
        double[] dArray = new double[n6];
        this.getImagBlock(this.getCPointer(), dArray, n, n2);
        return dArray;
    }

    public double getColPtr() throws FlNativeException {
        return this.getColPtr(this.getCPointer());
    }

    public double getRow() throws FlNativeException {
        return this.getRow(this.getCPointer());
    }

    public double getAdr() throws FlNativeException {
        return this.getAdr(this.getCPointer());
    }

    public SparseExch(Prop prop, String string) throws FlNativeException {
        CPointer cPointer = prop.getCPointer();
        this.initWSProp(this.getCPointer(), cPointer, string);
    }

    public SparseExch(int n, int n2, int n3, boolean bl) throws FlNativeException {
        this.initWSDim(this.getCPointer(), n, n2, n3, bl);
    }

    public void toProp(Prop prop, String string) throws FlNativeException {
        this.toProp(this.getCPointer(), prop.getCPointer(), string);
    }

    public void addSparseMatrixVals(int[] nArray, int[] nArray2, double[] dArray, boolean bl) {
        if (nArray == null) {
            nArray = new int[]{};
        }
        if (nArray2 == null) {
            nArray2 = new int[]{};
        }
        if (dArray == null) {
            dArray = new double[]{};
        }
        this.addSparseMatrixVals(this.getCPointer(), nArray, nArray2, dArray, bl);
    }

    @Override
    protected void doCleanup(CPointer cPointer) throws FlNativeException {
        this.cleanupSparseExch(cPointer);
    }

    private native void initWSProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native void initWSDim(CPointer var1, int var2, int var3, int var4, boolean var5) throws FlNativeException;

    private native void toProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native boolean isReal(CPointer var1) throws FlNativeException;

    private native int getM(CPointer var1) throws FlNativeException;

    private native int getN(CPointer var1) throws FlNativeException;

    private native int getNnz(CPointer var1) throws FlNativeException;

    private native void getIdx(CPointer var1, int[][] var2) throws FlNativeException;

    private native void getIdxBlock(CPointer var1, int[][] var2, int var3, int var4) throws FlNativeException;

    private native void getReal(CPointer var1, double[] var2) throws FlNativeException;

    private native void getRealBlock(CPointer var1, double[] var2, int var3, int var4) throws FlNativeException;

    private native void getImag(CPointer var1, double[] var2) throws FlNativeException;

    private native void getImagBlock(CPointer var1, double[] var2, int var3, int var4) throws FlNativeException;

    private native void addSparseMatrixVals(CPointer var1, int[] var2, int[] var3, double[] var4, boolean var5) throws FlNativeException;

    private native double getColPtr(CPointer var1) throws FlNativeException;

    private native double getRow(CPointer var1) throws FlNativeException;

    private native double getAdr(CPointer var1) throws FlNativeException;

    private native void cleanupSparseExch(CPointer var1) throws FlNativeException;
}

