/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.geommesh.map;

import com.comsol.geommesh.map.BoundarySimilarity;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.dbimodel.Cpl;
import com.comsol.model.dbimodel.ElemFeature;
import com.comsol.model.dbimodel.Element;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.operations.cpl.CplOperation;
import com.comsol.model.operations.cpl.CplOperationID;
import com.comsol.model.operations.cpl.ExtrusionOperation;
import com.comsol.model.operations.cpl.ICplOperation;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.bz;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.ds;
import com.comsol.util.classes.DoubleVariable;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.o;
import java.util.Vector;

public class CplBoundarySimilarity
extends BoundarySimilarity
implements ICplOperation {
    CplOperationID.ID b;

    public CplBoundarySimilarity(CplOperationID.ID iD) {
        super(iD);
        this.b = iD;
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    public void initialize(Cpl cpl) {
        ds ds2;
        Object object;
        this.g = cpl;
        if (cpl != null) {
            object = cpl.getModel();
            ds2 = cpl.selection().getSelectionFilter().getAllowedGeometries();
            if (((String[])ds2).length != 1) {
                throw new RuntimeException("Internal error in similarity initialize.");
            }
            GeomSequence geomSequence = object.geom(ds2[0]);
            this.a((PropFeature)cpl, geomSequence, geomSequence.getSDim());
        } else {
            this.a(null, null, 2);
        }
        object = cpl == null ? "aa" : cpl.tag();
        ds2 = new ds("opname", "Operator_name", (String)object, (dd)new bz());
        ds2.annotate().r().z().E();
        this.e.registerProp((Property)ds2);
        ExtrusionOperation.addCommonExtrProps((de)this.e);
        if (cpl != null) {
            this.e.setUnitConverter(cpl.getConverter());
        }
    }

    public void postCreateInitGUI(Cpl cpl) {
    }

    @Override
    public String[] getAllowedSubOperations() {
        if (this.a == 3 && ((Cpl)this.g).feature().size() == 0) {
            return CplOperationID.ID.getSubOperations();
        }
        return new String[0];
    }

    @Override
    public boolean hasSelection() {
        return true;
    }

    @Override
    public final String getDescription() {
        return this.b.getDescription();
    }

    @Override
    public final String getShortName() {
        return this.b.getShortName();
    }

    public Element toElementSyntax() {
        DoubleVariable doubleVariable;
        Object object;
        Cpl cpl = (Cpl)this.g;
        Element element = ExtrusionOperation.getPartElemSyntax((Cpl)cpl);
        GeomSequence geomSequence = cpl.getModel().geom(cpl.selection().geom());
        double d2 = geomSequence.geomScaleFactor();
        Frame frame = geomSequence.getMeshFrame();
        String string = frame.identifier();
        int n2 = geomSequence.getSDim();
        double[][] dArray = new double[n2][n2];
        double[] dArray2 = new double[n2];
        try {
            object = this.getTransformationMatrix((PropFeature)cpl, geomSequence);
            int n3 = 0;
            while (n3 < n2) {
                dArray2[n3] = object[n3][n2] * d2;
                int n4 = 0;
                while (n4 < n2) {
                    dArray[n3][n4] = object[n3][n4];
                    ++n4;
                }
                ++n3;
            }
            doubleVariable = new DoubleVariable(dArray);
            doubleVariable = doubleVariable.inverse();
            dArray = doubleVariable.toArray(new int[0]);
        }
        catch (FlException flException) {
            flException.addParameterPair("Boundary_similarity", cpl.accessGetIdentifier());
            throw flException;
        }
        doubleVariable = null;
        ElemFeature elemFeature = null;
        String[] stringArray = new String[n2];
        IVariableData iVariableData = frame.inPlaneCoord();
        int n5 = 0;
        while (n5 < n2) {
            stringArray[n5] = String.valueOf(String.valueOf(dArray[n5][0])) + "*(" + iVariableData[0] + "-" + String.valueOf(dArray2[0]) + ")";
            int n6 = 1;
            while (n6 < n2) {
                int n7 = n5;
                stringArray[n7] = String.valueOf(stringArray[n7]) + "+" + String.valueOf(dArray[n5][n6]) + "*(" + (String)iVariableData[n6] + "-" + String.valueOf(dArray2[n6]) + ")";
                ++n6;
            }
            ++n5;
        }
        object = element.field().create("map", "array");
        doubleVariable = object.pos().create("record");
        doubleVariable.set("type", "local");
        elemFeature = doubleVariable.field().create("expr", "array");
        n5 = 0;
        while (n5 < stringArray.length) {
            elemFeature.pos().create("string", stringArray[n5]);
            ++n5;
        }
        doubleVariable.set("frame", string);
        boolean bl2 = cpl.getString("usesrcmap").equals("on");
        if (!bl2) {
            doubleVariable = object.pos().create("record");
            doubleVariable.set("type", "unit");
            doubleVariable.set("frame", string);
        } else {
            iVariableData = cpl.getModel().physics().getVarData();
            IUnitConverter iUnitConverter = cpl.getConverter();
            String[] stringArray2 = cpl.getStringArray("srcmap");
            doubleVariable = object.pos().create("record");
            doubleVariable.set("type", "local");
            elemFeature = doubleVariable.field().create("expr", "array");
            int n8 = 0;
            while (n8 < stringArray2.length) {
                String string2 = stringArray2[n8];
                string2 = iVariableData.replaceWithCompleteNames(string2, cpl.shortScopeDot());
                string2 = iVariableData.checkRemoveRoot(string2);
                string2 = o.a((String)string2, (IUnitConverter)iUnitConverter, (boolean[])new boolean[]{false});
                elemFeature.pos().create("string", string2);
                ++n8;
            }
            doubleVariable.set("frame", string);
        }
        return element;
    }

    public Vector<Vector<String>> getPropGroups() {
        return CplOperation.getStdPropGroups((Cpl)((Cpl)this.g), (String)"Destination_boundary");
    }

    public void addCustomPlotProperties(de de2) {
        ds ds2 = new ds("selection", "Selection", "srcanddst", (dd)new di(new String[]{"srcanddst", "source", "destination"}, new String[]{"Source_and_destination", "Source", "Destination"}));
        ds2.annotate().i(true);
        de2.registerProp((Property)ds2);
    }

    public Selection[] getConfirmedSelectionsToPlot(de de2, PropFeature propFeature) {
        switch (de2.getFromAllProperty("selection").getString()) {
            case "source": {
                return new Selection[]{propFeature.selection()};
            }
            case "destination": {
                return new Selection[]{(Selection)propFeature.selection("destination")};
            }
        }
        return null;
    }

    public Selection[][] getFeatureSelectionsToPlot(de de2, PropFeature propFeature) {
        if ("srcanddst".equals(de2.getFromAllProperty("selection").getString())) {
            return new Selection[][]{{propFeature.selection()}, {(Selection)propFeature.selection("destination")}};
        }
        return null;
    }
}

