/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.guigraphics.events;

import com.comsol.gui.DesktopWindow;
import com.comsol.guigraphics.a.e;
import com.comsol.guigraphics.events.GuiEvent;
import com.comsol.guigraphics.events.IGuiEventListener;
import com.comsol.guigraphics.selection.FocusMode;
import com.comsol.guigraphics.selection.SelectionLevel;
import com.comsol.guigraphics.selection.SelectionMode;
import com.comsol.guigraphics.selection.SelectionModel;
import com.comsol.model.dbimodel.BatchFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.ResultFeature;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.TableBaseFeature;
import com.comsol.model.dbimodel.WorkPlaneFeature;
import com.comsol.model.dbimodel.application.AppBuilderFeature;
import com.comsol.model.dbimodel.design.DesignEntity;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.edit.util.GuiInfo;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.nativeutil.data.RenderDataEvent;
import com.comsol.nativeutil.data.RenderDraw;
import com.comsol.nativeutil.data.RenderWorkPlane;
import com.comsol.util.license.LicenseType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;

public class GuiEventManager {
    protected DesktopWindow a;
    private List<IGuiEventListener> b = new ArrayList<IGuiEventListener>();
    private Map<GuiEvent.Type, GuiEvent> c;
    private volatile boolean d;
    private final Queue<a> e = new ConcurrentLinkedQueue<a>();

    public GuiEventManager(DesktopWindow desktopWindow, com.comsol.guigraphics.a.a a2) {
        this.a = desktopWindow;
        if (a2 != null) {
            a2.addGUIEventManager(this);
        }
    }

    public void addListener(IGuiEventListener iGuiEventListener) {
        this.a(-1, iGuiEventListener);
    }

    public void addListenerFirst(IGuiEventListener iGuiEventListener) {
        this.a(0, iGuiEventListener);
    }

    private synchronized void a(int n2, IGuiEventListener iGuiEventListener) {
        if (!this.b.contains(iGuiEventListener)) {
            if (n2 == -1) {
                this.b.add(iGuiEventListener);
            } else {
                this.b.add(n2, iGuiEventListener);
            }
        }
    }

    public synchronized void removeListener(IGuiEventListener iGuiEventListener) {
        this.b.remove(iGuiEventListener);
        Iterator iterator = this.e.iterator();
        while (iterator.hasNext()) {
            a a2 = (a)iterator.next();
            if (a2.b != iGuiEventListener) continue;
            iterator.remove();
        }
    }

    public void fireGuiViewChanged(GuiInfo.GuiViewType guiViewType, GuiInfo.GuiViewType guiViewType2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.GUIVIEWCHANGED);
        guiEvent.setGuiView(guiViewType);
        guiEvent.setOldGuiView(guiViewType2);
        this.a(guiEvent);
    }

    public void fireDrawSelectionDimensionChanged(SelectionLevel selectionLevel) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.DRAWSELECTIONDIMENSIONCHANGED);
        guiEvent.setSelectionDimension(selectionLevel);
        this.a(guiEvent);
    }

    public void fireGeomSelectionDimensionChanged(int n2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.GEOMSELECTIONDIMENSIONCHANGED);
        guiEvent.setSelectionDimension(SelectionLevel.a(n2));
        this.a(guiEvent);
    }

    public void fireCurrentGeometryChanged(e e2, IGeomSequence iGeomSequence) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTGEOMCHANGED);
        guiEvent.setPreviousGeomSequence(e2);
        guiEvent.setGeomSequence(iGeomSequence);
        this.a(guiEvent);
    }

    public void fireCurrentMeshChanged(MeshSequence meshSequence, MeshSequence meshSequence2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTMESHCHANGED);
        guiEvent.setMeshSequence(meshSequence2);
        guiEvent.setOldMeshSequence(meshSequence);
        this.a(guiEvent);
    }

    public void fireCurrentBuilderPhysicsInterfaceChanged(DesignEntity designEntity) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.BUILDER_PHYSICS_INTERFACE_CHANGED);
        guiEvent.setBuilderPhysicsInterface(designEntity);
        this.a(guiEvent);
    }

    public void fireWidgetCheckboxSelectorChanged(String string, String string2, String string3, String string4) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.WIDGET_CHECKBOX_SELECTOR_CHANGED);
        guiEvent.setParameter("widgetTag", string3);
        guiEvent.setParameter("newValue", string4);
        guiEvent.setParameter("desktopTag", string);
        guiEvent.setParameter("viewTag", string2);
        this.a(guiEvent);
    }

    public void fireCurrentApplicationFeatureChanged(AppBuilderFeature appBuilderFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.APPLICATION_FEATURE_CHANGED);
        guiEvent.setApplicationEntity(appBuilderFeature);
        this.a(guiEvent);
    }

    public void fireCurrentApplicationEntityChanged(AppBuilderFeature appBuilderFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENT_APPLICATION_ENTITY_CHANGED);
        guiEvent.setApplicationEntity(appBuilderFeature);
        this.a(guiEvent);
    }

    public void fireCurrentTableChanged(TableBaseFeature tableBaseFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTTABLECHANGED);
        guiEvent.setTable(tableBaseFeature);
        this.a(guiEvent);
    }

    public void fireCurrentModelNodeChanged(ModelNode modelNode, ModelNode modelNode2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTMODELNODECHANGED);
        guiEvent.setOldModelNode(modelNode);
        guiEvent.setModelNode(modelNode2);
        this.a(guiEvent);
    }

    public void fireCurrentPhysicsChanged(Physics physics, Physics physics2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTPHYSICSCHANGED);
        guiEvent.setPhysicsInterface(physics, physics2);
        this.a(guiEvent);
    }

    public void fireCurrentStudyChanged(Study study) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTSTUDYSCHANGED);
        guiEvent.setStudy(study);
        this.a(guiEvent);
    }

    public void fireCurrentPlotGroupChanged(ResultFeature resultFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTPLOTGROUPCHANGED);
        guiEvent.setPlotGroup(resultFeature);
        this.a(guiEvent);
    }

    public void fireCurrentBatchChanged(BatchFeature batchFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTBATCHCHANGED);
        guiEvent.setBatch(batchFeature);
        this.a(guiEvent);
    }

    public void fireCurrentWorkPlaneChanged(WorkPlaneFeature workPlaneFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CURRENTWORKPLANECHANGED);
        guiEvent.setWorkPlane(workPlaneFeature);
        this.a(guiEvent);
    }

    public void fireLastWorkPlaneChanged(WorkPlaneFeature workPlaneFeature) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.LASTWORKPLANECHANGED);
        guiEvent.setWorkPlane(workPlaneFeature);
        this.a(guiEvent);
    }

    public void fireDrawRebuilt(GeomSequence geomSequence) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.DRAWREBUILT);
        guiEvent.setGeomSequence((IGeomSequence)geomSequence);
        this.a(guiEvent);
    }

    public void fireGeometryRebuilt(GeomSequence geomSequence) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.GEOMETRYREBUILT);
        guiEvent.setGeomSequence((IGeomSequence)geomSequence);
        this.a(guiEvent);
    }

    public void fireMeshRebuilt(MeshSequence meshSequence) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.MESHREBUILT);
        guiEvent.setMeshSequence(meshSequence);
        this.a(guiEvent);
    }

    public void fireClearWorkPlane(GuiInfo.GuiViewType guiViewType) {
        RenderWorkPlane renderWorkPlane = new RenderWorkPlane(null, null);
        if (guiViewType == GuiInfo.GuiViewType.GEOM) {
            renderWorkPlane.a(RenderDataEvent.TargetType.c);
        }
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CLEARWORKPLANE);
        guiEvent.setRenderWorkplane(renderWorkPlane);
        this.a(guiEvent);
    }

    public void fireAddWorkPlane(RenderWorkPlane renderWorkPlane) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.ADDWORKPLANE);
        guiEvent.setRenderWorkplane(renderWorkPlane);
        this.a(guiEvent);
    }

    public void fireClearEditObject() {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.CLEAREDITOBJECT);
        this.a(guiEvent);
    }

    public void fireAddEditObject(RenderDraw renderDraw, SelectionModel selectionModel) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.ADDEDITOBJECT);
        guiEvent.setRenderEditObject(renderDraw);
        guiEvent.setSelectionModel(selectionModel);
        this.a(guiEvent);
    }

    public void fireReloadDiagramDatabase(String string) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.LOADXMLDATABASE);
        guiEvent.setXMLDatabase(string);
        this.a(guiEvent);
    }

    public void fireHaltRendering() {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.HALTRENDERING);
        this.a(guiEvent);
    }

    public void fireResumeRendering() {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.RESUMERENDERING);
        this.a(guiEvent);
    }

    public void fireSelectionModeChanged(SelectionMode selectionMode) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.SELECTION_MODE_CHANGED);
        guiEvent.setSelectionMode(selectionMode);
        this.a(guiEvent);
    }

    public void fireFocusModeChanged(FocusMode focusMode) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.FOCUS_MODE_CHANGED);
        guiEvent.setFocusMode(focusMode);
        this.a(guiEvent);
    }

    public void fireHidingEnabledChanged(boolean bl2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.HIDING_ENABLED);
        guiEvent.setHidingEnabled(bl2);
        this.a(guiEvent);
    }

    public void fireDisableMouseSelectionChanged(boolean bl2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.DISABLE_MOUSE_SELECTION);
        guiEvent.setDisableMouseSelection(bl2);
        this.a(guiEvent);
    }

    public void fireSelectionPickingModeChanged(SelectionMode.PickingMode pickingMode) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.SELECTION_PICKINGMODE);
        guiEvent.setPickingMode(pickingMode);
        this.a(guiEvent);
    }

    public void fireActiveLicenseChanged(LicenseType[] licenseTypeArray, LicenseType[] licenseTypeArray2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.ACTIVE_LICENCES_CHANGED);
        guiEvent.setBlockedLicenses(licenseTypeArray);
        guiEvent.setUnblockedLicenses(licenseTypeArray2);
        this.a(guiEvent);
    }

    public void fireIgnoreSelectionMarkings(boolean bl2) {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.IGNORE_SELECTION_MARKINGS);
        guiEvent.setParameter("ignore", bl2 ? "on" : "off");
        this.a(guiEvent);
    }

    public void fireFeatureSelectionShown() {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.FEATURE_SELECTION_SHOWN);
        this.a(guiEvent);
    }

    public void fireFeatureSelectionCleared() {
        GuiEvent guiEvent = new GuiEvent(this.a, GuiEvent.Type.FEATURE_SELECTION_CLEARED);
        this.a(guiEvent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(GuiEvent guiEvent) {
        Object object = this;
        synchronized (object) {
            if (this.c != null) {
                if (this.c.containsKey((Object)guiEvent.getType())) {
                    this.c.put(guiEvent.getType(), guiEvent.merge(this.c.get((Object)guiEvent.getType())));
                } else {
                    this.c.put(guiEvent.getType(), guiEvent);
                }
                return;
            }
            for (IGuiEventListener object2 : this.b) {
                this.e.add(new a(guiEvent, object2));
            }
            if (this.d) {
                return;
            }
        }
        object = null;
        while (this.d = !this.e.isEmpty()) {
            a a2 = this.e.peek();
            try {
                try {
                    a2.b.handleGuiEvent(a2.a);
                }
                catch (RuntimeException runtimeException) {
                    if (object == null) {
                        object = runtimeException;
                    }
                    this.e.poll();
                    continue;
                }
            }
            catch (Throwable throwable) {
                this.e.poll();
                throw throwable;
            }
            this.e.poll();
        }
        if (object != null) {
            throw object;
        }
    }

    public synchronized void queueEvents() {
        if (this.c == null) {
            this.c = Collections.synchronizedMap(new LinkedHashMap());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendQueuedEvents() {
        Map<GuiEvent.Type, GuiEvent> map;
        Object object = this;
        synchronized (object) {
            if (this.c == null) {
                return;
            }
            map = this.c;
            this.c = null;
        }
        object = null;
        for (GuiEvent guiEvent : map.values()) {
            try {
                this.a(guiEvent);
            }
            catch (RuntimeException runtimeException) {
                if (object != null) continue;
                object = runtimeException;
            }
        }
        if (object != null) {
            throw object;
        }
    }

    private static class a {
        private final GuiEvent a;
        private final IGuiEventListener b;

        private a(GuiEvent guiEvent, IGuiEventListener iGuiEventListener) {
            this.a = guiEvent;
            this.b = iGuiEventListener;
        }
    }
}

