/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni.mesh;

import com.comsol.nativejni.CPointer;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeSerializable;
import com.comsol.nativejni.SerializableProxy;
import com.comsol.nativejni.data.RenderDrawGeomJNI;
import com.comsol.nativejni.data.RenderMeshCollectionJNI;
import com.comsol.nativejni.geom.Geom;
import com.comsol.nativejni.server.FlRunnable;
import com.comsol.nativejni.util.Prop;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlStringUtil;

public class Mesh
extends FlNativeSerializable {
    static {
        Mesh.setRenumberElemVersion(SystemUtil.getMeshRenumberElemVersion());
    }

    static native void setRenumberElemVersion(int var0);

    public Mesh() {
        this.initWS(this.getCPointer());
    }

    public Mesh(int n) {
        this.initWS1(this.getCPointer(), n);
    }

    public Mesh(RenderDrawGeomJNI renderDrawGeomJNI) {
        int n = renderDrawGeomJNI.getBoundingBox().length / 2;
        this.initWS1(this.getCPointer(), n);
        this.createFromRenderDrawGeom(this.getCPointer(), renderDrawGeomJNI.getCPointer());
    }

    public String toString() {
        String string = "";
        try {
            int n = this.getSDim();
            if (n == 0) {
                string = String.valueOf(string) + "0D ";
            } else if (n == 1) {
                string = String.valueOf(string) + "1D ";
            } else if (n == 2) {
                string = String.valueOf(string) + "2D ";
            } else if (n == 3) {
                string = String.valueOf(string) + "3D ";
            } else {
                string = String.valueOf(string) + "Space dimension not specified.\n";
                return string;
            }
            string = String.valueOf(string) + "Mesh object\n";
            string = String.valueOf(string) + "Mesh vertices:        " + this.getNumMeshVtx() + "\n";
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            int n6 = 0;
            int n7 = 0;
            int n8 = 0;
            int n9 = 0;
            while (n9 < this.getNumTypes()) {
                if (this.getEDim(n9) == 0) {
                    n2 += this.getNumElem(n9);
                } else if (this.getEDim(n9) == 1) {
                    n3 += this.getNumElem(n9);
                } else if (this.getEDim(n9) == 2) {
                    if (this.isSimplexElem(n9)) {
                        n4 += this.getNumElem(n9);
                    } else if (this.isBlockElem(n9)) {
                        n5 += this.getNumElem(n9);
                    }
                } else if (this.getEDim(n9) == 3) {
                    if (this.isSimplexElem(n9)) {
                        n6 += this.getNumElem(n9);
                    } else if (this.isBlockElem(n9)) {
                        n7 += this.getNumElem(n9);
                    } else if (this.isPrismElem(n9)) {
                        n8 += this.getNumElem(n9);
                    }
                }
                ++n9;
            }
            if (n == 0) {
                string = String.valueOf(string) + "Elements:             " + n2;
            } else if (n == 1) {
                string = String.valueOf(string) + "Boundary elements:    " + n2 + "\n" + "Elements:             " + n3;
            } else if (n == 2) {
                n9 = n4 + n5;
                string = String.valueOf(string) + "Vertex elements:      " + n2 + "\n" + "Boundary elements:    " + n3 + "\n" + "Elements:             " + n9 + "\n" + "  Triangular:         " + n4 + "\n" + "  Quadrilateral:      " + n5;
            } else {
                n9 = n6 + n7 + n8;
                int n10 = n4 + n5;
                string = String.valueOf(string) + "Vertex elements:      " + n2 + "\n" + "Edge elements:        " + n3 + "\n" + "Boundary elements:    " + n10 + "\n" + "  Triangular:         " + n4 + "\n" + "  Quadrilateral:      " + n5 + "\n" + "Elements:             " + n9 + "\n" + "  Tetrahedral:        " + n6 + "\n" + "  Prism:              " + n8 + "\n" + "  Hexahedral:         " + n7;
            }
            int[] nArray = this.storedHighOrderDataOrders();
            if (nArray.length == 1) {
                string = String.valueOf(string) + "\n\nHigh order shape data stored for order: " + nArray[0];
            } else if (nArray.length > 0) {
                string = String.valueOf(string) + "\n\nHigh order shape data stored for orders: " + FlStringUtil.strValueOf((int[])nArray);
            }
        }
        catch (FlException flException) {
            string = String.valueOf(string) + "Error: corrupt object\n";
        }
        return string;
    }

    public void updateTriMeshCollEdg(int n, int[] nArray) {
        this.updateTriMeshCollEdg(this.getCPointer(), n, nArray);
    }

    @Override
    protected FlNativeSerializable a() {
        return new Mesh();
    }

    public void duplicate(Mesh mesh) {
        this.duplicate(this.getCPointer(), mesh.getCPointer());
    }

    public void enrich(Prop prop, Prop prop2, FlRunnable flRunnable) {
        this.enrich(this.getCPointer(), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public void del(Prop prop, Prop prop2) {
        this.del(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public void toGeom(Geom geom, Prop prop, FlRunnable flRunnable) {
        this.toGeom(this.getCPointer(), geom.getCPointer(), prop.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public int getSDim() {
        return this.getSdim(this.getCPointer());
    }

    public double getGScale() {
        return this.getGScale(this.getCPointer());
    }

    public int[] getEntityRank(int n) {
        return this.getEntityRank(this.getCPointer(), n);
    }

    public int getNumEntity(int n) {
        return this.getNumEntity(this.getCPointer(), n);
    }

    public int getNumConComp() {
        return this.getNumConComp(this.getCPointer());
    }

    public int getNumTypes() {
        return this.getNumTypes(this.getCPointer());
    }

    public String[] getTypes() {
        return this.getTypes(this.getCPointer());
    }

    public int getNumVertices(int n) {
        return this.getNumVertices(this.getCPointer(), n);
    }

    public int getNumNodes(int n) {
        return this.getNumNodes(this.getCPointer(), n);
    }

    public int getEDim(int n) {
        return this.getEDim(this.getCPointer(), n);
    }

    public int getNumMeshVtx() {
        return this.getNumMeshVtx(this.getCPointer());
    }

    public int getNumMeshVtx(int n, int[] nArray) {
        return this.getNumMeshVtxSel(this.getCPointer(), n, nArray);
    }

    public int getNumElem(int n) {
        return this.getNumElem(this.getCPointer(), n);
    }

    public int getNumElem(int n, int[] nArray) {
        return this.getNumElem(this.getCPointer(), n, nArray);
    }

    public int getNumEntityType(int n) {
        return this.getNumEntityType(this.getCPointer(), n);
    }

    public boolean isSimplexElem(int n) {
        return this.isSimplexElem(this.getCPointer(), n);
    }

    public boolean isBlockElem(int n) {
        return this.isBlockElem(this.getCPointer(), n);
    }

    public boolean isPrismElem(int n) {
        return this.isPrismElem(this.getCPointer(), n);
    }

    public int getElemOrder(int n) {
        return this.getElemOrder(this.getCPointer(), n);
    }

    public void getCopyMapping(Prop prop, Prop prop2) {
        this.getCopyMapping(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public void checkAgainstGeom(Geom geom, boolean bl) {
        this.checkAgainstGeom(this.getCPointer(), geom.getCPointer(), bl);
    }

    public void checkValidMesh() {
        this.checkValidMesh(this.getCPointer());
    }

    public void checkValid(Geom geom) {
        this.checkValid(this.getCPointer(), geom != null ? geom.getCPointer() : CPointer.getNullCPointer());
    }

    public void checkInvertedElem(Prop prop, Prop prop2) {
        this.checkInvertedElem(this.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    @Override
    protected void doCleanup(CPointer cPointer) throws FlNativeException {
        this.cleanupWS(cPointer);
    }

    public void initOriginIndices() {
        this.initOriginIndices(this.getCPointer());
    }

    public void copy(Mesh mesh, Geom geom, Prop prop, Prop prop2, FlRunnable flRunnable) {
        this.copy(mesh.getCPointer(), geom.getCPointer(), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public void copy(Geom geom, Mesh mesh, Mesh mesh2, Geom geom2, Prop prop, Prop prop2, FlRunnable flRunnable) {
        this.copyGeneral(geom != null ? geom.getCPointer() : null, mesh.getCPointer(), mesh2.getCPointer(), geom2 != null ? geom2.getCPointer() : null, prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public double[] getStatistics(int n, int[] nArray, Prop prop) {
        return this.getStatistics(this.getCPointer(), n, nArray, prop.getCPointer());
    }

    public double[] getHGradMax(Geom geom, int n, int[] nArray) {
        return this.getHGradMax(this.getCPointer(), geom.getCPointer(), n, nArray);
    }

    public int[] getQualDistribution(int n, int[] nArray, int n2, Prop prop) {
        return this.getQualDistribution(this.getCPointer(), n, nArray, n2, prop.getCPointer());
    }

    public int[][] getControlEntitiesToKeep(Geom geom) {
        return this.getControlEntitiesToKeep(this.getCPointer(), geom.getCPointer());
    }

    public void getVolume(double[] dArray, int n) {
        this.getVolume(this.getCPointer(), dArray, n);
    }

    public void calcQual(double[] dArray, int n, Prop prop) {
        this.calcQual(this.getCPointer(), dArray, n, prop.getCPointer());
    }

    public void smooth(Prop prop, Prop prop2, Geom geom) {
        this.smooth(this.getCPointer(), prop.getCPointer(), prop2.getCPointer(), geom != null ? geom.getCPointer() : CPointer.getNullCPointer());
    }

    public void merge(Mesh mesh) {
        this.merge(this.getCPointer(), mesh.getCPointer());
    }

    public int[][] canonize(String string, String string2, Mesh mesh) {
        return this.canonize(this.getCPointer(), string, string2, mesh != null ? mesh.getCPointer() : null);
    }

    public void renumberElem(boolean bl) {
        this.renumberElem(this.getCPointer(), bl);
    }

    public void getBndUpDown(int[][] nArray) {
        this.getBndUpDown(this.getCPointer(), nArray);
    }

    public void getVtxCoord(double[][] dArray) {
        this.getVtxCoord(this.getCPointer(), dArray);
    }

    public void getBounds(double[] dArray) {
        this.getBounds(this.getCPointer(), dArray);
    }

    public void getGeomEntities(int[] nArray, int n) {
        this.getGeomEntities(this.getCPointer(), nArray, n);
    }

    public boolean needResave() {
        return this.needResave(this.getCPointer());
    }

    public int[] storedHighOrderDataOrders() {
        return this.storedHighOrderDataOrders(this.getCPointer());
    }

    public int[][] adj(int[][] nArray) {
        return this.adj(this.getCPointer(), nArray);
    }

    public void adjSparse(int[][] nArray, Prop prop) {
        this.adjSparse(this.getCPointer(), nArray, prop.getCPointer());
    }

    public void meshedEntities(int n, int n2, int[] nArray) {
        this.meshedEntities(this.getCPointer(), n, n2, nArray);
    }

    public void improveParameterization(Mesh mesh, Prop prop, FlRunnable flRunnable) {
        CPointer cPointer = mesh != null ? mesh.getCPointer() : CPointer.getNullCPointer();
        this.improveParameterization(this.getCPointer(), cPointer, prop.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public int[] partitionClosedEdges(int n) {
        return this.partitionClosedEdges(this.getCPointer(), n);
    }

    public void scale(double d2, double d3, double d4) {
        this.scale(this.getCPointer(), d2, d3, d4);
    }

    @Override
    public void initProxy(SerializableProxy serializableProxy) throws FlNativeException {
        this.initProxy(this.getCPointer(), serializableProxy.getCPointer());
    }

    @Override
    public void updateFromProxy(SerializableProxy serializableProxy) throws FlNativeException {
        this.updateFromProxy(this.getCPointer(), serializableProxy.getCPointer());
    }

    public void generateRenderDrawGeom(Mesh mesh, Geom geom, int n, int n2, int n3, RenderDrawGeomJNI renderDrawGeomJNI, int[][] nArray, String string, FlRunnable flRunnable) throws FlNativeException {
        this.generateRenderDrawGeom(mesh.getCPointer(), geom.getCPointer(), n, n2, n3, renderDrawGeomJNI.getCPointer(), nArray, string, flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public static void generateRenderDraw(CPointer[] cPointerArray, CPointer[] cPointerArray2, boolean[] blArray, int n, String string, FlRunnable flRunnable) {
        Mesh.generateRenderDraw(cPointerArray, cPointerArray2, blArray, n, string, flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public void generateRenderDrawGeom(Mesh mesh, RenderDrawGeomJNI renderDrawGeomJNI) throws FlNativeException {
        this.generateRenderDrawGeom(mesh.getCPointer(), renderDrawGeomJNI.getCPointer());
    }

    public void getRenderMeshCollection(Mesh mesh, Geom geom, int[][] nArray, RenderMeshCollectionJNI renderMeshCollectionJNI) throws FlNativeException {
        this.getRenderMeshCollection(mesh.getCPointer(), geom.getCPointer(), nArray, renderMeshCollectionJNI.getCPointer());
    }

    public void getRenderMeshCollection(Mesh mesh, int[][] nArray, RenderMeshCollectionJNI renderMeshCollectionJNI) throws FlNativeException {
        this.getRenderMeshCollection(mesh.getCPointer(), nArray, renderMeshCollectionJNI.getCPointer());
    }

    public int getSizeInMemory() throws FlNativeException {
        return this.getSizeInMemory(this.getCPointer());
    }

    public long calculateCheckSum() throws FlNativeException {
        return this.calculateCheckSum(this.getCPointer());
    }

    public void getMeshVertex(double[][] dArray, int n) {
        this.getMeshVertexBlk(this.getCPointer(), dArray, n);
    }

    public void setMeshVertex(double[][] dArray, int n) {
        if (dArray == null) {
            throw new FlException("Illegal_input_argument");
        }
        double[][] dArray2 = dArray;
        int n2 = dArray.length;
        int n3 = 0;
        while (n3 < n2) {
            double[] dArray3 = dArray2[n3];
            if (dArray3 == null) {
                throw new FlException("Illegal_input_argument");
            }
            ++n3;
        }
        this.setMeshVertexBlk(this.getCPointer(), dArray, n);
    }

    public void getElem(String string, int[][] nArray, int n) {
        this.getElemBlk(this.getCPointer(), string, nArray, n);
    }

    public void setElem(String string, int[][] nArray, int n) {
        if (nArray == null) {
            throw new FlException("Illegal_input_argument");
        }
        int[][] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray3 = nArray2[n3];
            if (nArray3 == null) {
                throw new FlException("Illegal_input_argument");
            }
            ++n3;
        }
        this.setElemBlk(this.getCPointer(), string, nArray, n);
    }

    public void getElemEntity(String string, int[] nArray, int n) {
        this.getElemEntityBlk(this.getCPointer(), string, nArray, n);
    }

    public void setElemEntity(String string, int[] nArray, int n) {
        if (nArray == null) {
            throw new FlException("Illegal_input_argument");
        }
        this.setElemEntityBlk(this.getCPointer(), string, nArray, n);
    }

    public double[] edgeMaxFaceAngle(int[] nArray, int[] nArray2, int[] nArray3, boolean bl) {
        return this.edgeMaxFaceAngle(this.getCPointer(), nArray, nArray2, nArray3, bl);
    }

    public double[] edgeMaxFaceAngle(int[] nArray, int[] nArray2, int[] nArray3) {
        return this.edgeMaxFaceAngle(nArray, nArray2, nArray3, true);
    }

    public double[][] getEdgTangentAtVtx(int[] nArray, int[] nArray2, int n) {
        return this.getEdgTangentAtVtx(this.getCPointer(), nArray, nArray2, n);
    }

    public double[][] getEdgParam() {
        return this.getEdgParam(this.getCPointer());
    }

    public void buildMeshImportOperation(Prop prop, Prop prop2, FlRunnable flRunnable) {
        this.buildMeshImportOperation(this.getCPointer(), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public void buildOperation(Geom geom, Prop prop, Prop prop2, FlRunnable flRunnable) {
        this.buildMeshOperation(this.getCPointer(), geom == null ? CPointer.getNullCPointer() : geom.getCPointer(), prop.getCPointer(), prop2.getCPointer(), flRunnable, FlRunnable.getRunInfoCPtr(flRunnable));
    }

    public void getOperationDefaults(Geom geom, Prop prop, Prop prop2) {
        this.getOperationDefaults(this.getCPointer(), geom == null ? CPointer.getNullCPointer() : geom.getCPointer(), prop.getCPointer(), prop2.getCPointer());
    }

    public boolean hasIncompleteDomains() {
        return this.hasIncompleteDomains(this.getCPointer());
    }

    public int[] getIncompleteDomains() {
        return this.getIncompleteDomains(this.getCPointer());
    }

    public void classifyLinearEntities(int n, int[] nArray, Prop prop) {
        this.classifyLinearEntities(this.getCPointer(), n, nArray, prop.getCPointer());
    }

    public void getCurvatureProperties(int n, int n2, boolean bl, Prop prop) {
        this.getCurvatureProperties(this.getCPointer(), n, n2, bl, prop.getCPointer());
    }

    public int[] checkSelections(CPointer[] cPointerArray, boolean bl) {
        return this.checkSelections(this.getCPointer(), cPointerArray, bl);
    }

    public void removeUnusedMeshVtx() {
        this.removeUnusedMeshVtx(this.getCPointer());
    }

    public void makeLinear() {
        this.makeLinear(this.getCPointer());
    }

    public void convertTo3D() {
        this.convertTo3D(this.getCPointer());
    }

    public double getMeanElemSize(int[][] nArray) {
        return this.getMeanElemSize(this.getCPointer(), nArray);
    }

    private native void initWS(CPointer var1) throws FlNativeException;

    private native void initWS1(CPointer var1, int var2) throws FlNativeException;

    private native void enrich(CPointer var1, CPointer var2, CPointer var3, FlRunnable var4, CPointer var5) throws FlNativeException;

    private native void del(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private native void duplicate(CPointer var1, CPointer var2) throws FlNativeException;

    private native void initOriginIndices(CPointer var1);

    private native void copy(CPointer var1, CPointer var2, CPointer var3, CPointer var4, FlRunnable var5, CPointer var6) throws FlNativeException;

    private native void copyGeneral(CPointer var1, CPointer var2, CPointer var3, CPointer var4, CPointer var5, CPointer var6, FlRunnable var7, CPointer var8) throws FlNativeException;

    private native double[] getStatistics(CPointer var1, int var2, int[] var3, CPointer var4) throws FlNativeException;

    private native double[] getHGradMax(CPointer var1, CPointer var2, int var3, int[] var4) throws FlNativeException;

    private native int[] getQualDistribution(CPointer var1, int var2, int[] var3, int var4, CPointer var5) throws FlNativeException;

    private native int[][] getControlEntitiesToKeep(CPointer var1, CPointer var2) throws FlNativeException;

    private native void getVolume(CPointer var1, double[] var2, int var3) throws FlNativeException;

    private native void calcQual(CPointer var1, double[] var2, int var3, CPointer var4) throws FlNativeException;

    private native void smooth(CPointer var1, CPointer var2, CPointer var3, CPointer var4) throws FlNativeException;

    private native void merge(CPointer var1, CPointer var2) throws FlNativeException;

    private native int[][] canonize(CPointer var1, String var2, String var3, CPointer var4) throws FlNativeException;

    private native void renumberElem(CPointer var1, boolean var2) throws FlNativeException;

    private native void toGeom(CPointer var1, CPointer var2, CPointer var3, FlRunnable var4, CPointer var5) throws FlNativeException;

    private native int getSdim(CPointer var1) throws FlNativeException;

    private native double getGScale(CPointer var1) throws FlNativeException;

    private native int[] getEntityRank(CPointer var1, int var2) throws FlNativeException;

    private native int getNumEntity(CPointer var1, int var2) throws FlNativeException;

    private native int getNumConComp(CPointer var1) throws FlNativeException;

    private native void getBndUpDown(CPointer var1, int[][] var2) throws FlNativeException;

    private native void getVtxCoord(CPointer var1, double[][] var2) throws FlNativeException;

    private native int getNumTypes(CPointer var1) throws FlNativeException;

    private native String[] getTypes(CPointer var1) throws FlNativeException;

    private native int getNumVertices(CPointer var1, int var2) throws FlNativeException;

    private native int getNumNodes(CPointer var1, int var2) throws FlNativeException;

    private native int getEDim(CPointer var1, int var2) throws FlNativeException;

    private native int getNumMeshVtx(CPointer var1) throws FlNativeException;

    private native int getNumElem(CPointer var1, int var2) throws FlNativeException;

    private native int getNumElem(CPointer var1, int var2, int[] var3) throws FlNativeException;

    private native int getNumEntityType(CPointer var1, int var2) throws FlNativeException;

    private native void getBounds(CPointer var1, double[] var2) throws FlNativeException;

    private native void getGeomEntities(CPointer var1, int[] var2, int var3) throws FlNativeException;

    private native int[][] adj(CPointer var1, int[][] var2) throws FlNativeException;

    private native void adjSparse(CPointer var1, int[][] var2, CPointer var3) throws FlNativeException;

    private native boolean isSimplexElem(CPointer var1, int var2) throws FlNativeException;

    private native boolean isBlockElem(CPointer var1, int var2) throws FlNativeException;

    private native boolean isPrismElem(CPointer var1, int var2) throws FlNativeException;

    private native int getElemOrder(CPointer var1, int var2) throws FlNativeException;

    private native void checkAgainstGeom(CPointer var1, CPointer var2, boolean var3) throws FlNativeException;

    private native void checkValidMesh(CPointer var1) throws FlNativeException;

    private native void checkValid(CPointer var1, CPointer var2) throws FlNativeException;

    private native void checkInvertedElem(CPointer var1, CPointer var2, CPointer var3) throws FlNativeException;

    private native void meshedEntities(CPointer var1, int var2, int var3, int[] var4) throws FlNativeException;

    private native void initProxy(CPointer var1, CPointer var2) throws FlNativeException;

    private native void updateFromProxy(CPointer var1, CPointer var2) throws FlNativeException;

    private native void generateRenderDrawGeom(CPointer var1, CPointer var2, int var3, int var4, int var5, CPointer var6, int[][] var7, String var8, FlRunnable var9, CPointer var10) throws FlNativeException;

    private static native void generateRenderDraw(CPointer[] var0, CPointer[] var1, boolean[] var2, int var3, String var4, FlRunnable var5, CPointer var6) throws FlNativeException;

    private native void generateRenderDrawGeom(CPointer var1, CPointer var2) throws FlNativeException;

    private native void getRenderMeshCollection(CPointer var1, CPointer var2, int[][] var3, CPointer var4) throws FlNativeException;

    private native void getRenderMeshCollection(CPointer var1, int[][] var2, CPointer var3) throws FlNativeException;

    private native int getSizeInMemory(CPointer var1) throws FlNativeException;

    private native long calculateCheckSum(CPointer var1) throws FlNativeException;

    private native void setMeshVertexBlk(CPointer var1, double[][] var2, int var3);

    private native void getMeshVertexBlk(CPointer var1, double[][] var2, int var3);

    private native void setElemBlk(CPointer var1, String var2, int[][] var3, int var4);

    private native void getElemBlk(CPointer var1, String var2, int[][] var3, int var4);

    private native void setElemEntityBlk(CPointer var1, String var2, int[] var3, int var4);

    private native void getElemEntityBlk(CPointer var1, String var2, int[] var3, int var4);

    private native double[] edgeMaxFaceAngle(CPointer var1, int[] var2, int[] var3, int[] var4, boolean var5) throws FlNativeException;

    private native double[][] getEdgTangentAtVtx(CPointer var1, int[] var2, int[] var3, int var4) throws FlNativeException;

    private native double[][] getEdgParam(CPointer var1) throws FlNativeException;

    private native void cleanupWS(CPointer var1) throws FlNativeException;

    private native void buildMeshImportOperation(CPointer var1, CPointer var2, CPointer var3, FlRunnable var4, CPointer var5) throws FlNativeException;

    private native void buildMeshOperation(CPointer var1, CPointer var2, CPointer var3, CPointer var4, FlRunnable var5, CPointer var6);

    private native void getOperationDefaults(CPointer var1, CPointer var2, CPointer var3, CPointer var4);

    private native boolean hasIncompleteDomains(CPointer var1) throws FlNativeException;

    private native int[] getIncompleteDomains(CPointer var1) throws FlNativeException;

    private native void classifyLinearEntities(CPointer var1, int var2, int[] var3, CPointer var4) throws FlNativeException;

    private native void getCurvatureProperties(CPointer var1, int var2, int var3, boolean var4, CPointer var5) throws FlNativeException;

    private native void improveParameterization(CPointer var1, CPointer var2, CPointer var3, FlRunnable var4, CPointer var5) throws FlNativeException;

    private native int[] partitionClosedEdges(CPointer var1, int var2);

    private native void scale(CPointer var1, double var2, double var4, double var6);

    private native int getNumMeshVtxSel(CPointer var1, int var2, int[] var3);

    private native void getCopyMapping(CPointer var1, CPointer var2, CPointer var3);

    private native int[] checkSelections(CPointer var1, CPointer[] var2, boolean var3) throws FlNativeException;

    private native void removeUnusedMeshVtx(CPointer var1);

    private native void makeLinear(CPointer var1);

    private native void createFromRenderDrawGeom(CPointer var1, CPointer var2);

    private native void updateTriMeshCollEdg(CPointer var1, int var2, int[] var3);

    private native void convertTo3D(CPointer var1);

    private native double getMeanElemSize(CPointer var1, int[][] var2);

    private native boolean needResave(CPointer var1);

    private native int[] storedHighOrderDataOrders(CPointer var1);
}

