/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.nativejni.util;

import com.comsol.nativejni.CPointer;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.FlNativeObject;
import com.comsol.nativejni.util.Prop;
import com.comsol.util.exceptions.FlException;

public class MatrixExch
extends FlNativeObject {
    public MatrixExch(int[] nArray) throws FlNativeException {
        this.initWSDim(this.getCPointer(), nArray, true);
    }

    public MatrixExch(int[] nArray, boolean bl) throws FlNativeException {
        this.initWSDim(this.getCPointer(), nArray, bl);
    }

    public MatrixExch(Prop prop, String string) throws FlNativeException {
        CPointer cPointer = prop.getCPointer();
        this.initWSProp(this.getCPointer(), cPointer, string);
    }

    public void toProp(Prop prop, String string) throws FlNativeException {
        this.toProp(this.getCPointer(), prop.getCPointer(), string);
    }

    public boolean isReal() throws FlNativeException {
        return this.isReal(this.getCPointer());
    }

    public int[] getDim() throws FlNativeException {
        return this.getDim(this.getCPointer());
    }

    public double[] getVal() throws FlNativeException {
        int n = this.a();
        double[] dArray = new double[n];
        this.getVal(this.getCPointer(), dArray);
        return dArray;
    }

    public double[] getVal(int n, int n2) {
        if (n < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n2 < 1) {
            throw new FlException("Stop_index_must_be_greater_than_0");
        }
        if (n2 < n) {
            throw new FlException("Stop_index_must_be_greater_than_or_equal_to_start_index");
        }
        int n3 = this.a(n, n2);
        double[] dArray = new double[n3];
        if (!this.isReal()) {
            n = n * 2 - 1;
        }
        this.getValBlock(this.getCPointer(), dArray, n);
        return dArray;
    }

    public void setVal(double[] dArray) throws FlNativeException {
        this.setVal(this.getCPointer(), dArray);
    }

    public void setValBlock(double[] dArray, int n) {
        if (n < 1) {
            throw new FlException("Start_index_must_be_greater_than_0");
        }
        if (n + dArray.length - 1 > this.a()) {
            throw new FlException("Length_of_values_is_greater_than_total_length");
        }
        if (!this.isReal()) {
            n = n * 2 - 1;
        }
        this.setValBlock(this.getCPointer(), dArray, n);
    }

    public void copy(MatrixExch matrixExch) {
        int n = matrixExch.a();
        this.copy(this.getCPointer(), matrixExch.getCPointer(), n);
    }

    public double getAdr(int n) throws FlNativeException {
        return this.getAdr(this.getCPointer());
    }

    public double getAdr() throws FlNativeException {
        return this.getAdr(this.getCPointer());
    }

    private int a() throws FlNativeException {
        int[] nArray = this.getDim();
        int n = 1;
        int n2 = 0;
        while (n2 < nArray.length) {
            n *= nArray[n2];
            ++n2;
        }
        if (!this.isReal()) {
            n *= 2;
        }
        return n;
    }

    private int a(int n, int n2) throws FlNativeException {
        int[] nArray = this.getDim();
        int n3 = 1;
        if (nArray.length > 0) {
            int n4 = nArray[0] >= n2 ? n2 : nArray[0];
            int n5 = nArray[0] >= n ? n : nArray[0] + 1;
            n3 = n4 - n5 + 1;
            int n6 = 1;
            while (n6 < nArray.length) {
                n3 *= nArray[n6];
                ++n6;
            }
            if (!this.isReal()) {
                n3 *= 2;
            }
        }
        return n3;
    }

    @Override
    protected void doCleanup(CPointer cPointer) throws FlNativeException {
        this.cleanupWS(cPointer);
    }

    private native void initWSProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native void initWSDim(CPointer var1, int[] var2, boolean var3) throws FlNativeException;

    private native void toProp(CPointer var1, CPointer var2, String var3) throws FlNativeException;

    private native boolean isReal(CPointer var1) throws FlNativeException;

    private native int[] getDim(CPointer var1) throws FlNativeException;

    private native void getVal(CPointer var1, double[] var2) throws FlNativeException;

    private native void getValBlock(CPointer var1, double[] var2, int var3) throws FlNativeException;

    private native void setVal(CPointer var1, double[] var2) throws FlNativeException;

    private native void setValBlock(CPointer var1, double[] var2, int var3) throws FlNativeException;

    private native void copy(CPointer var1, CPointer var2, int var3) throws FlNativeException;

    private native double getAdr(CPointer var1) throws FlNativeException;

    private native void cleanupWS(CPointer var1) throws FlNativeException;
}

