/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.application.util;

import com.comsol.model.application.util.IApplicationCommand;
import com.comsol.model.application.util.ModelApiCommand;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.application.AppFeature;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.SuppressableException;
import com.comsol.util.logger.FlLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class ApplicationCommandManager {
    private ArrayList<IApplicationCommand> a = new ArrayList();
    private static ApplicationCommandManager b;

    public void addApplicationCommand(IApplicationCommand iApplicationCommand) {
        if (this.a != null && !this.a.contains(iApplicationCommand)) {
            this.a.add(iApplicationCommand);
        }
    }

    public void removeApplicationCommand(IApplicationCommand iApplicationCommand) {
        if (this.a != null) {
            this.a.remove(iApplicationCommand);
        }
    }

    public void dispose(Model model) {
        if (this.a != null) {
            ArrayList<IApplicationCommand> arrayList = new ArrayList<IApplicationCommand>();
            arrayList.addAll(this.a);
            this.a.clear();
            for (IApplicationCommand iApplicationCommand : arrayList) {
                try {
                    iApplicationCommand.handleShutdown(model);
                }
                catch (RuntimeException runtimeException) {
                    FlLogger.b((Throwable)runtimeException);
                }
            }
        }
        this.a = null;
    }

    public CommandResult fireApplicationCommands(Model model, AppFeature appFeature, CommandData commandData) {
        ArrayList<IApplicationCommand> arrayList = new ArrayList<IApplicationCommand>();
        CommandResult commandResult = new CommandResult();
        if (this.a != null) {
            arrayList.addAll(this.a);
            for (IApplicationCommand iApplicationCommand : arrayList) {
                try {
                    CommandResult commandResult2 = iApplicationCommand.execute(model, appFeature, commandData);
                    if (commandResult2.ex != null) {
                        return commandResult2;
                    }
                    if (!commandResult2.success) continue;
                    return commandResult2;
                }
                catch (SuppressableException suppressableException) {
                    if (suppressableException.suppressed()) {
                        commandResult.ex = suppressableException;
                        break;
                    }
                    throw suppressableException;
                }
                catch (FlException flException) {
                    commandResult.ex = flException;
                    break;
                }
            }
        } else {
            commandResult.output.put("manager", "disposed");
        }
        return commandResult;
    }

    public static ApplicationCommandManager getDefaultInstance() {
        if (b == null) {
            b = new ApplicationCommandManager(){

                @Override
                public CommandResult fireApplicationCommands(Model model, AppFeature appFeature, CommandData commandData) {
                    CommandResult commandResult = super.fireApplicationCommands(model, appFeature, commandData);
                    commandResult.output.put("manager", "deaf");
                    return commandResult;
                }

                @Override
                public void addApplicationCommand(IApplicationCommand iApplicationCommand) {
                }

                @Override
                public void removeApplicationCommand(IApplicationCommand iApplicationCommand) {
                }

                @Override
                public void dispose(Model model) {
                }
            };
            ApplicationCommandManager.b.a.add(new ModelApiCommand());
        }
        return b;
    }

    public static class CommandData {
        public final InfoType type;
        public String command;
        public final Map<String, Object> arguments = new HashMap<String, Object>(5);

        public CommandData(InfoType infoType) {
            this.type = infoType;
        }
    }

    public static class CommandResult {
        public Throwable ex = null;
        public boolean success = false;
        public final Map<String, Object> output = new HashMap<String, Object>();
    }

    public static enum InfoType {
        ViewCommand,
        DesktopCommand,
        MethodExecutionStartCommand,
        DebugHookCommand,
        DebugLogCommand,
        MethodExecutionOverCommand;

    }

    public static class StartupCommandManager
    extends ApplicationCommandManager {
        @Override
        public CommandResult fireApplicationCommands(Model model, AppFeature appFeature, CommandData commandData) {
            switch (commandData.type) {
                case ViewCommand: 
                case DesktopCommand: {
                    return StartupCommandManager.getDefaultInstance().fireApplicationCommands(model, appFeature, commandData);
                }
            }
            return super.fireApplicationCommands(model, appFeature, commandData);
        }
    }
}

