/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.automodeling;

import com.comsol.model.automodeling.AutoSolverSuggestion;
import com.comsol.model.automodeling.AutoSolverSuggestionUtil;
import com.comsol.model.automodeling.AutoSolverType;
import com.comsol.model.automodeling.CouplingFeatureSuggestion;
import com.comsol.model.automodeling.IAutoSolverSuggestion;
import com.comsol.model.automodeling.SolverSuggestionMixer;
import com.comsol.model.automodeling.StrongCouplingSuggestion;
import com.comsol.model.automodeling.WeakCouplingSuggestion;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.properties.StudyStepProperties;
import com.comsol.nativeutil.properties.de;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.logger.FlLogger;
import com.comsol.util.methods.FlStringUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;

public class AutoSolverProvider {
    private String a;
    private List<IAutoSolverSuggestion> b;

    public AutoSolverProvider(String string) {
        this.a = string;
        this.b = new LinkedList<IAutoSolverSuggestion>();
    }

    public void add(IAutoSolverSuggestion[] iAutoSolverSuggestionArray) {
        if (iAutoSolverSuggestionArray != null) {
            IAutoSolverSuggestion[] iAutoSolverSuggestionArray2 = iAutoSolverSuggestionArray;
            int n2 = iAutoSolverSuggestionArray.length;
            int n3 = 0;
            while (n3 < n2) {
                IAutoSolverSuggestion iAutoSolverSuggestion = iAutoSolverSuggestionArray2[n3];
                this.b.add(iAutoSolverSuggestion);
                ++n3;
            }
        }
    }

    public String getAnalysis() {
        return this.a;
    }

    public IAutoSolverSuggestion[] getSolverSuggestions(StudyFeature studyFeature) {
        String[] stringArray = AutoSolverSuggestionUtil.physicsSolvedFor(studyFeature);
        HashMap<String, IAutoSolverSuggestion> hashMap = new HashMap<String, IAutoSolverSuggestion>();
        this.addSuggestions(studyFeature, studyFeature.getModel(), hashMap, stringArray);
        return hashMap.values().toArray(new IAutoSolverSuggestion[0]);
    }

    public void addSuggestions(StudyFeature studyFeature, Model model, HashMap<String, IAutoSolverSuggestion> hashMap, String[] stringArray) {
        Object object;
        Object object2;
        boolean bl2 = false;
        int n2 = 1;
        String[] stringArray2 = studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledcoupling.propName());
        String[] stringArray3 = studyFeature.getStringArray("activateCoupling");
        FlStringList flStringList = new FlStringList();
        int n3 = 0;
        while (n3 < stringArray3.length) {
            if ("off".equals(stringArray3[n3 + 1])) {
                flStringList.add(stringArray3[n3]);
            }
            n3 += 2;
        }
        String[] stringArray4 = flStringList.toArray();
        for (IAutoSolverSuggestion iAutoSolverSuggestion : this.b) {
            if (iAutoSolverSuggestion == null) continue;
            if (AutoSolverType.isCoupling(iAutoSolverSuggestion.getType())) {
                object2 = ((CouplingFeatureSuggestion)iAutoSolverSuggestion).getCoupledEntitiesTags(model, true);
                if (FlStringUtil.containsAny((String[])((CouplingFeatureSuggestion)iAutoSolverSuggestion).getCouplingFeatures(), (String[])stringArray2) || FlStringUtil.containsAny((String[])((CouplingFeatureSuggestion)iAutoSolverSuggestion).getCouplingFeatures(), (String[])stringArray4) || !FlStringUtil.containsAny((String[])object2, (String[])stringArray)) continue;
                if (bl2) {
                    FlLogger.a((String)("CouplingSuggestion" + n2 + ", appl: " + iAutoSolverSuggestion.getAppl()));
                }
                hashMap.put("CouplingSuggestion" + n2++, iAutoSolverSuggestion);
                continue;
            }
            object2 = iAutoSolverSuggestion.getAppl();
            if (object2 == null) {
                hashMap.put("NonPhysics", iAutoSolverSuggestion);
            } else if (FlStringUtil.contains((String[])stringArray, (String)iAutoSolverSuggestion.getAppl())) {
                object = hashMap.get(iAutoSolverSuggestion.getAppl());
                if (object != null) {
                    hashMap.put(iAutoSolverSuggestion.getAppl(), new SolverSuggestionMixer((IAutoSolverSuggestion)object, iAutoSolverSuggestion));
                } else {
                    hashMap.put(iAutoSolverSuggestion.getAppl(), iAutoSolverSuggestion);
                }
            }
            if (!bl2) continue;
            FlLogger.a((String)("PhysicsSuggestion, appl: " + iAutoSolverSuggestion.getAppl()));
        }
        for (IAutoSolverSuggestion iAutoSolverSuggestion : hashMap.values()) {
            de de2;
            Object object3;
            int n4;
            String[] stringArray5;
            if (!AutoSolverType.isCoupling(iAutoSolverSuggestion.getType()) || !((CouplingFeatureSuggestion)iAutoSolverSuggestion).allowOverridePhysicsSuggestion()) continue;
            if (iAutoSolverSuggestion instanceof StrongCouplingSuggestion) {
                object2 = iAutoSolverSuggestion.getSegStepSettings();
                if (object2 != null) {
                    stringArray5 = object = ((CouplingFeatureSuggestion)iAutoSolverSuggestion).getCoupledEntitiesTags(model, true);
                    n4 = ((String[])object).length;
                    int n5 = 0;
                    while (n5 < n4) {
                        object3 = stringArray5[n5];
                        if (hashMap.get(object3) != null && hashMap.get(object3).getSegStepSettings() != null) {
                            hashMap.get(object3).clearSegStepSettings();
                            if (bl2) {
                                FlLogger.a((String)("SegStepSettings cleared: PhysicsSuggestion, appl: " + (String)object3));
                            }
                        }
                        ++n5;
                    }
                }
                if ((object = iAutoSolverSuggestion.getLinSettings(IAutoSolverSuggestion.LinType.main)) == null) continue;
                de2 = object3 = ((CouplingFeatureSuggestion)iAutoSolverSuggestion).getCoupledEntitiesTags(model, true);
                int n6 = ((String[])de2).length;
                n4 = 0;
                while (n4 < n6) {
                    de de3 = de2[n4];
                    if (hashMap.get(de3) != null && hashMap.get(de3).getLinSettings(IAutoSolverSuggestion.LinType.main) != null) {
                        hashMap.get(de3).clearLinSettings();
                        if (bl2) {
                            FlLogger.a((String)("LinSettings cleared: PhysicsSuggestion, appl: " + (String)de3));
                        }
                    }
                    ++n4;
                }
                continue;
            }
            if (!(iAutoSolverSuggestion instanceof WeakCouplingSuggestion)) continue;
            object2 = (WeakCouplingSuggestion)iAutoSolverSuggestion;
            stringArray5 = object = ((WeakCouplingSuggestion)object2).getSegStepPhysics();
            n4 = ((String[])object).length;
            int n7 = 0;
            while (n7 < n4) {
                object3 = stringArray5[n7];
                de2 = ((WeakCouplingSuggestion)object2).getSegStepSettings((String)object3);
                if (de2 != null && hashMap.get(object3) != null && hashMap.get(object3).getSegStepSettings() != null) {
                    hashMap.get(object3).clearSegStepSettings();
                    if (bl2) {
                        FlLogger.a((String)("SegStepSettings cleared: PhysicsSuggestion, appl: " + (String)object3));
                    }
                }
                ++n7;
            }
            de2 = object3 = ((WeakCouplingSuggestion)object2).getLinSolverPhysics();
            int n8 = ((String[])de2).length;
            n4 = 0;
            while (n4 < n8) {
                de de4 = de2[n4];
                IAutoSolverSuggestion.LinSetting linSetting = ((AutoSolverSuggestion)object2).getLinSettings(IAutoSolverSuggestion.LinType.main, ((WeakCouplingSuggestion)object2).getLinSettingsId((String)de4));
                IAutoSolverSuggestion iAutoSolverSuggestion2 = hashMap.get(de4);
                if (linSetting != null && iAutoSolverSuggestion2 != null) {
                    iAutoSolverSuggestion2.clearLinSettings();
                    if (bl2) {
                        FlLogger.a((String)("LinSettings cleared: PhysicsSuggestion, appl: " + (String)de4));
                    }
                }
                ++n4;
            }
        }
    }
}

