/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.data;

import com.comsol.model.data.primitive.AbstractSelectionPrim;
import com.comsol.model.data.primitive.ComplexPrimitive;
import com.comsol.model.data.primitive.DReference;
import com.comsol.model.data.primitive.EntityFlags;
import com.comsol.model.data.primitive.LocalSelectionPrim;
import com.comsol.model.data.primitive.MeshSelectionPrim;
import com.comsol.model.data.primitive.MigrationDReference;
import com.comsol.model.data.primitive.ParamValuePrim;
import com.comsol.model.data.primitive.PropValuePrim;
import com.comsol.model.data.primitive.SelectionPrim;
import com.comsol.model.data.primitive.XDLocalSelectionPrim;
import com.comsol.model.dbimodel.SEL_TYPES;
import com.comsol.nativeutil.data.IModelAttributeUtil;
import com.comsol.nativeutil.properties.bs;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.exceptions.FlException;
import java.util.Arrays;

public class AttributeUtil
implements IModelAttributeUtil {
    public bs createPropValue() {
        return new PropValuePrim(false);
    }

    public String encodeReference(Object object) {
        MigrationDReference migrationDReference = (MigrationDReference)object;
        return migrationDReference.getStringRep();
    }

    public DReference getReference(String string) {
        return new MigrationDReference(string);
    }

    public Object createSelection(IModelAttributeUtil.SelectionTypes selectionTypes, String string, int n2, boolean bl2) {
        LocalSelectionPrim localSelectionPrim;
        MigrationDReference migrationDReference = new MigrationDReference(string);
        switch (selectionTypes) {
            case a: {
                localSelectionPrim = new LocalSelectionPrim(migrationDReference, -1, null);
                break;
            }
            case b: {
                localSelectionPrim = new MeshSelectionPrim(migrationDReference, -1, null);
                break;
            }
            case c: {
                localSelectionPrim = new XDLocalSelectionPrim(migrationDReference, -1, null);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        if (string == null) {
            localSelectionPrim.setSelType(SEL_TYPES.GLOBAL);
        } else if (n2 >= 0) {
            localSelectionPrim.setDim(n2);
            localSelectionPrim.setSelType(SEL_TYPES.GEOMDIM);
            localSelectionPrim.setHDim(n2);
            if (bl2) {
                localSelectionPrim.setAllgeom(true);
            } else {
                localSelectionPrim.setDomains(new CsBitSet(0, 1));
            }
        }
        return localSelectionPrim;
    }

    public Object duplicate(Object object) {
        if (object instanceof ComplexPrimitive) {
            return ((ComplexPrimitive)object).clone();
        }
        if (object instanceof String[]) {
            return Arrays.copyOf((String[])object, ((String[])object).length);
        }
        if (object instanceof String || object instanceof EntityFlags || object instanceof Long || object instanceof Integer || object instanceof Double) {
            return object;
        }
        throw new UnsupportedOperationException("Object type is not supported.");
    }

    public Object duplicateSelection(Object object, String string) {
        if (object instanceof XDLocalSelectionPrim && string != null) {
            XDLocalSelectionPrim xDLocalSelectionPrim = (XDLocalSelectionPrim)object;
            return xDLocalSelectionPrim.clone(string);
        }
        return this.duplicate(object);
    }

    public Object duplicateSelection(IModelAttributeUtil.SelectionTypes selectionTypes, Object object, String string) {
        return AbstractSelectionPrim.duplicateSelection(selectionTypes, (AbstractSelectionPrim)object, string);
    }

    public Object selectionUnion(Object object, Object object2) {
        AbstractSelectionPrim abstractSelectionPrim = (AbstractSelectionPrim)object;
        AbstractSelectionPrim abstractSelectionPrim2 = (AbstractSelectionPrim)object2;
        return AbstractSelectionPrim.migrationSelectionUnion(abstractSelectionPrim, abstractSelectionPrim2);
    }

    public Object removeXDselection(Object object) {
        return AbstractSelectionPrim.removeExtraDimensionAttachment((AbstractSelectionPrim)object);
    }

    public void setLockedSelection(Object object, boolean bl2) {
        AbstractSelectionPrim abstractSelectionPrim = (AbstractSelectionPrim)object;
        abstractSelectionPrim.setLocked(bl2);
    }

    public void clearReference(Object object) {
        if (object != null) {
            ((MigrationDReference)object).clear();
        }
    }

    public int getSDimMax(Object object) {
        return ((SelectionPrim)object).getDim();
    }

    public Object createParamValue(String string, String[][] stringArray) {
        return new ParamValuePrim(null, string, stringArray, null);
    }

    public Object getEntityFlags(String ... stringArray) {
        EntityFlags.Flags[] flagsArray = new EntityFlags.Flags[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            for (EntityFlags.Flags flags : EntityFlags.ALL_FLAGS) {
                if (!flags.name().toLowerCase().equals(stringArray[n2])) continue;
                flagsArray[n2] = flags;
                break;
            }
            if (flagsArray[n2] == null) {
                throw new FlException(String.valueOf(stringArray[n2]) + " is not an entityflag");
            }
            ++n2;
        }
        return new EntityFlags(flagsArray);
    }

    public boolean hasEntityFlag(Object object, String string) {
        EntityFlags entityFlags = (EntityFlags)object;
        for (EntityFlags.Flags flags : EntityFlags.ALL_FLAGS) {
            if (!flags.name().toLowerCase().equals(string)) continue;
            return entityFlags.hasFlag(flags);
        }
        throw new FlException(String.valueOf(string) + " is not an entityflag");
    }

    public Object addEntityFlags(Object object, String ... stringArray) {
        EntityFlags entityFlags;
        EntityFlags entityFlags2 = entityFlags = (EntityFlags)object;
        block0: for (EntityFlags.Flags flags : EntityFlags.ALL_FLAGS) {
            if (entityFlags.hasFlag(flags)) continue;
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (flags.name().toLowerCase().equals(stringArray[n2])) {
                    entityFlags2 = entityFlags2.setFlag(flags);
                    continue block0;
                }
                ++n2;
            }
        }
        return entityFlags != entityFlags2 ? entityFlags2 : null;
    }

    public String[] getPropReference(bs bs2) {
        PropValuePrim propValuePrim = (PropValuePrim)bs2;
        return propValuePrim.getMigrationReferenceStrings();
    }

    public void clearPropReference(bs bs2) {
        ((PropValuePrim)bs2).clearMigrationReferences();
    }

    public void setPropReference(bs bs2, String[] stringArray) {
        PropValuePrim propValuePrim = (PropValuePrim)bs2;
        propValuePrim.setMigrationReferenceStrings(stringArray);
    }

    public Object getPropSelection(bs bs2) {
        PropValuePrim propValuePrim = (PropValuePrim)bs2;
        return propValuePrim.getMigrationSelection();
    }

    public void setPropSelection(bs bs2, Object object) {
        PropValuePrim propValuePrim = (PropValuePrim)bs2;
        propValuePrim.setMigrationSelection((AbstractSelectionPrim)object);
    }
}

