/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.Expression;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.savepoint.interfaces.IExpressionBase;
import com.comsol.model.util.MetaModelUtil;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Base interface for variable collections and parameters")
@PrimitiveModelEntity.PureInterface
public interface ExpressionBase
extends ModelEntity,
IExpressionBase {
    public List<? extends Expression> getExpressionValues();

    public String[][] getExprProp();

    public void setExprProp(String[][] var1);

    public boolean[] getExprSaved();

    public void setExprSaved(boolean[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a variable name and expression", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase set(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="expr", doc="Variable expression") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a variable name and expression", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase set(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="expr", doc="Variable expression") double var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a variable name and expression", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase set(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="expr", doc="Variable expression") String var2, @PrimitiveModelEntity.ParamDoc(name="descr", doc="Variable description") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a variable name and expression", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase set(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="expr", doc="Variable expression") double var2, @PrimitiveModelEntity.ParamDoc(name="descr", doc="Variable description") String var4);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns all variable names", ret="List of variable names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] varnames();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns a variable expression", ret="Variable expression", type=PrimitiveModelEntity.MethodType.READ)
    public String get(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a variable expression", ret="Variable expression", type=PrimitiveModelEntity.MethodType.READ)
    public String descr(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes a variable", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase remove(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes variables", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase remove(@PrimitiveModelEntity.ParamDoc(name="vars", doc="Variable names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes all variables", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase clear();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a variable expression", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase descr(@PrimitiveModelEntity.ParamDoc(name="var", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="descr", doc="Variable description") String var2);

    @Override
    public boolean hasVariable(String var1);

    @Override
    public String getExpanded(String var1);

    @Override
    public String[] getFullVarnames();

    public Expression getExpression(String var1);

    public Expression getExpression(int var1);

    public void setExpression(int var1, Expression var2);

    public void move(int[] var1, int[] var2);

    public void encrypt(String var1, int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Renames a variable without changing the expression or description.", ret="Base expression", type=PrimitiveModelEntity.MethodType.WRITE)
    public ExpressionBase rename(@PrimitiveModelEntity.ParamDoc(name="oldName", doc="Old variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="newName", doc="New variable name") String var2);

    public void addChangedExpressionEvent(ModelEntity var1, String var2, MetaModelUtil.META_EVENT_INFO var3);

    public void removeChangedExpressionEvent(ModelEntity var1, String var2, MetaModelUtil.META_EVENT_INFO var3);

    public ModelEntity getExprSource();
}

