/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.FrameFeature;
import com.comsol.model.dbimodel.FrameFeatureList;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.physics.EquationViewParent;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.savepoint.interfaces.IFrame;
import com.comsol.util.classes.by;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Frame")
public interface Frame
extends ModelEntity,
MultiphysicsContributor,
EquationViewParent,
IFrame {
    public GeomSequence getGeom();

    public List<Physics> getPhysics();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a frame feature", ret="Frame feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public FrameFeature sshape(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Frame feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all frame features", ret="List of frame features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public FrameFeatureList<? extends FrameFeature> sshape();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the geometry", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame geom(@PrimitiveModelEntity.ParamDoc(name="gtag", doc="Geometry sequence tag") String var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the geometry", ret="Geometry sequence tag", type=PrimitiveModelEntity.MethodType.READ)
    public String geom();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns coordinate names. The length of the coordinate vector is always 3", ret="List of coordinate names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] coord();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the coordinate names. The length of the coordinate vector is always 3", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame coord(@PrimitiveModelEntity.ParamDoc(name="coordlist", doc="List of coordinate names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Set the coordinate name in position <code>pos</code>. The length of the coordinate vector is always 3", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame coord(@PrimitiveModelEntity.ParamDoc(name="pos", doc="Position index") int var1, @PrimitiveModelEntity.ParamDoc(name="coord", doc="Coordinate name") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the geometry shape order", ret="Geometry shape order", type=PrimitiveModelEntity.MethodType.READ)
    public int sorder();

    @PrimitiveModelEntity.MethodDoc(doc="Deprecated: use {@link ModelNode#sorder(String)} instead", ret="Frame", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public Frame sorder(@PrimitiveModelEntity.ParamDoc(name="order", doc="Geometry shape order") int var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the frame's identifier", ret="Frame identifier", type=PrimitiveModelEntity.MethodType.READ)
    public String identifier();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the variable name suffix of the frame", ret="Variable name suffix", type=PrimitiveModelEntity.MethodType.READ)
    public String varNameSuffix();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Checks if the frame is the geometry frame", ret="<code>true</code> if geometry frame", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isGeometryFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Sets this frame to be the geometry frame", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame geometryFrame();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Checks if the frame is the mesh frame", ret="<code>true</code> if mesh frame", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isMeshFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the frame to be the mesh frame", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame meshFrame();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Checks if the frame is the material frame", ret="<code>true</code> if material frame", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isMaterialFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the frame to be the material frame", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame materialFrame();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Checks if the frame is the spatial frame", ret="<code>true</code> if spatial frame", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isSpatialFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the frame to be the spatial frame", ret="Frame", type=PrimitiveModelEntity.MethodType.WRITE)
    public Frame spatialFrame();

    @PrimitiveModelEntity.MethodDoc(doc="Get the in-plane components of the coordinate vector, that is, the coordinate names for the geometry's dimension", ret="Coordinate vector", type=PrimitiveModelEntity.MethodType.READ)
    public String[] inPlaneCoord();

    public boolean isRemovableFrame();

    public void setRemovableFrame(boolean var1);

    public String getShapeType();

    public void createReset(Frame var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #isGeometryFrame()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public boolean ismeshframe();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #meshFrame()} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Frame meshframe();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #isMaterialFrame()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public boolean ismaterialframe();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #materialFrame()} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Frame materialframe();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #isSpatialFrame()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public boolean isspatialframe();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #spatialFrame()} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Frame spatialframe();

    public by<String, String> getSolveForTagDescr(boolean var1);
}

