/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.GeomObjectSelection;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionGroup;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Geometry object group selection")
public interface GeomObjectGroupSelection
extends IEventHandler,
GeomObjectSelection {
    public List<? extends SelectionGroup> getGroups();

    public String getWarning();

    public void setWarning(String var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be a selection of whole geometry objects", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection init();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be a selection of geometric entities in a specified dimension", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection init(@PrimitiveModelEntity.ParamDoc(name="dim", doc="Dimension") int var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be the given objects", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection set(String ... var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Adds the given objects to the selection", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection add(String ... var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Removes the given objects from the selection", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection remove(String ... var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be all the entities of an object", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection all(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection on named object to be an entity", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection on named object to be an entity", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object names") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection on named object to be an entity", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Adds the entities to the selection on named object", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection add(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Adds the entities to the selection on named object", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection add(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    public int[] completeSelection(String var1, int[] var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Removes the entities from the selection on named object", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection remove(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Removes the entities from the selection on named object", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection remove(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Clears all entities of the given object from the selection. Does not affect the selection on other objects", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection clear(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a list of names of the groups found", ret="List of names of groups", type=PrimitiveModelEntity.MethodType.READ)
    public String[] groupNames();

    @PrimitiveModelEntity.MethodDoc(doc="Adds the specified groups to the selection", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection addGroup(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection groups", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection setGroup(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the specified groups from the selection", ret="Geometry object group selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectGroupSelection removeGroup(int ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the group numbers for the selected groups", ret="List of group numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] group();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the name of the geometry object that contains the specified detail group", ret="Geometry object name", type=PrimitiveModelEntity.MethodType.READ)
    public String groupObject(@PrimitiveModelEntity.ParamDoc(name="detail", doc="Specified group") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the entity numbers of the specified detail group", ret="List of entity numbers", type=PrimitiveModelEntity.MethodType.READ)
    public int[] groupEntities(@PrimitiveModelEntity.ParamDoc(name="detail", doc="Specified group") int var1);

    public double[] entSize(int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the number of detail groups found", ret="Number of detail groups", type=PrimitiveModelEntity.MethodType.READ)
    public int size();

    public void initialize(String var1, String[] var2, int[][] var3, double[][] var4);

    @Override
    public void createReset(AbstractSelection var1, boolean var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #init()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public GeomObjectGroupSelection object(String var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #init(int)} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public GeomObjectGroupSelection object(String var1, int var2);

    public void sendEntitiesFoundEvent();
}

