/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.IListMove;
import com.comsol.model.dbimodel.ISelectionFilterCache;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.definitions.IDefinitionsList;
import com.comsol.util.interfaces.u;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="List of materials")
public interface MaterialList<T extends Material>
extends IListMove,
ISelectionFilterCache,
PropFeatureList<T>,
IDefinitionsList<Material>,
u {
    public String getCurrentModel();

    public void setCurrentModel(String var1);

    public void touch();

    public List<Boolean> getValid();

    public boolean busyOnDuplicate();

    @PrimitiveModelEntity.MethodDoc(doc="Creates material in current component.", ret="Created material", type=PrimitiveModelEntity.MethodType.WRITE)
    public Material create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Material tag") String var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Creates material of specified type in current component.", ret="Created material", type=PrimitiveModelEntity.MethodType.WRITE)
    public Material create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Material tag") String var1, @PrimitiveModelEntity.ParamDoc(name="type", doc="Material type") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Creates material of specified type in the specified component", ret="Created material", type=PrimitiveModelEntity.MethodType.WRITE)
    public Material create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Material tag") String var1, @PrimitiveModelEntity.ParamDoc(name="type", doc="Material type") String var2, @PrimitiveModelEntity.ParamDoc(name="component", doc="Component, empty string to create a global material.") String var3);

    public void createReset(MaterialList var1, boolean var2);

    public Material addCopy(Material var1, String var2);

    public boolean isValid(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets string property", ret="Property value", type=PrimitiveModelEntity.MethodType.READ)
    public String getString(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets vector string property", ret="Property value", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getStringArray(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets vector matrix property", ret="Property value", type=PrimitiveModelEntity.MethodType.READ)
    public String[][] getStringMatrix(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets string property value", ret="MaterialList", type=PrimitiveModelEntity.MethodType.WRITE)
    public MaterialList<Material> set(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets string vector property value", ret="MaterialList", type=PrimitiveModelEntity.MethodType.WRITE)
    public MaterialList<Material> set(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets string matrix property value", ret="MaterialList", type=PrimitiveModelEntity.MethodType.WRITE)
    public MaterialList<Material> set(@PrimitiveModelEntity.ParamDoc(name="pname", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Insert materials from an mph file into the material list of this model and returns the result of the operation as a double string array of length 3.<br>The first array contains the messages from insert, the second array contains paths to the inserted objects, and the third array contains paths to the inserted references. A pasted reference is an object that a inserted object refers to, and isn't necessarily contained by any of the inserted objects.", ret="Results from the insert operation", type=PrimitiveModelEntity.MethodType.WRITE)
    public String[][] insert(@PrimitiveModelEntity.ParamDoc(name="filename", doc="The file name") String var1, @PrimitiveModelEntity.ParamDoc(name="materials", doc="The tags of the materials to insert") String[] var2, String ... var3);

    public MaterialList<Material> setWithoutLogging(String var1, String var2);
}

