/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.CopyPasteInfo;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.method.ModelEntityListMethod;
import com.comsol.model.savepoint.interfaces.IModelEntityList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;

@PrimitiveModelEntity.TypeDoc(value="Base interface for lists of model object entities.")
public interface ModelEntityList<T extends ModelEntity>
extends ModelEntity,
IModelEntityList<T>,
Iterable<T> {
    @PrimitiveModelEntity.MethodDoc(doc="Creates a new entity with tag <em><code>newTag</code></em> which is a duplicate of the entity tagged <em><code>tag</code></em>", ret="The new entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public T duplicate(@PrimitiveModelEntity.ParamDoc(name="newTag", doc="Tag of the new entity") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of entity to duplicate") String var2);

    @PrimitiveModelEntity.MethodDoc(doc=" Creates a new entity with tag <em><code>newTag</code></em> duplicating the entity tagged <em><code>tag</code></em> and inserts it in this list at a specified position.", ret="The duplicated model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public T duplicateTo(@PrimitiveModelEntity.ParamDoc(name="newTag", doc="Tag of the new entity") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="Tag of the entity to duplicate") String var2, @PrimitiveModelEntity.ParamDoc(doc="The tag of the entity to insert the new entity after, or empty string to insert the new entity first in the list", name="insertAfter") String var3);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns a string array with the tags of all entities.", ret="Tag vector", type=PrimitiveModelEntity.MethodType.READ)
    public String[] tags();

    @Override
    public boolean hasTag(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the number of entities", ret="Number of entities", type=PrimitiveModelEntity.MethodType.READ)
    public int size();

    @PrimitiveModelEntity.MethodDoc(doc="Removes an entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public void remove(@PrimitiveModelEntity.ParamDoc(doc="Tag of entity to remove", name="tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a unique tag in the list context", ret="A unique tag", type=PrimitiveModelEntity.MethodType.READ)
    public String uniquetag(@PrimitiveModelEntity.ParamDoc(doc="The base for the unique tag", name="tag") String var1);

    public String uniquetag(String var1, String var2);

    public boolean isTagAvailable(String var1, String var2);

    public Map<String, T> getTag2Feature();

    public List<T> getListView();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the position in the list of the object with the given tag.", ret="The zero based index of the entity, or -1 if the entity does not exist.", type=PrimitiveModelEntity.MethodType.READ)
    public int index(@PrimitiveModelEntity.ParamDoc(doc="Tag of entity to look up", name="tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get an entity in the list with a given tag", ret="The specified entity", type=PrimitiveModelEntity.MethodType.ACCESS)
    public T get(@PrimitiveModelEntity.ParamDoc(doc="Tag of entity to access", name="tag") String var1);

    public T get(int var1);

    @Override
    public List<T> getActiveList();

    @PrimitiveModelEntity.MethodDoc(doc="Remove all entities in the list.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void clear();

    @PrimitiveModelEntity.MethodDoc(doc="Creates a copy of an entity and inserts it in this list. The tag of the entity to copy is given as a path of tags, '<code>tag1/tag2/tag3</code>' etc.", ret="The copied model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public T copy(@PrimitiveModelEntity.ParamDoc(doc="The tag of the new entity", name="newTag") String var1, @PrimitiveModelEntity.ParamDoc(doc="Tag of the entity to copy", name="tag") String var2);

    public ModelEntity insertNewEntity(ModelEntity var1, String var2, CopyPasteInfo var3);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a copy of an entity, inserts it in this list and assigns it to the given model node. The tag of the entity to copy is given as a path of tags, '<code>tag1/tag2/tag3</code>' etc.", ret="The copied model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public T copy(@PrimitiveModelEntity.ParamDoc(doc="The tag of the new entity", name="newTag") String var1, @PrimitiveModelEntity.ParamDoc(doc="Tag of the entity to copy", name="tag") String var2, @PrimitiveModelEntity.ParamDoc(doc="Tag of the destination model node", name="model") String var3);

    public boolean hasCopyTo();

    @PrimitiveModelEntity.MethodDoc(doc="Creates a copy of an entity and inserts it to this list at a specified position. The tag of the entity to copy is given as a path of tags, '<code>tag1/tag2/tag3</code>' etc.", ret="The copied model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public T copyTo(@PrimitiveModelEntity.ParamDoc(doc="The tag of the new entity", name="newTag") String var1, @PrimitiveModelEntity.ParamDoc(doc="Tag of the entity to copy", name="tag") String var2, @PrimitiveModelEntity.ParamDoc(doc="The tag of the entity to insert the new entity after, or empty string to insert the new entity first in the list", name="insertAfter") String var3);

    public T copyFromModel(String var1, String var2, String var3);

    public boolean containsName(String var1);

    public boolean mightContainName(String var1);

    public boolean containsLabel(String var1);

    public void checkContains(String var1);

    public boolean isTagsInitialized();

    public void setTagsInitialized(boolean var1);

    public Map<String, Integer> getAllTagsMap();

    @Override
    public ModelEntityListMethod<? extends T> method();

    public T findObject(String var1, String var2);

    public void internalRemove(String var1);

    public void internalAdd(int var1, T var2);

    public void internalMove(int var1, int var2);

    @Override
    default public Spliterator<T> spliterator() {
        return Spliterators.spliterator(this.iterator(), (long)this.size(), 1281);
    }

    default public Stream<T> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<T> activeStream() {
        return this.stream().filter(modelEntity -> modelEntity.isActive());
    }

    public boolean moveRequiresNewView(Object var1, int var2);

    public boolean isStaticList();

    public void setGroupAdjustOnMove(boolean var1);

    public boolean groupAdjustOnMove();
}

