/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.Expression;
import com.comsol.model.dbimodel.ExpressionBase;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelParam;
import com.comsol.model.dbimodel.ModelParamGroupCase;
import com.comsol.model.dbimodel.ModelParamGroupCaseList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Parameter group")
public interface ModelParamGroup
extends ExpressionBase,
ModelEntity {
    public void createReset(ModelParamGroup var1, boolean var2);

    public void updateParameterCases();

    public boolean muteUpdateParameterCases();

    public void unmuteUpdateParameterCases();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all parameter cases in the parameter group", ret="List of parameter group cases", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ModelParamGroupCaseList<? extends ModelParamGroupCase> paramCase();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a parameter group case with the given tag", ret="Parameter group case", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ModelParamGroupCase paramCase(@PrimitiveModelEntity.ParamDoc(name="cTag", doc="Parameter group case tag") String var1);

    public ModelParamGroupCaseList<? extends ModelParamGroupCase> getParamCases();

    public ModelParamGroupCaseList<? extends ModelParamGroupCase> getParamCasesGen();

    public ModelParam param();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the parameters in this group should be visible in parameter selection lists.")
    public boolean showInParamSel();

    @PrimitiveModelEntity.MethodDoc(doc="Sets whether to show parameters in this group in parameter selection lists.")
    public void setShowInParamSel(@PrimitiveModelEntity.ParamDoc(name="show", doc="True if parameters in this group should be shown in parameter selection lists.") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the parameters in this group from a specified parameter case.")
    public void setFromCase(@PrimitiveModelEntity.ParamDoc(name="paramCase", doc="The parameter case from which to set the parameters.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a number of named parameters in this group from a specified parameter case.")
    public void setFromCase(@PrimitiveModelEntity.ParamDoc(name="parNames", doc="The names of the parameters to set.") String[] var1, @PrimitiveModelEntity.ParamDoc(name="paramCase", doc="The parameter case from which to set the parameters.") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a parameter case", ret="Created parameter case", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelParamGroupCase create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Parameter case tag") String var1);

    public int getSortedColumn();

    public void setSortedColumn(int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var6);

    @PrimitiveModelEntity.MethodDoc(doc="Moves a parameter to this parameter group", ret="Parameter group", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ModelParamGroup move(@PrimitiveModelEntity.ParamDoc(name="parName", doc="Parameter name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Moves parameters to this parameter group", ret="Parameter group", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ModelParamGroup move(@PrimitiveModelEntity.ParamDoc(name="parNames", doc="Parameter names") String[] var1);

    public List<? extends Expression> getExpressionValues(boolean var1);

    public void postRename(String var1, String var2);
}

