/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.INodeGroupOperation;
import java.util.stream.Stream;

@PrimitiveModelEntity.TypeDoc(value="Node group")
public interface NodeGroup
extends PropFeature,
Iterable<ModelEntity> {
    @PrimitiveModelEntity.MethodDoc(doc="Adds a model entity to the group.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup add(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to add") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Adds a model entity to the group.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup add(@PrimitiveModelEntity.ParamDoc(name="type", doc="The model entity type") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to add") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Removes a model entity from the group.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup remove(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to remove") String var1, @PrimitiveModelEntity.ParamDoc(name="moveBefore", doc="Whether to move the entity before or after the other members of the group.") boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Removes a model entity from the group.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup remove(@PrimitiveModelEntity.ParamDoc(name="type", doc="The model entity type") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to remove") String var2, @PrimitiveModelEntity.ParamDoc(name="moveBefore", doc="Whether to move the entity before or after the other members of the group.") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Places the group after another entity.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup placeAfter(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to place the group after. To place the group before the first entity use <code>null</code> or an empty string as tag.") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Places the group after another entity.", type=PrimitiveModelEntity.MethodType.WRITE)
    public NodeGroup placeAfter(@PrimitiveModelEntity.ParamDoc(name="type", doc="The model entity type") String var1, @PrimitiveModelEntity.ParamDoc(name="tag", doc="The tag of the entity to place the group after. To place the group before the first entity use <code>null</code> or an empty string as tag.") String var2);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Makes the group members active or inactive. If inactivating, members which cannot be inactivated are ignored.", ret="Model entity", type=PrimitiveModelEntity.MethodType.WRITE)
    public ModelEntity active(@PrimitiveModelEntity.ParamDoc(name="flag", doc="<code>true</code>: make active; <code>false</code>: make inactive") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the number of group members.", ret="Number of entities", type=PrimitiveModelEntity.MethodType.READ)
    public int size();

    public int indexOf(ModelEntity var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the group member at the given position.", ret="Group member at the given position.", type=PrimitiveModelEntity.MethodType.READ)
    public ModelEntity get(@PrimitiveModelEntity.ParamDoc(name="index", doc="The position among the members") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the tags of the group members. If there are members of more than one type, the members of the same type as the first member are returned. Use {@link #members(String)} to get the members of a specific type.", ret="Entity tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] members();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the tags of the group members of the specified type.", ret="Entity tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] members(@PrimitiveModelEntity.ParamDoc(name="type", doc="The model entity type") String var1);

    public boolean accept(ModelEntity var1);

    public void setAfter(ModelEntity var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the model entity which this group is placed after. If <code>null</code> is returned, the group is placed before the first model entity.", ret="A model entity or <code>null</code>.", type=PrimitiveModelEntity.MethodType.READ)
    public ModelEntity getAfter();

    public ModelEntity getContext();

    public Stream<ModelEntity> stream();

    public void moveOnAddRemove(boolean var1);

    public void setIgnoreListEvents(boolean var1);

    @Override
    public INodeGroupOperation getOperation();
}

