/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.NumericalBaseFeature;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.operations.INumericalOperation;

@PrimitiveModelEntity.TypeDoc(value="Numerical features evaluate numerical data, such as integrals over a specific set of boundaries")
public interface NumericalFeature
extends NumericalBaseFeature {
    @Override
    public INumericalOperation getOperation();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the list of features in this numerical data feature", ret="List of numerical data features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PropFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Set the interpolation coordinates to use for <code>Interp</code> features. Identical to <code>set(\"coord\", double[][] value)</code>.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setInterpolationCoordinates(@PrimitiveModelEntity.ParamDoc(name="value", doc="Interpolation coordinates") double[][] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real values. Data is ordered such that one row contains data for all solution numbers.", ret="Matrix of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getReal();

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real values.", ret="Matrix of real values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getReal(@PrimitiveModelEntity.ParamDoc(name="columnwise", doc=" If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers.") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real values. Data is ordered such that one row contains data for all solution numbers.", ret="Matrix of real values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getReal(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for.") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real values", ret="Matrix of real values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getReal(@PrimitiveModelEntity.ParamDoc(name="columnwise", doc="If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers.") boolean var1, @PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for.") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the imaginary values.Data is ordered such that one row contains data for all solution numbers", ret="Matrix of imaginary values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getImag();

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the imaginary values. Data is ordered such that one row contains data for all solution numbers", ret="Matrix of imaginary values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getImag(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the imaginary values", ret="Matrix of imaginary values of numerical results", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][] getImag(@PrimitiveModelEntity.ParamDoc(name="allocate", doc="True if imaginary numbers should be generated  even if data is real.") boolean var1, @PrimitiveModelEntity.ParamDoc(name="columnwise", doc="If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers") boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the imaginary values.", ret="Matrix of imaginary values of numerical results", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getImag(@PrimitiveModelEntity.ParamDoc(name="allocate", doc="True if imaginary numbers should be generated even if data is real") boolean var1, @PrimitiveModelEntity.ParamDoc(name="columnwise", doc="If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers.") boolean var2, @PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for.") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Get the number of data vectors in the result", ret="", type=PrimitiveModelEntity.MethodType.READ)
    public int getNData();

    @PrimitiveModelEntity.MethodDoc(doc="Get the number of data vectors in the result for a given outersolnum", ret="Number of data vectors", type=PrimitiveModelEntity.MethodType.READ)
    public int getNData(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="True if the result is complex", ret="<code>true</code> if complex", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isComplex();

    @PrimitiveModelEntity.MethodDoc(doc="", ret="", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isComplex(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get the coordinates from an <code>Eval</code> operation", ret="Coordinates", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getCoordinates();

    @PrimitiveModelEntity.MethodDoc(doc="Get the elements from an <code>Eval</code> operation", ret="Element index", type=PrimitiveModelEntity.MethodType.READ)
    public int[][] getElements();

    @PrimitiveModelEntity.MethodDoc(doc="Get the element each vertex belongs to from an <code>Eval</code> operation", ret="Element index", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getVertexElements();

    @PrimitiveModelEntity.MethodDoc(doc="Get the data from an <code>Eval</code>, <code>Interp</code> or <code>Global</code> operation. The data is ordered data[expr][solnum][vertex]", ret="Retrieved data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][] getData();

    @PrimitiveModelEntity.MethodDoc(doc="Get the data from an <code>Eval</code>, <code>Interp</code> or <code>Global</code> operation, for one specific expression as indicated by its 0-index.", ret="Retrieved data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getData(@PrimitiveModelEntity.ParamDoc(name="expressionIndex", doc="Expression index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Get imaginary data from an <code>Eval</code>, <code>Interp</code> or <code>Global</code> operation, The data is ordered data[expr][solnum][vertex]", ret="Retrieved data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][][] getImagData();

    @PrimitiveModelEntity.MethodDoc(doc="Get imaginary data from an <code>Eval</code>, <code>Interp</code> or <code>Global</code> operation, for one specific expression as indicated by its 0-index.", ret="Retrieved data", type=PrimitiveModelEntity.MethodType.READ)
    public double[][] getImagData(@PrimitiveModelEntity.ParamDoc(name="expressionIndex", doc="Expression index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the result from the numerical feature in its associated table, if any.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setResult();

    @PrimitiveModelEntity.MethodDoc(doc="Appends the result from the numerical feature in its associated table, if any", type=PrimitiveModelEntity.MethodType.WRITE)
    public void appendResult();

    @PrimitiveModelEntity.MethodDoc(doc="Computes the result from the numerical feature, and returns it.", ret="The first element contains the real part of the matrix, the second contains the imaginary part of the matrix (null if none).", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][][] computeResult();

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real and imaginary values. Data is ordered such that one row contains data for all solution numbers.", ret="Array of length 2 where the first element is the real part and the second element is the imaginary part. The imaginary part can be null if the return value is all-real.", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][][] getComplex();

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real and imaginary values. Data is ordered such that one row contains data for all solution numbers.", ret="Array of length 2 where the first element is the real part and the second element is the imaginary part. The imaginary part can be null if the return value is all-real.", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][][] getComplex(@PrimitiveModelEntity.ParamDoc(name="columnwise", doc=" If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers.") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real and imaginary values. Data is ordered such that one row contains data for all solution numbers.", ret="Array of length 2 where the first element is the real part and the second element is the imaginary part. The imaginary part can be null if the return value is all-real.", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][][] getComplex(@PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for.") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Compute the numerical result (or fetch it from the cache) and return the real and imaginary values. Data is ordered such that one row contains data for all solution numbers.", ret="Array of length 2 where the first element is the real part and the second element is the imaginary part. The imaginary part can be null if the return value is all-real.", type=PrimitiveModelEntity.MethodType.WRITE)
    public double[][][] getComplex(@PrimitiveModelEntity.ParamDoc(name="columnwise", doc="If false, data is ordered such that each <b>row</b> contains the values for all solution numbers. If true, one <b>column</b> contains the values for all solution numbers.") boolean var1, @PrimitiveModelEntity.ParamDoc(name="outersolnum", doc="The outer solution number (1-indexed) to retrieve data for.") int var2);
}

