/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.automodeling.AutoSolverManager;
import com.comsol.model.automodeling.AutoSolverProvider;
import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SOLSEQ_TYPES;
import com.comsol.model.dbimodel.SOLVER_MODE;
import com.comsol.model.dbimodel.SavePoint;
import com.comsol.model.dbimodel.SolutionInfo;
import com.comsol.model.dbimodel.SolutionNative;
import com.comsol.model.dbimodel.SolverFeature;
import com.comsol.model.dbimodel.SolverFeatureList;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.XMeshNative;
import com.comsol.model.dbimodel.XmeshInfo;
import com.comsol.nativemph.xmesh.Solution;

@PrimitiveModelEntity.TypeDoc(value="Solver sequence")
public interface SolverSequence
extends IEventHandler,
IFeatureListCreate<SolverFeature>,
ModelEntity {
    public SolverFeatureList<? extends PropFeature> getFeature();

    public SolutionNative getSolutionnative();

    public void setSolutionnative(SolutionNative var1);

    public SolverFeature getCurrentFeature();

    public void setCurrentFeature(SolverFeature var1);

    public SavePoint getSavePoint();

    public void setSavePoint(SavePoint var1);

    public Study getStudyFeature();

    public void setStudyFeature(Study var1);

    public String getParamToString();

    public void setParamToString(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the parameter names", ret="Parameter names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getParamNames();

    public void setParamNames(String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the parameter values", ret="Parameter values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getParamVals();

    public void setParamVals(double[] var1);

    public String[] getParamUnits();

    public void setParamUnits(String[] var1);

    public SOLSEQ_TYPES getSolType();

    public void setSolType(SOLSEQ_TYPES var1);

    public void setSolTypeRaw(SOLSEQ_TYPES var1);

    public boolean isAttachedFlag();

    public SOLVER_MODE getSolverMode();

    public void setSolverMode(SOLVER_MODE var1);

    public void setSolverModeRaw(SOLVER_MODE var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns solution info object", ret="Solution info object", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolutionInfo getSolutioninfo();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all solver features", ret="List of solver features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns solver feature", ret="Solver feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public SolverFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Solver feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Runs solver sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    public String current();

    public SolverSequence current(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Runs all solver sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void runAll();

    @PrimitiveModelEntity.MethodDoc(doc="Continues to run a solver sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void continueRun();

    public Solution getSolution();

    public XMeshNative getXmesh();

    @PrimitiveModelEntity.MethodDoc(doc="Runs the features in a solver sequence to a feature", type=PrimitiveModelEntity.MethodType.READ)
    public void run(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Run to this feature") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Runs the features for a solver sequence from a feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public void runFrom(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Run from this feature") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Copy the solution to a new solver sequence", type=PrimitiveModelEntity.MethodType.WRITE)
    public void copySolution(@PrimitiveModelEntity.ParamDoc(name="fname", doc="Tag of the new solution") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a solver sequence automatically from the study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createAutoSequence(@PrimitiveModelEntity.ParamDoc(name="aSequence", doc="Study tag of the study to generate the solver sequence from") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a solver sequence automatically from the study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createAutoSequence(@PrimitiveModelEntity.ParamDoc(name="aSequence", doc="Study tag of the study to generate the solver sequence from") String var1, @PrimitiveModelEntity.ParamDoc(name="forceSequence", doc="Always create a sequence if true") boolean var2);

    public void registerAutoModeler(AutoSolverProvider var1);

    public void unregisterAutoModeler(AutoSolverProvider var1);

    @PrimitiveModelEntity.MethodDoc(doc="Clears the solution data associated with the solver sequence. Prefer using {@link #clearSolutionData()} instead that generally works as expected.", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public void clearSolution();

    @PrimitiveModelEntity.MethodDoc(doc="Clears the solution data associated with the solver sequence. The features are not changed. Result features are unaffected", type=PrimitiveModelEntity.MethodType.WRITE)
    public void clearSolutionData();

    public void createReset(SolverSequence var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets parameter names", ret="Parameter names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getPNames();

    @PrimitiveModelEntity.MethodDoc(doc="Get solution type", ret="Solution type: <code><i>Stationary</i></code>,<code><i>Parametric</i></code>, <code><i>Time</i></code>, or <code><i>Eigenvalue</i></code>", type=PrimitiveModelEntity.MethodType.READ)
    public String getType();

    @PrimitiveModelEntity.MethodDoc(doc="Returns an array of sizes for the solution data", ret="The number of degrees of freedoms is stored in the first position and the number of solutions (solnums) in the second", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSize();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the number of solutions stored of a type", ret="Number of solutions", type=PrimitiveModelEntity.MethodType.READ)
    public int getNU(@PrimitiveModelEntity.ParamDoc(name="uType", doc="Type of solution: <code><i>Sol</i></code> (main solution), <code><i>Reacf</i></code> (reaction force), <code><i>Adj</i></code> (adjoint solution), <code><i>Fsens</i></code> (functional sensitivity), and <code><i>Sens</i></code> (forward sensitivity)") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Retrieves the real part of the solution vector using a default solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getU();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the real part of the solution vector for a solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the real part of the solution vector for a solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Real part of solution vector") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the real part of the solution vector for a solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="uNum", doc="Solution index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns for a solution of Parametric type the real part of all the parameter values stored", ret="Real part of parameter values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getPVals();

    @PrimitiveModelEntity.MethodDoc(doc="Returns for a solution of Parametric type the real part of all the parameter values stored for a solution number", ret="Real part of parameter values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getPVals(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets real part of the first time-derivative of the solution vector", ret="Real part of first time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDot();

    @PrimitiveModelEntity.MethodDoc(doc="Gets real part of the first time-derivative of the solution vector for a solution number", ret="Real part of first time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDot(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of the solution vector for default solution number", ret="Imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImag();

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of the solution vector for a solution number", ret="Imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of the solution vector for a solution number", ret="Imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of the solution vector for a solution number", ret="Imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="uNum", doc="Solution index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the imaginary part of the parameter values for the default solution number", ret="Imaginary part of the parameter values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getPValsImag();

    @PrimitiveModelEntity.MethodDoc(doc="Gets the imaginary part of the parameter values for a solution number", ret="Imaginary part of the parameter values", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getPValsImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of first time-derivative solution vector for the default solution number", ret="Imaginary part of first time-derivative solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotImag();

    @PrimitiveModelEntity.MethodDoc(doc="Gets imaginary part of first time-derivative solution vector for the default solution number", ret="Imaginary part of first time-derivative solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Test if solver sequence is attached to a study", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isAttached();

    @PrimitiveModelEntity.MethodDoc(doc="Attaches solver sequence to a study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void attach(@PrimitiveModelEntity.ParamDoc(name="study", doc="Study tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Detaches solver sequence from its study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void detach();

    @PrimitiveModelEntity.MethodDoc(doc="Assigns a solver sequence to a study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void study(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Study tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the study tag of a solver sequence", ret="Study tag", type=PrimitiveModelEntity.MethodType.READ)
    public String study();

    @PrimitiveModelEntity.MethodDoc(doc="Updates a solver sequence to make it up to date with respect to the current model", type=PrimitiveModelEntity.MethodType.WRITE)
    public void updateSolution();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the solution is real", ret="<code>true</code> if solution is real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealU();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the solution is real", ret="<code>true</code> if solution is real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the solution is real", ret="<code>true</code> if solution is real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the solution is real", ret="<code>true</code> if solution is real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="uNum", doc="Solution index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the parameters are real", ret="<code>true</code> if parameters are real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealPVals();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the time-derivative of the solution is real", ret="<code>true</code> if parameters are real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealUDot();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the time-derivative of the solution is real", ret="<code>true</code> if parameters are real", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isRealUDot(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the solution vector solution for a default solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUBlock(@PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the solution vector solution for a default solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the solution vector solution for a default solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3, @PrimitiveModelEntity.ParamDoc(name="stop", doc="stop") int var4);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the solution vector solution for a default solution number", ret="Real part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="uNum", doc="Solution INDEX") int var3, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var4, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var5);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the time-derivative of the solution vector solution for a default solution number", ret="Real part of time-derivative of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotBlock(@PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of real part of the time-derivative of the solution vector solution for a default solution number", ret="Real part of time-derivative of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the solution vector solution for a default solution number", ret="Imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImagBlock(@PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the solution vector solution for a default solution number", ret="Imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the solution vector solution for a default solution number", ret="Imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var4);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the solution vector solution for a default solution number", ret="Imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="uType", doc="Solution type") String var2, @PrimitiveModelEntity.ParamDoc(name="uNum", doc="Solution index") int var3, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var4, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var5);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the time-derivative of the solution vector solution for a default solution number", ret="Imaginary part of time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotImagBlock(@PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var1, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Gets blocks of imaginary part of the time-derivative of the solution vector solution for a default solution number", ret="Imaginary part of time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.READ)
    public double[] getUDotImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2, @PrimitiveModelEntity.ParamDoc(name="stop", doc="Stop index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Returns extended mesh information for solution", ret="Extended mesh information", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XmeshInfo xmeshInfo();

    @PrimitiveModelEntity.MethodDoc(doc="Returns extended mesh information for solution for mesh case", ret="Extended mesh information", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XmeshInfo xmeshInfo(@PrimitiveModelEntity.ParamDoc(name="meshCase", doc="Mesh case") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the solution storage format on cluster.", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setClusterStorage(@PrimitiveModelEntity.ParamDoc(name="format", doc="Type of cluster storage format: <code><i>all</i></code> (Solution is stored on all nodes), <code><i>single</i></code> (Only a single node stores the entire solution).") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the solution storage format on cluster.", type=PrimitiveModelEntity.MethodType.READ)
    public String getClusterStorage();

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setU(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of solution vector for a solution number", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setU(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUImag(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets parameter names of solution", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPNames(@PrimitiveModelEntity.ParamDoc(name="names", doc="Parameter names") String[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of parameter values of solution", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPVals(@PrimitiveModelEntity.ParamDoc(name="val", doc="Parameter values") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of parameter values of solution for solution number", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPVals(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Imaginary part of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of parameter values of solution", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPValsImag(@PrimitiveModelEntity.ParamDoc(name="val", doc="Imaginary part of parameter values") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of parameter values of solution", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPValsImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Imaginary part of parameter values") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDot(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets real part of time-derivative of the solution vector for a solution number", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDot(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of time-derivative of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotImag(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets imaginary part of time-derivative of the solution vector for a solution number", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotImag(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Create a solution", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createSolution();

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the real part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUBlock(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="start") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the real part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUImagBlock(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the time derivative of the real part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotBlock(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the time derivative of the real part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the time derivative of the imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotImagBlock(@PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var1, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets blocks of the time derivative of the imaginary part of the solution vector", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setUDotImagBlock(@PrimitiveModelEntity.ParamDoc(name="solnum", doc="Solution number") int var1, @PrimitiveModelEntity.ParamDoc(name="val", doc="Solution vector") double[] var2, @PrimitiveModelEntity.ParamDoc(name="start", doc="Start index") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Gets the default solution number", ret="Default solution number", type=PrimitiveModelEntity.MethodType.READ)
    public int getDefaultSolnum();

    public boolean isMulti();

    @PrimitiveModelEntity.MethodDoc(doc="Returns an array of sizes for the solution data", ret="The number of local degrees of freedoms is stored in the first position and the number of local solutions (local solnums) in the second", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSize(@PrimitiveModelEntity.ParamDoc(name="iMulti", doc="Local solution number in multi solution") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns an array of sizes for the solution data", ret="The number of local solutions in multi solution in the first position and the number of solutions (solnums) in the second", type=PrimitiveModelEntity.MethodType.READ)
    public int[] getSizeMulti();

    @PrimitiveModelEntity.MethodDoc(doc="Returns extended mesh information for solution iMulti of multi solution object", ret="Extended mesh information for solution iMulti of multi solution object", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XmeshInfo xmeshInfo(@PrimitiveModelEntity.ParamDoc(name="iMulti", doc="Local solution number in multi solution") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh tag", ret="Mesh tag", type=PrimitiveModelEntity.MethodType.READ)
    public String getMesh(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns mesh tag", ret="Mesh tag", type=PrimitiveModelEntity.MethodType.READ)
    public String getMesh(@PrimitiveModelEntity.ParamDoc(name="geom", doc="Geometry tag") String var1, @PrimitiveModelEntity.ParamDoc(name="iMulti", doc="Local solution number in multi solution") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Runs the features in a solver sequence from a feature to a feature", type=PrimitiveModelEntity.MethodType.READ)
    public void runFromTo(@PrimitiveModelEntity.ParamDoc(name="fstartname", doc="Run from feature") String var1, @PrimitiveModelEntity.ParamDoc(name="fstopname", doc="Run to feature") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the solution is initialized", ret="<code>true</code> if solution is initialized", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isInitialized();

    @PrimitiveModelEntity.MethodDoc(doc="Get sequence type", ret="Types: <code><i>SolverSequence</i></code>, <code><i>CopySolution</i></code>, <code><i>ParametricStore</i></code>, <code><i>Stored</i></code>, <code><i>Parametric</i></code>,  or <code><i>None</i></code>", type=PrimitiveModelEntity.MethodType.READ)
    public String getSequenceType();

    public void updateSavePointSelections(SavePoint var1);

    public void setSolutionnativeData(SolutionNative var1, SOLSEQ_TYPES var2);

    public void setSolutionnativeRaw(SolutionNative var1);

    public void setSavePointRaw(SavePoint var1);

    public void setAttachedFlag(boolean var1);

    public AutoSolverManager getAutoSolverManager();

    public void touch();

    @PrimitiveModelEntity.MethodDoc(doc="Checks if the solutions associated with the solver sequence are empty.", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isEmpty();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Create a solver feature.", ret="Created solver feature.", type=PrimitiveModelEntity.MethodType.WRITE)
    public SolverFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Feature tag.") String var1, @PrimitiveModelEntity.ParamDoc(name="oper", doc="Type of feature.") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns <code>true</code> if solver sequence has problems", ret="<code>true</code> if solver sequence has problems", type=PrimitiveModelEntity.MethodType.READ)
    public boolean hasProblems();

    @PrimitiveModelEntity.MethodDoc(doc="Returns warning message", ret="Warning message", type=PrimitiveModelEntity.MethodType.READ)
    public String getWarningMessage();

    @PrimitiveModelEntity.MethodDoc(doc="Returns error message", ret="Error message", type=PrimitiveModelEntity.MethodType.READ)
    public String getErrorMessage();

    public boolean isUseConvPlotOffset();

    public void setUseConvPlotOffset(boolean var1);

    public void setContinueSol(SolutionNative var1);

    public SolutionNative getContinueSol();

    public boolean hasContinueSol();

    @PrimitiveModelEntity.MethodDoc(doc="Returns path to adaptation study feature", ret="Path to adaptation study feature", type=PrimitiveModelEntity.MethodType.READ)
    public String adaptationStudyFeature();

    @PrimitiveModelEntity.MethodDoc(doc="Sets adaptation study feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public void adaptationStudyFeature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="A path of tags to the adaptation study feature") String var1);

    public StudyFeature getAdapStudyFeature();

    public void setAdapStudyFeature(StudyFeature var1);

    public String[] getOptConstrExprs();

    public double[] getOptConstrLbnds();

    public double[] getOptConstrUbnds();

    public double[][] getOptConstrVals();

    public void setOptConstrExprs(String[] var1);

    public void setOptConstrLbnds(double[] var1);

    public void setOptConstrUbnds(double[] var1);

    public void setOptConstrVals(double[][] var1);

    public void setOptSolution(String var1);

    public void cleanOptConstrLists();

    public void setConstrFeasibilityInfo(Boolean[] var1);

    public Boolean[] getConstrFeasibilityInfo();

    public SolverFeature getFeatureToEvalDesignConstrs();

    public void setFeatureToEvalDesignConstrs(SolverFeature var1);

    public void setHasInfeasibleDesignConstraints(boolean var1);

    public boolean getHasInfeasibleDesignConstraints();

    public String getOptSolution();
}

