/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.BatchFeature;
import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.dbimodel.IFeatureListCreate;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.InformationList;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.StudyContainer;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyFeatureList;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.classes.an;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="List of study features")
public interface Study
extends IFeatureListCreate<StudyFeature>,
MatchTagContainer,
ModelEntity,
StudyContainer {
    public StudyFeatureList<? extends PropFeature> getFeature();

    public List<? extends SolverSequence> getSolvers();

    public List<? extends BatchFeature> getJobs();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if default results plots should be generated", ret="<code>true</code> if default results plots should be generated", type=PrimitiveModelEntity.MethodType.ACCESS)
    public boolean isGenPlots();

    @PrimitiveModelEntity.MethodDoc(doc="Set if default results plots should be generated", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setGenPlots(@PrimitiveModelEntity.ParamDoc(name="value", doc="<code>true</code> if default results plots should be generated") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if convergence plots should be generated", ret="<code>true</code> if convergence plots should be generated", type=PrimitiveModelEntity.MethodType.ACCESS)
    public boolean isGenConv();

    @PrimitiveModelEntity.MethodDoc(doc="Set if convergence plots should be generated", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setGenConv(@PrimitiveModelEntity.ParamDoc(name="value", doc="<code>true</code> if convergence plots should be generated") boolean var1);

    public boolean isStoreSol();

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if the plots of location of undefined values should be generated", ret="<code>true</code> if plots of location of undefined values should be generated", type=PrimitiveModelEntity.MethodType.ACCESS)
    public boolean isPlotUndefVals();

    @PrimitiveModelEntity.MethodDoc(doc="Set if the plots of location of undefined values should be generated", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setPlotUndefVals(@PrimitiveModelEntity.ParamDoc(name="value", doc="<code>true</code> if the plots of location of undefined values should be generated") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the study steps", ret="List of study steps", type=PrimitiveModelEntity.MethodType.ACCESS)
    public StudyFeatureList<? extends PropFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a study step with the given tag", ret="Requested study tag", type=PrimitiveModelEntity.MethodType.ACCESS)
    public StudyFeature feature(@PrimitiveModelEntity.ParamDoc(name="study", doc="Study tag") String var1);

    public void createReset(Study var1, boolean var2);

    @PrimitiveModelEntity.MethodDoc(doc="Runs the study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void run();

    @PrimitiveModelEntity.MethodDoc(doc="Runs the attached solver sequence without regenerating it", type=PrimitiveModelEntity.MethodType.WRITE)
    public void runNoGen();

    @PrimitiveModelEntity.MethodDoc(doc="Continues the study", type=PrimitiveModelEntity.MethodType.WRITE)
    public void continueRun();

    @PrimitiveModelEntity.MethodDoc(doc="Create an attached solver sequence and/or job using default solver settings", type=PrimitiveModelEntity.MethodType.WRITE)
    public void createAutoSequences(@PrimitiveModelEntity.ParamDoc(name="type", doc="One of <code><i>all</i></code>, <code><i>jobs</i></code>, or <code><i>sol</i></code>") String var1);

    public String mainTag();

    @PrimitiveModelEntity.MethodDoc(doc="Generates a new attached solver sequence and/or job using default solver settings", ret="", type=PrimitiveModelEntity.MethodType.READ)
    public void showAutoSequences(@PrimitiveModelEntity.ParamDoc(name="type", doc="Generates a new attached solver sequence and/or job using default solver settings") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the tags for the solver sequences of a certain type related to this study", ret="Solver sequence tags", type=PrimitiveModelEntity.MethodType.READ)
    public String[] getSolverSequences(@PrimitiveModelEntity.ParamDoc(name="type", doc="One of <code><i>All</i></code>, <code><i>None</i></code>, <code><i>SolverSequence</i></code>, <code><i>CopySolution</i></code>, <code><i>ParametricStore</i></code>, <code><i>Stored</i></code>, or <code><i>Parametric</i></code>.") String var1);

    public boolean determineParametric(Model var1, List<? extends PropFeature> var2, List<String[]> var3, List<String[]> var4, List<String> var5, List<String> var6, List<Boolean> var7, List<String[]> var8, FlStringList var9, FlStringList var10, FlStringList var11, List<Boolean> var12, an var13);

    public LicenseRequirement[] contributeSpecialSteps(StudyFeature var1, StudyFeatureList<? extends PropFeature> var2, EVAL var3);

    public String getExternalStudyTag();

    public void setExternalStudyTag(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the last computation time in milliseconds.", ret="Computation time in milliseconds", type=PrimitiveModelEntity.MethodType.READ)
    public long getLastComputationTime();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the last computation time in the given format. The format can either be a time unit or a text describing a longer format. Currently supported formats are:<br><code>hr:min:sec</code> Returns format in hours, minutes, and seconds in the form <code>X hr Y min Z sec</code>. No translation.<br><code>h:min:s</code> Returns format in hours, minutes, and seconds in the form <code>X h Y min Z s</code>. No translation.<br><code>detailed</code> Returns format in seconds and also includes more readable units for longer times. Translates the output to the current language.<br>", ret="Formatted computation time", type=PrimitiveModelEntity.MethodType.READ)
    public String getLastComputationTime(@PrimitiveModelEntity.ParamDoc(name="format", doc="Time format") String var1);

    public void setLastComputationTime(long var1);

    public InformationList<? extends Information> information();

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Creates a study step", ret="Created study step", type=PrimitiveModelEntity.MethodType.WRITE)
    public StudyFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="Study tag") String var1, @PrimitiveModelEntity.ParamDoc(name="type", doc="Study type") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if there should be a Store Solution node inserted between each Study Step", ret="<code>true</code> if there should be a Store Solution node inserted between each Study Step", type=PrimitiveModelEntity.MethodType.ACCESS)
    public boolean isStoreSolution();

    @PrimitiveModelEntity.MethodDoc(doc="Set if there should be a Store Solution node inserted between each Study Step", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setStoreSolution(@PrimitiveModelEntity.ParamDoc(name="store", doc="<code>true</code> if there should be a Store Solution node inserted between each Study Step") boolean var1);
}

