/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel.physics;

import com.comsol.model.applapi.IApplMode;
import com.comsol.model.applapi.IApplPostInfo;
import com.comsol.model.automodeling.IAutoMeshSuggestion;
import com.comsol.model.automodeling.IAutoSolverSuggestion;
import com.comsol.model.dbimodel.Diagram;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.IPlotAndImageExport;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;
import com.comsol.model.dbimodel.StudyContainer;
import com.comsol.model.dbimodel.physics.EquationViewParent;
import com.comsol.model.dbimodel.physics.FeatureInfo;
import com.comsol.model.dbimodel.physics.FeatureInfoList;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsFeatureList;
import com.comsol.model.dbimodel.physics.PhysicsField;
import com.comsol.model.dbimodel.physics.PhysicsFieldList;
import com.comsol.model.dbimodel.physics.PhysicsProp;
import com.comsol.model.dbimodel.physics.PhysicsPropList;
import com.comsol.model.savepoint.interfaces.IPhysics;
import com.comsol.model.util.ModelInternalUtil;

@PrimitiveModelEntity.TypeDoc(value="Physics interface")
public interface Physics
extends IPlotAndImageExport,
MatchTagContainer,
MultiphysicsContributor,
SelectionEntity,
StudyContainer,
EquationViewParent,
IPhysics {
    public PhysicsPropList<? extends PhysicsProp> getProp();

    public PhysicsFieldList<? extends PhysicsField> getField();

    public PhysicsFeatureList<? extends PhysicsFeature> getFeature();

    public String getApplmodeID();

    @Override
    public GeomSequence getGeom();

    @Override
    public IApplMode getApp();

    public String[] getApplmodeIDs();

    public void setApplmodeIDs(String[] var1);

    public void touch();

    public PhysicsPropList<? extends PhysicsProp> getVirtualProp();

    @Override
    public FeatureInfoList<FeatureInfo> getFeatureInfo();

    public boolean isEdited();

    public void setEdited(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the tag of the geometry which the physics interface lives on. Returns <code>null</code> for 0D physics interfaces", ret="Geometry tag or <code>null</code>", type=PrimitiveModelEntity.MethodType.READ)
    public String geom();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the physics properties", ret="List of physics properties", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsPropList<? extends PhysicsProp> prop();

    @PrimitiveModelEntity.MethodDoc(doc="Returns the physics features", ret="Physics features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsFeatureList<? extends PhysicsFeature> feature();

    @PrimitiveModelEntity.MethodDoc(doc="Returns a physics feature", ret="Physics feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsFeature feature(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The feature tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a physics field", ret="Physics field", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsField field(@PrimitiveModelEntity.ParamDoc(name="field", doc="Field name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a physics property", ret="Physics property", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsProp prop(@PrimitiveModelEntity.ParamDoc(name="propname", doc="Property name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns list of physics fields", ret="List of physics fields", type=PrimitiveModelEntity.MethodType.ACCESS)
    public PhysicsFieldList<? extends PhysicsField> field();

    public void createReset(Physics var1, ModelInternalUtil.ResetPass var2);

    @PrimitiveModelEntity.MethodDoc(doc="Get the type identification", ret="Type identifier", type=PrimitiveModelEntity.MethodType.READ)
    public String getType();

    public String identifierDot();

    public void recreateExternalData(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the top-level diagram feature container, if any", ret="An instance of Diagram or <code>null</code> if the physics interfaces doesn't want or doesn't support diagram visualization", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Diagram diagram();

    @Override
    public IApplPostInfo getPostInfo();

    @PrimitiveModelEntity.MethodDoc(doc="Sets whether to group nodes by space dimension", type=PrimitiveModelEntity.MethodType.WRITE)
    public void setGroupBySpaceDimension(@PrimitiveModelEntity.ParamDoc(name="groupBySpaceDimension", doc="Whether to group nodes by space dimension") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Whether to group nodes by space dimension", ret="Whether to group nodes by space dimension", type=PrimitiveModelEntity.MethodType.WRITE)
    public boolean groupBySpaceDimension();

    public boolean isHandlingGroupBySpaceDimensionChange();

    @Override
    public String getDescription();

    public boolean isDisabled();

    public boolean setDisabled(boolean var1);

    public boolean isAppInitialized();

    public boolean isInitializing();

    public IAutoSolverSuggestion[] getAutoSolverSuggestion(String var1);

    public IAutoMeshSuggestion[] getAutoMeshSuggestions(GeomSequence var1);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a physics feature", ret="Created physics feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public PhysicsFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The feature tag") String var1, @PrimitiveModelEntity.ParamDoc(name="feature", doc="The feature type identifier") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Creates a physics feature", ret="Created physics feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public PhysicsFeature create(@PrimitiveModelEntity.ParamDoc(name="tag", doc="The feature tag") String var1, @PrimitiveModelEntity.ParamDoc(name="feature", doc="The feature type identifier") String var2, @PrimitiveModelEntity.ParamDoc(name="dim", doc="The geometric entity level to assign the feature to") int var3);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #tag()} instead", type=PrimitiveModelEntity.MethodType.READ)
    @Deprecated
    public String identifier();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #tag(String)} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public Physics identifier(@PrimitiveModelEntity.ParamDoc(name="name", doc="Physics interface identifier") String var1);
}

