/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.matlib.AbstractMaterialSocket;
import com.comsol.model.matlib.IExternalMaterialSocket;
import com.comsol.model.matlib.IVariableID;
import com.comsol.model.matlib.MaterialSocketUtil;
import com.comsol.model.matlib.TensorSpecCommon;
import com.comsol.model.matlib.VariableIDCommon;
import com.comsol.model.matlib.VariableIDSpecial;
import com.comsol.model.matlib.VariableIDUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class BuiltinMaterialSockets {
    public static boolean doShowStandardProperty(String string) {
        switch (IExternalMaterialSocket.StandardProperty.valueOf(string)) {
            case callInit: 
            case callCleanup: 
            case complex: 
            case stateName: 
            case errorMessage: 
            case parameters: 
            case stringParameters: {
                return true;
            }
        }
        return false;
    }

    public static class GeneralBHRelationSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.generalBHRelation";
        }

        @Override
        public String getDescription() {
            return "General_BH_relation";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.MAGNETIC_FIELD);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.OldInputComplexPair> getOldInputs(Material material) {
            ArrayList<AbstractMaterialSocket.OldInputComplexPair> arrayList = new ArrayList<AbstractMaterialSocket.OldInputComplexPair>();
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.MAGNETIC_FIELD, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            arrayList.add(new MaterialSocketUtil.VectorState(VariableIDCommon.MAGNETIC_FLUX_DENSITY, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            GeneralBHRelationSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            GeneralBHRelationSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.MAGNETIC_FIELD, MaterialSocketUtil.VECTOR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.MAGNETIC_FIELD, MaterialSocketUtil.VECTOR));
                    MaterialSocketUtil.VectorState vectorState = new MaterialSocketUtil.VectorState(VariableIDCommon.MAGNETIC_FLUX_DENSITY, argClass == MaterialSocketUtil.ArgClass.DCOMPLEX);
                    arrayList.add(new AbstractMaterialSocket.FunctionStateArgument(argClass, vectorState));
                    arrayList.add(new AbstractMaterialSocket.FunctionStateJacobianArgument(argClass, true, vectorState, VariableIDCommon.MAGNETIC_FIELD, MaterialSocketUtil.VECTOR));
                    GeneralBHRelationSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    GeneralBHRelationSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            GeneralBHRelationSocket.addStandardInitFunctionCall(this, material, arrayList);
            GeneralBHRelationSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        protected AbstractMaterialSocket.RowColPair[][] getOutputComponentMap(IVariableID iVariableID) {
            return null;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }

    public static class GeneralHBRelationSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.generalHBRelation";
        }

        @Override
        public String getDescription() {
            return "General_HB_relation";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.MAGNETIC_FLUX_DENSITY);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.OldInputComplexPair> getOldInputs(Material material) {
            ArrayList<AbstractMaterialSocket.OldInputComplexPair> arrayList = new ArrayList<AbstractMaterialSocket.OldInputComplexPair>();
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.MAGNETIC_FLUX_DENSITY, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            arrayList.add(new MaterialSocketUtil.VectorState(VariableIDCommon.MAGNETIC_FIELD, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            GeneralHBRelationSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            GeneralHBRelationSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.MAGNETIC_FLUX_DENSITY, MaterialSocketUtil.VECTOR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.MAGNETIC_FLUX_DENSITY, MaterialSocketUtil.VECTOR));
                    MaterialSocketUtil.VectorState vectorState = new MaterialSocketUtil.VectorState(VariableIDCommon.MAGNETIC_FIELD, argClass == MaterialSocketUtil.ArgClass.DCOMPLEX);
                    arrayList.add(new AbstractMaterialSocket.FunctionStateArgument(argClass, vectorState));
                    arrayList.add(new AbstractMaterialSocket.FunctionStateJacobianArgument(argClass, true, vectorState, VariableIDCommon.MAGNETIC_FLUX_DENSITY, MaterialSocketUtil.VECTOR));
                    GeneralHBRelationSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    GeneralHBRelationSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            GeneralHBRelationSocket.addStandardInitFunctionCall(this, material, arrayList);
            GeneralHBRelationSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        protected AbstractMaterialSocket.RowColPair[][] getOutputComponentMap(IVariableID iVariableID) {
            return null;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }

    public static class GeneralStressDeformationBuiltinSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.generalStressDeformation";
        }

        @Override
        public String getDescription() {
            return "General_stress_deformation_relation";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.DEFORMATION_GRADIENT);
            arrayList.add(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE));
            arrayList.add(VariableIDSpecial.LOCAL_SYSTEM);
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.PK2_STRESS);
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            GeneralStressDeformationBuiltinSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            GeneralStressDeformationBuiltinSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.OldInputComplexPair> getOldInputs(Material material) {
            ArrayList<AbstractMaterialSocket.OldInputComplexPair> arrayList = new ArrayList<AbstractMaterialSocket.OldInputComplexPair>();
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.DEFORMATION_GRADIENT, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE), material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.ROW_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.ROW_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE), MaterialSocketUtil.SCALAR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE), MaterialSocketUtil.SCALAR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDSpecial.LOCAL_SYSTEM, MaterialSocketUtil.ROW_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.DynamicVariableID("not_used", "delta", "not_used", TensorSpecCommon.SCALAR, "", null, null), MaterialSocketUtil.SCALAR));
                    arrayList.add(new AbstractMaterialSocket.FunctionOutputArgument(argClass, VariableIDCommon.PK2_STRESS, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionJacobianArgument(argClass, true, VariableIDCommon.PK2_STRESS, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.VOIGT_ORDER, MaterialSocketUtil.ROW_ORDER));
                    GeneralStressDeformationBuiltinSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    GeneralStressDeformationBuiltinSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            GeneralStressDeformationBuiltinSocket.addStandardInitFunctionCall(this, material, arrayList);
            GeneralStressDeformationBuiltinSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        protected AbstractMaterialSocket.RowColPair[][] getOutputComponentMap(IVariableID iVariableID) {
            return MaterialSocketUtil.INVERSE_VOIGT_ORDER;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }

    public static class GeneralStressStrainBuiltinSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.generalStressStrain";
        }

        @Override
        public String getDescription() {
            return "General_stress_strain_relation";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.GREEN_LAGRANGE_STRAIN);
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.PK2_STRESS);
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            GeneralStressStrainBuiltinSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            GeneralStressStrainBuiltinSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = this.getNumArgClass(material);
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.GREEN_LAGRANGE_STRAIN, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionOutputArgument(argClass, VariableIDCommon.PK2_STRESS, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionJacobianArgument(argClass, true, VariableIDCommon.PK2_STRESS, VariableIDCommon.GREEN_LAGRANGE_STRAIN, MaterialSocketUtil.VOIGT_ORDER, MaterialSocketUtil.VOIGT_ORDER));
                    GeneralStressStrainBuiltinSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    GeneralStressStrainBuiltinSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            GeneralStressStrainBuiltinSocket.addStandardInitFunctionCall(this, material, arrayList);
            GeneralStressStrainBuiltinSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        protected AbstractMaterialSocket.RowColPair[][] getOutputComponentMap(IVariableID iVariableID) {
            return MaterialSocketUtil.INVERSE_VOIGT_ORDER;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }

    public static class InelasticResidualDeformationBuiltinSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.inelasticResidualDeformation";
        }

        @Override
        public String getDescription() {
            return "Inelastic_residual_deformation";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.PK2_STRESS);
            arrayList.add(VariableIDCommon.DEFORMATION_GRADIENT);
            arrayList.add(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE));
            arrayList.add(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.STRAINREFERENCETEMPERATURE));
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            arrayList.add(new MaterialSocketUtil.RowOrderTensorState(VariableIDCommon.INELASTIC_DEFORMATION_GRADIENT, false));
            InelasticResidualDeformationBuiltinSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            InelasticResidualDeformationBuiltinSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.OldInputComplexPair> getOldInputs(Material material) {
            ArrayList<AbstractMaterialSocket.OldInputComplexPair> arrayList = new ArrayList<AbstractMaterialSocket.OldInputComplexPair>();
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.PK2_STRESS, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.DEFORMATION_GRADIENT, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.PK2_STRESS, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.ROW_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.ROW_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE), MaterialSocketUtil.SCALAR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.STRAINREFERENCETEMPERATURE), MaterialSocketUtil.SCALAR));
                    MaterialSocketUtil.RowOrderTensorState rowOrderTensorState = new MaterialSocketUtil.RowOrderTensorState(VariableIDCommon.INELASTIC_DEFORMATION_GRADIENT, false);
                    arrayList.add(new AbstractMaterialSocket.FunctionStateArgument(argClass, rowOrderTensorState));
                    arrayList.add(new AbstractMaterialSocket.FunctionStateJacobianArgument(argClass, true, rowOrderTensorState, VariableIDCommon.DEFORMATION_GRADIENT, MaterialSocketUtil.ROW_ORDER));
                    InelasticResidualDeformationBuiltinSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    InelasticResidualDeformationBuiltinSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            InelasticResidualDeformationBuiltinSocket.addStandardInitFunctionCall(this, material, arrayList);
            InelasticResidualDeformationBuiltinSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }

    public static class InelasticResidualStrainBuiltinSocket
    extends AbstractMaterialSocket {
        @Override
        public String getID() {
            return "com.comsol.inelasticResidualStrain";
        }

        @Override
        public String getDescription() {
            return "Inelastic_residual_strain";
        }

        @Override
        public List<IVariableID> getInputs(Material material) {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            arrayList.add(VariableIDCommon.PK2_STRESS);
            arrayList.add(VariableIDCommon.GREEN_LAGRANGE_STRAIN);
            arrayList.add(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE));
            arrayList.add(new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.STRAINREFERENCETEMPERATURE));
            return arrayList;
        }

        @Override
        public List<IVariableID> getNonStateOutputs() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            return arrayList;
        }

        @Override
        public List<IExternalMaterialSocket.StateDeclaration> getStates(Material material) {
            ArrayList<IExternalMaterialSocket.StateDeclaration> arrayList = new ArrayList<IExternalMaterialSocket.StateDeclaration>();
            arrayList.add(new MaterialSocketUtil.VoigtOrderTensorState(VariableIDCommon.INELASTIC_GREEN_LAGRANGE_STRAIN, false));
            InelasticResidualStrainBuiltinSocket.collectStandardUserDefinedStates(material, arrayList);
            return arrayList;
        }

        @Override
        public List<IVariableID> getMaterialParameters() {
            ArrayList<IVariableID> arrayList = new ArrayList<IVariableID>();
            InelasticResidualStrainBuiltinSocket.collectStandardRuntimeParameters(this, arrayList);
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.OldInputComplexPair> getOldInputs(Material material) {
            ArrayList<AbstractMaterialSocket.OldInputComplexPair> arrayList = new ArrayList<AbstractMaterialSocket.OldInputComplexPair>();
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.PK2_STRESS, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            arrayList.add(new AbstractMaterialSocket.OldInputComplexPair(VariableIDCommon.GREEN_LAGRANGE_STRAIN, material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name())));
            return arrayList;
        }

        @Override
        protected List<AbstractMaterialSocket.IFunctionCallSpecification> getCallSpecifications(Material material) {
            ArrayList<AbstractMaterialSocket.IFunctionCallSpecification> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionCallSpecification>();
            arrayList.add(new AbstractMaterialSocket.FunctionCallAdapter(MaterialSocketUtil.FuncType.EVAL){

                @Override
                protected String getFunctionName(Material material) {
                    return "eval";
                }

                @Override
                protected Collection<AbstractMaterialSocket.IFunctionArgument> getArguments(Material material) {
                    ArrayList<AbstractMaterialSocket.IFunctionArgument> arrayList = new ArrayList<AbstractMaterialSocket.IFunctionArgument>();
                    MaterialSocketUtil.ArgClass argClass = material.getBoolean(IExternalMaterialSocket.StandardProperty.complex.name()) ? MaterialSocketUtil.ArgClass.DCOMPLEX : MaterialSocketUtil.ArgClass.DOUBLE;
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.PK2_STRESS, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionOldInputArgument(argClass, VariableIDCommon.GREEN_LAGRANGE_STRAIN, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, VariableIDCommon.GREEN_LAGRANGE_STRAIN, MaterialSocketUtil.VOIGT_ORDER));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.TEMPERATURE), MaterialSocketUtil.SCALAR));
                    arrayList.add(new AbstractMaterialSocket.FunctionInputArgument(argClass, new VariableIDUtil.QuantityVariableID(PhysicalQuantityID.STRAINREFERENCETEMPERATURE), MaterialSocketUtil.SCALAR));
                    MaterialSocketUtil.VoigtOrderTensorState voigtOrderTensorState = new MaterialSocketUtil.VoigtOrderTensorState(VariableIDCommon.INELASTIC_GREEN_LAGRANGE_STRAIN, false);
                    arrayList.add(new AbstractMaterialSocket.FunctionStateArgument(argClass, voigtOrderTensorState));
                    arrayList.add(new AbstractMaterialSocket.FunctionStateJacobianArgument(argClass, true, voigtOrderTensorState, VariableIDCommon.GREEN_LAGRANGE_STRAIN, MaterialSocketUtil.VOIGT_ORDER));
                    InelasticResidualStrainBuiltinSocket.addAllStandardArguments(this, material, arrayList);
                    return arrayList;
                }

                @Override
                protected Collection<AbstractMaterialSocket.ErrorInfo> getErrors(Material material) {
                    Collection<AbstractMaterialSocket.ErrorInfo> collection = super.getErrors(material);
                    InelasticResidualStrainBuiltinSocket.addStandardErrors(collection);
                    return collection;
                }
            });
            InelasticResidualStrainBuiltinSocket.addStandardInitFunctionCall(this, material, arrayList);
            InelasticResidualStrainBuiltinSocket.addCleanupFunctionCall(this, material, arrayList);
            return arrayList;
        }

        @Override
        public boolean showStandardProperty(String string) {
            return BuiltinMaterialSockets.doShowStandardProperty(string);
        }
    }
}

