/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.matlib;

import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.FunctionFeatureList;
import com.comsol.model.dbimodel.History;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.history.MethodCall;
import com.comsol.model.matlib.MaterialNode;
import com.comsol.nativeutil.constants.XmlPropUtil;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.ag;
import com.comsol.nativeutil.properties.ay;
import com.comsol.nativeutil.properties.ch;
import com.comsol.nativeutil.properties.cj;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.de;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.dk;
import com.comsol.nativeutil.properties.dr;
import com.comsol.nativeutil.properties.ds;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.classes.exprparser.ExprParser;
import com.comsol.util.classes.exprparser.f;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class MaterialFunction {
    private static final boolean c = false;
    private static final String[] d = (String[])Arrays.stream(FunctionType.values()).map(functionType -> functionType.toString()).toArray(String[]::new);
    protected final FunctionType a;
    protected final de b;
    private static /* synthetic */ int[] e;

    public static String[] getMaterialFunctions() {
        return d;
    }

    private MaterialFunction(FunctionType functionType, String string) {
        this.a = functionType;
        List<String> list = this.a(string);
        this.b = new de(list.get(0), list.get(1));
    }

    protected abstract List<String> a(String var1);

    public static final MaterialFunction createNewFunction(FunctionType functionType, String string) {
        switch (MaterialFunction.b()[functionType.ordinal()]) {
            case 1: {
                return new a(string);
            }
            case 2: {
                return new c(string);
            }
            case 3: {
                return new b(string);
            }
        }
        throw new IllegalArgumentException("Unknown function type '" + (Object)((Object)functionType) + "'.");
    }

    public static final void addFromConfigurationElement(MaterialModel materialModel, IConfigurationElement iConfigurationElement) {
        MaterialFunction materialFunction;
        Object object;
        String string = iConfigurationElement.getAttribute("type");
        String string2 = iConfigurationElement.getAttribute("funcname");
        if (FunctionType.ANALYTIC.toString().equalsIgnoreCase(string)) {
            object = new StringBuilder(string2).append(iConfigurationElement.getAttribute("args").replace("[[", "(").replace("]]", ")"));
            materialFunction = MaterialFunction.createNewFunction(FunctionType.ANALYTIC, ((StringBuilder)object).toString());
        } else if (FunctionType.INTERPOLATION.toString().equalsIgnoreCase(string)) {
            materialFunction = MaterialFunction.createNewFunction(FunctionType.INTERPOLATION, string2);
        } else if (FunctionType.PIECEWISE.toString().equalsIgnoreCase(string)) {
            object = new StringBuilder(string2).append(iConfigurationElement.getAttribute("args").replace("[[", "(").replace("]]", ")"));
            materialFunction = MaterialFunction.createNewFunction(FunctionType.PIECEWISE, ((StringBuilder)object).toString());
        } else {
            throw new IllegalArgumentException("Unknown function type '" + string + "'.");
        }
        object = materialFunction.getProperties();
        String[] stringArray = iConfigurationElement.getAttributeNames();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string3 = stringArray[n3];
            Optional.ofNullable(object.getProperty(string3)).ifPresent(property -> {
                String string2 = iConfigurationElement.getAttribute(string3);
                if (property.isMatrixType()) {
                    property.set(XmlPropUtil.b((String[][])q.c((String)string2)));
                } else {
                    property.set(string2);
                }
            });
            ++n3;
        }
        materialFunction.addToModel(materialModel.func());
    }

    public static void addMaterialFunctions(MaterialModel materialModel, MaterialNode materialNode) {
        String string = materialModel.tag();
        for (FunctionFeature functionFeature : materialModel.func()) {
            MaterialFunction.createMaterialFunction(functionFeature).stream().forEach(materialFunction -> materialNode.a((MaterialFunction)materialFunction, string));
        }
    }

    public static List<MaterialFunction> createMaterialFunction(FunctionFeature functionFeature) {
        ArrayList<MaterialFunction> arrayList = new ArrayList<MaterialFunction>();
        String string = functionFeature.getOperationID();
        if (FunctionType.ANALYTIC.toString().equalsIgnoreCase(string)) {
            StringBuilder stringBuilder = new StringBuilder(functionFeature.functionNames()[0]);
            stringBuilder.append('(').append(FlStringUtil.delimitedString((String[])functionFeature.getStringArray("args"), (String)","));
            stringBuilder.append(')');
            MaterialFunction materialFunction = MaterialFunction.createNewFunction(FunctionType.ANALYTIC, stringBuilder.toString());
            materialFunction.a(functionFeature);
            arrayList.add(materialFunction);
        } else if (FunctionType.INTERPOLATION.toString().equalsIgnoreCase(string)) {
            String[] stringArray = functionFeature.functionNames();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                MaterialFunction materialFunction = MaterialFunction.createNewFunction(FunctionType.INTERPOLATION, string2);
                materialFunction.a(functionFeature);
                arrayList.add(materialFunction);
                ++n3;
            }
        } else if (FunctionType.PIECEWISE.toString().equalsIgnoreCase(string)) {
            StringBuilder stringBuilder = new StringBuilder(functionFeature.functionNames()[0]);
            stringBuilder.append('(').append(functionFeature.getString("arg")).append(')');
            MaterialFunction materialFunction = MaterialFunction.createNewFunction(FunctionType.PIECEWISE, stringBuilder.toString());
            materialFunction.a(functionFeature);
            arrayList.add(materialFunction);
        } else {
            throw new IllegalArgumentException("Unknown function type '" + string + "'.");
        }
        return arrayList;
    }

    public FunctionType getType() {
        return this.a;
    }

    public String getName() {
        return this.b.getName();
    }

    public de getProperties() {
        return this.b;
    }

    public void toXML(String string, CsXMLWriter csXMLWriter) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("type");
        arrayList.add(this.a.toString());
        Property[] propertyArray = this.getProperties().getAllProperties();
        int n2 = propertyArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Property property = propertyArray[n3];
            if (property.isMatrixType()) {
                String[][] stringArray = property.getStringMatrix();
                if (!Arrays.deepEquals((Object[])property.getDefaultMatrix(), (Object[])stringArray)) {
                    String string2 = Arrays.deepToString((Object[])XmlPropUtil.a((String[][])stringArray));
                    arrayList.add(property.getName());
                    arrayList.add(string2);
                }
            } else {
                arrayList.add(property.getName());
                arrayList.add(property.getString());
            }
            ++n3;
        }
        csXMLWriter.writeElement(string, arrayList.toArray(new String[arrayList.size()]));
    }

    protected static final List<String> b(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        f f2 = (f)ExprParser.a((String)string, (boolean)true).c(0);
        int n2 = 0;
        while (n2 < f2.k()) {
            String string2 = f2.c(n2).o();
            arrayList.add(string2);
            ++n2;
        }
        return arrayList;
    }

    public abstract String getSignature();

    public abstract void addToModel(FunctionFeatureList var1);

    protected abstract void a(PropFeature var1);

    protected void b(PropFeature propFeature) {
        String string = this.b.getString("_label");
        if (!propFeature.allowDuplicateLabels()) {
            string = propFeature.getUniqueName(string, true);
        }
        propFeature.label(string);
        propFeature.set("fununit", this.b.getString("fununit"));
        propFeature.set("argunit", this.b.getString("argunit"));
    }

    protected void a() {
        this.b.registerProp((Property)new ds("_label", "#Label", this.a.toString()));
        this.b.registerProp((Property)new ds("fununit", "#Function unit", ""));
        this.b.registerProp((Property)new ds("argunit", "#Function argument units", ""));
    }

    protected void c(PropFeature propFeature) {
        this.b.set("fununit", propFeature.getString("fununit"));
        this.b.set("argunit", propFeature.getString("argunit"));
    }

    /* synthetic */ MaterialFunction(FunctionType functionType, String string, MaterialFunction materialFunction) {
        this(functionType, string);
    }

    static /* synthetic */ int[] b() {
        if (e != null) {
            return e;
        }
        int[] nArray = new int[FunctionType.values().length];
        try {
            nArray[FunctionType.ANALYTIC.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FunctionType.INTERPOLATION.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FunctionType.PIECEWISE.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        e = nArray;
        return nArray;
    }

    private static class a
    extends MaterialFunction {
        private a(String string) {
            super(FunctionType.ANALYTIC, string, null);
            List<String> list = this.a(string);
            this.b.registerProp((Property)new ds("funcname", "Function_name", ""));
            this.b.set("funcname", list.get(0));
            this.b.registerProp((Property)new dk("args", "Function_arguments", new String[0]));
            this.b.set("args", list.subList(1, list.size()).toArray(new String[list.size() - 1]));
            this.b.registerProp((Property)new ds("expression", "Function_expression", ""));
            this.b.registerProp((Property)new ds("dermethod", "Automatic_derivation", "automatic"));
            this.b.registerProp((Property)new dr("argders", "Derivative_expressions", new String[0][2]));
            this.a();
        }

        @Override
        protected List<String> a(String string) {
            List<String> list = com.comsol.model.matlib.MaterialFunction$a.b(string);
            if (list.size() < 2) {
                throw new IllegalArgumentException("An analytic function must have at least one argument.");
            }
            return list;
        }

        @Override
        protected void a(PropFeature propFeature) {
            String string = propFeature.getString("funcname");
            String string2 = propFeature.tag();
            this.getProperties().set("expression", propFeature.getString("expr"));
            this.getProperties().set("dermethod", propFeature.getString("dermethod"));
            this.getProperties().set("argders", propFeature.getStringMatrix("argders"));
            this.c(propFeature);
        }

        @Override
        public void addToModel(FunctionFeatureList functionFeatureList) {
            FunctionFeature functionFeature = functionFeatureList.create(this.getName(), this.a.toString());
            functionFeature.set("funcname", this.getName());
            functionFeature.set("args", this.b.getStringArray("args"));
            functionFeature.set("expr", this.b.getString("expression"));
            functionFeature.set("dermethod", this.b.getString("dermethod"));
            if (this.b.getString("dermethod").equals("manual")) {
                functionFeature.set("argders", this.b.getStringMatrix("argders"));
            }
            this.b(functionFeature);
        }

        @Override
        public String getSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.b.getName());
            stringBuilder.append('(');
            String[] stringArray = this.b.getStringArray("args");
            int n2 = 0;
            while (n2 < stringArray.length) {
                stringBuilder.append(stringArray[n2]);
                if (n2 < stringArray.length - 1) {
                    stringBuilder.append(',');
                }
                ++n2;
            }
            stringBuilder.append(')');
            return stringBuilder.toString();
        }

        public String toString() {
            return this.b.getString("expression");
        }
    }

    public static enum FunctionType {
        ANALYTIC("Analytic"),
        PIECEWISE("Piecewise"),
        INTERPOLATION("Interpolation");

        private String name;

        private FunctionType(String string2) {
            this.name = string2;
        }

        public String toString() {
            return this.name;
        }
    }

    private static class b
    extends MaterialFunction {
        private b(String string) {
            super(FunctionType.INTERPOLATION, string, null);
            this.b.registerProp((Property)new ds("funcname", "Function_name", ""));
            this.b.set("funcname", string);
            di di2 = new di(new String[]{"neighbor", "linear", "piecewisecubic", "cubicspline"}, new String[]{"Nearest_neighbor", "Linear", "Piecewise_cubic", "Cubic_spline"});
            this.b.registerProp((Property)new ds("interp", "Interpolation_method", "piecewisecubic", (dd)di2));
            di di3 = new di(new String[]{"const", "interior", "linear", "value"}, new String[]{"Constant", "Nearest_neighbor", "Linear", "Specified_value"});
            this.b.registerProp((Property)new ds("extrap", "Extrapolation_method", "const", (dd)di3));
            this.b.registerProp((Property)new ag("extrapvalue", "Value_outside_range", "NaN"));
            ay ay2 = new ay("datatype", "Type", "model", new String[]{"model", "file"}, new String[]{"Model", "File"});
            this.b.registerProp((Property)ay2);
            di di4 = new di(new String[]{"spreadsheet", "sectionwise", "grid", "table"}, new String[]{"Spreadsheet", "Sectionwise", "Grid", "Table"});
            ay2.registerProp("model", (Property)new ds("structtype", "Struct_type", "table", (dd)di4));
            ay2.registerProp("model", (Property)new dr("coords", "Coordinates", (String[][])new String[0][]));
            ay2.registerProp("model", (Property)new dk("data", "Data_table", new String[0]));
            ay2.registerProp("model", (Property)new dr("elems", "Elements", (String[][])new String[0][]));
            ay2.registerProp("file", (Property)new ds("filename", "Filename", ""));
            ay2.registerProp("file", (Property)new cj("fileindex", "Position_in_file", 1, (dd)new ch(1)));
            this.a();
        }

        @Override
        protected List<String> a(String string) {
            return Arrays.asList(string, string);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void a(PropFeature propFeature) {
            String string = propFeature.tag();
            String string2 = propFeature.getString("interp");
            String string3 = propFeature.getString("extrap");
            String string4 = propFeature.getString("extrapvalue");
            String string5 = propFeature.getString("sourcetype");
            String string6 = propFeature.getString("source");
            if ("user".equalsIgnoreCase(string5)) {
                if ("table".equalsIgnoreCase(string6)) {
                    String string7 = propFeature.getString("funcname");
                    this.getProperties().set("funcname", string7);
                    this.getProperties().set("interp", string2);
                    this.getProperties().set("extrap", string3);
                    this.getProperties().set("extrapvalue", string4);
                    this.getProperties().set("datatype", "model");
                    String[][] stringArray2 = q.d((String[][])propFeature.getStringMatrix("table"));
                    if (stringArray2.length > 0) {
                        this.getProperties().getFromAllProperty("coords").set((String[][])new String[][]{stringArray2[0]});
                        this.getProperties().getFromAllProperty("data").set(stringArray2[1]);
                    }
                } else {
                    if (!"file".equalsIgnoreCase(string6)) throw new IllegalArgumentException("Unknown property value source = '" + string6 + "'.");
                    String[][] stringArray3 = propFeature.getStringMatrix("funcs");
                    Arrays.stream(stringArray3).filter(stringArray -> string.equals(stringArray[0])).findFirst().ifPresent(stringArray -> {
                        this.getProperties().set("funcname", stringArray[0]);
                        this.getProperties().set("interp", string2);
                        this.getProperties().set("extrap", string3);
                        this.getProperties().set("extrapvalue", string4);
                        this.getProperties().set("datatype", "file");
                        this.getProperties().getFromAllProperty("filename").set(propFeature.getString("filename"));
                        this.getProperties().getFromAllProperty("fileindex").set(stringArray[1]);
                    });
                }
            } else {
                if (!"model".equalsIgnoreCase(string5)) throw new IllegalArgumentException("Unknown property value sourcetype = '" + string5 + "'.");
                String[][] stringArray4 = propFeature.getStringMatrix("funcs");
                Arrays.stream(stringArray4).filter(stringArray -> string.equals(stringArray[0])).findFirst().ifPresent(stringArray -> {
                    this.getProperties().set("funcname", stringArray[0]);
                    this.getProperties().set("interp", string2);
                    this.getProperties().set("extrap", string3);
                    this.getProperties().set("extrapvalue", string4);
                    this.getProperties().set("datatype", "model");
                    this.getProperties().getFromAllProperty("structtype").set(propFeature.getString("struct"));
                    String string4 = propFeature.getString("importeddim");
                    String[][] stringArray2 = null;
                    if ("1d".equalsIgnoreCase(string4)) {
                        stringArray2 = new String[1][0];
                    } else if ("2d".equalsIgnoreCase(string4)) {
                        stringArray2 = new String[2][0];
                    } else if ("3d".equalsIgnoreCase(string4)) {
                        stringArray2 = new String[3][0];
                    } else {
                        throw new IllegalArgumentException("Unexpected import dimension of interpolation file: " + string4);
                    }
                    this.getProperties().getFromAllProperty("coords").set(stringArray2);
                });
            }
            this.c(propFeature);
        }

        @Override
        public void addToModel(FunctionFeatureList functionFeatureList) {
            String string = functionFeatureList.getModel().tag();
            if (this.b.getString("datatype").equals("file")) {
                FunctionFeature functionFeature = functionFeatureList.create(this.getName(), this.a.toString());
                functionFeature.set("sourcetype", "user");
                functionFeature.set("source", "file");
                functionFeature.set("filename", this.b.getFromAllProperty("filename").getString().trim());
                functionFeature.setIndex("funcs", this.b.getString("funcname"), 0, 0);
                functionFeature.setIndex("funcs", this.b.getFromAllProperty("fileindex").getString(), 0, 1);
                functionFeature.set("interp", this.b.getString("interp"));
                functionFeature.set("extrap", this.b.getString("extrap"));
                if (this.b.getString("extrap").equals("value")) {
                    functionFeature.set("extrapvalue", this.b.getString("extrapvalue"));
                }
                this.b(functionFeature);
            } else if (this.b.getString("datatype").equals("model")) {
                if (this.b.getFromAllProperty("structtype").getString().equals("table")) {
                    FunctionFeature functionFeature = functionFeatureList.create(this.getName(), this.a.toString());
                    functionFeature.set("sourcetype", "user");
                    functionFeature.set("source", "table");
                    functionFeature.set("funcname", this.b.getString("funcname"));
                    String[][] stringArray = new String[][]{this.b.getFromAllProperty("coords").getStringMatrix()[0], this.b.getFromAllProperty("data").getStringArray()};
                    functionFeature.set("table", q.d((String[][])stringArray));
                    functionFeature.set("interp", this.b.getString("interp"));
                    functionFeature.set("extrap", this.b.getString("extrap"));
                    if (this.b.getString("extrap").equals("value")) {
                        functionFeature.set("extrapvalue", this.b.getString("extrapvalue"));
                    }
                    this.b(functionFeature);
                } else {
                    String string2;
                    String[][] stringArray = this.b.getFromAllProperty("coords").getStringMatrix();
                    switch (stringArray.length) {
                        case 1: {
                            string2 = "1D";
                            break;
                        }
                        case 2: {
                            string2 = "2D";
                            break;
                        }
                        case 3: {
                            string2 = "3D";
                            break;
                        }
                        default: {
                            throw new IllegalArgumentException("Unexpected dimension of coordinates: " + stringArray.length);
                        }
                    }
                    try {
                        File file = SystemUtil.createTempFileForModel((String)string, (String)".ext");
                        String[] stringArray2 = this.b.getFromAllProperty("data").getStringArray();
                        String string3 = this.b.getFromAllProperty("structtype").getString();
                        try (PrintWriter printWriter = new PrintWriter(file);){
                            int n2;
                            if ("spreadsheet".equals(string3)) {
                                printWriter.append("% x ");
                                if (stringArray.length == 3) {
                                    printWriter.append("y z ");
                                } else if (stringArray.length == 2) {
                                    printWriter.append("y ");
                                }
                                printWriter.println(this.b.getString("funcname"));
                                int n3 = 0;
                                while (n3 < stringArray2.length) {
                                    int n4 = 0;
                                    while (n4 < stringArray.length) {
                                        printWriter.print(stringArray[n4][n3]);
                                        printWriter.print(' ');
                                        ++n4;
                                    }
                                    printWriter.println(stringArray2[n3]);
                                    ++n3;
                                }
                            } else if ("sectionwise".equals(string3)) {
                                int n5;
                                printWriter.println("% Coordinates");
                                int n6 = 0;
                                while (n6 < stringArray2.length) {
                                    n5 = 0;
                                    while (n5 < stringArray.length) {
                                        printWriter.print(stringArray[n5][n6]);
                                        printWriter.print(' ');
                                        ++n5;
                                    }
                                    printWriter.println();
                                    ++n6;
                                }
                                String[][] stringArray3 = this.b.getFromAllProperty("elems").getStringMatrix();
                                printWriter.print("% Elements (");
                                if (stringArray3.length == 2) {
                                    printWriter.println("edge)");
                                } else if (stringArray3.length == 3) {
                                    printWriter.println("triangular)");
                                } else if (stringArray3.length == 4) {
                                    printWriter.println("tetrahedral)");
                                }
                                n5 = 0;
                                while (n5 < stringArray3[0].length) {
                                    n2 = 0;
                                    while (n2 < stringArray3.length) {
                                        printWriter.print(stringArray3[n2][n5]);
                                        printWriter.print(' ');
                                        ++n2;
                                    }
                                    printWriter.println();
                                    ++n5;
                                }
                                printWriter.println("% Data");
                                n5 = 0;
                                while (n5 < stringArray2.length) {
                                    printWriter.println(stringArray2[n5]);
                                    ++n5;
                                }
                            } else if ("grid".equals(string3)) {
                                printWriter.println("% Grid");
                                int n7 = 0;
                                while (n7 < stringArray.length) {
                                    String[] stringArray4 = stringArray[n7];
                                    n2 = 0;
                                    while (n2 < stringArray4.length) {
                                        printWriter.print(stringArray4[n2]);
                                        printWriter.print(' ');
                                        ++n2;
                                    }
                                    printWriter.println();
                                    ++n7;
                                }
                                printWriter.println("% Data");
                                n7 = 0;
                                while (n7 < stringArray2.length) {
                                    printWriter.print(stringArray2[n7]);
                                    printWriter.print(' ');
                                    ++n7;
                                }
                            }
                            if (printWriter.checkError()) {
                                throw new IOException("Failure writing to file '" + file.getPath() + "'");
                            }
                        }
                        FunctionFeature functionFeature = functionFeatureList.create(this.getName(), this.a.toString());
                        String string4 = functionFeature.getModel().file().uniquetag("res");
                        FileResource fileResource = (FileResource)functionFeature.getModel().file().create(string4);
                        String string5 = file.getAbsolutePath();
                        fileResource.resource(string5, false);
                        History history = functionFeature.getModel().hist();
                        MethodCall methodCall = new MethodCall((ModelEntity)functionFeature.getModel().file(string4), "resource", (Object)string5);
                        history.log(methodCall);
                        functionFeature.set("sourcetype", "model").set("source", "file").set("struct", string3).set("modelres", string4).set("importedname", string5).set("importeddim", string2).set("importedstruct", string3);
                        if ("spreadsheet".equals(string3)) {
                            functionFeature.set("nargs", stringArray.length);
                        }
                        functionFeature.set("interp", this.b.getString("interp"));
                        functionFeature.set("extrap", this.b.getString("extrap"));
                        if (this.b.getString("extrap").equals("value")) {
                            functionFeature.set("extrapvalue", this.b.getString("extrapvalue"));
                        }
                        this.b(functionFeature);
                    }
                    catch (IOException iOException) {
                        throw new FlException((Throwable)iOException);
                    }
                }
            }
        }

        @Override
        public String getSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.b.getString("funcname"));
            stringBuilder.append("(...)");
            return stringBuilder.toString();
        }

        public String toString() {
            String string;
            if (this.b.getString("datatype").equals("file")) {
                StringBuilder stringBuilder = new StringBuilder(this.b.getFromAllProperty("filename").getString());
                stringBuilder.append(", ").append(this.b.getFromAllProperty("fileindex").getInt());
                return stringBuilder.toString();
            }
            String string2 = this.b.getFromAllProperty("structtype").getString();
            String[][] stringArray = this.b.getFromAllProperty("coords").getStringMatrix();
            switch (stringArray.length) {
                case 1: {
                    string = "1D";
                    break;
                }
                case 2: {
                    string = "2D";
                    break;
                }
                case 3: {
                    string = "3D";
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unexpected dimension of coordinates: " + stringArray.length);
                }
            }
            StringBuilder stringBuilder = new StringBuilder(FlLocale.getString((String)"Imported_interpolation_data"));
            stringBuilder.append(": ").append(string).append(' ').append(string2);
            return stringBuilder.toString();
        }
    }

    private static class c
    extends MaterialFunction {
        private c(String string) {
            super(FunctionType.PIECEWISE, string, null);
            List<String> list = this.a(string);
            this.b.registerProp((Property)new ds("funcname", "Function_name", ""));
            this.b.set("funcname", list.get(0));
            this.b.registerProp((Property)new ds("arg", "Function_argument", ""));
            this.b.set("arg", list.get(1));
            this.b.registerProp((Property)new dr("expressions", "Function_expressions", new String[0][3]));
            di di2 = new di(new String[]{"constant", "interior", "none", "value"}, new String[]{"Constant", "Nearest_interior", "No_extrapolation", "Specified_value"});
            this.b.registerProp((Property)new ds("extrap", "Extrapolation_method", "constant", (dd)di2));
            this.b.registerProp((Property)new ds("extrapvalue", "Extrapolation_value", "0"));
            this.a();
        }

        @Override
        protected List<String> a(String string) {
            List<String> list = com.comsol.model.matlib.MaterialFunction$c.b(string);
            if (list.size() != 2) {
                throw new IllegalArgumentException("A piecewise function must have exactly one argument.");
            }
            return list;
        }

        @Override
        protected void a(PropFeature propFeature) {
            String string = propFeature.getString("funcname");
            String string2 = propFeature.tag();
            this.getProperties().set("funcname", string);
            this.getProperties().set("expressions", propFeature.getStringMatrix("pieces"));
            this.getProperties().set("extrap", propFeature.getString("extrap"));
            this.getProperties().set("extrapvalue", propFeature.getString("extrapvalue"));
            this.c(propFeature);
        }

        @Override
        public void addToModel(FunctionFeatureList functionFeatureList) {
            FunctionFeature functionFeature = functionFeatureList.create(this.getName(), this.a.toString());
            functionFeature.set("funcname", this.getName());
            functionFeature.set("arg", this.b.getString("arg"));
            functionFeature.set("extrap", this.b.getString("extrap"));
            functionFeature.set("pieces", this.b.getStringMatrix("expressions"));
            this.b(functionFeature);
        }

        @Override
        public String getSignature() {
            StringBuilder stringBuilder = new StringBuilder(this.b.getName());
            stringBuilder.append('(').append(this.b.getString("arg")).append(')');
            return stringBuilder.toString();
        }

        public String toString() {
            String[][] stringArray = this.b.getStringMatrix("expressions");
            String[] stringArray2 = new String[stringArray.length];
            int n2 = 0;
            while (n2 < stringArray2.length) {
                stringArray2[n2] = stringArray[n2][2];
                ++n2;
            }
            return "{" + FlStringUtil.delimitedString((String[])stringArray2, (String)",") + "}";
        }
    }
}

