/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.DrawObject;
import com.comsol.model.dbimodel.GeomMeasure;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomObjectSelection;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.operations.SelectionProperty;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.nativemph.cache.CacheManager;
import com.comsol.nativeutil.data.RenderDraw;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.q;
import java.util.List;

public class GeomMeasureMethod
extends ModelEntityMethod {
    public GeomMeasureMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public GeomMeasure getMe() {
        return (GeomMeasure)this.u();
    }

    public int[] getNEntities() {
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        GeomObjectSelection geomObjectSelection = this.getMe().selection();
        List<? extends GeomObject> list = geomObjectSelection.getGeomObjects();
        int n2 = geomSequence.getSDim();
        int[] nArray = new int[n2 + 1];
        for (GeomObject geomObject : list) {
            int[] nArray2 = geomObject.info().getNEntities();
            int n3 = 0;
            while (n3 <= n2) {
                nArray[n3] = nArray[n3] + nArray2[n3];
                ++n3;
            }
        }
        return nArray;
    }

    public double getVolume() {
        if (this.getMe().selection().dimension().length == 0) {
            throw new FlException("You_must_specify_an_entity_selection");
        }
        int n2 = this.getMe().selection().dimension()[0];
        List<? extends GeomObject> list = this.getMe().selection().getGeomObjects();
        int n3 = 0;
        while (n3 < list.size()) {
            if (!list.get(n3).exists()) {
                throw new FlException("Missing_geometry_object");
            }
            ++n3;
        }
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        int n4 = geomSequence.getSDim();
        int n5 = 1;
        int[][] nArray = this.getMe().selection().getEntities(list.toArray(new GeomObject[list.size()]));
        switch (n2) {
            case 0: {
                return this.getNumSelectedVtx();
            }
            case 1: {
                double d2 = 0.0;
                if (n4 == 1) {
                    int n6 = 0;
                    while (n6 < list.size()) {
                        GeomObject geomObject = list.get(n6);
                        double[][] dArray = geomObject.getVertexCoord();
                        int[][] nArray2 = geomObject.getStartEnd();
                        int[] nArray3 = nArray[n6];
                        int n7 = nArray3.length;
                        int n8 = 0;
                        while (n8 < n7) {
                            int n9 = nArray3[n8];
                            d2 = d2 + dArray[0][nArray2[1][n9 - 1] - 1] - dArray[0][nArray2[0][n9 - 1] - 1];
                            ++n8;
                        }
                        ++n6;
                    }
                } else {
                    int n10 = 0;
                    while (n10 < list.size()) {
                        GeomObject geomObject = list.get(n10);
                        int[] nArray4 = nArray[n10];
                        int n11 = nArray4.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            int n13 = nArray4[n12];
                            d2 += geomObject.getEdgeLength(n13);
                            ++n12;
                        }
                        ++n10;
                    }
                }
                return d2;
            }
            case 2: 
            case 3: {
                double d3 = 0.0;
                RenderDraw[] renderDrawArray = GeomMeasureMethod.a(list, geomSequence, n5);
                int n14 = 0;
                while (n14 < list.size()) {
                    double d4 = renderDrawArray[n14].a(n2, nArray[n14]);
                    if (d4 == 0.0 && nArray[n14].length > 0) {
                        throw new FlException("Failed_to_measure_selected_geometry");
                    }
                    d3 += d4;
                    ++n14;
                }
                return d3;
            }
        }
        throw new RuntimeException("Unexpected selection dimension");
    }

    private static RenderDraw[] a(List<? extends GeomObject> list, GeomSequence geomSequence, int n2) {
        String string = "Analyzing_geometry";
        try {
            return geomSequence.method().getRenderDrawArray(list, n2, string, CacheManager.getCacheManager().getLastRenderId(), true);
        }
        catch (FlException flException) {
            if (flException.isCancelException()) {
                throw new FlException("Cancel_button_clicked_while_measuring");
            }
            throw flException;
        }
    }

    public double getBoundaryVolume() {
        if (this.getMe().selection().dimension().length == 0) {
            throw new FlException("You_must_specify_an_entity_selection");
        }
        int n2 = this.getMe().selection().dimension()[0];
        List<? extends GeomObject> list = this.getMe().selection().getGeomObjects();
        int n3 = 0;
        while (n3 < list.size()) {
            if (!list.get(n3).exists()) {
                throw new FlException("Missing_geometry_object");
            }
            ++n3;
        }
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        int n4 = 1;
        if (geomSequence.getSDim() == 3 && n2 == 2) {
            throw new FlException("Perimeter_for_3D_face_selection_is_not_supported");
        }
        switch (n2) {
            case 0: 
            case 1: {
                return 0.0;
            }
            case 2: 
            case 3: {
                double d2 = 0.0;
                int[][] nArray = this.getMe().selection().getEntities(list.toArray(new GeomObject[list.size()]));
                RenderDraw[] renderDrawArray = GeomMeasureMethod.a(list, geomSequence, n4);
                int n5 = 0;
                while (n5 < list.size()) {
                    double d3 = renderDrawArray[n5].b(n2, nArray[n5]);
                    if (d3 == 0.0 && nArray[n5].length > 0) {
                        throw new FlException("Entity_has_no_rendering_mesh");
                    }
                    d2 += d3;
                    ++n5;
                }
                return d2;
            }
        }
        throw new RuntimeException("Unexpected selection dimension");
    }

    /*
     * WARNING - void declaration
     */
    public double[] getVtxCoord() {
        if (this.getNumSelectedVtx() < 1) {
            throw new FlException("You_must_specify_one_vertex_in_the_selection");
        }
        GeomObjectSelection geomObjectSelection = this.getMe().selection();
        List<? extends GeomObject> list = geomObjectSelection.getGeomObjects();
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        int n2 = geomSequence.getSDim();
        double[] dArray = new double[n2];
        if (this.getNumSelectedVtx() == 1) {
            void geomObject;
            double[][] dArray2 = list.get(0).getVertexCoord();
            boolean n3 = false;
            while (geomObject < n2) {
                dArray[geomObject] = dArray2[geomObject][geomObjectSelection.getEntities(list.get(0))[0] - 1];
                ++geomObject;
            }
        } else {
            void var7_12;
            int n4 = 0;
            for (GeomObject n10 : list) {
                int[] nArray;
                double[][] dArray2 = n10.getVertexCoord();
                int[] nArray2 = nArray = geomObjectSelection.getEntities(n10);
                int n3 = nArray.length;
                int n5 = 0;
                while (n5 < n3) {
                    int n6 = nArray2[n5];
                    ++n4;
                    int n7 = 0;
                    while (n7 < n2) {
                        int n8 = n7;
                        dArray[n8] = dArray[n8] + dArray2[n7][n6 - 1];
                        ++n7;
                    }
                    ++n5;
                }
            }
            boolean bl2 = false;
            while (var7_12 < n2) {
                void v1 = var7_12++;
                dArray[v1] = dArray[v1] / (double)n4;
            }
        }
        return dArray;
    }

    public double[] getVtxDistance() {
        int n2;
        int n3;
        Object object;
        GeomObject geomObject;
        if (this.getNumSelectedVtx() != 2) {
            throw new FlException("You_must_specify_two_vertices_in_the_selection");
        }
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        int n4 = geomSequence.getSDim();
        double[] dArray = new double[1 + n4];
        GeomObjectSelection geomObjectSelection = this.getMe().selection();
        List<? extends GeomObject> list = geomObjectSelection.getGeomObjects();
        int n5 = list.size();
        if (n5 == 1) {
            geomObject = list.get(0);
            object = geomObject.getVertexCoord();
            n3 = geomObjectSelection.getEntities(geomObject)[0] - 1;
            int n6 = geomObjectSelection.getEntities(geomObject)[1] - 1;
            n2 = 0;
            while (n2 < n4) {
                dArray[n2 + 1] = object[n2][n6] - object[n2][n3];
                ++n2;
            }
        } else {
            geomObject = list.get(0);
            object = list.get(1);
            double[][] dArray2 = geomObject.getVertexCoord();
            double[][] dArray3 = object.getVertexCoord();
            n2 = geomObjectSelection.getEntities(geomObject)[0] - 1;
            int n7 = geomObjectSelection.getEntities((DrawObject)object)[0] - 1;
            int n8 = 0;
            while (n8 < n4) {
                dArray[n8 + 1] = dArray3[n8][n7] - dArray2[n8][n2];
                ++n8;
            }
        }
        double d2 = 0.0;
        n3 = 0;
        while (n3 < n4) {
            d2 += dArray[n3 + 1] * dArray[n3 + 1];
            ++n3;
        }
        dArray[0] = Math.sqrt(d2);
        n3 = 0;
        while (n3 < n4 + 1) {
            dArray[n3] = dArray[n3];
            ++n3;
        }
        return dArray;
    }

    public int getNumSelectedVtx() {
        int[][] nArray;
        GeomObjectSelection geomObjectSelection = this.getMe().selection();
        List<? extends GeomObject> list = geomObjectSelection.getGeomObjects();
        int[] nArray2 = geomObjectSelection.dimension();
        if (nArray2.length != 1 || nArray2[0] != 0) {
            return 0;
        }
        int n2 = 0;
        int[][] nArray3 = nArray = geomObjectSelection.getEntities(list.toArray(new GeomObject[list.size()]));
        int n3 = nArray.length;
        int n4 = 0;
        while (n4 < n3) {
            int[] nArray4 = nArray3[n4];
            n2 += nArray4.length;
            ++n4;
        }
        return n2;
    }

    @Override
    public ModelEntityPropSet createEntityPropSet() {
        ModelEntityPropSet modelEntityPropSet = new ModelEntityPropSet(this.getMe(), "geom_measurements", "Geometric_measure", true);
        SelectionProperty selectionProperty = new SelectionProperty("input_stat", "Selection", this.getMe().getSelectionFilter(null));
        modelEntityPropSet.registerEntityProp(selectionProperty, "selection", null, null);
        return modelEntityPropSet;
    }

    @Override
    public String toString() {
        return FlLocale.getString((String)"Measure", (boolean)true);
    }

    public double[] getBoundingBox() {
        Object object;
        int n2 = -1;
        if (this.getMe().selection().dimension().length != 0) {
            n2 = this.getMe().selection().dimension()[0];
        }
        GeomSequence geomSequence = (GeomSequence)this.getMe().getContainer();
        int n3 = geomSequence.getSDim();
        double[] dArray = new double[n3 * 2];
        int n4 = 0;
        while (n4 < dArray.length) {
            dArray[n4] = Double.POSITIVE_INFINITY;
            dArray[n4 + 1] = Double.NEGATIVE_INFINITY;
            n4 += 2;
        }
        n4 = 1;
        List<? extends GeomObject> list = this.getMe().selection().getGeomObjects();
        int n5 = 0;
        while (n5 < list.size()) {
            if (!list.get(n5).exists()) {
                throw new FlException("Missing_geometry_object");
            }
            ++n5;
        }
        if (n2 >= 0) {
            object = this.getMe().selection().getEntities(list.toArray(new GeomObject[list.size()]));
            if (((int[][])object).length == 0) {
                return dArray;
            }
        } else {
            object = new int[list.size()][];
        }
        int[] nArray = new int[]{n2};
        if (n2 == -1) {
            nArray = q.a((int)0, (int)1, (int)n3);
        }
        int[] nArray2 = nArray;
        int n6 = nArray.length;
        int n7 = 0;
        while (n7 < n6) {
            int n8 = nArray2[n7];
            switch (n8) {
                case 0: {
                    int n9;
                    Object object2;
                    int n10 = 0;
                    while (n10 < list.size()) {
                        GeomObject geomObject = list.get(n10);
                        object2 = geomObject.getVertexCoordMesh();
                        if (n2 == -1) {
                            n9 = list.get(n10).getNEntities()[n8];
                            object[n10] = q.a((int)1, (int)1, (int)n9);
                        }
                        int[] nArray3 = object[n10];
                        int n11 = nArray3.length;
                        int n12 = 0;
                        while (n12 < n11) {
                            n9 = nArray3[n12];
                            int n13 = 0;
                            while (n13 < n3) {
                                if (object2[n13][n9 - 1] < dArray[2 * n13]) {
                                    dArray[2 * n13] = object2[n13][n9 - 1];
                                }
                                if (object2[n13][n9 - 1] > dArray[2 * n13 + 1]) {
                                    dArray[2 * n13 + 1] = object2[n13][n9 - 1];
                                }
                                ++n13;
                            }
                            ++n12;
                        }
                        ++n10;
                    }
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    int n9;
                    Object object2;
                    RenderDraw[] renderDrawArray = GeomMeasureMethod.a(list, geomSequence, n4);
                    int n14 = 0;
                    while (n14 < list.size()) {
                        if (n2 == -1) {
                            int n15 = list.get(n14).getNEntities()[n8];
                            object[n14] = q.a((int)1, (int)1, (int)n15);
                        }
                        object2 = renderDrawArray[n14].c(n8, object[n14]);
                        n9 = 0;
                        while (n9 < n3) {
                            if (object2[2 * n9] < dArray[2 * n9]) {
                                dArray[2 * n9] = (double)object2[2 * n9];
                            }
                            if (object2[2 * n9 + 1] > dArray[2 * n9 + 1]) {
                                dArray[2 * n9 + 1] = (double)object2[2 * n9 + 1];
                            }
                            ++n9;
                        }
                        ++n14;
                    }
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected selection dimension");
                }
            }
            ++n7;
        }
        return dArray;
    }
}

