/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.automodeling.AutoMeshManager;
import com.comsol.model.automodeling.IAutoMeshProvider;
import com.comsol.model.data.events.NODE_EVENT_TYPES;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.GEOMSEQUENCE_TYPES;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomInfoBase;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.HideMesh;
import com.comsol.model.dbimodel.History;
import com.comsol.model.dbimodel.MESH_TYPES;
import com.comsol.model.dbimodel.MODEL_NODE_TYPES;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshFeatureList;
import com.comsol.model.dbimodel.MeshImportAssocNative;
import com.comsol.model.dbimodel.MeshList;
import com.comsol.model.dbimodel.MeshNative;
import com.comsol.model.dbimodel.MeshSelectionContainer;
import com.comsol.model.dbimodel.MeshSelectionFeature;
import com.comsol.model.dbimodel.MeshSelectionFeatureList;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelNode;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.SelectionFeature;
import com.comsol.model.dbimodel.SelectionList;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.View;
import com.comsol.model.dbimodel.physics.EquationViewParent;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbmodel.CommonFeatureDb;
import com.comsol.model.dbmodel.MeshFeatureDb;
import com.comsol.model.dbmodel.physics.MultiphysicsCouplingDb;
import com.comsol.model.dbmodel.physics.PhysicsDb;
import com.comsol.model.history.ComponentSyntaxUtil;
import com.comsol.model.history.MethodCall;
import com.comsol.model.method.GeomSequenceMethod;
import com.comsol.model.method.MeshFeatureMethod;
import com.comsol.model.method.ModelEntityMethod;
import com.comsol.model.method.PropFeatureListMethod;
import com.comsol.model.method.internal.IGeomSequenceInternal;
import com.comsol.model.method.internal.IMeshSelectionInternal;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.operations.HAutoTable;
import com.comsol.model.operations.IMeshOperation;
import com.comsol.model.operations.IMeshPropCollector;
import com.comsol.model.operations.MeshBuildData;
import com.comsol.model.properties.AbstractModelEntityGetSetHandler;
import com.comsol.model.properties.ModelEntityGroupProp;
import com.comsol.model.properties.ModelEntityPropSet;
import com.comsol.model.properties.ModelEntityPropSetVisibilityConstraint;
import com.comsol.model.savepoint.interfaces.IModelNode;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.EventWrapper;
import com.comsol.model.util.MetaModelUtil;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ReInitInfo;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativemph.cache.CacheManager;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.mesh.Mesh;
import com.comsol.nativemph.mesh.MeshImportAssoc;
import com.comsol.nativemph.mesh.NastranEntry;
import com.comsol.nativemph.mesh.c;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.nativeutil.data.RenderMeshCollection;
import com.comsol.nativeutil.properties.IAnnotation;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.bk;
import com.comsol.nativeutil.properties.bx;
import com.comsol.nativeutil.properties.by;
import com.comsol.nativeutil.properties.dd;
import com.comsol.nativeutil.properties.di;
import com.comsol.nativeutil.properties.dr;
import com.comsol.nativeutil.properties.ds;
import com.comsol.nativeutil.properties.e;
import com.comsol.nativeutil.runnable.s;
import com.comsol.nativeutil.w;
import com.comsol.systemutils.SystemUtil;
import com.comsol.util.classes.CsIntMultimap;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.classes.UndoType;
import com.comsol.util.classes.an;
import com.comsol.util.classes.bg;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlNumberUtil;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import org.xml.sax.helpers.AttributesImpl;

public class MeshSequenceMethod
extends ModelEntityMethod {
    public static final String meshSizeDefault = "MeshSizeDefault";
    public static final String meshFinalizeNode = "Finalize";
    public static final boolean debugMeshBuild = false;
    private boolean b = false;
    private boolean c = false;
    private boolean d = false;
    private boolean e = false;
    private double[] f;
    private boolean g = false;
    private boolean h = false;
    private boolean i = false;
    private boolean j = false;

    public MeshSequenceMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public MeshSequence getMe() {
        return (MeshSequence)this.u();
    }

    public static boolean isOperationStartingImport(String string) {
        return "Import".equals(string) || "CreateVertices".equals(string);
    }

    public static void debugPrintOut(String string) {
    }

    public void addEventHandlers() {
        EventManagerWrapper eventManagerWrapper = new EventManagerWrapper(this.getModel());
        eventManagerWrapper.addEntityEventHandler(this.m(), "GeomRemove", this.getMe(), NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
        eventManagerWrapper.addAttributeEventHandler(this.m(), "ScaleAngularUnit", this.getMe(), "angularUnit", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
        eventManagerWrapper.addAttributeEventHandler(this.m(), "ScaleLengthUnit", this.getMe(), "lengthUnit", MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
        eventManagerWrapper.addEntityEventHandler(this.getMe(), "RemoveMesh", this.getMe(), NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_PERMANENT);
    }

    public void handleEvent(EventWrapper eventWrapper) {
        switch (eventWrapper.getTag()) {
            case "GeomRemove": {
                ModelEntityList modelEntityList = (ModelEntityList)this.getMe().getContainer();
                if (modelEntityList == null) break;
                modelEntityList.remove(this.n());
                break;
            }
            case "ScaleLengthUnit": 
            case "ScaleAngularUnit": {
                this.updateHashKey(true);
                break;
            }
            case "RemoveMesh": {
                MeshNative meshNative;
                GeomSequence geomSequence;
                this.removeHides();
                if (this.m().isInModel() && this.m().measureFinal().selection().mesh().equals(this.n())) {
                    this.m().measureFinal().selection().mesh("");
                }
                if ((geomSequence = this.m()) == null || !geomSequence.isInModel() || (meshNative = this.getMe().getMeshnativeRaw()) != geomSequence.getGeomInfo()) break;
                geomSequence.updateGeomInfo();
                break;
            }
            case "ContibutorRemove": {
                ModelEntity modelEntity = (ModelEntity)eventWrapper.getObject();
                this.contribute(modelEntity, false);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public void removeHides() {
        GeomSequence geomSequence = this.m();
        MeshSequence meshSequence = this.getMe();
        for (View view : this.getModel().view()) {
            void n2;
            if (view.getGeomSequence() != geomSequence) continue;
            FlStringList flStringList = new FlStringList();
            for (HideMesh hideMesh : view.hideMesh()) {
                if (hideMesh.getMesh() != meshSequence) continue;
                flStringList.add(hideMesh.tag());
            }
            int n3 = flStringList.size();
            while (n2 > 0) {
                view.hideMesh().remove(flStringList.get((int)(n2 - true)));
                --n2;
            }
        }
    }

    private MESH_TYPES k() {
        return this.getMe().getType();
    }

    public boolean isBuilding() {
        return this.g;
    }

    public void initialize() {
        GeomSequence geomSequence = this.m();
        boolean bl2 = false;
        boolean bl3 = false;
        String[] stringArray = geomSequence.meshes();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String object = stringArray[n3];
            MESH_TYPES mESH_TYPES = this.getModel().mesh(object).getType();
            boolean bl4 = this.getModel().mesh(object).method().w();
            if (mESH_TYPES == MESH_TYPES.IMPORTED) {
                bl2 = true;
            } else if (!object.equals(this.n()) && !bl4) {
                bl3 = true;
            }
            ++n3;
        }
        if (this.k() == MESH_TYPES.AUTOMATIC || this.k() == MESH_TYPES.MANUAL) {
            for (ModelEntity modelEntity : this.getMe().getAllSuggestionProviders()) {
                this.contribute(modelEntity, true);
            }
        }
        if (!geomSequence.allowsMeshImportSequence() && geomSequence.getSDim() > 0 || bl3 && !bl2) {
            if (!this.hasSizeDefaults()) {
                this.createMeshSizeDefaults(null);
                if (geomSequence.needsBuildFinal(false)) {
                    geomSequence.run();
                }
            }
        } else if (this.k() == MESH_TYPES.IMPORTED) {
            this.createMeshFinalizeNode(true);
        }
        this.updateHashKey(false);
    }

    public void reInitializeThis(ReInitInfo reInitInfo) {
        ReInitInfo reInitInfo2 = reInitInfo.modifiedCopy(true);
        this.m().reInitialize(reInitInfo2);
        for (PropFeature modelEntity : this.x()) {
            modelEntity.reInitialize(reInitInfo2);
        }
        this.getMe().getConstructionEntitiesToKeep();
        for (ModelEntity modelEntity : this.getMe().getContributingInterfaces()) {
            this.a(modelEntity, true);
        }
    }

    private MeshFeatureList<MeshFeature> l() {
        return this.getMe().getFeature();
    }

    public void postLoadInitializeThis(boolean bl2) {
        Mesh mesh;
        int n2;
        int n3;
        boolean bl3 = true;
        if (MESH_TYPES.IMPORTED == this.k()) {
            bl3 = this.getFinalizeFeature() != null;
        } else if (MESH_TYPES.MANUAL == this.k()) {
            n3 = this.l().size();
            bl3 = n3 == 0;
            n2 = 0;
            while (n2 < n3 && !bl3) {
                bl3 = !((MeshFeature)this.l().get(n2)).getOperationID().equals("Import");
                ++n2;
            }
        }
        n3 = this.r();
        if (!bl3) {
            this.toggleFinalizeNodeForType(MESH_TYPES.IMPORTED);
            this.getMe().setTypeGen(MESH_TYPES.IMPORTED);
            n2 = 1;
            for (MeshFeature modelEntity2 : this.l()) {
                if (modelEntity2.getOperationID().equals("Import") && modelEntity2.isActive()) {
                    if (modelEntity2.getImportAssocIO() == null) {
                        modelEntity2.setImportAssocIO(new int[0][]);
                    }
                    if (modelEntity2.isBuilt()) continue;
                    n2 = 0;
                    continue;
                }
                if (!modelEntity2.getOperationID().equals(meshFinalizeNode)) continue;
                modelEntity2.setImportAssocIO(new int[0][]);
                if (n2 == 0) continue;
                mesh = this.getMesh();
                if (mesh != null) {
                    this.getMe().setLastBuiltFeature(modelEntity2);
                    modelEntity2.setBuildStatus(FEATURE_STATUS.BUILT);
                    int[][][] nArrayArray = new int[n3 + 1][][];
                    int n4 = 0;
                    while (n4 <= n3) {
                        nArrayArray[n4] = new int[mesh.x()[n4] + 1][];
                        nArrayArray[n4][0] = new int[0];
                        int n5 = 1;
                        while (n5 < nArrayArray[n4].length) {
                            nArrayArray[n4][n5] = new int[]{n5 - 1};
                            ++n5;
                        }
                        ++n4;
                    }
                    this.getMe().setEntAssocMapFinal(nArrayArray);
                    this.getMe().setEntAssocMapCurrent(nArrayArray);
                }
                modelEntity2.saveStateKey();
            }
        }
        if (this.k() == MESH_TYPES.IMPORTED && this.getModel().getSavedInVersion() < 1172) {
            MeshNative meshNative = this.getMe().getMeshnativeRaw();
            if (meshNative != null && meshNative.getMesh() != null) {
                Mesh mesh3 = meshNative.getMesh();
                mesh3 = mesh3.C();
                mesh3.c();
                meshNative.replaceMesh(mesh3);
            }
            if ((meshNative = this.getMe().getMeshnativeCurrent()) != null && meshNative.getMesh() != null) {
                Mesh mesh5 = meshNative.getMesh();
                mesh5 = mesh5.C();
                mesh5.c();
                meshNative.replaceMesh(mesh5);
            }
            for (MeshFeature meshFeature : this.x()) {
                meshNative = meshFeature.getImportedMeshnative();
                if (meshNative == null || meshNative.getMesh() == null) continue;
                mesh = meshNative.getMesh();
                mesh = mesh.C();
                mesh.c();
                meshNative.replaceMesh(mesh);
            }
        }
        if (this.k() != MESH_TYPES.IMPORTED && this.getModel().getSavedInVersion() < 1034 && this.getMe().getNode().getChild("importAssoc") != null) {
            this.getMe().getNode().removeChild("importAssoc");
        }
        if ((this.k() == MESH_TYPES.AUTOMATIC || this.k() == MESH_TYPES.MANUAL) && this.getModel().getSavedInVersion() < 1214) {
            List<ModelEntity> list = this.getMe().getAllSuggestionProviders();
            for (ModelEntity modelEntity : list) {
                if (modelEntity instanceof Physics) continue;
                this.contribute(modelEntity, true);
            }
        }
        if (MESH_TYPES.IMPORTED == this.k()) {
            boolean bl4 = false;
            for (MeshFeature meshFeature : this.l()) {
                if (meshFeature.getImportAssocIO() == null) continue;
                bl4 = true;
                break;
            }
            if (bl4) {
                this.getMe().assocMigrator();
            }
            if (this.getMe().getGeom().getFinalizeFeature() != null) {
                this.getMe().getGeom().updateGeomInfo();
                this.getMe().getFinalizeFeature().setCacheTagImported(this.getMe().getGeom().getFinalizeFeature().getCacheTag());
                this.getMe().getGeom().getFinalizeFeature().removeFlag(ModelEntity.Flags.NOREMOVE);
                this.getMe().getGeom().getFinalizeFeature().removeFlag(ModelEntity.Flags.NODEACTIVATE);
                this.getMe().getGeom().getFinalizeFeature().removeFlag(ModelEntity.Flags.NORETAG);
                this.getMe().getGeom().feature().remove("fin");
                this.getMe().getGeom().setHasFinalize(false);
            }
        }
    }

    public void migrationUpdateStatusAfterLoad() {
        int n2 = this.getModel().getSavedInVersion();
        if (this.k() == MESH_TYPES.MANUAL && n2 < 345) {
            if (this.getMe().isLockedMesh()) {
                this.getMe().setType(MESH_TYPES.ADAPTED);
            } else if (this.isImportType()) {
                this.getMe().setTypeGen(MESH_TYPES.IMPORTED);
            }
        }
        if (this.k() == MESH_TYPES.IMPORTED && n2 <= 1202) {
            for (MeshFeature meshFeature : this.getMe().feature()) {
                meshFeature.setId(this.getMe().getImportAssoc().getNewOperationID());
            }
        }
        if (n2 < 1026) {
            for (MeshFeature meshFeature : this.l()) {
                if (!meshFeature.isBuilt() || !meshFeature.getBuildStatus().isBuilt()) continue;
                for (MeshFeature meshFeature2 : meshFeature.feature()) {
                    if (meshFeature2.isBuilt()) continue;
                    meshFeature2.setBuildStatus(FEATURE_STATUS.BUILT);
                }
                if (!meshFeature.getOperationID().equals("LogicalExpression")) continue;
                meshFeature.getOperation().preBuildCheck(this.m());
                meshFeature.setBuildStatus(FEATURE_STATUS.BUILT);
            }
        }
    }

    public void updateStatusAfterLoad(boolean bl2) {
        for (MeshFeature meshFeature : this.x()) {
            if (!meshFeature.isBuilt()) continue;
            meshFeature.getOperation().postLoadUpdateBuiltOperation();
            meshFeature.saveStateKey();
        }
        if (bl2) {
            this.updateStatus();
        }
    }

    public void assocMigrator() {
        int n2 = this.r();
        boolean bl2 = false;
        for (MeshFeature meshFeature : this.l()) {
            NastranEntry[] nastranEntryArray;
            Object object;
            boolean bl3 = meshFeature.getType().equals(meshFinalizeNode);
            if (meshFeature.getImportAssocIO() == null && (!bl3 || !bl2)) continue;
            bl2 = true;
            w w2 = new w();
            w2.b("associo", meshFeature.getImportAssocIO());
            w2.d("ftype", meshFeature.getType());
            if (bl3) {
                int n3;
                object = this.getMe().getEntAssocMapFinal();
                if (object == null || ((Mesh)object).length <= n2) {
                    object = new int[n2 + 1][][];
                    n3 = 0;
                    while (n3 <= n2) {
                        object[n3] = (Mesh)new int[this.getMeshCurrent().x()[n3] + 1][];
                        object[n3][0] = (Mesh)new int[0];
                        int n4 = 1;
                        while (n4 < ((Mesh)object[n3]).length) {
                            object[n3][n4] = (Mesh)new int[]{n4 - 1};
                            ++n4;
                        }
                        ++n3;
                    }
                }
                n3 = 0;
                while (n3 <= n2) {
                    w2.b("assocentfinal" + n3, (int[][])object[n3]);
                    ++n3;
                }
            }
            if ((object = meshFeature.getImportedMesh()) == null) {
                object = new Mesh(n2);
            }
            meshFeature.setImportAssocID(null, this.getMe().getImportAssoc().getAssoc().a(this.getMeshCurrent(), object, w2));
            meshFeature.setIgnoreAssocData(null, false);
            meshFeature.setSelInCorrectState(null, true);
            meshFeature.setImportAssocIO(null);
            if (bl3) {
                this.getMe().setEntAssocMapCurrent(null);
                this.getMe().setEntAssocMapFinal(null);
            }
            if ((nastranEntryArray = meshFeature.getNastranEntries()) != null) {
                NastranEntry[] nastranEntryArray2 = nastranEntryArray;
                int n5 = nastranEntryArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    NastranEntry nastranEntry = nastranEntryArray2[n6];
                    int n7 = nastranEntry.g();
                    w w3 = new w();
                    w3.d("geomdim", nastranEntry.c());
                    w3.b("geoment", nastranEntry.d());
                    nastranEntry.g(this.getMe().getImportAssoc().setGeomSelection(n7, (Mesh)object, w3));
                    ++n6;
                }
            }
            if (!this.getMe().getImportAssoc().getAssoc().a()) continue;
            meshFeature.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
        }
    }

    public void createMeshSizeDefaults(MeshFeature meshFeature) {
        String string;
        if (this.m().getSDim() <= 0 || this.getMe().isLockedMesh() || meshFeature == null && this.getMe().getType() == MESH_TYPES.IMPORTED) {
            return;
        }
        MeshFeatureList meshFeatureList = null;
        meshFeatureList = meshFeature == null ? this.x() : (MeshFeatureList)meshFeature.getFeature();
        if (meshFeatureList.index(string = "size") >= 0) {
            string = meshFeatureList.uniquetag(string);
        }
        this.b = true;
        boolean bl2 = this.d;
        this.d = true;
        try {
            MeshFeature meshFeature2 = meshFeatureList.create(string, meshSizeDefault);
            meshFeature2.addFlag(ModelEntity.Flags.NODEACTIVATE);
            meshFeature2.addFlag(ModelEntity.Flags.NOREMOVE);
            meshFeature2.addFlag(ModelEntity.Flags.NORETAG);
            meshFeature2.set("hauto", 5);
        }
        finally {
            this.d = bl2;
            this.b = false;
        }
    }

    public void createMeshFinalizeNode(boolean bl2) {
        ModelEntity modelEntity;
        if (this.m().getSDim() <= 0 || this.getMe().isLockedMesh() || this.getMe().getFinalizeFeature() != null) {
            return;
        }
        this.m().setSequenceType(GEOMSEQUENCE_TYPES.DEFINED_BY_MESH);
        MeshFeatureList<MeshFeature> meshFeatureList = this.x();
        String string = "fin";
        if (meshFeatureList.index(string) >= 0) {
            return;
        }
        this.c = true;
        try {
            modelEntity = meshFeatureList.create(string, meshFinalizeNode);
            modelEntity.addFlag(ModelEntity.Flags.NOREMOVE);
            modelEntity.addFlag(ModelEntity.Flags.NODEACTIVATE);
            modelEntity.addFlag(ModelEntity.Flags.NORETAG);
        }
        finally {
            this.c = false;
        }
        if (bl2) {
            modelEntity = (MeshList)this.getMe().getContainer();
            int n2 = 0;
            while (n2 < modelEntity.size()) {
                MeshSequence meshSequence = (MeshSequence)modelEntity.get(n2);
                if (meshSequence.getGeom().getTag().equals(this.m().getTag())) {
                    meshSequence.method().createMeshFinalizeNode(false);
                }
                ++n2;
            }
        }
    }

    public MeshSequence getMasterSequence() {
        GeomSequence geomSequence = this.m();
        for (MeshSequence meshSequence : this.getModel().mesh()) {
            if (meshSequence.getGeom() != geomSequence) continue;
            return meshSequence;
        }
        throw new FlException("Internal_mesh_error");
    }

    private GeomSequence m() {
        return this.getMe().getGeom();
    }

    @Override
    public IUnitConverter getConverter() {
        return this.m().getUnitConverter();
    }

    public MeshSequence.MeshNodeType getNodeType() {
        MESH_TYPES mESH_TYPES = this.k();
        if (this.isGeneratedUsingAPI()) {
            return MeshSequence.MeshNodeType.APIGenerated;
        }
        if (this.isMeshPart()) {
            return MeshSequence.MeshNodeType.MeshPart;
        }
        if (this.getMe().getAdapStudyFeature() != null) {
            return MeshSequence.MeshNodeType.StudyControlled;
        }
        if (this.isImportType() && this.y() != null && this.y().size() > 0 || mESH_TYPES == MESH_TYPES.IMPORTED) {
            return MeshSequence.MeshNodeType.Import;
        }
        if (this.m().isEmpty() && this.getMesh().b()) {
            return MeshSequence.MeshNodeType.Undefined;
        }
        if (mESH_TYPES == MESH_TYPES.ADAPTED) {
            return MeshSequence.MeshNodeType.AdaptedLegacy;
        }
        if (mESH_TYPES == MESH_TYPES.AUTOMATIC) {
            return MeshSequence.MeshNodeType.PhysicsControlled;
        }
        return MeshSequence.MeshNodeType.Manual;
    }

    public String getMeshNodeDescriptor() {
        StringBuilder stringBuilder = new StringBuilder(this.getNodeType().name().toLowerCase(Locale.US)).append(this.r());
        for (ModelEntity modelEntity : this.getMe().getContributingInterfaces()) {
            stringBuilder.append(".").append(modelEntity.tag());
        }
        return stringBuilder.toString();
    }

    @Override
    public ModelEntityPropSet createEntityPropSet() {
        ModelEntityPropSet modelEntityPropSet = new ModelEntityPropSet(this.getMe(), "mesh_settings", "Mesh_settings", true);
        String string = null;
        MeshSequence.MeshNodeType meshNodeType = this.getNodeType();
        switch (meshNodeType) {
            case Import: {
                string = "Imported_mesh";
                break;
            }
            case Undefined: {
                string = "Undefined";
                break;
            }
            case AdaptedLegacy: {
                string = "Adapted_mesh";
                break;
            }
            case APIGenerated: {
                string = "Created_using_API";
            }
        }
        if (string != null) {
            di di2 = new di(new String[]{"manual"}, new String[]{string});
            ds ds2 = new ds("meshtype", "Sequence_type", "manual", (dd)di2);
            modelEntityPropSet.registerEntityProp((Property)ds2, "type", (by)new AbstractModelEntityGetSetHandler(this.getMe()){

                @Override
                public String getString() {
                    return "manual";
                }

                @Override
                public void set(String string) {
                }
            });
            ds2.annotate().a(new PropAnnotationInfo.o(){

                public boolean isDisabled() {
                    return true;
                }
            });
            modelEntityPropSet.registerPropertyGroup("mesh_settings", "Mesh_settings", new String[]{"meshtype"}, true);
        } else if (meshNodeType == MeshSequence.MeshNodeType.Manual || meshNodeType == MeshSequence.MeshNodeType.PhysicsControlled) {
            Double d2;
            ModelEntityGroupProp modelEntityGroupProp = new ModelEntityGroupProp(this.getMe(), "meshtype", "Sequence_type", "automatic", new String[]{"manual", "automatic"}, new String[]{"User_controlled_mesh", "Physics_controlled_mesh"});
            modelEntityGroupProp.annotate().c("mesh_expand");
            modelEntityPropSet.registerEntityProp((Property)modelEntityGroupProp, "type", (by)new AbstractModelEntityGetSetHandler(this.getMe()){

                @Override
                public String getString() {
                    if (MeshSequenceMethod.this.getMe().isAutomatic()) {
                        return "automatic";
                    }
                    return "manual";
                }

                @Override
                public void set(String string) {
                    if ("automatic".equals(string)) {
                        MeshSequenceMethod.this.getMe().automatic(true);
                    } else if ("manual".equals(string)) {
                        MeshSequenceMethod.this.getMe().automatic(false);
                    } else {
                        super.set(string);
                    }
                }
            });
            modelEntityPropSet.registerPropertyGroup("mesh_settings", "Mesh_settings", new String[]{"meshtype"}, true);
            FlStringList flStringList = new FlStringList();
            Object object = HAutoTable.getSpecialValues();
            int n2 = ((double[])object).length;
            int n3 = 0;
            while (n3 < n2) {
                d2 = object[n3];
                flStringList.add(d2.toString());
                ++n3;
            }
            d2 = new di(flStringList.toArray(), HAutoTable.getDescriptions());
            ds ds3 = new ds("meshsize", "Element_size", "5.0", (dd)d2);
            modelEntityPropSet.registerEntityProp((Property)ds3, "toolsSize", "getToolsSize", "setToolsSize");
            ModelEntityGroupProp modelEntityGroupProp2 = new ModelEntityGroupProp(this.getMe(), "physvisible", "Phys is visible", "invisible", new String[]{"visible", "invisible"}, new String[]{"Visible", "Invisible"});
            modelEntityGroupProp2.annotate().a(IAnnotation.WidgetType.m);
            modelEntityPropSet.registerEntityProp((Property)modelEntityGroupProp2, "type", (by)new AbstractModelEntityGetSetHandler(this.getMe()){

                @Override
                public String getString() {
                    int n2 = MeshSequenceMethod.this.C().size();
                    if (n2 > 0) {
                        return "visible";
                    }
                    return "invisible";
                }

                @Override
                public void set(String string) {
                }
            });
            object = new dr("phys", "#", 2);
            modelEntityGroupProp2.registerEntityProp("visible", (Property)object, "contrib", new AbstractModelEntityGetSetHandler(this.getMe()){

                @Override
                public String[][] getStringMatrix() {
                    List<ModelEntity> list = MeshSequenceMethod.this.getMe().getContributingInterfaces();
                    List list2 = MeshSequenceMethod.this.C();
                    String[][] stringArray = new String[list2.size()][];
                    int n2 = 0;
                    for (ModelEntity modelEntity : list2) {
                        String string = list.contains(modelEntity) ? "on" : "off";
                        stringArray[n2++] = new String[]{modelEntity.getDisplayString(), string};
                    }
                    return stringArray;
                }

                @Override
                public void setIndex(String string, int n2, int n3) {
                    boolean bl2 = "on".equals(string);
                    String string2 = MeshSequenceMethod.this.getTagFromContributor(n2, true);
                    MeshSequenceMethod.this.getMe().contribute(string2, bl2);
                }
            });
            PropAnnotationInfo.TableInfo tableInfo = new PropAnnotationInfo.TableInfo(new String[]{"Contributor", "Use"}).e(new int[]{100, 80}).d(new boolean[]{false, true}).a(new boolean[]{false, true}).h(new boolean[]{true, false}).e(new boolean[]{true, false}).g(new boolean[]{false, true}).af().ae();
            object.annotate().a(tableInfo).Z().d("");
            modelEntityPropSet.registerPropertyGroup("physics_selection_group", "Physics_controlled_mesh", new String[]{"meshsize", "physvisible"}, true);
            modelEntityPropSet.setVisibilityConstraint("physics_selection_group", new ModelEntityPropSetVisibilityConstraint(){

                @Override
                public boolean isVisible() {
                    return MeshSequenceMethod.this.getNodeType() == MeshSequence.MeshNodeType.PhysicsControlled;
                }

                @Override
                public String[] attributeDependencies() {
                    return new String[]{"type"};
                }
            });
        } else if (meshNodeType == MeshSequence.MeshNodeType.StudyControlled) {
            StudyFeature studyFeature = this.getMe().getAdapStudyFeature();
            PrimitiveModelEntity primitiveModelEntity = studyFeature.getContainer().getContainer();
            String string2 = "#" + primitiveModelEntity.getDisplayString() + ": " + studyFeature.getDisplayString();
            di di3 = new di(new String[]{"manual"}, new String[]{string2});
            ds ds4 = new ds("studyref", "Adaptation_study", "manual", (dd)di3);
            ds4.annotate().a(IAnnotation.WidgetType.aa);
            PropAnnotationInfo.u u2 = new PropAnnotationInfo.u(){

                public Object a() {
                    return MeshSequenceMethod.this.getMe().getAdapStudyFeature();
                }
            };
            ds4.annotate().a(u2);
            modelEntityPropSet.registerEntityProp((Property)ds4, "adapstudy", (by)new AbstractModelEntityGetSetHandler(this.getMe()){

                @Override
                public String getString() {
                    return "manual";
                }

                @Override
                public void set(String string) {
                }
            });
            e e2 = new e("disconnect", new bk[]{new bk(){

                public void activate(Property property) {
                }

                public UndoType getUndoType(bx bx2) {
                    return UndoType.a;
                }

                public String getActionName(bx bx2) {
                    return "Disconnect_from_study_and_edit";
                }

                public void action(bx bx2) {
                }
            }});
            e2.annotate().c("mesh_disconnect_study");
            modelEntityPropSet.registerEntityProp((Property)e2, null, "");
            modelEntityPropSet.registerPropertyGroup("mesh_settings", "Mesh_settings", new String[]{"studyref", "disconnect"}, true);
        }
        return modelEntityPropSet;
    }

    public double[] getGeomDimension() {
        double d2 = 0.0;
        double d3 = Double.MAX_VALUE;
        double d4 = 0.0;
        double[] dArray = this.getMe().isImportSequence() ? this.getMe().infoCurrent().getBoundingBox() : (this.m().exists() ? this.m().getBoundingBox() : this.getMe().infoCurrent().getBoundingBox());
        int n2 = 0;
        while (n2 < dArray.length) {
            d2 = Math.max(d2, dArray[n2 + 1] - dArray[n2]);
            d3 = Math.min(d3, dArray[n2 + 1] - dArray[n2]);
            d4 += dArray[n2 + 1] - dArray[n2];
            n2 += 2;
        }
        if (d2 <= 0.0) {
            d2 = 1.0;
        }
        if (d3 >= Double.MAX_VALUE) {
            d3 = 1.0;
        }
        d4 = d4 == 0.0 ? 1.0 : (d4 /= (double)this.r());
        return new double[]{d2, d3, d4};
    }

    public int[][] getConstructionEntitiesToKeep(int[][] nArray) {
        if (nArray == null) {
            if (this.isImportType()) {
                nArray = new int[this.r() + 1][0];
            } else {
                GeomSequence geomSequence = this.m();
                nArray = MeshSequenceMethod.a(geomSequence);
            }
        }
        return nArray;
    }

    private static int[][] a(GeomSequence geomSequence) {
        int[][] nArrayArray = new int[geomSequence.getSDim() + 1][];
        int[] nArray = geomSequence.getNEntitiesMesh();
        int[] nArray2 = geomSequence.getNEntities();
        int n2 = 0;
        while (n2 < nArrayArray.length) {
            nArrayArray[n2] = new int[nArray[n2] - nArray2[n2]];
            int n3 = 0;
            while (n3 < nArrayArray[n2].length) {
                nArrayArray[n2][n3] = nArray2[n2] + n3;
                ++n3;
            }
            ++n2;
        }
        return nArrayArray;
    }

    public MeshSequence[] getDependencySequence() {
        if (this.getModel().isReinitializing()) {
            return null;
        }
        HashSet<MeshSequence> hashSet = null;
        if (this.j) {
            return null;
        }
        this.j = true;
        try {
            MeshSequence[] meshSequenceArray;
            MeshSequence[] meshSequenceArray2;
            MeshSequence meshSequence;
            for (MeshSequence[] meshSequenceArray3 : this.x()) {
                if (meshSequenceArray3.isInitializing()) continue;
                IMeshOperation iMeshOperation = meshSequenceArray3.getOperation();
                meshSequence = null;
                try {
                    meshSequence = iMeshOperation.getReferredSequence((MeshFeature)meshSequenceArray3);
                }
                catch (FlException flException) {}
                if (meshSequence == null) {
                    meshSequenceArray2 = meshSequenceArray3;
                    meshSequenceArray = meshSequenceArray2.feature();
                    for (PropFeature propFeature : meshSequenceArray) {
                        if (propFeature.isInitializing()) continue;
                        IMeshOperation iMeshOperation2 = (IMeshOperation)propFeature.getOperation();
                        try {
                            meshSequence = iMeshOperation2.getReferredSequence((MeshFeature)propFeature);
                        }
                        catch (FlException flException) {}
                        if (meshSequence != null) break;
                    }
                }
                if (meshSequence == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet<MeshSequence>();
                }
                hashSet.add(meshSequence);
            }
            GeomSequence geomSequence = this.m();
            for (GeomFeature geomFeature : geomSequence.feature()) {
                meshSequence = geomFeature.getOperation().getDependentMesh();
                if (meshSequence == null) continue;
                if (hashSet == null) {
                    hashSet = new HashSet();
                }
                hashSet.add(meshSequence);
            }
            if (hashSet != null) {
                meshSequenceArray2 = hashSet.toArray(new MeshSequence[hashSet.size()]);
                int n2 = meshSequenceArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    MeshSequence meshSequence2 = meshSequenceArray2[n3];
                    meshSequenceArray = meshSequence2.getDependencySequence();
                    if (meshSequenceArray != null) {
                        MeshSequence[] meshSequenceArray4 = meshSequenceArray;
                        int n4 = meshSequenceArray.length;
                        int n5 = 0;
                        while (n5 < n4) {
                            MeshSequence meshSequence3 = meshSequenceArray4[n5];
                            hashSet.add(meshSequence3);
                            ++n5;
                        }
                    }
                    ++n3;
                }
            }
            MeshSequence[] meshSequenceArray5 = hashSet != null ? hashSet.toArray(new MeshSequence[hashSet.size()]) : null;
            return meshSequenceArray5;
        }
        finally {
            this.j = false;
        }
    }

    public Mesh getMesh() {
        MeshNative meshNative = this.getMe().getMeshnativeRaw();
        if (meshNative != null) {
            return meshNative.getMesh();
        }
        return new Mesh(this.r());
    }

    public Mesh getMeshCurrent() {
        MeshNative meshNative = this.getMe().getMeshnativeCurrent();
        if (meshNative == null) {
            meshNative = this.getMe().getMeshnativeRaw();
        }
        if (meshNative != null && meshNative.getMesh() != null) {
            return meshNative.getMesh();
        }
        return new Mesh(this.r());
    }

    public void setMeshCurrent(Mesh mesh, long l2) {
        MeshSequence meshSequence = this.getMe();
        if (mesh == null) {
            meshSequence.setLastBuiltFeature(null);
        }
        meshSequence.setConstructionEntitiesToKeep(null);
        Mesh mesh2 = meshSequence.getMeshCurrent();
        if (mesh2 == mesh && meshSequence.getCacheTagCurrentCurrent() == l2) {
            return;
        }
        boolean bl2 = false;
        if (mesh2 != null && mesh != null && mesh2.b() && mesh.b()) {
            bl2 = true;
        }
        meshSequence.getStatistics().clearStatUtil();
        if (meshSequence.getGlobalStatistics(false, true) != null) {
            meshSequence.getGlobalStatistics(false, true).clearStatUtil();
        }
        if (!bl2) {
            MeshNative meshNative = meshSequence.getNewMeshNative(mesh);
            meshSequence.setMeshnativeCurrent(meshNative);
        }
        this.getMe().setCacheTagCurrentCurrent(l2);
        if (mesh != null) {
            meshSequence.getStatistics();
            meshSequence.getGlobalStatistics();
        }
    }

    public void setMesh(Mesh mesh, long l2) {
        Geom geom;
        MeshSequence meshSequence = this.getMe();
        meshSequence.setMeshnativeCurrent(null);
        meshSequence.setCacheTagCurrentCurrent(0L);
        if (mesh == null) {
            meshSequence.setLastBuiltFeature(null);
        }
        if (meshSequence.getMesh() == mesh && meshSequence.getCacheTagCurrent() == l2) {
            return;
        }
        int[][] nArray = null;
        if (mesh != null && (geom = this.m().getGeom()) != null) {
            nArray = mesh.a(geom);
        }
        meshSequence.setConstructionEntitiesToKeep(nArray);
        geom = meshSequence.getMesh();
        boolean bl2 = false;
        if (geom != null && mesh != null && geom.b() && mesh.b()) {
            bl2 = true;
        }
        meshSequence.getStatistics().clearStatUtil();
        if (meshSequence.getGlobalStatistics(false, true) != null) {
            meshSequence.getGlobalStatistics(false, true).clearStatUtil();
        }
        if (!bl2) {
            MeshNative meshNative = meshSequence.getNewMeshNative(mesh);
            meshSequence.setMeshnative(meshNative);
        }
        meshSequence.setCacheTagCurrent(l2);
        if (mesh != null) {
            meshSequence.initializeTransientData();
            meshSequence.getStatistics();
            meshSequence.getGlobalStatistics();
        }
    }

    public String getPreceding(String string, boolean bl2) {
        if (string != null && string.equals("")) {
            return "";
        }
        this.getMe().feature(string);
        String string2 = "";
        MeshFeatureList<? extends MeshFeature> meshFeatureList = this.getMe().feature();
        if (bl2) {
            int propFeature;
            boolean n2 = false;
            int n3 = 0;
            while (n3 < meshFeatureList.size()) {
                if (meshFeatureList.get(n3).tag().equals(string)) {
                    propFeature = n3;
                    break;
                }
                ++n3;
            }
            n3 = propFeature - true;
            while (n3 >= 0) {
                if (meshFeatureList.get(n3).isActive()) {
                    return meshFeatureList.get(n3).tag();
                }
                --n3;
            }
            return "";
        }
        for (PropFeature propFeature : this.getMe().feature()) {
            if (propFeature.tag().equals(string)) {
                return string2;
            }
            string2 = propFeature.tag();
        }
        throw new RuntimeException("Internal mesh error.");
    }

    public boolean isBuiltUntil(String string) {
        if (string == null) {
            throw new RuntimeException("Internal error in mesh.");
        }
        if (string.equals("")) {
            return true;
        }
        MeshFeature meshFeature = this.getMe().getLastBuiltFeature();
        if (meshFeature == null) {
            return false;
        }
        int n2 = this.x().index(string);
        if (n2 < 0) {
            throw new RuntimeException("Internal error in mesh.");
        }
        return meshFeature.getTag().equals(string) && meshFeature.isBuilt();
    }

    public String getKeyForEntitiesToKeep() {
        int[][] nArray;
        if (this.isImportType()) {
            return String.valueOf(this.getMe().getCacheTagCurrentCurrent());
        }
        StringBuilder stringBuilder = new StringBuilder(100);
        int[][] nArray2 = nArray = this.getMe().getConstructionEntitiesToKeep();
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int[] nArray3 = nArray2[n3];
            stringBuilder.append(Arrays.toString(nArray3));
            stringBuilder.append(';');
            ++n3;
        }
        return stringBuilder.toString();
    }

    public void clearMesh() {
        MeshBuildData meshBuildData = this.a(new MeshBuildData());
        this.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
        MeshFeatureList<MeshFeature> meshFeatureList = this.x();
        int n2 = 0;
        while (n2 < meshFeatureList.size()) {
            MeshFeature meshFeature = (MeshFeature)meshFeatureList.get(n2);
            if (!meshFeature.getOperationID().equals(meshSizeDefault)) {
                meshFeature.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            }
            ++n2;
        }
        this.getMe().setLastBuiltFeature(null);
        if (this.getMasterSequence().equals(this.getMe()) && this.getMe().getGeom().isDefinedByMesh()) {
            int[][] nArray = new int[1 + this.r()][1];
            try {
                this.getMe().getGeom().setSequenceType(GEOMSEQUENCE_TYPES.STANDARD);
                this.importMeshAssoc(nArray);
            }
            finally {
                this.getMe().getGeom().setSequenceType(GEOMSEQUENCE_TYPES.DEFINED_BY_MESH);
            }
        }
        this.updateHashKey(false);
    }

    public double autoMeshSize() {
        try {
            return Double.valueOf(this.getMe().getToolsSize());
        }
        catch (NumberFormatException numberFormatException) {
            this.getMe().setToolsSize("5.0");
            return 5.0;
        }
    }

    public void autoMeshSize(double d2) {
        MeshFeature meshFeature;
        if (d2 < 1.0) {
            d2 = 1.0;
        } else if (d2 > 9.0) {
            d2 = 9.0;
        }
        int n2 = (int)this.autoMeshSize();
        int n3 = (int)d2;
        if (n2 != n3) {
            this.e = true;
        }
        this.getMe().setToolsSizeGen(String.valueOf(String.valueOf(n3)) + ".0");
        if (this.k() == MESH_TYPES.AUTOMATIC && (meshFeature = this.getSizeDefaultFeature()) != null) {
            try {
                this.d = true;
                meshFeature.set("hauto", d2);
            }
            finally {
                this.d = false;
            }
        }
    }

    public void automatic(boolean bl2) {
        this.getMe().setAdapStudyFeature(null);
        if (bl2) {
            this.getMe().setType(MESH_TYPES.AUTOMATIC);
        } else {
            if (this.x().size() == 0 || this.k() == MESH_TYPES.AUTOMATIC && (this.x().size() <= 1 || this.e)) {
                this.createAutoSequence(false);
            }
            this.getMe().setType(MESH_TYPES.MANUAL);
        }
    }

    public void runAuto() {
        MeshFeatureList<MeshFeature> meshFeatureList = this.l();
        if (this.k() == MESH_TYPES.MANUAL && !this.m().isEmpty() && (meshFeatureList.size() == 0 || meshFeatureList.size() == 1 && ((MeshFeature)meshFeatureList.get(0)).getOperationID().equals(meshSizeDefault))) {
            if (this.getMesh() != null && !this.getMesh().b()) {
                return;
            }
            int n2 = this.r();
            int n3 = this.m().getNDomains();
            if (n3 == 0 && n2 >= 1) {
                --n2;
            }
            String string = meshFeatureList.uniquetag("auto_f");
            switch (n2) {
                case 3: {
                    meshFeatureList.create(string, "FreeTet");
                    break;
                }
                case 2: {
                    meshFeatureList.create(string, "FreeTri");
                    break;
                }
                case 1: {
                    meshFeatureList.create(string, "Edge");
                    break;
                }
                case 0: {
                    meshFeatureList.create(string, "Point");
                    break;
                }
                default: {
                    throw new RuntimeException("Unexpected space dimension");
                }
            }
            this.getMe().feature(string).selection().remaining();
        }
        this.run();
    }

    public void createReset(MeshSequence meshSequence, boolean bl2) {
        this.createResetCommon(meshSequence, bl2);
        if (this.getMe().isAutomatic()) {
            assert (meshSequence.isAutomatic());
            if (this.getMe().autoMeshSize() != meshSequence.autoMeshSize()) {
                meshSequence.autoMeshSize(this.getMe().autoMeshSize());
            }
            if (!bl2) {
                int n2 = this.getMe().getAllSuggestionProviders().size();
                int n3 = 0;
                while (n3 < n2) {
                    String string = this.getTagFromContributor(n3, false);
                    if (!this.getMe().contributing(string)) {
                        meshSequence.contribute(string, false);
                    }
                    ++n3;
                }
            }
        } else {
            if (this.getMe().getNodeType() == MeshSequence.MeshNodeType.StudyControlled) {
                return;
            }
            this.x().createReset(meshSequence.getFeature(), meshSequence, bl2);
        }
        if (!bl2 && !this.getMe().isAutomatic() && meshSequence.getModel().mesh().autorunResetSequence(meshSequence.tag()) && !meshSequence.getModel().hasBeenRun(meshSequence.tag())) {
            History history = meshSequence.getModel().hist();
            MethodCall methodCall = new MethodCall((PrimitiveModelEntity)meshSequence, "run", new Object[0]);
            history.log(methodCall);
        }
    }

    public int[] getMeshedEntities(int n2) {
        Mesh mesh = this.getMeshCurrent();
        if (mesh == null) {
            throw new FlException("Data_not_available");
        }
        GeomSequence geomSequence = this.m();
        int n3 = !geomSequence.isDefinedByMesh() ? geomSequence.getNEntitiesMesh()[n2] : mesh.x()[n2];
        return mesh.c(n2, n3);
    }

    public int getNumVertex() {
        Mesh mesh = this.getMesh();
        if (mesh == null) {
            return 0;
        }
        return mesh.p();
    }

    public int getNumElem(int n2, int[] nArray) {
        if (n2 > this.r() || n2 < 0) {
            throw new IllegalArgumentException("Wrong edim");
        }
        int n3 = this.m().getNEntities()[n2];
        int[] nArray2 = (int[])nArray.clone();
        int n4 = 0;
        while (n4 < nArray2.length) {
            if (nArray2[n4] > 0 && nArray2[n4] <= n3) {
                int n5 = n4++;
                nArray2[n5] = nArray2[n5] - 1;
                continue;
            }
            throw new IllegalArgumentException("Incorrect entity: " + nArray2[n4]);
        }
        Mesh mesh = this.getMesh();
        if (mesh == null) {
            return 0;
        }
        int n6 = 0;
        int n7 = mesh.m();
        int n8 = 0;
        while (n8 < n7) {
            if (mesh.g(n8) == n2) {
                n6 += mesh.d(n8, nArray2);
            }
            ++n8;
        }
        return n6;
    }

    public void initialize(Mesh mesh, MESH_TYPES mESH_TYPES) {
        if (mesh.getIdentifyingTag() != 0L) {
            mesh = mesh.C();
        }
        if (mESH_TYPES == MESH_TYPES.ADAPTED) {
            for (MeshFeature meshFeature : this.x()) {
                meshFeature.removeFlag(ModelEntity.Flags.NOREMOVE);
            }
            this.x().clear();
        } else {
            this.m().setSequenceType(GEOMSEQUENCE_TYPES.DEFINED_BY_MESH);
        }
        this.setMesh(mesh, mesh.A());
        this.getMe().setLockedMesh(true);
        this.getMe().setType(mESH_TYPES);
    }

    public void initialize(Xmesh xmesh, int n2, MESH_TYPES mESH_TYPES) {
        MeshFeature meshFeature = this.getSizeDefaultFeature();
        if (meshFeature != null) {
            meshFeature.removeFlag(ModelEntity.Flags.NOREMOVE);
        }
        this.x().clear();
        this.getMe().setCurrentFeature(null);
        Mesh mesh = xmesh.b(n2, 0);
        long l2 = mesh.A();
        this.setMesh(mesh, l2);
        this.getMe().setCurrentFeature(null);
        this.getMe().setLastBuiltFeature(null);
        this.getMe().setLockedMesh(true);
        this.getMe().setType(mESH_TYPES);
    }

    public RenderMeshCollection getRenderMeshCollection() {
        Mesh mesh = this.getMeshCurrent();
        if (mesh != null) {
            return mesh.c(this.m().getGeom());
        }
        return null;
    }

    public boolean hasProblems() {
        for (PropFeature propFeature : this.x()) {
            if (!((MeshFeature)propFeature).hasProblem()) continue;
            return true;
        }
        return false;
    }

    public void notifyGeometryChanged() {
        MeshFeature meshFeature;
        int n2;
        double[] dArray;
        MESH_TYPES mESH_TYPES = this.k();
        if (mESH_TYPES == MESH_TYPES.ADAPTED) {
            this.getModel().mesh().remove(this.n());
            return;
        }
        MeshFeatureList<MeshFeature> meshFeatureList = this.x();
        boolean bl2 = this.getMe().isAutogenerated();
        GeomSequence geomSequence = this.m();
        Geom geom = geomSequence.getGeom();
        if (geom != null && !Arrays.equals(dArray = this.getGeomDimension(), this.f)) {
            this.f = dArray;
            n2 = 0;
            while (n2 < meshFeatureList.size()) {
                meshFeature = (MeshFeature)meshFeatureList.get(n2);
                meshFeature.getOperation().notifyGeometryChanged(this.getMe(), meshFeature);
                ++n2;
            }
        }
        if (this.x().size() == 0 && !geomSequence.allowsMeshImportSequence()) {
            this.createMeshSizeDefaults(null);
        }
        boolean bl3 = false;
        n2 = 0;
        while (n2 < meshFeatureList.size()) {
            meshFeature = (MeshFeature)meshFeatureList.get(n2);
            if (meshFeature.getOperationID().equals(meshSizeDefault)) {
                bl3 = true;
            }
            if (bl3) {
                meshFeature.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            }
            ++n2;
        }
        this.getMe().setType(mESH_TYPES);
        this.getMe().setAutogenerated(bl2);
        this.clearMeshSequence();
        this.A();
    }

    public void clearMeshSequence() {
        MeshBuildData meshBuildData = this.a(new MeshBuildData());
        this.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
        this.getMe().setLockedMesh(false);
        this.updateHashKey(false);
    }

    private int r() {
        return this.m().getSDim();
    }

    public void createAutoSequence(boolean bl2) {
        GeomSequence geomSequence = this.m();
        if (bl2 && geomSequence.needsBuildFinal(false)) {
            geomSequence.run();
        }
        IModelInternal iModelInternal = this.getModel();
        AutoMeshManager autoMeshManager = this.getMe().getAutoMeshManager();
        GeomSequence geomSequence2 = geomSequence.isDeformed() ? geomSequence.getUndefGeom() : geomSequence;
        List<ModelEntity> list = this.getMe().getContributingInterfaces();
        IAutoMeshProvider iAutoMeshProvider = iModelInternal.method().a(geomSequence2, new HashSet<ModelEntity>(list));
        autoMeshManager.registerProvider(iAutoMeshProvider);
        try {
            MeshFeature meshFeature2 = this.getMe().getLastBuiltFeature();
            String string = null;
            FlStringList flStringList = new FlStringList();
            ArrayList<IMeshOperation.IMeshProblem[]> arrayList = new ArrayList<IMeshOperation.IMeshProblem[]>();
            for (MeshFeature n2 : this.l()) {
                if (!n2.isBuilt()) break;
                if (meshFeature2 == n2) {
                    string = n2.tag();
                }
                flStringList.add(n2.getKey());
                IMeshOperation iMeshOperation = n2.getOperation();
                arrayList.add(iMeshOperation.extractProblems(n2));
            }
            this.d = true;
            try {
                autoMeshManager.generateSequence(this.getMe());
                this.getMe().setAutogenerated(true);
            }
            finally {
                this.e = false;
            }
            int n2 = 0;
            for (MeshFeature meshFeature3 : this.l()) {
                String string2 = meshFeature3.generateKey();
                if (n2 >= flStringList.size() || !flStringList.get(n2).equals(string2)) break;
                meshFeature3.setKey(string2);
                meshFeature3.setBuildStatus(FEATURE_STATUS.BUILT);
                meshFeature3.method().i().forEach(meshFeature -> meshFeature.setBuildStatus(FEATURE_STATUS.BUILT));
                if (arrayList.get(n2) != null) {
                    meshFeature3.resetProblems();
                    IMeshOperation.IMeshProblem[] iMeshProblemArray = (IMeshOperation.IMeshProblem[])arrayList.get(n2);
                    int n3 = iMeshProblemArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        IMeshOperation.IMeshProblem iMeshProblem = iMeshProblemArray[n4];
                        iMeshProblem.restoreProblem(meshFeature3);
                        ++n4;
                    }
                }
                if (meshFeature3.tag().equals(string)) {
                    this.getMe().setLastBuiltFeature(meshFeature3);
                }
                ++n2;
            }
            if (this.l().size() != flStringList.size()) {
                ((MeshFeature)this.l().get(this.l().size() - 1)).setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            }
        }
        finally {
            this.d = false;
            autoMeshManager.unregisterProvider(iAutoMeshProvider);
        }
    }

    public void runCurrent() {
        this.run(this.current());
    }

    public void run() {
        this.run(null);
    }

    /*
     * WARNING - void declaration
     */
    public void run(String string) {
        NastranEntry[] nastranEntryArray;
        Object object;
        long l2 = System.currentTimeMillis();
        MeshSequenceMethod.debugPrintOut("------------------  Start mesh build to: " + string);
        ModelInternalUtil.computeBatchKey(this.getModel());
        MeshSequence meshSequence = this.getMe();
        MeshFeature meshFeature = meshSequence.getCurrentFeature();
        this.f();
        if (meshSequence.isLockedMesh() || this.isCreateReset()) {
            MeshSequenceMethod.debugPrintOut("... skipped");
            return;
        }
        if (!meshSequence.getMeshnative().hasMeshObject()) {
            for (MeshFeature meshFeature2 : this.x()) {
                if (!meshFeature2.isBuilt()) continue;
                meshFeature2.setStatus(FEATURE_STATUS.NEEDS_REBUILD);
                meshFeature2.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            }
        }
        boolean bl2 = true;
        for (MeshFeature meshFeature3 : this.x()) {
            if (meshFeature3.getMessages() != null) {
                meshFeature3.setMessages(null);
            }
            if (!bl2) continue;
            meshFeature3.getOperation().preBuildCheck(this.m());
            if (!meshFeature3.tag().equals(string)) continue;
            bl2 = false;
        }
        if (string != null && string.length() == 0) {
            string = null;
        }
        Object var7_8 = null;
        if (this.isImportType()) {
            int[] nArray = meshSequence.info().getNEntities();
        }
        double d2 = 0.0;
        if (this.m().needsBuildFinal(false)) {
            d2 = 0.2;
            s.a((String)("#" + this.getMe().label()), (double)0.0, (double)d2, (String[])new String[0], (String)("#" + this.m().label()), (String)"", (double)0.0, (boolean)false, (String)("#" + this.m().label()), (boolean)false, (boolean)false);
            try {
                this.s();
                this.m().run();
            }
            finally {
                s.a();
            }
        }
        if (meshSequence.isAutomatic()) {
            MeshSequenceMethod.debugPrintOut("Generate physics controlled mesh");
            this.createAutoSequence(false);
        } else {
            this.updateStatus();
        }
        MeshBuildData meshBuildData = this.a(new MeshBuildData());
        MeshFeature meshFeature4 = null;
        if (string != null) {
            meshFeature4 = meshSequence.feature(string);
        } else {
            MeshFeatureList<MeshFeature> meshFeatureList = this.x();
            if (meshFeatureList.size() > 0) {
                meshFeature4 = (MeshFeature)meshFeatureList.get(meshFeatureList.size() - 1);
                string = meshFeature4.tag();
            }
        }
        boolean bl3 = false;
        if (meshFeature4 != null && !meshFeature4.isActive() && (meshFeature4 = this.c(meshFeature4)) == null) {
            meshFeature4 = meshSequence.feature(string);
            bl3 = true;
        }
        for (MeshFeature meshFeature5 : this.x()) {
            if (meshFeature5 == meshFeature4) break;
            if (meshFeature5.isActive()) continue;
            meshFeature5.saveStateKey();
            meshFeature5.setBuildStatus(FEATURE_STATUS.BUILT);
        }
        if (meshFeature4 != null && meshFeature4 == meshSequence.getLastBuiltFeature() && meshFeature4.isBuilt() && !meshFeature4.hasSomeError()) {
            meshSequence.setCurrentFeature(meshFeature4);
            MeshSequenceMethod.debugPrintOut("... all done.");
            return;
        }
        List list = this.x().getActiveList();
        ListIterator<MeshFeature> listIterator = list.listIterator();
        int n2 = 0;
        while (listIterator.hasNext() && !bl3) {
            object = (MeshFeature)listIterator.next();
            boolean flException = false;
            if (listIterator.hasNext()) {
                int meshFeature6 = listIterator.nextIndex();
                nastranEntryArray = (MeshFeature)list.get(meshFeature6);
                flException = nastranEntryArray.isBuilt();
                if (object == meshSequence.getLastBuiltFeature() && meshSequence.getType() != MESH_TYPES.IMPORTED && flException && nastranEntryArray.getOperation().getMesh() == null) {
                    assert (n2 == 0);
                    n2 = 1;
                }
            }
            if (!object.isBuilt() || object.getOperationID().equals("Reference") || object.hasSomeError() && !flException || n2 == 2) {
                object = (MeshFeature)listIterator.previous();
                if (listIterator.hasPrevious()) {
                    double[] methodCall = new double[]{d2};
                    nastranEntryArray = (MeshFeature)list.get(listIterator.previousIndex());
                    double d3 = this.a((MeshFeature)nastranEntryArray, meshFeature4, new int[1]);
                    meshBuildData = this.a(nastranEntryArray.tag(), methodCall, d3);
                    if (meshBuildData == null) {
                        return;
                    }
                    this.getMe().setCurrentFeature((MeshFeature)nastranEntryArray);
                    this.getMe().setLastBuiltFeature((MeshFeature)nastranEntryArray);
                    d2 = methodCall[0];
                    break;
                }
                meshBuildData = this.a(meshBuildData);
                this.getMe().setCurrentFeature((MeshFeature)this.getMe().feature().get(0));
                break;
            }
            if (object == meshFeature4) {
                double[] flStringList = new double[]{d2};
                meshBuildData = this.a(object.tag(), flStringList, 0.0);
                if (meshBuildData == null) {
                    return;
                }
                d2 = flStringList[0];
                meshSequence.setCurrentFeature((MeshFeature)object);
                meshSequence.setLastBuiltFeature((MeshFeature)object);
                if (meshBuildData.isFinalMesh) {
                    nastranEntryArray = (NastranEntry[])this.getMe().info().getNEntities();
                    this.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
                    if (MESH_TYPES.IMPORTED == this.k()) {
                        this.a(meshBuildData.mesh, (int[])nastranEntryArray);
                    }
                } else {
                    this.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
                    if (MESH_TYPES.IMPORTED == this.k()) {
                        this.a(meshBuildData.mesh);
                    }
                }
                if (meshBuildData.throwThisError != null) {
                    throw meshBuildData.throwThisError;
                }
                long l3 = System.currentTimeMillis() - l2;
                MeshSequenceMethod.debugPrintOut("Meshing complete (cached): " + meshBuildData.mesh.l());
                MeshSequenceMethod.debugPrintOut("Full meshing operation took " + FlNumberUtil.b((double)((double)l3 * 0.001), (int)4, (double)1.0) + " seconds");
                return;
            }
            if (n2 == 1) {
                n2 = 2;
            }
            meshSequence.setCurrentFeature((MeshFeature)object);
            if (!object.getOperation().isAttributeOperation()) continue;
            this.a(meshBuildData.mesh, (MeshFeature)object);
            try {
                object.saveStateKey();
                object.getOperation().build(meshBuildData, this.getMe(), (MeshFeature)object, true, false);
            }
            finally {
                object.saveStateKey();
            }
        }
        MeshSequenceMethod.debugPrintOut("Start actual build from: " + (meshFeature4 != null ? meshFeature4.tag() : "null") + "--" + meshBuildData.mesh.l());
        try {
            try {
                void var7_10;
                meshBuildData.warningData.clear();
                try {
                    this.d = true;
                    object = this.a(meshBuildData, meshFeature4, listIterator, this.getMe(), d2);
                }
                finally {
                    this.d = false;
                }
                if (meshFeature4 != null && meshFeature4.getOperationID().equals("Import") && meshSequence == this.getMasterSequence()) {
                    NastranEntry[] flException = meshFeature4.getNastranEntries();
                    meshFeature4.method().addNastranEntities(flException);
                    if (this.x().size() == 2 && this.getMesh().b()) {
                        this.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
                        this.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
                        if (flException != null) {
                            meshFeature4.method().addNastranEntitiesSelection(flException, meshBuildData.mesh);
                            meshFeature4.method().nameNastranEntries(flException);
                        }
                    }
                }
                while (listIterator.hasNext()) {
                    MeshFeature meshFeature6 = listIterator.next();
                    if (meshFeature6.getOperation().hasSelection()) {
                        ((IMeshSelectionInternal)meshFeature6.selection()).setRemainingEntities(null);
                    }
                    meshFeature6.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
                }
                this.updateStatus();
                if (var7_10 != null && this.getMe() == this.getMasterSequence() && meshFeature4 != null && meshFeature4.getOperationID().equalsIgnoreCase(meshFinalizeNode)) {
                    int n3 = 0;
                    while (n3 < list.size() - 1) {
                        MeshFeature meshFeature7 = (MeshFeature)list.get(n3);
                        nastranEntryArray = meshFeature7.getNastranEntries();
                        if (nastranEntryArray != null) {
                            meshFeature7.method().addNastranEntities(nastranEntryArray);
                            meshFeature7.method().addNastranEntitiesSelection(nastranEntryArray, meshBuildData.mesh);
                        }
                        boolean bl4 = false;
                        if (meshFeature7.hasProperty("source")) {
                            if (meshFeature7.getString("source").equals("native") || meshFeature7.getString("source").equals("filterdataset")) {
                                bl4 = meshFeature7.hasProperty("selection") && meshFeature7.getBoolean("selection");
                            } else if (meshFeature7.getString("source").equals("nastran")) {
                                bl4 = meshFeature7.hasProperty("selcreation") && meshFeature7.getBoolean("selcreation");
                            } else if (meshFeature7.getString("source").equals("stl")) {
                                boolean bl5 = bl4 = meshFeature7.hasProperty("selectionstl") && meshFeature7.getBoolean("selectionstl");
                            }
                        }
                        if (bl4) {
                            MeshSelectionFeatureList<MeshSelectionFeature> meshSelectionFeatureList = meshFeature7.getMeshSelections();
                            MeshImportAssoc meshImportAssoc = meshFeature7.getSequence().getImportAssoc().getAssoc();
                            SelectionList<? extends SelectionFeature> selectionList = meshFeature7.getModel().selection();
                            for (MeshSelectionFeature meshSelectionFeature : meshSelectionFeatureList) {
                                if (!meshSelectionFeature.isValid()) continue;
                                SelectionFeature selectionFeature = meshSelectionFeature.getSelectionFeature();
                                SelectionFeature selectionFeature2 = null;
                                if (selectionFeature != null) {
                                    for (SelectionFeature selectionFeature3 : selectionList) {
                                        if (selectionFeature3 != selectionFeature) continue;
                                        selectionFeature2 = selectionFeature3;
                                        break;
                                    }
                                }
                                if (selectionFeature2 == null) {
                                    throw new FlException("Internal_error");
                                }
                                w w2 = new w();
                                meshImportAssoc.a(meshSelectionFeature.getAssocId(), meshBuildData.mesh, false, w2);
                                try {
                                    meshFeature7.method().b(true);
                                    selectionFeature2.geom(w2.x("geomdim"));
                                    selectionFeature2.set(w2.H("geoment"));
                                }
                                finally {
                                    meshFeature7.method().b(false);
                                }
                            }
                        }
                        if (nastranEntryArray != null) {
                            meshFeature7.method().nameNastranEntries(nastranEntryArray);
                        }
                        ++n3;
                    }
                }
            }
            catch (FlException flException) {
                if (this.k() == MESH_TYPES.AUTOMATIC && !flException.isCancelException()) {
                    this.getMe().setType(MESH_TYPES.MANUAL);
                }
                if (meshFeature != this.getMe().getCurrentFeature()) {
                    History history = this.getModel().hist();
                    nastranEntryArray = null;
                    nastranEntryArray = new MethodCall((ModelEntity)this.getMe(), "run", (Object)this.current());
                    history.log((MethodCall)nastranEntryArray);
                }
                if (flException.getOriginContext() instanceof MeshFeature) {
                    MeshFeature meshFeature8 = (MeshFeature)flException.getOriginContext();
                    if (this.getModel().mesh().size() == 1) {
                        throw new FlException("A_problem_occurred_when_building_mesh_feature_X#" + meshFeature8.getDisplayString(), (Throwable)flException);
                    }
                    throw new FlException("A_problem_occurred_when_building_mesh_feature_X_in_Y#" + meshFeature8.getDisplayString() + "#" + this.getMe().getDisplayString(), (Throwable)flException);
                }
                throw flException;
            }
        }
        finally {
            if (this.isImportType()) {
                this.A();
            }
        }
        if (((ArrayList)object).size() > 0) {
            if (this.k() == MESH_TYPES.AUTOMATIC) {
                this.getMe().setType(MESH_TYPES.MANUAL);
            }
            if (meshFeature != this.getMe().getCurrentFeature()) {
                History history = this.getModel().hist();
                MethodCall methodCall = null;
                methodCall = new MethodCall((ModelEntity)this.getMe(), "current", (Object)this.current());
                history.log(methodCall);
            }
            FlException flException = ((ArrayList)object).size() > 0 ? ((a)((ArrayList)object).get(0)).a() : new FlException("The_mesh_contains_inverted_elements");
            FlStringList flStringList = new FlStringList();
            int n4 = 0;
            while (n4 < ((ArrayList)object).size()) {
                flStringList.add(((a)((ArrayList)object).get((int)n4)).a);
                ++n4;
            }
            if (flStringList.size() == 1) {
                if (this.getModel().mesh().size() == 1) {
                    throw new FlException("A_problem_occurred_when_building_mesh_feature_X#" + flStringList.get(0), (Throwable)flException);
                }
                throw new FlException("A_problem_occurred_when_building_mesh_feature_X_in_Y#" + flStringList.get(0) + "#" + this.getMe().getDisplayString(), (Throwable)flException);
            }
            FlException flException2 = new FlException("Multiple_problems_occurred_when_building_X#" + this.getMe().getDisplayString(), (Throwable)flException);
            StringBuilder stringBuilder = new StringBuilder();
            int n5 = 0;
            while (n5 < flStringList.size()) {
                if (n5 > 0) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(flStringList.get(n5));
                ++n5;
            }
            flException2.addParameterPair(0, "Features", stringBuilder.toString());
            throw flException2;
        }
        long l4 = System.currentTimeMillis() - l2;
        MeshSequenceMethod.debugPrintOut("Meshing complete: " + meshBuildData.mesh.l());
        MeshSequenceMethod.debugPrintOut("Full meshing operation took " + FlNumberUtil.b((double)((double)l4 * 0.001), (int)4, (double)1.0) + " seconds");
    }

    private ArrayList<a> a(MeshBuildData meshBuildData, MeshFeature meshFeature, ListIterator<MeshFeature> listIterator, MeshSequence meshSequence, double d2) {
        int[] nArray;
        int[] nArray2;
        boolean bl2;
        ArrayList<a> arrayList = new ArrayList<a>();
        if (this.getMe().isLockedMesh()) {
            Mesh mesh = this.getMesh();
            if (mesh != null) {
                meshBuildData.mesh = mesh;
                meshBuildData.cacheTag = this.getMe().getCacheTagCurrent();
            }
            return arrayList;
        }
        boolean bl3 = meshFeature != null && !meshFeature.isActive();
        boolean bl4 = bl2 = meshSequence != this.getMe();
        if (bl2 && !Arrays.equals(nArray2 = meshSequence.getGeom().getNEntitiesMesh(), nArray = this.getMe().getGeom().getNEntitiesMesh())) {
            throw new FlException("Reference_remeshing_is_not_supported_for_a_deformed_configuration_based_on_a_geometry_with_mesh_control_entities");
        }
        if (meshBuildData.isFinalMesh) {
            meshSequence.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
        } else {
            meshSequence.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
        }
        double d3 = 1.0;
        int[] nArray3 = new int[]{d2 > 0.0 ? 1 : 0};
        if (listIterator.hasNext()) {
            d3 = this.a(listIterator.next(), meshFeature, nArray3);
            listIterator.previous();
        }
        if (d2 > 0.0) {
            d2 = d3 * d2 / (1.0 - d2);
            d3 += d2;
        }
        double[] dArray = new double[]{d2 / d3};
        if (bl3) {
            assert (this.getMe().getType() == MESH_TYPES.IMPORTED);
            this.a(meshBuildData, meshFeature, arrayList, meshSequence, d3, nArray3[0], dArray);
        } else {
            boolean bl5 = false;
            while (listIterator.hasNext()) {
                MeshFeature meshFeature2 = listIterator.next();
                bl5 = this.a(meshBuildData, meshFeature2, arrayList, meshSequence, d3, nArray3[0], dArray);
                if (meshFeature2 == meshFeature || bl5) break;
            }
        }
        return arrayList;
    }

    private double a(MeshFeature meshFeature, MeshFeature meshFeature2, int[] nArray) {
        assert (nArray.length == 1);
        double d2 = 0.0;
        int n2 = this.l().index(meshFeature.tag());
        int n3 = meshFeature2 != null ? this.l().index(meshFeature2.tag()) : this.l().size() - 1;
        int n4 = n2;
        while (n4 <= n3) {
            IMeshOperation iMeshOperation;
            double d3;
            MeshFeature meshFeature3 = (MeshFeature)this.l().get(n4);
            if (meshFeature3.isActive() && (d3 = (iMeshOperation = meshFeature3.getOperation()).getWorkEstimate()) > 0.0) {
                d2 += d3;
                nArray[0] = nArray[0] + 1;
            }
            ++n4;
        }
        if (d2 == 0.0) {
            d2 = 1.0;
        }
        return d2;
    }

    private boolean a(MeshBuildData meshBuildData, MeshFeature meshFeature, ArrayList<a> arrayList, MeshSequence meshSequence, double d2, int n2, double[] dArray) {
        Object object;
        boolean bl2;
        boolean bl3;
        block44: {
            this.a(meshBuildData.mesh, meshFeature);
            IMeshOperation iMeshOperation = meshFeature.getOperation();
            MeshSequence meshSequence2 = null;
            bl3 = false;
            boolean bl4 = bl2 = meshSequence != this.getMe();
            if ("Reference".equals(meshFeature.getOperationID())) {
                try {
                    meshSequence2 = iMeshOperation.getReferredSequence(meshFeature);
                }
                catch (FlException flException) {
                    if (!bl2 && !flException.isCancelException()) {
                        meshFeature.resetProblems();
                        iMeshOperation.addError(meshFeature, flException);
                    }
                    throw flException;
                }
            }
            String string = meshFeature.getKey();
            double d3 = meshFeature.getOperation().getWorkEstimate() / d2;
            boolean bl5 = false;
            try {
                ArrayList<a> arrayList2;
                if (meshSequence2 == null) {
                    meshFeature.saveStateKey();
                    try {
                        try {
                            if (d3 >= 0.001 && n2 > 1) {
                                object = this.a(meshFeature);
                                s.a((String)("#" + this.getMe().label()), (double)dArray[0], (double)d3, (String[])new String[0], (String)object, (String)"", (double)0.0, (boolean)false, (String)object, (boolean)false, (boolean)false);
                                bl5 = true;
                                this.s();
                            }
                            MeshSequenceMethod.debugPrintOut("Build: " + meshFeature.tag() + "--" + meshBuildData.mesh.l());
                            iMeshOperation.build(meshBuildData, this.getMe(), meshFeature, !bl2, bl2);
                            MeshSequenceMethod.debugPrintOut("Build OK");
                        }
                        catch (FlException flException) {
                            MeshSequenceMethod.debugPrintOut("Build Exception: " + flException.toString());
                            if (this.isImportType()) {
                                Mesh mesh = this.getMeshCurrent();
                                if (this.getMe().getCurrentFeature().getImportedMesh() == null || !mesh.b()) {
                                    this.a(mesh);
                                }
                            }
                            if (!bl2) {
                                throw flException;
                            }
                            flException.prependMessage("Failed_to_build_feature_X_in_sequence_Y#" + meshFeature.getDisplayString() + "#" + this.getDisplayString());
                            throw flException;
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl5) {
                            s s2 = s.a();
                            dArray[0] = dArray[0] + d3;
                            bl3 = bl3 || s2.f() || s2.g();
                        }
                        throw throwable;
                    }
                    if (bl5) {
                        s s3 = s.a();
                        dArray[0] = dArray[0] + d3;
                        boolean bl6 = bl3 = bl3 || s3.f() || s3.g();
                    }
                    if (meshFeature.hasSomeError() || meshBuildData.errorLog != null && meshBuildData.errorLog.b(this.getMe().tag(), meshFeature.tag()) && meshBuildData.errorLog.c() > 0) {
                        arrayList.add(new a(meshFeature.getDisplayString(), meshBuildData.errorLog));
                    }
                    break block44;
                }
                int n3 = 0;
                meshFeature.saveStateKey();
                if (!bl2) {
                    meshFeature.resetProblems();
                }
                bl5 = false;
                try {
                    try {
                        Object object22;
                        MeshBuildData meshBuildData2 = new MeshBuildData();
                        meshBuildData2.prop = (IMeshPropCollector)meshBuildData.prop.clone();
                        for (Object object22 : meshFeature.feature().getActiveList()) {
                            object22.getOperation().build(meshBuildData2, meshSequence, (MeshFeature)object22, false, bl2);
                        }
                        meshBuildData.cacheTag = CacheManager.getKey((long)meshBuildData.cacheTag, (String)meshFeature.getOperationID(), (String)meshFeature.getKey());
                        object22 = meshBuildData.prop;
                        meshBuildData.prop = meshBuildData2.prop;
                        Iterator iterator = meshSequence2.getFeature().getActiveList().listIterator();
                        n3 = meshBuildData.warningData.size();
                        if (d3 >= 0.001) {
                            String string2 = this.a(meshFeature);
                            s.a((String)("#" + this.getMe().label()), (double)dArray[0], (double)d3, (String[])new String[0], (String)string2, (String)"", (double)0.0, (boolean)false, (String)string2, (boolean)false, (boolean)false);
                            bl5 = true;
                            this.s();
                        }
                        arrayList2 = meshSequence2.method().a(meshBuildData, null, (ListIterator<MeshFeature>)iterator, meshSequence, 0.0);
                        meshBuildData.prop = object22;
                    }
                    catch (FlException flException) {
                        if (!bl2) {
                            iMeshOperation.addError(meshFeature, flException);
                            flException.setOriginContext((Object)meshFeature);
                        }
                        throw flException;
                    }
                }
                catch (Throwable throwable) {
                    if (bl5) {
                        s s4 = s.a();
                        dArray[0] = dArray[0] + d3;
                        bl3 = bl3 || s4.f() || s4.g();
                    }
                    throw throwable;
                }
                if (bl5) {
                    s s5 = s.a();
                    dArray[0] = dArray[0] + d3;
                    bl3 = bl3 || s5.f() || s5.g();
                }
                int n4 = 0;
                while (n4 < arrayList2.size()) {
                    arrayList.add(arrayList2.get(n4).a(meshFeature.getDisplayString()));
                    ++n4;
                }
                if (!bl2) {
                    if (meshBuildData.errorLog != null || meshBuildData.warningData.size() > n3) {
                        if (meshBuildData.errorLog != null) {
                            iMeshOperation.addError(meshFeature, meshBuildData.errorLog, meshBuildData.sourceFeatureLookup);
                        }
                        n4 = n3;
                        while (n4 < meshBuildData.warningData.size()) {
                            iMeshOperation.addWarning(meshFeature, meshBuildData.warningData.get((int)n4).warningId, meshBuildData.warningData.get((int)n4).message, meshBuildData.warningData.get((int)n4).dimension, meshBuildData.warningData.get((int)n4).entities);
                            ++n4;
                        }
                        meshFeature.setBuildStatus(FEATURE_STATUS.WARNING);
                        meshBuildData.errorLog = null;
                    } else if (!bl3) {
                        meshFeature.setBuildStatus(FEATURE_STATUS.BUILT);
                    }
                }
            }
            finally {
                if (bl2) {
                    meshFeature.setKey(string);
                }
            }
        }
        if (!bl2) {
            this.getMe().setCurrentFeature(meshFeature);
            this.getMe().setLastBuiltFeature(meshFeature);
        } else {
            meshSequence.setLastBuiltFeature(null);
        }
        if (meshBuildData.isFinalMesh) {
            object = meshSequence.info().getNEntities();
            meshSequence.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
            if (MESH_TYPES.IMPORTED == this.k()) {
                this.a(meshBuildData.mesh, (int[])object);
            }
        } else {
            meshSequence.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
            if (MESH_TYPES.IMPORTED == this.k()) {
                this.a(meshBuildData.mesh);
            }
        }
        return bl3;
    }

    private String a(MeshFeature meshFeature) {
        String string = this.getMe().isAutomatic() ? meshFeature.getOperation().getDescription() : "#" + meshFeature.label();
        return string;
    }

    private void s() {
        GeomSequenceMethod.j();
    }

    public void importMeshAssoc(int[][] nArray) {
        try {
            this.g = true;
            GeomSequence geomSequence = this.m();
            FlException flException = geomSequence.updateSelectionsAfterFinGeomChange(nArray, 0, null);
            this.a(nArray);
            if (flException != null) {
                throw flException;
            }
        }
        finally {
            this.g = false;
        }
    }

    private void a(int[][] nArray) {
        IModelInternal iModelInternal = this.getModel();
        String string = this.getMe().getTag();
        for (GeomSequence geomSequence : iModelInternal.geom().getListView()) {
            geomSequence.notifyImportMeshAssocChanged(string, nArray);
        }
    }

    private void a(Mesh mesh, int[] nArray) {
        MeshFeature meshFeature = this.getMe().getCurrentFeature();
        if (!meshFeature.getType().equals(meshFinalizeNode)) {
            return;
        }
        this.a(mesh);
        int n2 = meshFeature.getImportAssocID(null);
        w w2 = new w();
        w2.b("numgeoment", mesh.x());
        w w3 = new w();
        int n3 = this.getMe().getImportAssoc().updateAssoc(mesh, new Mesh(mesh.j()), meshFeature.getType(), n2);
        this.getMe().getImportAssoc().getAssoc().a(mesh, w2, w3);
        if (n2 != n3) {
            meshFeature.setImportAssocID(null, n3);
        }
        if (this.getMasterSequence() == this.getMe()) {
            int n4;
            int n5;
            Object object;
            int[][] nArray2 = w3.N("selectionmap");
            int n6 = this.getModel().getSavedInVersion();
            if (n6 > 0 && n6 < 1172 && Arrays.equals(nArray, mesh.x())) {
                boolean bl2 = false;
                int n7 = 1;
                while (n7 < nArray2.length) {
                    if (q.b((int[])nArray2[n7]) > 0) {
                        bl2 = true;
                        break;
                    }
                    ++n7;
                }
                if (!bl2) {
                    object = nArray2;
                    n5 = nArray2.length;
                    int n8 = 0;
                    while (n8 < n5) {
                        int[] nArray3 = object[n8];
                        n4 = 0;
                        while (n4 < nArray3.length) {
                            nArray3[n4] = n4;
                            ++n4;
                        }
                        ++n8;
                    }
                }
            }
            GeomSequence geomSequence = this.m();
            geomSequence.setAssocMaps(nArray2);
            geomSequence.setAssocMapsNFiniteVoids(0);
            int n9 = this.r();
            int[][] nArrayArray = new int[n9 + 1][];
            n5 = 0;
            while (n5 < n9) {
                nArrayArray[n5] = new int[nArray[n5] + 1];
                object = nArray2[n5];
                n4 = 1;
                while (n4 < ((int[][])object).length) {
                    int[] nArray4 = object[n4];
                    if (nArray4 > 0 && nArray4 < nArrayArray[n5].length) {
                        nArrayArray[n5][nArray4] = n4;
                    }
                    ++n4;
                }
                ++n5;
            }
            nArrayArray[n9] = q.a((int)(nArray[n9] + 1), (int)-1);
            int[] nArray5 = nArray2[n9];
            int n10 = 0;
            while (n10 < nArray5.length) {
                n4 = nArray5[n10];
                if (n4 >= 0 && n4 < nArrayArray[n9].length) {
                    nArrayArray[n9][n4] = n10;
                }
                ++n10;
            }
            geomSequence.setInverseAssocMaps(nArrayArray);
            geomSequence.setInverseAssocMapsNFiniteVoids(0);
            this.importMeshAssoc(nArray2);
        }
    }

    private void a(Mesh mesh, Mesh mesh2, MeshFeature meshFeature, String string) {
        int n2;
        int n3 = meshFeature.getImportAssocID(string);
        if (n3 != (n2 = this.getMe().getImportAssoc().updateAssoc(mesh, mesh2, meshFeature.getType(), n3))) {
            meshFeature.setImportAssocID(string, n2);
        }
    }

    private void a(Mesh mesh) {
        int n2;
        int n3;
        Object object;
        Object object2;
        MeshFeature meshFeature = this.getMe().getCurrentFeature();
        if (meshFeature != null) {
            object2 = meshFeature.getSelectionContainerNames(true).iterator();
            while (object2.hasNext()) {
                object = object2.next();
                Mesh mesh2 = new Mesh(mesh.j());
                if (meshFeature.isActive()) {
                    Mesh n22 = meshFeature.getImportedMesh();
                    if (n22 != null) {
                        mesh2 = n22;
                    }
                    if (mesh2.p() > mesh.p()) {
                        throw new IllegalStateException("Internal mesh error");
                    }
                }
                this.a(mesh, mesh2, meshFeature, (String)object);
                for (PropFeature propFeature : meshFeature.getFeature()) {
                    if (!propFeature.hasSelection()) continue;
                    this.a(mesh, mesh2, (MeshFeature)propFeature, null);
                }
            }
            this.getMe().getImportAssoc().setMeshSelections(this.getMe(), mesh);
            this.getMe().getImportAssoc().setNastranEntries(this.getMe(), mesh);
            this.b(meshFeature);
        }
        object = this.t();
        if (meshFeature == null && !object.isEmpty() && (n3 = (object2 = object.get(0)).getImportAssocID(null)) != (n2 = this.getMe().getImportAssoc().updateAssoc(mesh, new Mesh(mesh.j()), object2.getType(), n3))) {
            object2.setImportAssocID(null, n2);
        }
        Iterator<MeshSelectionContainer> iterator = object.iterator();
        while (iterator.hasNext()) {
            object2 = iterator.next();
            MeshFeatureMethod.updateSelection((MeshSelectionContainer)object2, null, true);
        }
    }

    private List<MeshSelectionContainer> t() {
        ArrayList<MeshSelectionContainer> arrayList = new ArrayList<MeshSelectionContainer>();
        GeomSequence geomSequence = this.m();
        String string = this.n();
        for (View view : this.getModel().view()) {
            if (view.getGeomSequence() != geomSequence) continue;
            for (HideMesh hideMesh : view.hideMesh()) {
                if (!hideMesh.mesh().equals(string)) continue;
                arrayList.add(hideMesh);
            }
        }
        arrayList.add(this.getMe().getStatistics());
        return arrayList;
    }

    private void b(MeshFeature meshFeature) {
        boolean bl2 = false;
        for (MeshFeature meshFeature2 : this.l()) {
            if (bl2) {
                meshFeature2.method().updateGeomFromAssoc();
                if (meshFeature2.isActive()) break;
            }
            if (meshFeature2 != meshFeature) continue;
            bl2 = true;
        }
    }

    void f() {
        block13: {
            if (this.k() != MESH_TYPES.IMPORTED) {
                return;
            }
            if (this.x().size() == 0) {
                return;
            }
            List<MeshSelectionContainer> list = this.t();
            for (MeshSelectionContainer object2 : list) {
                if (object2.getImportAssocID(null) == 0) {
                    MeshFeatureMethod.updateSelection(object2, null, true);
                    continue;
                }
                if (!object2.isIgnoreAssocData(null)) continue;
                MeshFeatureMethod.a(object2, null, this.getMe().getMeshCurrent(), true);
            }
            if (this.getMeshCurrent() == null || this.getMeshCurrent().p() == 0) {
                return;
            }
            ArrayList<bg<MeshFeature, String>> arrayList = new ArrayList<bg<MeshFeature, String>>();
            try {
                boolean bl2 = false;
                MeshFeature meshFeature = this.getMe().getCurrentFeature();
                int bg2 = 0;
                while (bg2 < this.l().size()) {
                    MeshFeatureDb meshFeatureDb = (MeshFeatureDb)this.x().get(bg2);
                    if (meshFeatureDb == meshFeature) {
                        bl2 = true;
                    }
                    if (bl2 || meshFeatureDb.getBuildStatus() != FEATURE_STATUS.BUILT && meshFeatureDb.isActive()) {
                        this.a(meshFeatureDb, arrayList);
                        for (MeshFeature meshFeature2 : meshFeatureDb.feature()) {
                            if (!meshFeature2.hasSelection()) continue;
                            this.a((MeshFeatureDb)meshFeature2, arrayList);
                        }
                        if (bl2 && meshFeatureDb.isActive() && meshFeatureDb != meshFeature) {
                            bl2 = false;
                        }
                    }
                    ++bg2;
                }
                for (bg bg3 : arrayList) {
                    ((MeshFeature)bg3.a).setIgnoreAssocData((String)bg3.b, false);
                }
            }
            catch (FlException flException) {
                if (flException.getMessage().startsWith("Illegal_selection_definition_at_mesh_feature_X#")) break block13;
                throw flException;
            }
        }
    }

    private void a(MeshFeatureDb meshFeatureDb, List<bg<MeshFeature, String>> list) {
        for (String string : meshFeatureDb.getSelectionContainerNames(true)) {
            if (!meshFeatureDb.isIgnoreAssocData(string)) continue;
            if (meshFeatureDb.isSelInCorrectState(string)) {
                meshFeatureDb.updateImportGeomSelection();
            } else {
                int n2 = meshFeatureDb.getImportAssocID(string);
                if (n2 == 0) {
                    MeshImportAssocNative meshImportAssocNative = this.getMe().getImportAssoc();
                    n2 = meshImportAssocNative.getNewAssocFeatureID();
                    meshFeatureDb.setImportAssocID(string, n2);
                }
            }
            if (!meshFeatureDb.isIgnoreAssocData(string)) {
                list.add((bg<MeshFeature, String>)bg.a((Object)meshFeatureDb, (Object)string));
            }
            meshFeatureDb.setIgnoreAssocData(string, true);
        }
    }

    private void a(MeshFeature meshFeature, Mesh mesh) {
        boolean bl2 = false;
        FlException flException = null;
        for (MeshFeature meshFeature2 : this.x()) {
            if (bl2) {
                block5: {
                    try {
                        meshFeature2.method().a(mesh);
                    }
                    catch (FlException flException2) {
                        if (!meshFeature2.isActive()) break block5;
                        flException = flException2;
                    }
                }
                if (meshFeature2.isActive()) break;
            }
            if (meshFeature2 != meshFeature) continue;
            bl2 = true;
        }
        if (flException != null) {
            throw flException;
        }
    }

    private MeshFeature c(MeshFeature meshFeature) {
        MeshFeatureList<MeshFeature> meshFeatureList = this.x();
        int n2 = this.x().index(meshFeature.tag());
        while (n2 >= 0) {
            if (((MeshFeature)meshFeatureList.get(n2)).isActive()) {
                return (MeshFeature)meshFeatureList.get(n2);
            }
            MeshFeature meshFeature2 = (MeshFeature)meshFeatureList.get(n2);
            meshFeature2.setStatus(FEATURE_STATUS.NEEDS_REBUILD);
            meshFeature2.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
            --n2;
        }
        return null;
    }

    private void a(Mesh mesh, MeshFeature meshFeature) {
        if (meshFeature.getOperation().hasSelection()) {
            IMeshSelectionInternal iMeshSelectionInternal = (IMeshSelectionInternal)meshFeature.selection();
            if (meshFeature.selection().isRemaining()) {
                iMeshSelectionInternal.setRemainingEntities(this.b(mesh));
            } else {
                iMeshSelectionInternal.setRemainingEntities(null);
            }
        }
    }

    private MeshBuildData a(String string, double[] dArray, double d2) {
        MeshBuildData meshBuildData = this.a(new MeshBuildData());
        if (string == null) {
            return this.a(meshBuildData);
        }
        if (this.getMe().isImportSequence()) {
            return this.b(string, dArray, d2);
        }
        List list = this.x().getActiveList();
        ListIterator listIterator = list.listIterator();
        MeshFeature meshFeature = null;
        while (listIterator.hasNext()) {
            meshFeature = (MeshFeature)listIterator.next();
            if (meshFeature.getOperationID().equals("Reference")) {
                throw new RuntimeException("Reference operation unsupported here.");
            }
            if (!meshFeature.isBuilt()) {
                throw new FlException("Meshing_sequence_not_executed");
            }
            if (meshFeature.getOperation().isAttributeOperation()) {
                meshFeature.getOperation().build(meshBuildData, this.getMe(), meshFeature, false, true);
            }
            if (meshFeature.tag().equals(string)) break;
        }
        if (meshFeature != null && this.a(meshBuildData, meshFeature, true)) {
            return meshBuildData;
        }
        MeshFeature meshFeature2 = null;
        while (listIterator.hasPrevious()) {
            meshFeature2 = (MeshFeature)listIterator.previous();
            if (this.a(meshBuildData, meshFeature2, true)) break;
        }
        boolean bl2 = false;
        if (meshFeature2 == null) {
            meshFeature2 = (MeshFeature)listIterator.next();
            bl2 = true;
        }
        if (meshBuildData.mesh == null) {
            this.a(meshBuildData);
            bl2 = true;
        }
        meshBuildData.prop = null;
        double d3 = this.a(meshFeature2, (MeshFeature)this.l().get(string), new int[1]);
        double d4 = d3 / (d3 + d2);
        if (dArray[0] > 0.0) {
            dArray[0] = dArray[0] / d4;
            dArray[0] = d3 * dArray[0] / (1.0 - dArray[0]);
            d3 += dArray[0];
        }
        double d5 = dArray[0] / (d3 /= d4);
        dArray[0] = d4;
        boolean bl3 = false;
        boolean bl4 = false;
        ListIterator listIterator2 = list.listIterator();
        Mesh mesh = null;
        MeshFeature meshFeature3 = null;
        long l2 = 0L;
        while (listIterator2.hasNext()) {
            meshFeature = (MeshFeature)listIterator2.next();
            if (bl2 || meshFeature.getOperation().isAttributeOperation()) {
                s s2;
                Object object;
                this.a(meshBuildData.mesh, meshFeature);
                c c2 = meshBuildData.errorLog;
                IMeshOperation iMeshOperation = meshFeature.getOperation();
                bl3 = false;
                double d6 = iMeshOperation.getWorkEstimate() / d3;
                if (d6 >= 0.001) {
                    object = this.a(meshFeature);
                    s.a((String)("#" + this.getMe().label()), (double)d5, (double)d6, (String[])new String[0], (String)object, (String)"", (double)0.0, (boolean)false, (String)object, (boolean)false, (boolean)false);
                    bl3 = true;
                    this.s();
                }
                try {
                    iMeshOperation.build(meshBuildData, this.getMe(), meshFeature, true, true);
                    meshFeature3 = meshFeature;
                    mesh = meshBuildData.mesh;
                    l2 = meshBuildData.cacheTag;
                }
                catch (Throwable throwable) {
                    if (bl3) {
                        s2 = s.a();
                        d5 += d6;
                        bl4 = bl4 || s2.f() || s2.g();
                    }
                    throw throwable;
                }
                if (bl3) {
                    s2 = s.a();
                    d5 += d6;
                    boolean bl5 = bl4 = bl4 || s2.f() || s2.g();
                }
                if (c2 != meshBuildData.errorLog && !meshFeature.hasProblem()) {
                    meshBuildData.errorLog.a(null, null);
                    iMeshOperation.addError(meshFeature, meshBuildData.errorLog, meshBuildData.sourceFeatureLookup);
                    object = new a(meshFeature.getDisplayString(), meshBuildData.errorLog);
                    meshBuildData.throwThisError = ((a)object).a();
                }
                if (bl4) {
                    this.getMe().setLastBuiltFeature(meshFeature3);
                    if (mesh != null) {
                        this.getMe().setMesh(mesh, l2);
                    }
                    return null;
                }
            }
            if (meshFeature.tag().equals(string)) break;
            if (!meshFeature.equals(meshFeature2)) continue;
            bl2 = true;
        }
        return meshBuildData;
    }

    private MeshBuildData b(String string, double[] dArray, double d2) {
        int n2;
        MeshFeatureList<MeshFeature> meshFeatureList;
        MeshFeature meshFeature;
        MeshBuildData meshBuildData = this.a(new MeshBuildData());
        if (this.a(meshBuildData, meshFeature = (MeshFeature)(meshFeatureList = this.l()).get(n2 = meshFeatureList.index(string)), false)) {
            return meshBuildData;
        }
        MeshSequence meshSequence = this.getMe();
        MeshFeature meshFeature2 = meshSequence.getLastBuiltFeature();
        if (meshFeature2 != null && !meshFeature2.isActive()) {
            meshFeature2 = null;
        }
        int n3 = meshFeature2 != null ? meshFeatureList.index(meshFeature2.tag()) : -1;
        boolean bl2 = false;
        if (meshFeature2 != null && n2 < n3) {
            boolean bl3 = false;
            int n4 = n2 + 1;
            while (n4 <= n3) {
                if (((MeshFeature)meshFeatureList.get(n4)).getOperation().isCacheCriticalOperation()) {
                    bl3 = true;
                }
                ++n4;
            }
            if (!bl3 && this.a(meshBuildData, meshFeature2, false) && this.a(meshBuildData, meshFeature)) {
                return meshBuildData;
            }
        } else if (meshFeature2 != null && n2 > n3 && this.a(meshBuildData, meshFeature2, false)) {
            bl2 = true;
        }
        if (!bl2) {
            meshBuildData = this.a(new MeshBuildData());
            n3 = -1;
        }
        double d3 = this.a((MeshFeature)meshFeatureList.get(n3 + 1), meshFeature, new int[1]);
        double d4 = d3 / (d3 + d2);
        d3 /= d4;
        int n5 = n3 + 1;
        while (n5 <= n2) {
            int n6 = n5;
            int n7 = n5;
            while (n7 <= n2) {
                if (((MeshFeature)meshFeatureList.get(n7)).isActive() && ((MeshFeature)meshFeatureList.get(n7)).getOperation().isCacheCriticalOperation()) break;
                n6 = n7++;
            }
            n7 = n6;
            while (n7 > n5) {
                if (this.a(meshBuildData, (MeshFeature)meshFeatureList.get(n7))) {
                    ++n7;
                    if (d2 != 0.0) break;
                    int n8 = n5;
                    while (n8 < n7) {
                        MeshFeature meshFeature3 = (MeshFeature)meshFeatureList.get(n8);
                        if (meshFeature3.isActive()) {
                            d3 -= meshFeature3.getOperation().getWorkEstimate();
                        }
                        ++n8;
                    }
                    break;
                }
                --n7;
            }
            Mesh mesh = null;
            meshFeature2 = null;
            long l2 = 0L;
            int n9 = n7;
            while (n9 <= n6) {
                MeshFeature meshFeature4 = (MeshFeature)meshFeatureList.get(n9);
                if (meshFeature4.isActive()) {
                    s s2;
                    IMeshOperation iMeshOperation = meshFeature4.getOperation();
                    double d5 = iMeshOperation.getWorkEstimate() / d3;
                    boolean bl4 = false;
                    if (d5 >= 0.001) {
                        String string2 = this.a(meshFeature4);
                        s.a((String)("#" + this.getMe().label()), (double)dArray[0], (double)d5, (String[])new String[0], (String)string2, (String)"", (double)0.0, (boolean)false, (String)string2, (boolean)false, (boolean)false);
                        bl4 = true;
                        this.s();
                    }
                    boolean bl5 = false;
                    try {
                        try {
                            iMeshOperation.build(meshBuildData, this.getMe(), meshFeature4, true, true);
                            if (meshBuildData.isFinalMesh) {
                                meshSequence.setMesh(meshBuildData.mesh, meshBuildData.cacheTag);
                            } else {
                                meshSequence.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
                            }
                            meshFeature2 = meshFeature4;
                            mesh = meshBuildData.mesh;
                            l2 = meshBuildData.cacheTag;
                        }
                        catch (FlException flException) {
                            iMeshOperation.addError(meshFeature4, flException);
                            throw flException;
                        }
                    }
                    catch (Throwable throwable) {
                        if (bl4) {
                            s2 = s.a();
                            dArray[0] = dArray[0] + d5;
                            bl5 = s2.f() || s2.g();
                        }
                        throw throwable;
                    }
                    if (bl4) {
                        s2 = s.a();
                        dArray[0] = dArray[0] + d5;
                        bl5 = s2.f() || s2.g();
                    }
                    for (String string3 : meshFeature4.getSelectionContainerNames(true)) {
                        meshSequence.getImportAssoc().updateAssocMap(meshFeature4.getImportAssocID(string3), meshFeature4.getType(), meshBuildData.mesh, meshFeature4.getImportedMesh());
                    }
                    this.a(meshFeature4, meshBuildData.mesh);
                    if (bl5) {
                        this.getMe().setLastBuiltFeature(meshFeature2);
                        if (mesh != null) {
                            this.getMe().setMesh(mesh, l2);
                        }
                        return null;
                    }
                }
                ++n9;
            }
            n5 = n6;
            ++n5;
        }
        return meshBuildData;
    }

    private boolean a(MeshBuildData meshBuildData, MeshFeature meshFeature) {
        IMeshOperation iMeshOperation = meshFeature.getOperation();
        if (!meshFeature.isActive() || !meshFeature.isBuilt()) {
            return false;
        }
        Mesh mesh = iMeshOperation.getMesh();
        if (mesh == null) {
            return false;
        }
        meshBuildData.mesh = mesh;
        meshBuildData.cacheTag = iMeshOperation.getCacheTag();
        meshBuildData.isFinalMesh = false;
        this.setMeshCurrent(meshBuildData.mesh, meshBuildData.cacheTag);
        this.getMe().setCurrentFeature(meshFeature);
        this.getMe().setLastBuiltFeature(meshFeature);
        for (String string : meshFeature.getSelectionContainerNames(true)) {
            this.getMe().getImportAssoc().updateAssocMap(meshFeature.getImportAssocID(string), meshFeature.getType(), meshBuildData.mesh, meshFeature.getImportedMesh());
        }
        this.a(meshFeature, meshBuildData.mesh);
        return true;
    }

    private boolean a(MeshBuildData meshBuildData, MeshFeature meshFeature, boolean bl2) {
        IMeshOperation iMeshOperation = meshFeature.getOperation();
        MeshSequence meshSequence = this.getMe();
        meshBuildData.mesh = null;
        if (meshFeature == meshSequence.getLastBuiltFeature()) {
            meshBuildData.mesh = this.getMeshCurrent();
            if (meshSequence.getMeshnativeCurrent() == null) {
                meshBuildData.cacheTag = meshSequence.getCacheTagCurrent();
                meshBuildData.isFinalMesh = this.k() == MESH_TYPES.IMPORTED ? meshFeature.getOperationID().equals(meshFinalizeNode) : true;
            } else {
                meshBuildData.cacheTag = meshSequence.getCacheTagCurrentCurrent();
                meshBuildData.isFinalMesh = false;
            }
            if (!meshFeature.hasProblem()) {
                iMeshOperation.insertMesh(meshBuildData);
            }
        } else if (bl2) {
            meshBuildData.mesh = iMeshOperation.getMesh();
            meshBuildData.cacheTag = iMeshOperation.getCacheTag();
        }
        return meshBuildData.mesh != null;
    }

    private MeshBuildData a(MeshBuildData meshBuildData) {
        GeomSequence geomSequence;
        meshBuildData.geom = geomSequence = this.m();
        meshBuildData.mesh = new Mesh(geomSequence.getSDim());
        if (!this.isImportType()) {
            meshBuildData.cacheTag = CacheManager.getKey((long)geomSequence.getGeomId(), (String)this.getMe().tag());
        } else {
            meshBuildData.cacheTag = CacheManager.getKey((long)this.r(), (String)"mesh_import");
            meshBuildData.isFinalMesh = false;
        }
        return meshBuildData;
    }

    public String current() {
        MeshFeature meshFeature = this.getMe().getCurrentFeature();
        if (meshFeature == null) {
            return "";
        }
        return meshFeature.tag();
    }

    public void current(String string) {
        this.getMe().setCurrentFeature(this.getMe().feature(string));
    }

    public void updateStatus() {
        boolean bl2 = false;
        FEATURE_STATUS fEATURE_STATUS = FEATURE_STATUS.BUILT;
        for (MeshFeature meshFeature : this.x()) {
            if (meshFeature.getOperation().getID().equals(meshSizeDefault)) {
                bl2 = true;
            }
            fEATURE_STATUS = meshFeature.updateStatus(fEATURE_STATUS, bl2);
        }
    }

    public int[][] remainingEntities(MeshFeature meshFeature) {
        MeshFeatureList<? extends MeshFeature> meshFeatureList = this.getMe().feature();
        int n2 = meshFeatureList.index(meshFeature.tag());
        if (n2 == 0) {
            return this.b((Mesh)null);
        }
        int n3 = this.r();
        int[][] nArrayArray = new int[n3 + 1][];
        if (nArrayArray[0] == null) {
            int n4 = 0;
            while (n4 <= n3) {
                nArrayArray[n4] = new int[0];
                ++n4;
            }
        }
        return nArrayArray;
    }

    private int[][] b(Mesh mesh) {
        int n2 = this.r();
        int[] nArray = this.isImportType() ? this.getMe().infoCurrent().getNEntities() : this.m().getNEntitiesMesh();
        int[][] nArrayArray = new int[n2 + 1][];
        if (mesh == null) {
            int n3 = 0;
            while (n3 <= n2) {
                nArrayArray[n3] = new int[nArray[n3]];
                int n4 = 0;
                while (n4 < nArray[n3]) {
                    nArrayArray[n3][n4] = n4 + 1;
                    ++n4;
                }
                ++n3;
            }
        } else {
            int[][] nArray2 = mesh.a(this.m().getGeom());
            int[] nArray3 = this.isImportType() ? this.getMe().infoCurrent().getNEntities() : this.m().getNEntities();
            int n5 = 0;
            while (n5 <= n2) {
                int[] nArray4 = mesh.c(n5, nArray[n5]);
                int n6 = 0;
                int n7 = 0;
                while (n7 < nArray3[n5]) {
                    n6 += nArray4[n7];
                    ++n7;
                }
                n7 = 0;
                int n8 = 0;
                while (n8 < nArray2[n5].length) {
                    if (nArray4[nArray2[n5][n8]] == 0) {
                        ++n7;
                    }
                    ++n8;
                }
                nArrayArray[n5] = new int[nArray3[n5] - n6 + n7];
                n8 = 0;
                int n9 = 0;
                while (n9 < nArray3[n5]) {
                    if (nArray4[n9] == 0) {
                        nArrayArray[n5][n8++] = n9 + 1;
                    }
                    ++n9;
                }
                n9 = 0;
                while (n9 < nArray2[n5].length) {
                    if (nArray4[nArray2[n5][n9]] == 0) {
                        nArrayArray[n5][n8++] = nArray2[n5][n9] + 1;
                    }
                    ++n9;
                }
                ++n5;
            }
        }
        return nArrayArray;
    }

    public boolean hasSizeDefaults() {
        if (this.b) {
            return true;
        }
        return this.getSizeDefaultFeature() != null;
    }

    public MeshFeature getSizeDefaultFeature() {
        if (this.y() != null) {
            for (MeshFeature meshFeature : this.y()) {
                if (!meshFeature.getOperationID().equals(meshSizeDefault)) continue;
                return meshFeature;
            }
        }
        return null;
    }

    public MeshFeature getFinalizeFeature() {
        for (MeshFeature meshFeature : this.x()) {
            if (!meshFeature.getOperationID().equals(meshFinalizeNode)) continue;
            return meshFeature;
        }
        return null;
    }

    private boolean w() {
        return (this.m().isEmpty() && this.getSizeDefaultFeature() == null || this.isImportType() || this.getMe().isLockedMesh()) && (!this.isImportType() || this.y() == null || this.y().size() <= 0) && this.k() != MESH_TYPES.IMPORTED && this.m().isEmpty();
    }

    public boolean isGeneratedUsingAPI() {
        return !((!this.m().isEmpty() || this.getSizeDefaultFeature() != null) && !this.isImportType() && !this.getMe().isLockedMesh() || this.isImportType() && this.y() != null && this.y().size() > 0 || this.k() == MESH_TYPES.IMPORTED || this.m().isEmpty() && this.getMesh().b() || this.k() == MESH_TYPES.ADAPTED || this.getMesh().b());
    }

    public boolean isImportType() {
        return this.getSizeDefaultFeature() == null && !this.getMe().isLockedMesh() && this.m().isDefinedByMesh();
    }

    @Override
    public IModelNode deduceScope() {
        return this.m().getStoredParent();
    }

    public void clearAllModelSelections() {
        GeomSequence geomSequence = this.m();
        int[][] nArrayArray = new int[this.r() + 1][];
        int n2 = 0;
        while (n2 <= this.r()) {
            nArrayArray[n2] = new int[geomSequence.getNEntities()[n2] + 1];
            ++n2;
        }
        this.importMeshAssoc(nArrayArray);
    }

    @Override
    public void appendToBatchKey(StringBuilder stringBuilder) {
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(super.toString());
        if (stringBuilder.length() != 0) {
            stringBuilder.append("\n");
        }
        stringBuilder.append("Current child: ").append(this.getMe().current());
        String string = "";
        for (MeshFeature meshFeature : this.x()) {
            String string2 = meshFeature.tag();
            string = "".equals(string) ? string2 : String.valueOf(string) + ", " + string2;
        }
        if (!string.equals("")) {
            stringBuilder.append("\n").append("Child nodes: ").append(string);
        }
        return stringBuilder.toString();
    }

    public void canCreateMesh() {
        if (!this.m().getGeom().m()) {
            throw new FlException("The_geometry_must_be_empty_use_the_copy_operation_to_copy_a_predefined_mesh_onto_a_geometry");
        }
        if (this.m().meshes().length > 1) {
            throw new FlException("Only_one_meshing_sequence_is_allowed_when_creating_a_mesh_using_the_API");
        }
        if (this.getMe().isLockedMesh()) {
            return;
        }
        boolean bl2 = true;
        Mesh mesh = this.getMesh();
        bl2 = !mesh.b() ? false : (this.x().size() == 0 ? true : (this.x().size() > 1 ? false : this.hasSizeDefaults()));
        if (!bl2) {
            throw new FlException("You_need_to_clear_the_mesh_before_you_can_set_mesh_data");
        }
    }

    private MeshFeatureList<MeshFeature> x() {
        return this.getMe().getFeature();
    }

    private MeshFeatureList<MeshFeature> y() {
        return this.getMe().getFeatureGen();
    }

    public boolean isCreatingSizeDefaults() {
        return this.b;
    }

    public boolean isCreatingFinalizeNode() {
        return this.c;
    }

    boolean h() {
        return this.d || ((IGeomSequenceInternal)this.m()).isDoingAssocUpdate();
    }

    public boolean isFinalized() {
        return this.getFinalizeFeature() == null || this.getFinalizeFeature() == this.getMe().getLastBuiltFeature();
    }

    @Override
    protected String a(String string, String string2) {
        ModelNode modelNode;
        MeshSequence meshSequence = this.getMe();
        if (ComponentSyntaxUtil.isEnabled() && (modelNode = ComponentSyntaxUtil.getComponent(meshSequence, ComponentSyntaxUtil.Context.CREATE)) != null) {
            return "model.component(\"" + modelNode.tag() + "\").mesh().create(\"" + meshSequence.tag() + "\");";
        }
        return String.valueOf(string) + ".create(\"" + meshSequence.tag() + "\", \"" + meshSequence.geom() + "\");";
    }

    public void toggleFinalizeNodeForType(MESH_TYPES mESH_TYPES) {
        if (mESH_TYPES == MESH_TYPES.ADAPTED) {
            return;
        }
        if (mESH_TYPES == MESH_TYPES.IMPORTED) {
            this.createMeshFinalizeNode(true);
        } else {
            this.z();
            this.removeHides();
        }
    }

    public String getDefaultName() {
        if (this.isMeshPart()) {
            return "Mesh_part";
        }
        return "Mesh";
    }

    public boolean isMeshPart() {
        return this.getMe().getParentModel() != null && this.getMe().getParentModel().getModelType() == MODEL_NODE_TYPES.MESH_PART;
    }

    private void z() {
        MeshFeature meshFeature = this.getFinalizeFeature();
        if (meshFeature == null) {
            return;
        }
        meshFeature.removeFlag(ModelEntity.Flags.NOREMOVE);
        this.x().remove(meshFeature.tag());
        MeshList meshList = (MeshList)this.getMe().getContainer();
        int n2 = 0;
        while (n2 < meshList.size()) {
            MeshSequence meshSequence = (MeshSequence)meshList.get(n2);
            if (meshSequence.getGeom().getTag().equals(this.m().getTag())) {
                meshSequence.method().z();
            }
            ++n2;
        }
    }

    private void A() {
        String string = this.getMe().tag();
        for (MeshSequence meshSequence : this.getModel().mesh()) {
            for (MeshFeature meshFeature : meshSequence.feature()) {
                if (!"Copy".equals(meshFeature.getOperationID()) || !string.equals(meshFeature.getString("mesh"))) continue;
                meshFeature.setImportedMesh(null);
            }
        }
    }

    public boolean updateHashKey(boolean bl2) {
        if (this.h) {
            return false;
        }
        if (!this.isMeshPart() && !this.i) {
            return false;
        }
        GeomSequence geomSequence = this.m();
        long l2 = 0L;
        l2 = 997L * l2 + (long)(geomSequence.hasAnyUnit() ? 1009 : 1031);
        l2 = 997L * l2 + FlStringUtil.getLongHash((String)geomSequence.getLengthUnit());
        l2 = 997L * l2 + FlStringUtil.getLongHash((String)geomSequence.getAngularUnit());
        try {
            this.h = true;
            for (MeshFeature meshFeature : this.x()) {
                if (bl2) {
                    meshFeature.updateHashKey();
                }
                l2 = 997L * l2 + meshFeature.getHashKey();
            }
        }
        finally {
            this.h = false;
        }
        if (l2 != this.getMe().getHashKey()) {
            this.getMe().setHashKey(l2);
            return true;
        }
        return false;
    }

    public String docMarker() {
        if (this.isMeshPart()) {
            return "MeshPart";
        }
        return "MeshSequence";
    }

    @Override
    protected boolean a(ModelEntity modelEntity, ModelNode modelNode) {
        if (this.getMe().isMeshPart()) {
            return ((MeshSequence)modelEntity).isMeshPart();
        }
        return super.a(modelEntity, modelNode);
    }

    public int[] mapMeshControlEntitiesToMeshGeom(int n2, int[] nArray) {
        int n3;
        int n4;
        int n5;
        int n6;
        int[] nArray2;
        MeshSequence meshSequence = this.getMe();
        if (meshSequence.getType() == MESH_TYPES.IMPORTED) {
            return nArray;
        }
        GeomSequence geomSequence = meshSequence.getGeom();
        if (geomSequence.getNEntities()[n2] == geomSequence.getNEntitiesMesh()[n2]) {
            return nArray;
        }
        if (meshSequence.isEmpty()) {
            return nArray;
        }
        if (meshSequence.isComplete()) {
            return geomSequence.mapGeomToMeshGeom(n2, nArray);
        }
        int[][] nArrayArray = new int[nArray.length][];
        HashSet<Integer> hashSet = null;
        CsIntMultimap csIntMultimap = ((GeomInfoBase)geomSequence.info()).getGeomToMeshGeomMap(n2);
        boolean bl2 = false;
        int n7 = geomSequence.getNEntities()[n2];
        int n8 = 0;
        while (n8 < nArray.length) {
            nArrayArray[n8] = csIntMultimap.a(nArray[n8] - 1);
            if (nArrayArray[n8] != null) {
                if (hashSet == null) {
                    int[] nArray3 = meshSequence.getConstructionEntitiesToKeep()[n2];
                    hashSet = new HashSet<Integer>();
                    nArray2 = nArray3;
                    n6 = nArray3.length;
                    n5 = 0;
                    while (n5 < n6) {
                        n4 = nArray2[n5];
                        hashSet.add(n4);
                        ++n5;
                    }
                }
                n3 = 0;
                nArray2 = nArrayArray[n8];
                n6 = nArray2.length;
                n5 = 0;
                while (n5 < n6) {
                    n4 = nArray2[n5];
                    if (n4 >= n7 && hashSet.contains(n4 + 1)) {
                        n3 = 1;
                        break;
                    }
                    ++n5;
                }
                if (n3 == 0) {
                    bl2 = true;
                } else {
                    nArrayArray[n8] = null;
                }
            }
            ++n8;
        }
        if (bl2) {
            an an2 = new an();
            n3 = 0;
            while (n3 < nArray.length) {
                if (nArrayArray[n3] != null) {
                    nArray2 = nArrayArray[n3];
                    n6 = nArray2.length;
                    n5 = 0;
                    while (n5 < n6) {
                        n4 = nArray2[n5];
                        an2.add(n4 + 1);
                        ++n5;
                    }
                } else {
                    an2.add(nArray[n3]);
                }
                ++n3;
            }
            return an2.sortedArray();
        }
        return nArray;
    }

    public void synchronizeMesh() {
        boolean bl2 = this.B();
        if (!bl2) {
            if (com.comsol.util.cluster.a.b()) {
                com.comsol.util.cluster.a.c((Object)this.getMesh(), (int)0);
            } else {
                Mesh mesh = new Mesh();
                com.comsol.util.cluster.a.c((Object)mesh, (int)0);
                this.getMe().getMeshnative().replaceMesh(mesh);
            }
            if (!this.B()) {
                throw new FlException("Internal_error_in_meshing_sequence");
            }
        }
    }

    private boolean B() {
        if (SystemUtil.isCluster()) {
            com.comsol.util.cluster.a.b((String)this.getClass().getName());
            long l2 = this.getMesh().A();
            Object[] objectArray = com.comsol.util.cluster.a.c((Object)l2);
            long l3 = (Long)objectArray[0];
            boolean bl2 = true;
            Object[] objectArray2 = objectArray;
            int n2 = objectArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Object object = objectArray2[n3];
                if ((Long)object != l3) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            return bl2;
        }
        return true;
    }

    @Override
    public boolean isInvisibleInGui() {
        if (super.isInvisibleInGui()) {
            return true;
        }
        ModelNode modelNode = (ModelNode)this.getParentModel();
        if (modelNode.getModelType() == MODEL_NODE_TYPES.EXTRA_DIMENSION && modelNode.isAutoGenerated()) {
            return true;
        }
        GeomSequence geomSequence = this.m();
        if (geomSequence.isMainGeometry(true)) {
            return false;
        }
        return !geomSequence.isDeformed();
    }

    public void doAdapStudy(String string) {
        StudyFeature studyFeature = ModelInternalUtil.getAdapStudy(string, this.getModel());
        this.getMe().setAdapStudyFeature(studyFeature);
    }

    public String doAdapStudy() {
        String string = "";
        StudyFeature studyFeature = this.getMe().getAdapStudyFeature();
        if (studyFeature != null && studyFeature.getStudy() != null && studyFeature.getStudy().get() != null && studyFeature.getStudy().get().length > 0) {
            string = studyFeature.getStudy().get()[0];
        }
        return string;
    }

    @Override
    public void createDuplicate(ModelEntity modelEntity) {
        super.createDuplicate(modelEntity);
        MeshSequence meshSequence = (MeshSequence)modelEntity;
        MeshSequence meshSequence2 = this.getMe();
        if (meshSequence2.isAutomatic()) {
            meshSequence.autoMeshSize(meshSequence2.autoMeshSize());
            return;
        }
        meshSequence.setType(meshSequence2.getType());
        meshSequence.autoMeshSize(meshSequence2.autoMeshSize());
        ((PropFeatureListMethod)meshSequence2.feature().method()).createDuplicate(meshSequence.feature());
        if (meshSequence.isImportSequence()) {
            meshSequence.getImportAssoc().getAssoc();
        }
    }

    public void setForceUsingHashKey(boolean bl2) {
        this.i = bl2;
    }

    @Override
    protected boolean a(ModelEntity modelEntity, AttributesImpl attributesImpl, AttributesImpl attributesImpl2, AttributesImpl attributesImpl3) {
        boolean bl2 = super.a(modelEntity, attributesImpl, attributesImpl2, attributesImpl3);
        MeshSequence meshSequence = this.getMe();
        if (this.e(modelEntity)) {
            return bl2;
        }
        MeshSequence meshSequence2 = (MeshSequence)modelEntity;
        bl2 |= this.a("automatic", meshSequence.isAutomatic(), meshSequence2.isAutomatic(), attributesImpl, attributesImpl2, attributesImpl3);
        return bl2 |= this.a("autoMeshSize", meshSequence.autoMeshSize(), meshSequence2.autoMeshSize(), attributesImpl, attributesImpl2, attributesImpl3);
    }

    private void a(ModelEntity modelEntity, boolean bl2) {
        EventManagerWrapper eventManagerWrapper = new EventManagerWrapper(this.getModel());
        if (bl2) {
            eventManagerWrapper.addEntityEventHandler(modelEntity, "ContibutorRemove", this.getMe(), NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
        } else {
            eventManagerWrapper.removeEntityEventHandler(modelEntity, "ContibutorRemove", this.getMe(), NODE_EVENT_TYPES.REMOVE, MetaModelUtil.META_EVENT_INFO.MODIFY_VOLATILE);
        }
    }

    public ModelEntity getContributorFromTag(String string) {
        EquationViewParent equationViewParent;
        try {
            equationViewParent = string.startsWith("multiphysics/") ? this.getMe().getParentModel().multiphysics(string.substring("multiphysics/".length())) : (string.startsWith("physics/") ? this.getMe().getParentModel().physics(string.substring("physics/".length())) : (string.startsWith("common/") ? this.getMe().getParentModel().common(string.substring("common/".length())) : this.getMe().getParentModel().physics(string)));
        }
        catch (FlException flException) {
            throw new FlException("Unknown_contributor");
        }
        return equationViewParent;
    }

    public String getTagFromContributor(int n2, boolean bl2) {
        String string;
        List<ModelEntity> list = bl2 ? this.C() : this.getMe().getAllSuggestionProviders();
        ModelEntity modelEntity = list.get(n2);
        if (modelEntity instanceof PhysicsDb) {
            string = "physics/" + modelEntity.tag();
        } else if (modelEntity instanceof MultiphysicsCouplingDb) {
            string = "multiphysics/" + modelEntity.tag();
        } else if (modelEntity instanceof CommonFeatureDb) {
            string = "common/" + modelEntity.tag();
        } else {
            throw new FlException("Unknown_contributor");
        }
        return string;
    }

    public void contribute(String string, boolean bl2) {
        ModelEntity modelEntity = this.getContributorFromTag(string);
        this.contribute(modelEntity, bl2);
    }

    public void contribute(ModelEntity modelEntity, boolean bl2) {
        List<ModelEntity> list = this.getMe().getContributingInterfaces();
        if (bl2) {
            if (!list.contains(modelEntity)) {
                list.add(modelEntity);
                this.a(modelEntity, true);
            }
        } else if (list.remove(modelEntity)) {
            this.a(modelEntity, false);
        }
    }

    private List<ModelEntity> C() {
        List<ModelEntity> list = this.getMe().getAllSuggestionProviders();
        ArrayList<ModelEntity> arrayList = new ArrayList<ModelEntity>();
        for (ModelEntity modelEntity : list) {
            if (!modelEntity.isActive()) continue;
            arrayList.add(modelEntity);
        }
        return arrayList;
    }

    private static class a {
        String a;
        c b;

        public a(String string, c c2) {
            this.a = string;
            this.b = c2;
        }

        FlException a() {
            if (this.b == null) {
                return null;
            }
            if (this.b.c() >= 1) {
                int n2 = this.b.a(0);
                FlNativeException flNativeException = new FlNativeException(this.b.a(0, 0));
                StackTraceElement[] stackTraceElementArray = new StackTraceElement[n2];
                int n3 = 0;
                while (n3 < n2) {
                    stackTraceElementArray[n2 - n3 - 1] = new StackTraceElement("Mesh", "native", this.b.c(0, n3), Integer.parseInt(this.b.d(0, n3)));
                    if (n3 > 0) {
                        String string = this.b.a(0, n3);
                        flNativeException.appendMessage(string);
                    }
                    int n4 = this.b.e(0, n3);
                    int n5 = 0;
                    while (n5 < n4) {
                        flNativeException.addParameterPair(this.b.a(0, n3, n5), this.b.b(0, n3, n5));
                        ++n5;
                    }
                    String string = this.b.b(0, n3);
                    if (string != null && string.length() > 0) {
                        flNativeException.addParameterPair("Detail", string);
                    }
                    ++n3;
                }
                flNativeException.setStackTrace(stackTraceElementArray);
                return flNativeException;
            }
            return null;
        }

        public a a(String string) {
            return new a(String.valueOf(string) + "/" + this.a, this.b);
        }
    }
}

