/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.ReducedModel;
import com.comsol.model.dbimodel.SOLSEQ_TYPES;
import com.comsol.model.dbimodel.SolutionNative;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.method.PropFeatureListMethod;
import com.comsol.model.operations.IDatasetOperation;
import com.comsol.model.operations.operationID.ReducedModelOperationID;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ReducedModelCandidate;
import com.comsol.nativemph.util.h;
import com.comsol.nativemph.xmesh.Solution;
import com.comsol.nativemph.xmesh.SolutionStatic;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.cluster.a;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.file.b;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;

public class ReducedModelListMethod<T extends ReducedModel>
extends PropFeatureListMethod<T> {
    public ReducedModelListMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    public void initialize() {
    }

    @Override
    public PropFeature resolveFeatureToCopy(String[] stringArray, Model model) {
        if (stringArray.length == 0) {
            throw new FlException("Found_no_feature_to_copy");
        }
        return model.reduced(stringArray[0]);
    }

    public String doDocMarker() {
        return "ReducedModelList";
    }

    public String getDefaultName() {
        return "Reduced_models";
    }

    /*
     * WARNING - void declaration
     */
    public void internalRemove(String string) {
        ReducedModel reducedModel = (ReducedModel)this.getMe().get(string);
        ArrayList<ModelEntity> arrayList = new ArrayList<ModelEntity>();
        for (ModelEntity modelEntity : this.getModel().init()) {
            if (!reducedModel.equals(modelEntity.getDerivedFrom())) continue;
            arrayList.add(modelEntity);
        }
        for (ModelEntity modelEntity : arrayList) {
            this.getModel().init().remove(modelEntity.tag());
        }
        arrayList.clear();
        for (ModelEntity modelEntity : this.getModel().ode()) {
            if (!reducedModel.equals(modelEntity.getDerivedFrom())) continue;
            arrayList.add(modelEntity);
        }
        for (ModelEntity modelEntity : arrayList) {
            this.getModel().ode().remove(modelEntity.tag());
        }
        arrayList.clear();
        for (SolverSequence solverSequence : this.getModel().sol()) {
            if (!reducedModel.equals(solverSequence.getDerivedFrom())) continue;
            arrayList.add(solverSequence);
        }
        if (arrayList.size() > 0) {
            void var4_15;
            boolean bl2 = false;
            while (var4_15 < arrayList.size()) {
                ModelEntity modelEntity = (ModelEntity)arrayList.get((int)var4_15);
                for (ReducedModel reducedModel2 : this.getModel().reduced()) {
                    if (reducedModel.equals(reducedModel2) || reducedModel2.getSrc() != null && !reducedModel2.getSrc().equals(modelEntity.tag())) continue;
                    arrayList.remove((int)var4_15--);
                    modelEntity.addFlag(ModelEntity.Flags.NOREMOVE);
                    modelEntity.setDerivedFrom(reducedModel2);
                    break;
                }
                ++var4_15;
            }
        }
        for (ModelEntity modelEntity : arrayList) {
            modelEntity.removeFlag(ModelEntity.Flags.NOREMOVE);
            this.getModel().sol().remove(modelEntity.tag());
        }
        arrayList.clear();
    }

    public void exportReducedModel(String string, String string2) throws IOException {
        File file;
        if (string2 == null || string2.isEmpty()) {
            return;
        }
        if (FlStringUtil.contains((String[])this.tags(), (String)string)) {
            ReducedModel reducedModel = (ReducedModel)this.getMe().get(string);
            file = reducedModel.getOperation().exportReducedModel();
            if (file == null) {
                FlException flException = new FlException("Reduced_model_export_is_not_supported");
                throw flException;
            }
        } else {
            FlException flException = new FlException("Reduced_model_tag_is_unknown");
            flException.addParameterPair("Tag", string);
            throw flException;
        }
        FileManagerUtil.a((File)file, (String)string2, null);
    }

    private String b(String string, String string2) {
        if (string == null || string2 == null) {
            return null;
        }
        switch (string) {
            case "modal": {
                if (string2.startsWith("transient")) {
                    return ReducedModelOperationID.ModalTransient.name();
                }
                return ReducedModelOperationID.ModalFrequency.name();
            }
            case "awe": {
                return ReducedModelOperationID.AWE.name();
            }
        }
        return null;
    }

    public ReducedModel importReducedModel(String string, String string2) throws IOException {
        if (string2 == null || this.getMe().getModel().isCreateReset()) {
            return null;
        }
        String string3 = null;
        try {
            string3 = this.f(string2);
        }
        catch (Exception exception) {
            FlException flException = new FlException((Throwable)exception);
            flException.addParameterPair("Filename", string2);
            throw flException;
        }
        if (string3 == null) {
            FlException flException = new FlException("Could_not_find_a_reduced_model_file");
            flException.addParameterPair("Filename", string2);
            throw flException;
        }
        File file = FileManagerUtil.a((String)string2, null, (boolean)false);
        b b2 = new b(file);
        InputStream inputStream = b2.getInputStream(b2.getEntry(string3));
        PrimitiveModelEntity primitiveModelEntity = null;
        String string4 = "";
        try {
            String string5;
            Solution solution;
            String string6;
            ReducedModelCandidate reducedModelCandidate;
            String string7;
            String string8;
            if (a.a()) {
                a.a((File)file, (String)string3, (String)this.getModel().getTag());
            }
            if ((string8 = this.b(string7 = (reducedModelCandidate = new ReducedModelCandidate(string6 = (solution = (Solution)h.a((InputStream)inputStream, (boolean)false)).W())).getValues(new String[]{"modeltype"})[0], string5 = reducedModelCandidate.getValues(new String[]{"analysistype"})[0])) == null) {
                PrimitiveModelEntity primitiveModelEntity2 = primitiveModelEntity;
                return primitiveModelEntity2;
            }
            try {
                if (FlStringUtil.contains((String[])this.getMe().tags(), (String)string)) {
                    if (!((ReducedModel)this.getMe().get(string)).getOperationID().equals(string8)) {
                        throw new FlException("Reduced_models_of_different_types_cannot_be_overwritten");
                    }
                    primitiveModelEntity = (ReducedModel)this.getMe().get(string);
                } else {
                    primitiveModelEntity = (ReducedModel)this.create(string, string8);
                }
                primitiveModelEntity.setConfiguration(reducedModelCandidate);
                primitiveModelEntity.getOperation().set("reconstructors", new String[0]);
                solution.h(primitiveModelEntity.getConfiguration());
                String string9 = primitiveModelEntity.getString("metaCOMSOLVersionInt");
                try {
                    int n2 = Integer.parseInt(string9);
                    if (ModelInternalUtil.getCurrentVersion() < n2) {
                        throw new FlException("Reduced_model_file_created_with_a_later_version_of_COMSOL_Multiphysics").addParameterPair("Version", primitiveModelEntity.getString("metaCOMSOLVersion"));
                    }
                }
                catch (NumberFormatException numberFormatException) {}
                String string10 = solution.O();
                b2 = new b(file);
                inputStream = b2.getInputStream(b2.getEntry(string10));
                SolutionStatic solutionStatic = (SolutionStatic)h.a((InputStream)inputStream, (boolean)false);
                solution.a(solutionStatic);
                SolutionNative solutionNative = primitiveModelEntity.getModel().sol().createSolutionNative();
                solution.e(file.getAbsolutePath());
                solutionNative.setLoadingPath(file.getAbsolutePath());
                solutionNative.setSolution(solution);
                SolverSequence solverSequence = primitiveModelEntity.getModel().sol().create(primitiveModelEntity.getModel().sol().uniquetag("rd"));
                string4 = solverSequence.tag();
                for (PropFeature object2 : primitiveModelEntity.getModel().result().dataset()) {
                    if (!((IDatasetOperation)object2.getOperation()).isSolution() || !object2.getString("solution").equals(string4)) continue;
                    object2.addFlag(ModelEntity.Flags.AUTOGENERATED);
                    break;
                }
                solverSequence.addFlag(ModelEntity.Flags.NOREMOVE);
                solverSequence.setDerivedFrom((ModelEntity)primitiveModelEntity);
                solverSequence.setStudyFeature(null);
                String string11 = ModelEntityUtil.uniqueNameWithinList(solverSequence, FlLocale.getString((String)"Reduced_model_data", (boolean)true));
                solverSequence.label(string11);
                solverSequence.setSolutionnative(solutionNative);
                solverSequence.setSolType(SOLSEQ_TYPES.ROM);
                primitiveModelEntity.setArchive(string2);
                primitiveModelEntity.setSrc(solverSequence.tag());
                primitiveModelEntity.setSolverSequenceTag(solverSequence.tag());
            }
            catch (Exception exception) {
                if (!"".equals(string4)) {
                    primitiveModelEntity.getModel().sol(string4).removeFlag(ModelEntity.Flags.NOREMOVE);
                    primitiveModelEntity.getModel().sol().remove(string4);
                }
                if (exception instanceof FlException) {
                    throw exception;
                }
                throw new FlException((Throwable)exception);
            }
        }
        finally {
            if (b2 != null) {
                b2.close();
            }
        }
        return primitiveModelEntity;
    }

    private String f(String string) throws IOException {
        String string2 = null;
        String string3 = FlFileUtil.e((String)string);
        if (".mphrom".equals(string3)) {
            try {
                File file = FileManagerUtil.a((String)string, null, (boolean)false);
                try (b b2 = new b(file);){
                    Enumeration enumeration = b2.entries();
                    while (enumeration.hasMoreElements()) {
                        ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
                        String string4 = zipEntry.getName();
                        String string5 = FlFileUtil.e((String)string4);
                        if (!".mphbin".equals(string5) || !string4.startsWith("solmeta")) continue;
                        string2 = string4;
                        break;
                    }
                }
            }
            catch (IOException iOException) {
                throw new FlException((Throwable)iOException);
            }
        }
        return string2;
    }

    @Override
    public String[] getPreResetFeatures() {
        return (String[])this.getMe().stream().filter(reducedModel -> reducedModel.getOperationID().equals(ReducedModelOperationID.ModalFrequency.id())).map(reducedModel -> reducedModel.tag()).toArray(String[]::new);
    }
}

