/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.method;

import com.comsol.model.analysis.IAnalysisOperation;
import com.comsol.model.analysis.OptimizationSolver;
import com.comsol.model.analysis.StudyFeatureID;
import com.comsol.model.applapi.IApplPostInfo;
import com.comsol.model.applapi.IMultiphysicsItem;
import com.comsol.model.automodeling.AutoSolverProvider;
import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.Coordsys;
import com.comsol.model.dbimodel.EVAL;
import com.comsol.model.dbimodel.Expr;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelTags;
import com.comsol.model.dbimodel.MultigridLevel;
import com.comsol.model.dbimodel.MultigridLevelList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.ReducedModel;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyFeatureList;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.method.PropFeatureListMethod;
import com.comsol.model.method.PropFeatureMethod;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.operations.IOperation;
import com.comsol.model.operations.SelectionProperty;
import com.comsol.model.properties.PhysicsOrFeatureReferenceProvider;
import com.comsol.model.properties.StudyStepProperties;
import com.comsol.model.selections.ISelectionFilter;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.EventWrapper;
import com.comsol.model.util.LicenseRequirement;
import com.comsol.model.util.ModelReductionUtil;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.dq;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.license.LicenseType;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class StudyFeatureMethod
extends PropFeatureMethod {
    public StudyFeatureMethod(PrimitiveModelEntity primitiveModelEntity) {
        super(primitiveModelEntity);
    }

    @Override
    public StudyFeature getMe() {
        return (StudyFeature)this.u();
    }

    @Override
    protected boolean b() {
        String string = this.getMe().getOperation().getID();
        return "StudyReference".equals(string);
    }

    @Override
    public void createDuplicate(ModelEntity modelEntity) {
        super.createDuplicate(modelEntity);
        StudyFeature studyFeature = this.getMe();
        if (studyFeature.getMglevel() != null) {
            ((PropFeatureListMethod)studyFeature.getMglevel().method()).createDuplicate(((StudyFeature)modelEntity).getMglevel());
        }
    }

    /*
     * WARNING - void declaration
     */
    public String doMesh(String string) {
        if (this.getMe().contributesPhysics()) {
            void meshSequence;
            GeomSequence geomSequence = this.getModel().geom(string);
            String[] stringArray = this.getMe().getStringArray("mesh");
            boolean n2 = false;
            while (meshSequence < stringArray.length) {
                if (stringArray[meshSequence].equals(string)) {
                    return stringArray[meshSequence + true];
                }
                meshSequence += 2;
            }
            if (geomSequence.isInDerivedExtraDim()) {
                for (MeshSequence meshSequence2 : this.getModel().mesh()) {
                    if (meshSequence2.getGeom() != geomSequence) continue;
                    return meshSequence2.tag();
                }
            }
        } else if (StudyFeatureID.isOptimizationID(this.getMe().getOperationID())) {
            return "nomesh";
        }
        throw new FlException("Analysis_x_has_no_mesh_defined_for_geometry_y#" + this.n() + "#" + string);
    }

    public StudyFeature doMesh(String string, String string2) {
        String[] stringArray;
        this.getModel().geom(string);
        boolean bl2 = false;
        try {
            if (this.getMe().contributesPhysics()) {
                bl2 = "nomesh".equals(string2) || this.getModel().mesh(string2).getGeom().tag().equals(string);
            }
        }
        catch (FlException flException) {
            bl2 = false;
        }
        if (bl2) {
            stringArray = this.getMe().getStringArray("mesh");
            int n2 = 0;
            while (n2 < stringArray.length) {
                if (stringArray[n2].equals(string)) break;
                n2 += 2;
            }
            if (n2 >= stringArray.length) {
                throw new FlException("Unsupported_geometry");
            }
        } else {
            throw new FlException("Mesh_is_not_defined_for_the_given_geometry");
        }
        stringArray[n2 + 1] = string2;
        this.getMe().set("mesh", stringArray);
        return this.getMe();
    }

    public MultigridLevelList doMglevel() {
        return this.getMe().getMglevel();
    }

    public MultigridLevel doMglevel(String string) {
        return (MultigridLevel)this.doMglevel().findObject(string, "multigrid_level");
    }

    @Override
    public void active(boolean bl2) {
        if (!this.getMe().isDeactivatable() && !bl2) {
            FlException flException = new FlException("Object_cannot_be_disabled");
            flException.addParameterPair("Tag", this.getMe().tag());
            throw flException;
        }
        if (bl2 && ModelReductionUtil.disabledByMORStudy(this.getMe(), true)) {
            FlException flException = new FlException("Object_cannot_be_enabled");
            flException.addParameterPair("Tag", this.getMe().tag());
            throw flException;
        }
        this.getMe().setActiveFlag(bl2);
    }

    @Override
    protected void d(ModelEntity modelEntity) {
        boolean bl2 = this.getMe().isActiveFlag();
        if (bl2 && ModelReductionUtil.disabledByMORStudy((StudyFeature)modelEntity, true)) {
            return;
        }
        super.d(modelEntity);
    }

    public boolean doActivate(String string) {
        block8: {
            String[] stringArray;
            block10: {
                block9: {
                    Map map;
                    if (ModelReductionUtil.disabledByMORStudy(this.getMe(), true)) {
                        return false;
                    }
                    if (!this.getMe().contributesPhysics()) break block8;
                    if (this.getMe().hasProperty("activate") && this.getMe().getOperation().getPropSet().getFromAllProperty("activate") instanceof dq && (map = (stringArray = (String[])this.getMe().getOperation().getPropSet().getFromAllProperty("activate")).d()).containsKey(string)) {
                        return ((String)map.get(string)).equals("on");
                    }
                    if (!this.hasProperty("activate") || !this.getModel().physics().hasTag(string)) break block9;
                    stringArray = this.getMe().getStringArray("activate");
                    int n2 = 0;
                    while (n2 < stringArray.length) {
                        if (stringArray[n2].equals(string)) {
                            return stringArray[n2 + 1].equals("on");
                        }
                        n2 += 2;
                    }
                    break block8;
                }
                if (!this.hasProperty("activateCoupling") || !this.getModel().multiphysics().hasTag(string)) break block10;
                stringArray = this.getMe().getStringArray("activateCoupling");
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3].equals(string)) {
                        return stringArray[n3 + 1].equals("on");
                    }
                    n3 += 2;
                }
                break block8;
            }
            if (!this.hasProperty("activaterom") || !this.getModel().reduced().hasTag(string)) break block8;
            stringArray = this.getMe().getStringArray("activaterom");
            int n4 = 0;
            while (n4 < stringArray.length) {
                if (stringArray[n4].equals(string)) {
                    return stringArray[n4 + 1].equals("on");
                }
                n4 += 2;
            }
        }
        return false;
    }

    public StudyFeature doActivate(String string, boolean bl2) {
        if (this.getMe().contributesPhysics() && this.getMe().hasProperty("activate")) {
            dq dq2 = (dq)this.getMe().getOperation().getPropSet().getFromAllProperty("activate");
            Map map = dq2.d();
            if (map.containsKey(string)) {
                dq2.a(string, bl2 ? "on" : "off");
            } else {
                dq dq3 = (dq)this.getMe().getOperation().getPropSet().getFromAllProperty("activateCoupling");
                map = dq3.d();
                if (map.containsKey(string)) {
                    dq3.a(string, bl2 ? "on" : "off");
                }
            }
        }
        return this.getMe();
    }

    public String doDiscretization(String string) {
        Property property;
        dq dq2;
        Map map;
        if (this.getMe().contributesPhysics() && this.getMe().hasProperty("discretization") && (map = (dq2 = (dq)(property = this.getMe().getOperation().getPropSet().getFromAllProperty("discretization"))).d()).containsKey(string)) {
            return (String)map.get(string);
        }
        return "physics";
    }

    public StudyFeature doDiscretization(String string, String string2) {
        Property property;
        if (this.getMe().contributesPhysics() && this.getMe().hasProperty("discretization") && (property = this.getMe().getOperation().getPropSet().getFromAllProperty("discretization")) instanceof dq) {
            dq dq2 = (dq)property;
            Map map = dq2.d();
            if (map.containsKey(string)) {
                dq2.a(string, string2);
            } else {
                throw new FlException("Discretization_is_not_defined_for_the_given_physics_interface");
            }
        }
        return this.getMe();
    }

    public void addEventHandlers() {
        ((IAnalysisOperation)this.cG_()).addEventHandlers(new EventManagerWrapper(this.getModel()), this.getMe());
    }

    public void disposeEventHandlers() {
        IAnalysisOperation iAnalysisOperation = (IAnalysisOperation)this.getMe().getOperationNoCreate();
        if (iAnalysisOperation != null) {
            iAnalysisOperation.disposeEventHandlers();
        }
    }

    public void postCreateInit() {
        PrimitiveModelEntity primitiveModelEntity = this.getMe().getContainer();
        while (!(primitiveModelEntity instanceof Study)) {
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
        ((IAnalysisOperation)this.cG_()).postCreateInit((Study)primitiveModelEntity, this.getMe());
    }

    public boolean contributesPhysics() {
        return ((IAnalysisOperation)this.getMe().getOperation()).contributesPhysics() && !ModelReductionUtil.disabledByMORStudy(this.getMe(), true);
    }

    public AutoSolverProvider doGetSolverSuggestions() {
        IModelInternal iModelInternal = this.getModel();
        String[] stringArray = this.getMe().getmatchtag(ModelTags.Analysis.name());
        return iModelInternal.method().getSolverSuggestion(stringArray[0]);
    }

    public StudyFeature doGetNotStudyFeature() {
        return (StudyFeature)this.getMe().getPropertyReference("notstudystep");
    }

    public String doDocMarker() {
        return "study_" + this.getMe().getOperationID().toLowerCase(Locale.ENGLISH);
    }

    @Override
    public boolean docMarkerToLowercase() {
        return true;
    }

    public List<LicenseRequirement> doMultiphysics(StudyFeature studyFeature, EVAL eVAL) {
        LicenseType[] licenseTypeArray;
        int n2;
        int n3;
        LicenseType[][] licenseTypeArray2;
        Object object;
        ArrayList<LicenseRequirement> arrayList = new ArrayList<LicenseRequirement>();
        IOperation iOperation = this.cG_();
        boolean bl2 = false;
        boolean bl3 = false;
        switch (eVAL) {
            case VARIABLES: {
                if (iOperation instanceof IMultiphysicsItem) {
                    bl2 = true;
                }
                bl3 = true;
                break;
            }
            case SHAPE: 
            case FINALIZE: {
                if (iOperation instanceof IMultiphysicsItem && eVAL == EVAL.FINALIZE) {
                    bl2 = true;
                }
                bl3 = true;
            }
        }
        if (bl2 && this.contributesPhysics()) {
            object = (IMultiphysicsItem)((Object)iOperation);
            licenseTypeArray2 = object.multiphysics(studyFeature, this.getMe(), eVAL);
            n3 = licenseTypeArray2.length;
            n2 = 0;
            while (n2 < n3) {
                licenseTypeArray = licenseTypeArray2[n2];
                if (licenseTypeArray.length > 0) {
                    arrayList.add(new LicenseRequirement(licenseTypeArray, this.getMe()));
                }
                ++n2;
            }
        }
        if (bl3) {
            object = (Study)studyFeature.getContainer().getContainer();
            licenseTypeArray2 = object.contributeSpecialSteps(studyFeature, (StudyFeatureList)studyFeature.getContainer(), eVAL);
            n3 = licenseTypeArray2.length;
            n2 = 0;
            while (n2 < n3) {
                licenseTypeArray = licenseTypeArray2[n2];
                arrayList.add((LicenseRequirement)licenseTypeArray);
                ++n2;
            }
        }
        return arrayList;
    }

    public void doHandleEvent(EventWrapper eventWrapper) {
        ((IAnalysisOperation)this.getMe().getOperation()).handleEvent(eventWrapper);
    }

    @Override
    public String label() {
        String string = this.getMe().getEntityName();
        if (this.b() && "".equals(string) && this.getMe().hasPropValue("studyref")) {
            return this.getUniqueReferenceBasedName();
        }
        return string;
    }

    public String doGetReferenceBasedName() {
        if ("".equals(this.getMe().getEntityName()) && this.getMe().hasPropValue("studyref")) {
            ModelEntity modelEntity = this.getMe().getPropertyReference("studyref");
            String string = this.getMe().getOperation().getID();
            if ("StudyReference".equals(string)) {
                String string2 = "";
                string2 = modelEntity != null ? modelEntity.label() : FlLocale.getString((String)"No_study", (boolean)true);
                return string2;
            }
        }
        return null;
    }

    @Override
    protected String[] a(boolean bl2) {
        if (bl2 && this.getMe().contributesPhysics()) {
            List<String> list = Stream.of(StudyStepProperties.AnalysisCaseProps.values()).map(analysisCaseProps -> analysisCaseProps.propName()).collect(Collectors.toList());
            list.addAll(Arrays.asList("activate", "activateCoupling", "activaterom"));
            return list.toArray(new String[0]);
        }
        return super.a(bl2);
    }

    @Override
    public boolean isGUIActive() {
        if (ModelReductionUtil.disabledByMORStudy(this.getMe(), false)) {
            return false;
        }
        return super.isActive();
    }

    @Override
    public boolean isActive() {
        if (ModelReductionUtil.disabledByMORStudy(this.getMe(), true)) {
            return false;
        }
        return super.isActive();
    }

    @Override
    public LicenseRequirement[] getRequiredLicenses(boolean bl2) {
        StudyFeature studyFeature = this.getMe();
        if (!bl2 && !studyFeature.isActive()) {
            return new LicenseRequirement[0];
        }
        ArrayList<LicenseRequirement> arrayList = new ArrayList<LicenseRequirement>();
        IAnalysisOperation iAnalysisOperation = (IAnalysisOperation)this.cG_();
        LicenseType[][] licenseTypeArray = iAnalysisOperation.getLicenseRequirements(studyFeature);
        int n2 = licenseTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            LicenseType[] licenseTypeArray2 = licenseTypeArray[n3];
            if (licenseTypeArray2.length > 0) {
                arrayList.add(new LicenseRequirement(licenseTypeArray2, studyFeature));
            }
            ++n3;
        }
        return arrayList.toArray(new LicenseRequirement[arrayList.size()]);
    }

    public IApplPostInfo getPostInfo() {
        return ((IAnalysisOperation)this.cG_()).getPostInfo();
    }

    public boolean isDeactivatable() {
        return !ModelReductionUtil.disabledByMORStudy(this.getMe(), true) && !this.a(this.getMe());
    }

    private boolean a(StudyFeature studyFeature) {
        PropFeatureList propFeatureList = (PropFeatureList)studyFeature.getContainer();
        if (studyFeature.getOperationID().equals(StudyFeatureID.Parametric.id()) && !studyFeature.isActive() && propFeatureList != null) {
            for (PropFeature propFeature : propFeatureList) {
                if (!propFeature.isActive() || !StudyFeatureID.isOptimizationID(propFeature.getOperationID()) || !OptimizationSolver.valueOf(propFeature.getString("optsolver")).isInnerType()) continue;
                int n2 = FlStringUtil.find((String[])propFeatureList.tags(), (String)studyFeature.getTag())[0];
                int n3 = FlStringUtil.find((String[])propFeatureList.tags(), (String)propFeature.getTag())[0];
                return n3 < n2;
            }
        }
        return false;
    }

    @Override
    public String getReferenceTag(Property property) {
        if (property.includeSequenceInTag()) {
            return String.valueOf(this.getMe().getContainer().getContainer().getTag()) + "/" + super.getReferenceTag();
        }
        return super.getReferenceTag();
    }

    public void setupAnalysisCase() {
        StudyFeature studyFeature = this.getMe();
        if (!studyFeature.contributesPhysics()) {
            return;
        }
        this.getModel().method().a(studyFeature);
    }

    public boolean revertAnalysisCase() {
        if (!this.getMe().contributesPhysics()) {
            return false;
        }
        return this.getModel().method().a(false);
    }

    public StudyFeature.AnalysisCaseStatus getAnalysisCaseStatus(ModelEntity modelEntity) {
        StudyFeature studyFeature = this.getMe();
        if (!modelEntity.isActiveFlag()) {
            return StudyFeature.AnalysisCaseStatus.DISABLED;
        }
        if (!studyFeature.hasProperty(StudyStepProperties.AnalysisCaseProps.useadvanceddisable.propName()) || !studyFeature.getBoolean(StudyStepProperties.AnalysisCaseProps.useadvanceddisable.propName())) {
            return StudyFeature.AnalysisCaseStatus.NONE;
        }
        if (modelEntity instanceof Expr) {
            for (PrimitiveModelEntity primitiveModelEntity : studyFeature.getReferenceArray(StudyStepProperties.AnalysisCaseProps.disabledvariables.propName())) {
                if (primitiveModelEntity != modelEntity) continue;
                return StudyFeature.AnalysisCaseStatus.DISABLED;
            }
        }
        if (modelEntity instanceof Coordsys) {
            for (PrimitiveModelEntity primitiveModelEntity : studyFeature.getReferenceArray(StudyStepProperties.AnalysisCaseProps.disabledcoordinatesystems.propName())) {
                if (primitiveModelEntity != modelEntity) continue;
                return StudyFeature.AnalysisCaseStatus.DISABLED;
            }
        }
        if (modelEntity instanceof CommonFeature && FlStringUtil.contains((String[])studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledcommon.propName()), (String)modelEntity.tag())) {
            return StudyFeature.AnalysisCaseStatus.DISABLED;
        }
        if (modelEntity instanceof ReducedModel && FlStringUtil.contains((String[])studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledreduced.propName()), (String)modelEntity.tag())) {
            return StudyFeature.AnalysisCaseStatus.DISABLED;
        }
        if (modelEntity instanceof Physics || modelEntity instanceof PhysicsFeature) {
            PrimitiveModelEntity primitiveModelEntity;
            primitiveModelEntity = modelEntity;
            if (modelEntity instanceof PhysicsFeature) {
                while (primitiveModelEntity != null && !(primitiveModelEntity instanceof Physics)) {
                    primitiveModelEntity = primitiveModelEntity.getContainer();
                }
            }
            ArrayList arrayList = new ArrayList();
            String[] stringArray = studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledphysics.propName());
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray[n3];
                ModelEntity modelEntity2 = PhysicsOrFeatureReferenceProvider.getEntityOrNull(studyFeature, string, arrayList);
                if (modelEntity2 == modelEntity || modelEntity2 == primitiveModelEntity) {
                    return StudyFeature.AnalysisCaseStatus.DISABLED;
                }
                ++n3;
            }
        }
        if (modelEntity instanceof MultiphysicsCoupling && FlStringUtil.contains((String[])studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledcoupling.propName()), (String)modelEntity.tag())) {
            return StudyFeature.AnalysisCaseStatus.DISABLED;
        }
        if (modelEntity instanceof Physics && FlStringUtil.contains((String[])studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledcoupling.propName()), (String)modelEntity.tag())) {
            return StudyFeature.AnalysisCaseStatus.NO_FRAME_CONTROL;
        }
        if (modelEntity instanceof Frame && FlStringUtil.contains((String[])studyFeature.getStringArray(StudyStepProperties.AnalysisCaseProps.disabledcoupling.propName()), (String)("frame:" + modelEntity.tag()))) {
            return StudyFeature.AnalysisCaseStatus.NO_FRAME_CONTROL;
        }
        return StudyFeature.AnalysisCaseStatus.NONE;
    }

    public Selection checkSelection(PropValue propValue) {
        Property property = propValue.getProperty();
        AbstractSelection abstractSelection = propValue.getSelection();
        ISelectionFilter.SelectionType[] selectionTypeArray = ((SelectionProperty)property).getSelectionFilter().getAllowedTypes();
        if (!q.a((Object[])selectionTypeArray, (Object)((Object)ISelectionFilter.SelectionType.GEOM)) && !q.a((Object[])selectionTypeArray, (Object)((Object)ISelectionFilter.SelectionType.GEOMDIM))) {
            FlException flException = new FlException("Wrong_type_of_selection");
            flException.addParameterPair("Property", this.getMe().getTag());
            throw flException;
        }
        Selection selection = (Selection)abstractSelection;
        return selection;
    }
}

