/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations;

import com.comsol.model.applapi.IApplPostInfo;
import com.comsol.model.applapi.IVariableContainer;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.applapi.VariableTreeFilter;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.operations.IPostBaseOperation;
import com.comsol.model.operations.IPropExpressionInfo;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IMaterial;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.savepoint.interfaces.IModelEntity;
import com.comsol.model.savepoint.interfaces.IMultiphysicsCoupling;
import com.comsol.model.savepoint.interfaces.IPhysics;
import com.comsol.model.savepoint.interfaces.IPostInfoProvider;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.util.classes.FlHashMap;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.b;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.Function;

public abstract class ExpressionInfo
implements IPropExpressionInfo {
    protected PropFeature b;
    protected String c;
    protected String d;
    private boolean a;
    private String f = null;
    private String g = null;
    protected boolean e;
    private boolean h = true;

    @Override
    public void setFeature(PropFeature propFeature) {
        this.b = propFeature;
        this.e = false;
    }

    public void setFeature(PropFeature propFeature, boolean bl2) {
        this.b = propFeature;
        this.e = bl2;
    }

    @Override
    public PropFeature getFeature() {
        return this.b;
    }

    public void setDescriptionProp(String string) {
        this.c = string;
    }

    public void setUnitProp(String string) {
        this.d = string;
    }

    @Override
    public abstract int resolveEdim();

    @Override
    public IModel resolveModel() {
        return this.b != null ? this.b.getModel() : null;
    }

    @Override
    public boolean isResolvedModelSavePoint() {
        IModel iModel = this.resolveModel();
        return iModel != null && iModel.isSavePoint();
    }

    @Override
    public IGeomSequence resolveGeom() {
        if (this.b != null) {
            if (this.b.getParentModel() != null && !(this.b instanceof GeomFeature)) {
                return this.b.getParentModel().getGeom();
            }
            PrimitiveModelEntity primitiveModelEntity = this.b;
            while (primitiveModelEntity != null) {
                if (primitiveModelEntity instanceof GeomSequence) {
                    return ((GeomSequence)primitiveModelEntity).getMainGeometryOrSubsequence();
                }
                primitiveModelEntity = primitiveModelEntity.getContainer();
            }
            List<? extends GeomSequence> list = this.b.getModel().physicsGeom();
            if (list.size() > 0) {
                return list.get(0);
            }
        }
        return null;
    }

    @Override
    public void setDescription(String string) {
        if (!(this.c == null || this.b.hasProperty(String.valueOf(this.c) + "active") && this.b.getBoolean(String.valueOf(this.c) + "active"))) {
            this.b.set(this.c, string);
        }
    }

    @Override
    public void setDescription(String[] stringArray) {
        if (this.c != null) {
            this.b.set(this.c, stringArray);
        }
    }

    @Override
    public String getDescription() {
        if (this.c != null) {
            return this.b.getString(this.c);
        }
        return "";
    }

    @Override
    public String[] getMultipleDescription() {
        if (this.c != null) {
            return this.b.getStringArray(this.c);
        }
        return new String[0];
    }

    @Override
    public String[] getUnit() {
        if (this.d != null) {
            return this.b.getStringArray(this.d);
        }
        return new String[0];
    }

    @Override
    public void setUnit(String[] stringArray) {
        if (this.d != null) {
            this.b.set(this.d, stringArray);
        }
    }

    public Data getDefaultExprAndDescr() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        int n2 = this.resolveEdim();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> this.a((IModelEntity)iModelEntity, n2, iModel));
        if (data != null) {
            return data;
        }
        return new Data("", "");
    }

    public Data getDefaultExprAndDescr(IModelEntity iModelEntity) {
        int n2 = this.resolveEdim();
        IModel iModel = this.resolveModel();
        return this.a(iModelEntity, n2, iModel);
    }

    private Data a(IModelEntity iModelEntity, int n2, IModel iModel) {
        IApplPostInfo iApplPostInfo = ExpressionInfo.a(iModelEntity);
        if (iApplPostInfo != null) {
            return this.a(iApplPostInfo.getScalarPlotDefaults(n2, iModelEntity), iModel);
        }
        return null;
    }

    private Data a(String[] stringArray, IModel iModel) {
        if (stringArray == null || stringArray.length != 2 || stringArray[0] == null) {
            return null;
        }
        String string = stringArray[0].trim();
        String string2 = stringArray[1];
        if (string2 == null) {
            string2 = iModel.physics().getVarData().getScalarDescription(string);
        }
        if (string2 == null) {
            string2 = "";
        }
        return new Data(string, FlLocale.getString((String)string2));
    }

    public Data getDefaultMultiExprAndDescr() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        int n2 = this.resolveEdim();
        FlStringList flStringList = new FlStringList();
        FlStringList flStringList2 = new FlStringList();
        ExpressionInfo.a(iModel).forEach(iModelEntity -> {
            if (ExpressionInfo.a(iGeomSequence, iModelEntity)) {
                this.a((IModelEntity)iModelEntity, n2, flStringList, flStringList2);
            }
        });
        return new Data(flStringList.toArray(), flStringList2.toArray());
    }

    public Data getDefaultMultiExprAndDescr(IModelEntity iModelEntity) {
        int n2 = this.resolveEdim();
        FlStringList flStringList = new FlStringList();
        FlStringList flStringList2 = new FlStringList();
        this.a(iModelEntity, n2, flStringList, flStringList2);
        if (flStringList.size() > 0) {
            return new Data(flStringList.toArray(), flStringList2.toArray());
        }
        return null;
    }

    private void a(IModelEntity iModelEntity, int n2, FlStringList flStringList, FlStringList flStringList2) {
        IApplPostInfo iApplPostInfo = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo();
        if (iApplPostInfo == null) {
            return;
        }
        String[][] stringArray = iApplPostInfo.getMultiScalarPlotDefaults(n2, iModelEntity);
        if (stringArray == null || stringArray.length != 2 || stringArray[0] == null || stringArray[1] == null || stringArray[0].length != stringArray[1].length) {
            return;
        }
        String[] stringArray2 = stringArray[0];
        String[] stringArray3 = stringArray[1];
        int n3 = 0;
        while (n3 < stringArray[0].length) {
            String string;
            if (stringArray2[n3] != null && (string = stringArray2[n3].trim()).length() != 0) {
                String string2 = stringArray3[n3];
                if (string2 == null) {
                    string2 = iModelEntity.getModel().physics().getVarData().getScalarDescription(stringArray2[n3]);
                }
                if (string2 == null) {
                    string2 = "";
                }
                flStringList.add(stringArray2[n3]);
                flStringList2.add(FlLocale.getString((String)string2));
            }
            ++n3;
        }
    }

    public Data getDefaultDeform() {
        return this.a(true);
    }

    public Data getDefaultDeform(IModelEntity iModelEntity) {
        return this.a(iModelEntity, true, this.resolveEdim());
    }

    public Data getDefaultArrayExpr() {
        return this.a(false);
    }

    public Data getDefaultArrayExpr(IModelEntity iModelEntity) {
        return this.a(iModelEntity, false, this.resolveEdim());
    }

    private Data a(boolean bl2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        int n2 = this.resolveEdim();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> this.a((IModelEntity)iModelEntity, bl2, n2));
        if (data != null) {
            return data;
        }
        int n3 = this.getNArrayComponents();
        String[] stringArray = new String[n3];
        stringArray[0] = "";
        stringArray[1] = "";
        if (n3 > 2) {
            stringArray[2] = "";
        }
        return new Data(stringArray, "");
    }

    private Data a(IModelEntity iModelEntity, boolean bl2, int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        IApplPostInfo iApplPostInfo = ExpressionInfo.a(iModelEntity);
        if (iApplPostInfo == null) {
            return null;
        }
        IVariableData iVariableData = iModel.physics().getVarData();
        String string = bl2 ? iApplPostInfo.getVectorDeformDefault(n2, iModelEntity) : iApplPostInfo.getVectorPlotDefault(n2, iModelEntity);
        if (string != null) {
            Object object;
            b b2 = iVariableData.getVariableTree(this.getVariableTreeFilter().edim(n2).includeHigherDimensions(), null);
            List<b> list = Arrays.asList(b2.d());
            for (b object2 : list) {
                object = Arrays.asList(object2.d());
                Iterator<b> iterator = object.iterator();
                while (iterator.hasNext()) {
                    b b3 = iterator.next();
                    Data data = this.a(iVariableData, string, b3, iGeomSequence);
                    if (data == null) continue;
                    return data;
                }
            }
            if (iVariableData.isVector(string) && this.b != null) {
                IVariableContainer iVariableContainer = iVariableData.getVariable(string);
                String[] stringArray = iVariableContainer.getComponents();
                if (iGeomSequence.isAxisymmetric()) {
                    stringArray[1] = stringArray[2];
                }
                if ((object = (IPostBaseOperation)this.b.getOperation()).getSDim() == 2) {
                    return new Data(new String[]{stringArray[0], stringArray[1]}, FlLocale.getString((String)iVariableContainer.getDescription()));
                }
                if (object.getSDim() == 3) {
                    return new Data(stringArray, FlLocale.getString((String)iVariableContainer.getDescription()));
                }
            }
        }
        return null;
    }

    private Data a(IVariableData iVariableData, String string, b b2, IGeomSequence iGeomSequence) {
        int n2 = this.getNArrayComponents();
        if (b2.c() >= n2 && string.equals(b2.b()) && iVariableData.isVector(b2.b()) && b2.c() >= n2) {
            b[] bArray = b2.d();
            String string2 = FlLocale.getString((String)b2.b("description"));
            String[] stringArray = new String[n2];
            int n3 = 0;
            while (n3 < n2) {
                stringArray[n3] = bArray[n3].b();
                ++n3;
            }
            if (iGeomSequence != null && iGeomSequence.isAxisymmetric() && n2 == 2) {
                stringArray[1] = bArray[bArray.length - 1].b();
            }
            return new Data(stringArray, string2);
        }
        if (b2.c() > 0) {
            List<b> list = Arrays.asList(b2.d());
            for (b b3 : list) {
                Data data = this.a(iVariableData, string, b3, iGeomSequence);
                if (data == null) continue;
                return data;
            }
        }
        return null;
    }

    public Data getDefaultMatrixExprAndDescr() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        int n2 = this.resolveEdim();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> {
            String[] stringArray = iApplPostInfo.getMatrixPlotDefaults(n2, (IModelEntity)iModelEntity);
            if (stringArray == null || stringArray.length != 2 || stringArray[0] == null) {
                return null;
            }
            String string = stringArray[0].trim();
            String string2 = stringArray[1];
            String string3 = iModel.physics().getVarData().baseNameToKey(string);
            if (string2 == null && string3 != null) {
                string2 = iModel.physics().getVarData().getDescription(string3);
            }
            if (string2 == null) {
                string2 = "";
            }
            return new Data(string, FlLocale.getString((String)string2));
        });
        if (data != null) {
            return data;
        }
        return new Data("", "");
    }

    @Override
    public IApplPostInfo.ParticleForce getDefaultParticleForce() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        IApplPostInfo.ParticleForce[] particleForceArray2 = this.b(ExpressionInfo.a(iModel), iGeomSequence, (iModelEntity, iApplPostInfo) -> iApplPostInfo.getParticleData(this.b.getString("tvar"), new String[]{this.b.getString("velvarx"), this.b.getString("velvary"), this.b.getString("velvarz")}, (IModelEntity)iModelEntity), particleForceArray -> particleForceArray != null && ((IApplPostInfo.ParticleForce[])particleForceArray).length > 0);
        if (particleForceArray2 != null && particleForceArray2.length > 0) {
            return particleForceArray2[0];
        }
        return new IApplPostInfo.ParticleForce(new String[]{"", "", ""}, "", "");
    }

    public String getDefaultParticleMass() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String string = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> {
            String string = iApplPostInfo.getDefaultParticleMass((IModelEntity)iModelEntity);
            return string != null && string.trim().length() > 0 ? string : null;
        });
        return string;
    }

    public void getDefaultPrincipal(boolean bl2, int n2, int n3, List<IApplPostInfo.Principal> list, List<String> list2, List<String> list3) {
        String string;
        IApplPostInfo.Principal principal;
        int n4;
        int n5;
        IApplPostInfo.Principal[] principalArray;
        IApplPostInfo.Principal[] principalArray2;
        list.clear();
        list2.clear();
        list3.clear();
        if (!this.isResolvedModelSavePoint()) {
            return;
        }
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        int n6 = 0;
        for (IPhysics iModelEntity : iModel.physics().getActiveList()) {
            if ((iGeomSequence == null || !iGeomSequence.equals(iModelEntity.getGeom())) && (iGeomSequence != null || iModelEntity.getGeom() != null) || iModelEntity.getPostInfo() == null || (principalArray2 = iModelEntity.getPostInfo().getPrincipal(bl2, n2, n3, iModelEntity)) == null) continue;
            principalArray = principalArray2;
            n5 = principalArray2.length;
            n4 = 0;
            while (n4 < n5) {
                principal = principalArray[n4];
                list.add(principal);
                list2.add(String.valueOf(iModelEntity.tag()) + "_" + n6);
                ++n6;
                string = principal.descr;
                if (principal.descr.length() == 0) {
                    string = "#" + principal.values[0];
                }
                list3.add("#" + FlLocale.getString((String)iModelEntity.getDescription()) + ": " + FlLocale.getString((String)string));
                ++n4;
            }
        }
        for (IMultiphysicsCoupling iMultiphysicsCoupling : iModel.multiphysics().getActiveList()) {
            if ((iGeomSequence == null || !iGeomSequence.equals(iMultiphysicsCoupling.getGeom())) && (iGeomSequence != null || iMultiphysicsCoupling.getGeom() != null) || iMultiphysicsCoupling.getPostInfo() == null || (principalArray2 = iMultiphysicsCoupling.getPostInfo().getPrincipal(bl2, n2, n3, iMultiphysicsCoupling)) == null) continue;
            principalArray = principalArray2;
            n5 = principalArray2.length;
            n4 = 0;
            while (n4 < n5) {
                principal = principalArray[n4];
                list.add(principal);
                list2.add(String.valueOf(iMultiphysicsCoupling.tag()) + "_" + n6);
                ++n6;
                string = principal.descr;
                if (principal.descr.length() == 0) {
                    string = "#" + principal.values[0];
                }
                list3.add("#" + FlLocale.getString((String)iMultiphysicsCoupling.getDescription()) + ": " + FlLocale.getString((String)string));
                ++n4;
            }
        }
    }

    public Data getDefaultFarField() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> this.a(iApplPostInfo.getFarField((IModelEntity)iModelEntity), iModel));
        if (data != null) {
            return data;
        }
        return new Data("", "");
    }

    public Data getDefaultFarFieldColor() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> this.a(iApplPostInfo.getFarFieldColor((IModelEntity)iModelEntity), iModel));
        if (data != null) {
            return data;
        }
        return new Data("", "");
    }

    public Data getDefaultFarFieldDirectivity() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        Data data = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> this.a(iApplPostInfo.getFarFieldDirectivity((IModelEntity)iModelEntity), iModel));
        if (data != null) {
            return data;
        }
        return this.getDefaultFarField();
    }

    public boolean isFarFieldRadiusDependent() {
        if (!this.isResolvedModelSavePoint()) {
            return false;
        }
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        for (IModelEntity iModelEntity : ExpressionInfo.a(iModel)) {
            if (!ExpressionInfo.b(iGeomSequence, iModelEntity) || !((IPostInfoProvider)((Object)iModelEntity)).getPostInfo().isFarFieldRadiusDependent(iModelEntity)) continue;
            return true;
        }
        return false;
    }

    public Data getDefaultCometTail(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = FlStringUtil.array((int)n2, (String)"0");
        String[] stringArray2 = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getCometTail(n2, (IModelEntity)iModelEntity));
        if (stringArray2 != null) {
            int n3 = this.getNArrayComponents();
            boolean bl2 = iGeomSequence.isAxisymmetric();
            if (bl2 && n3 == 2) {
                stringArray2[1] = stringArray2[stringArray2.length - 1];
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, Math.min(stringArray2.length, n2));
            return new Data(stringArray, "");
        }
        return new Data(stringArray, "");
    }

    public Data getDefaultParticleArrow(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = FlStringUtil.array((int)n2, (String)"0");
        String[] stringArray2 = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getParticleArrow(n2, (IModelEntity)iModelEntity));
        if (stringArray2 != null) {
            int n3 = this.getNArrayComponents();
            if (iGeomSequence.isAxisymmetric() && n3 == 2) {
                stringArray2[1] = stringArray2[stringArray2.length - 1];
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, Math.min(stringArray2.length, n2));
            return new Data(stringArray, "");
        }
        return new Data(stringArray, "");
    }

    public Data getDefaultTrajectoryRibbonDir(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = FlStringUtil.array((int)n2, (String)"0");
        String[] stringArray2 = this.c(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getTrajectoryRibbonDir(n2, (IModelEntity)iModelEntity));
        if (stringArray2 != null) {
            int n3 = this.getNArrayComponents();
            if (iGeomSequence.isAxisymmetric() && n3 == 2) {
                stringArray2[1] = stringArray2[stringArray2.length - 1];
            }
            System.arraycopy(stringArray2, 0, stringArray, 0, Math.min(stringArray2.length, n2));
            return new Data(stringArray, "");
        }
        return new Data(stringArray, "");
    }

    public int[] getDefaultInletSelection() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        HashSet hashSet = new HashSet();
        ExpressionInfo.a(iModel).forEach(iModelEntity -> {
            int[] nArray;
            if (ExpressionInfo.a(iGeomSequence, iModelEntity) && (nArray = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo().getInletBoundaries()) != null) {
                int[] nArray2 = nArray;
                int n2 = nArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    hashSet.add(n4);
                    ++n3;
                }
            }
        });
        return q.b((Integer[])((Integer[])hashSet.stream().sorted().toArray(Integer[]::new)));
    }

    @Override
    public FlHashMap<String, IApplPostInfo.ParticleForce[]> getParticleForces() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        FlHashMap flHashMap = new FlHashMap();
        ExpressionInfo.a(iModel).forEach(iModelEntity -> {
            if (ExpressionInfo.a(iGeomSequence, iModelEntity)) {
                this.b.getString("tvar");
                IApplPostInfo.ParticleForce[] particleForceArray = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo().getParticleData(this.b.getString("tvar"), new String[]{this.b.getString("velvarx"), this.b.getString("velvary"), this.b.getString("velvarz")}, (IModelEntity)iModelEntity);
                if (particleForceArray != null && particleForceArray.length > 0) {
                    flHashMap.put((Object)iModelEntity.tag(), (Object)particleForceArray);
                }
            }
        });
        return flHashMap;
    }

    @Override
    public String[][] getParameters() {
        if (!this.isResolvedModelSavePoint()) {
            return null;
        }
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        if (iGeomSequence != null && !iGeomSequence.getModel().isSavePoint()) {
            return null;
        }
        int n2 = this.resolveEdim();
        List<IModelEntity> list = ExpressionInfo.a(iModel);
        FlStringList flStringList = new FlStringList();
        FlStringList flStringList2 = new FlStringList();
        FlStringList flStringList3 = new FlStringList();
        FlStringList flStringList4 = new FlStringList();
        list.forEach(iModelEntity -> {
            String[][] stringArray;
            IApplPostInfo iApplPostInfo;
            IGeomSequence iGeomSequence2 = ((IPostInfoProvider)((Object)iModelEntity)).getGeom();
            if ((iGeomSequence == null || iGeomSequence2 == null || iGeomSequence.equals(iGeomSequence2)) && (iApplPostInfo = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo()) != null && (stringArray = this.b.getOperationID().equals("ParticleMass") ? iApplPostInfo.getParticleMassPlotParameters(n2, (IModelEntity)iModelEntity) : iApplPostInfo.getPlotParameters(n2, (IModelEntity)iModelEntity)) != null && stringArray.length > 0) {
                int n3 = 0;
                while (n3 < stringArray.length) {
                    if (stringArray[n3].length != 4) {
                        throw new RuntimeException("Wrong number of parameter columns");
                    }
                    flStringList.add(stringArray[n3][0]);
                    flStringList2.add(stringArray[n3][1]);
                    flStringList3.add(stringArray[n3][2]);
                    flStringList4.add(FlLocale.getString((String)stringArray[n3][3]));
                    ++n3;
                }
            }
        });
        String[][] stringArray = new String[flStringList.size()][4];
        int n3 = 0;
        while (n3 < flStringList.size()) {
            stringArray[n3][0] = flStringList.get(n3);
            stringArray[n3][1] = flStringList2.get(n3);
            stringArray[n3][2] = flStringList3.get(n3);
            stringArray[n3][3] = flStringList4.get(n3);
            ++n3;
        }
        return stringArray;
    }

    public IApplPostInfo.LegendInfo getDefaultGlobalLegend() {
        IModel iModel = this.resolveModel();
        IApplPostInfo.LegendInfo legendInfo = null;
        return this.a(ExpressionInfo.a(iModel), legendInfo);
    }

    private <T> IApplPostInfo.LegendInfo a(List<T> list, IApplPostInfo.LegendInfo legendInfo) {
        for (T t2 : list) {
            IApplPostInfo.LegendInfo legendInfo2;
            IApplPostInfo iApplPostInfo = ((IPostInfoProvider)t2).getPostInfo();
            if (iApplPostInfo == null || (legendInfo2 = iApplPostInfo.getDefaultGlobalLegend()) == null) continue;
            if (legendInfo == null) {
                legendInfo = new IApplPostInfo.LegendInfo(legendInfo2);
                continue;
            }
            legendInfo.combine(legendInfo2);
        }
        if (legendInfo == null) {
            legendInfo = new IApplPostInfo.LegendInfo(true, false);
        }
        return legendInfo;
    }

    public String[] getCharacteristicYZParameters() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = ExpressionInfo.b(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getCharacteristicYZParameters((IModelEntity)iModelEntity));
        if (stringArray != null) {
            return stringArray;
        }
        return new String[]{"1", "1"};
    }

    @Override
    public String getScope() {
        return this.b.scopeDot();
    }

    @Override
    public final String getShortExpr(String string) {
        return this.getShortExprs(string)[0];
    }

    @Override
    public final String getShortExpr(String string, String string2, IModel iModel) {
        return this.a(string2, iModel, string)[0];
    }

    @Override
    public final String[] getShortExprs(String ... stringArray) {
        return this.a(this.getScope(), this.resolveModel(), stringArray);
    }

    protected String[] a(String string, IModel iModel, String ... stringArray) {
        IVariableData iVariableData = iModel.physics().getVarData();
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = FlStringUtil.isVariableName((String)stringArray[n2]) ? ParseUtil.d((String)stringArray[n2], (String)string) : iVariableData.replaceWithShortNames(stringArray[n2], string);
            ++n2;
        }
        return stringArray2;
    }

    @Override
    public String getShortMatrixExpr(String string) {
        IVariableData iVariableData = this.resolveModel().physics().getVarData();
        String string2 = this.getScope();
        return iVariableData.replaceTensorVarWithShortNames(string, string2);
    }

    @Override
    public final String getScopedExpr(String string) {
        return this.getScopedExprs(string)[0];
    }

    @Override
    public String[] getScopedExprs(String ... stringArray) {
        String string = this.getScope();
        String[] stringArray2 = new String[stringArray.length];
        IVariableData iVariableData = this.resolveModel().physics().getVarData();
        int n2 = 0;
        while (n2 < stringArray.length) {
            stringArray2[n2] = iVariableData.replaceWithCompleteNames(stringArray[n2], string);
            ++n2;
        }
        return stringArray2;
    }

    @Override
    public String getScopedMatrixExpr(String string) {
        String string2 = this.getScope();
        IVariableData iVariableData = this.resolveModel().physics().getVarData();
        return iVariableData.replaceWithCompleteTensorNames(string, string2);
    }

    @Override
    public ExprType getExprType() {
        return null;
    }

    @Override
    public void setExprGroup(String string, String string2) {
        this.f = string;
        this.g = string2;
    }

    @Override
    public boolean isExpressionVisible() {
        return this.f == null || this.g == null ? true : this.g.equals(this.b.getString(this.f));
    }

    public void inlineButton() {
        ExprType exprType = this.getExprType();
        if (!(exprType == null || ExprType.SINGLE.equals((Object)exprType) || ExprType.MATRIX.equals((Object)exprType) || ExprType.MATRIX_OR_ARRAY.equals((Object)exprType))) {
            throw new RuntimeException("Inlined buttons only supported for single edit fields.");
        }
        this.a = true;
    }

    @Override
    public boolean isButton() {
        return this.a;
    }

    @Override
    public VariableTreeFilter getVariableTreeFilter() {
        return new VariableTreeFilter();
    }

    public String[] getDefaultPointTrajectoryExpressionPoint(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultPointTrajectoryExpressionPoint(n2, (IModelEntity)iModelEntity));
        if (stringArray != null) {
            return stringArray;
        }
        Object[] objectArray = new String[n2];
        Arrays.fill(objectArray, "0");
        return objectArray;
    }

    public String[] getDefaultPointTrajectoryExpressionGlobal(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[] stringArray = ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultPointTrajectoryExpressionGlobal(n2, (IModelEntity)iModelEntity));
        if (stringArray != null) {
            return stringArray;
        }
        Object[] objectArray = new String[n2];
        Arrays.fill(objectArray, "0");
        return objectArray;
    }

    public String[][] getDefaultEllipseExpressions(int n2) {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        String[][] stringArray2 = ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (iModelEntity, iApplPostInfo) -> iApplPostInfo.getDefaultEllipseExpression(n2, (IModelEntity)iModelEntity), stringArray -> stringArray != null && ((String[][])stringArray).length == 2);
        if (stringArray2 != null && stringArray2.length == 2) {
            return stringArray2;
        }
        Object[] objectArray = new String[n2];
        Arrays.fill(objectArray, "0");
        return new String[][]{objectArray, objectArray};
    }

    public IApplPostInfo.Smith getDefaultSmith() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        return ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultSmith((IModelEntity)iModelEntity));
    }

    public IApplPostInfo.Octave getDefaultOctave() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        return ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultOctave((IModelEntity)iModelEntity));
    }

    public IApplPostInfo.ImpulseResponse getDefaultImpulseResponse() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        return ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultImpulseResponse((IModelEntity)iModelEntity));
    }

    public IApplPostInfo.ShellDataSet getDefaultShellDataSet() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        return ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultShellDataSet((IModelEntity)iModelEntity));
    }

    public IApplPostInfo.LayeredShell[] getLayeredShell() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        ArrayList arrayList = new ArrayList();
        iModel.material().getActiveList().forEach(iMaterial -> this.a(arrayList, iMaterial.getPostInfo(), iGeomSequence, (IMaterial)iMaterial));
        return arrayList.toArray(new IApplPostInfo.LayeredShell[arrayList.size()]);
    }

    private void a(List<IApplPostInfo.LayeredShell> list, IApplPostInfo iApplPostInfo, IGeomSequence iGeomSequence, IMaterial iMaterial) {
        IApplPostInfo.LayeredShell[] layeredShellArray;
        if (iApplPostInfo != null && (layeredShellArray = iApplPostInfo.getLayeredShell(iMaterial)) != null) {
            list.addAll(Arrays.asList(layeredShellArray));
        }
    }

    public IApplPostInfo.LayeredShellSlice getDefaultLayeredShellSlice() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        return ExpressionInfo.a(ExpressionInfo.a(iModel), iGeomSequence, (IModelEntity iModelEntity, IApplPostInfo iApplPostInfo) -> iApplPostInfo.getDefaultLayeredShellSlice((IModelEntity)iModelEntity));
    }

    public String[][] getGlobalMatrixDescriptionTransformations() {
        IModel iModel = this.resolveModel();
        IGeomSequence iGeomSequence = this.resolveGeom();
        ArrayList arrayList = new ArrayList();
        ExpressionInfo.a(iModel).forEach(iModelEntity -> {
            String[][] stringArray;
            if (ExpressionInfo.b(iGeomSequence, iModelEntity) && (stringArray = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo().getGlobalMatrixDescriptionTransformations((IModelEntity)iModelEntity)) != null) {
                arrayList.addAll(Arrays.asList(stringArray));
            }
        });
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    private static IApplPostInfo a(IModelEntity iModelEntity) {
        if (iModelEntity instanceof IPostInfoProvider) {
            return ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo();
        }
        if (iModelEntity instanceof PhysicsFeature) {
            return ((PhysicsFeature)iModelEntity).getPostInfo();
        }
        throw new FlException("Cannot_create_default_plot_for @class " + iModelEntity.tag());
    }

    private static List<IModelEntity> a(IModel iModel) {
        ArrayList<IModelEntity> arrayList = new ArrayList<IModelEntity>();
        arrayList.addAll(iModel.physics().getActiveList());
        arrayList.addAll(iModel.multiphysics().getActiveList());
        arrayList.addAll(iModel.common().getActiveList());
        arrayList.addAll(iModel.coordSystem().getActiveList());
        arrayList.addAll(iModel.reduced().getActiveList());
        return arrayList;
    }

    private static boolean a(IGeomSequence iGeomSequence, IModelEntity iModelEntity) {
        if (((IPostInfoProvider)((Object)iModelEntity)).getPostInfo() == null) {
            return false;
        }
        IGeomSequence iGeomSequence2 = ((IPostInfoProvider)((Object)iModelEntity)).getGeom();
        return iGeomSequence != null && iGeomSequence.equals(iGeomSequence2) || iGeomSequence2 == null;
    }

    private static boolean b(IGeomSequence iGeomSequence, IModelEntity iModelEntity) {
        if (((IPostInfoProvider)((Object)iModelEntity)).getPostInfo() == null) {
            return false;
        }
        IGeomSequence iGeomSequence2 = ((IPostInfoProvider)((Object)iModelEntity)).getGeom();
        return iGeomSequence != null && iGeomSequence.equals(iGeomSequence2) || iGeomSequence == null && iGeomSequence2 == null;
    }

    private static <R> R a(List<IModelEntity> list, IGeomSequence iGeomSequence, BiFunction<IModelEntity, IApplPostInfo, R> biFunction) {
        return (R)ExpressionInfo.a(list, iGeomSequence, biFunction, object -> object != null);
    }

    private static <R> R a(List<IModelEntity> list, IGeomSequence iGeomSequence, BiFunction<IModelEntity, IApplPostInfo, R> biFunction, Function<R, Boolean> function) {
        for (IModelEntity iModelEntity : list) {
            R r2;
            if (!ExpressionInfo.a(iGeomSequence, iModelEntity) || !function.apply(r2 = biFunction.apply(iModelEntity, ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo())).booleanValue()) continue;
            return r2;
        }
        return null;
    }

    private static <R> R b(List<IModelEntity> list, IGeomSequence iGeomSequence, BiFunction<IModelEntity, IApplPostInfo, R> biFunction) {
        for (IModelEntity iModelEntity : list) {
            R r2;
            if (!ExpressionInfo.b(iGeomSequence, iModelEntity) || (r2 = biFunction.apply(iModelEntity, ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo())) == null) continue;
            return r2;
        }
        return null;
    }

    private <R> R b(List<IModelEntity> list, IGeomSequence iGeomSequence, BiFunction<IModelEntity, IApplPostInfo, R> biFunction, Function<R, Boolean> function) {
        for (IModelEntity iModelEntity : list) {
            Object object;
            String[] stringArray;
            if (this.b != null && this.b.getParentModel() != null) {
                R r2;
                stringArray = FlStringUtil.strSplit((String)iModelEntity.scope(), (int)46);
                object = FlStringUtil.strSplit((String)this.b.scope(), (int)46);
                if (stringArray.length <= 1 || ((R)object).length <= 1 || !((String)object[1]).equals(stringArray[1]) || !function.apply(r2 = ExpressionInfo.a(biFunction, iModelEntity)).booleanValue()) continue;
                return r2;
            }
            stringArray = ModelEntityUtil.getGeometry(iModelEntity);
            if ((iGeomSequence == null || !iGeomSequence.equals(stringArray)) && (iGeomSequence != null || stringArray != null) || !function.apply(object = ExpressionInfo.a(biFunction, iModelEntity)).booleanValue()) continue;
            return object;
        }
        return null;
    }

    private <R> R c(List<IModelEntity> list, IGeomSequence iGeomSequence, BiFunction<IModelEntity, IApplPostInfo, R> biFunction) {
        return (R)this.b(list, iGeomSequence, biFunction, object -> object != null);
    }

    private static <R> R a(BiFunction<IModelEntity, IApplPostInfo, R> biFunction, IModelEntity iModelEntity) {
        IApplPostInfo iApplPostInfo = ((IPostInfoProvider)((Object)iModelEntity)).getPostInfo();
        if (iApplPostInfo != null) {
            return biFunction.apply(iModelEntity, iApplPostInfo);
        }
        return null;
    }

    @Override
    public boolean isIncludeResultParameters() {
        return false;
    }

    @Override
    public boolean hasInputAndLocalParams() {
        return false;
    }

    public void disableAutoComplete() {
        this.h = false;
    }

    public boolean isAutoCompleteAllowed() {
        return this.h;
    }

    public boolean isAddAutoCompleteOnly() {
        return false;
    }

    @Override
    public boolean includeSectionToolBar() {
        return true;
    }

    @Override
    public boolean allowFunctions() {
        return true;
    }

    @Override
    public boolean allowPropFunctions() {
        return false;
    }

    public static class Data {
        private String a;
        private String[] b;
        private String c;
        private String[] d;

        public Data(String string, String string2) {
            this.a = string;
            this.c = string2;
        }

        public Data(String[] stringArray, String string) {
            this.b = stringArray;
            this.c = string;
        }

        public Data(String[] stringArray, String[] stringArray2) {
            this.b = stringArray;
            this.d = stringArray2;
        }

        public String getExpr() {
            return this.a;
        }

        public String[] getArrayExpr() {
            return this.b;
        }

        public String getDescr() {
            return this.c;
        }

        public String[] getArrayDescr() {
            return this.d;
        }
    }

    public static enum ExprType {
        SINGLE,
        ARRAY,
        MATRIX,
        MATRIX_OR_ARRAY,
        PARTICLE,
        BUILDER,
        BUILDER_CONDITION,
        BUILDER_UNIT,
        BUILDER_ARGUMENT,
        BUILDER_LINK,
        LATEX,
        BUILDER_LATEX;


        public boolean isForPhysicsBuilder() {
            return this.name().startsWith("BUILDER");
        }

        public boolean isForLaTeX() {
            return this.name().endsWith("LATEX");
        }

        public boolean useFullCompletion() {
            return this.isForPhysicsBuilder() || this.isForLaTeX();
        }
    }
}

