/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.applapi.LayeredShellData;
import com.comsol.model.dbimodel.DatasetFeature;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public enum DatasetOperationID implements IOperationID
{
    ARRAY1D("Array1D", "arr", "Array_1D", "dataset_array1d.png"),
    ARRAY2D("Array2D", "arr", "Array_2D", "dataset_array2d.png"),
    ARRAY3D("Array3D", "arr", "Array_3D", "dataset_array3d.png"),
    AVERAGE("Average", "av", "Average", "cpl_average.png"),
    CONTOUR("Contour", "con", "Contour", "dataset_contour.png"),
    CUTLINE2D("CutLine2D", "cln", "Cut_line_2D", "dataset_cut_line2d.png"),
    CUTLINE3D("CutLine3D", "cln", "Cut_line_3D", "dataset_cut_line3d.png"),
    CUTPLANE("CutPlane", "cpl", "Cut_plane", "dataset_cut_plane.png"),
    CUTPOINT1D("CutPoint1D", "cpt", "Cut_point_1D", "dataset_cut_point1d.png"),
    CUTPOINT2D("CutPoint2D", "cpt", "Cut_point_2D", "dataset_cut_point2d.png"),
    CUTPOINT3D("CutPoint3D", "cpt", "Cut_point_3D", "dataset_cut_point3d.png"),
    EDGE2D("Edge2D", "edg", "Edge_2D", "dataset_edge_2d.png"),
    EDGE3D("Edge3D", "edg", "Edge_3D", "dataset_edge3d.png"),
    EXTRUDE1D("Extrude1D", "extr", "Extrusion_1D", "dataset_extrusion1d.png"),
    EXTRUDE2D("Extrude2D", "extr", "Extrusion_2D", "dataset_extrusion2d.png"),
    FILTER("Filter", "filt", "Filter", "data_set_filter.png"),
    GRID1D("Grid1D", "grid", "Grid_1D", "dataset_grid1d.png"),
    GRID2D("Grid2D", "grid", "Grid_2D", "dataset_grid2d.png"),
    GRID3D("Grid3D", "grid", "Grid_3D", "dataset_grid3d.png"),
    INTEGRAL("Integral", "int", "Integral", "cpl_integration.png"),
    INTERSECTIONPOINT2D("IntersectionPoint2D", "ip", "Intersection_point_2D", "dataset_intersection_point2d.png"),
    INTERSECTIONPOINT3D("IntersectionPoint3D", "ip", "Intersection_point_3D", "dataset_intersection_point3d.png"),
    ISOSURFACE("Isosurface", "iso", "Isosurface", "dataset_isosurface.png"),
    JOIN("Join", "join", "Join", "dataset_join.png"),
    LAYEREDMATERIAL("LayeredMaterial", "lshl", "Layered_material", "dataset_layered_shell.png"),
    MAXIMUM("Maximum", "max", "Maximum", "cpl_maximum.png"),
    MESH("Mesh", "mesh", "Mesh", "post_mesh_quality.png"),
    MINIMUM("Minimum", "min", "Minimum", "cpl_minimum.png"),
    MIRROR2D("Mirror2D", "mir", "Mirror_2D", "dataset_mirror2d.png"),
    MIRROR3D("Mirror3D", "mir", "Mirror_3D", "dataset_mirror3d.png"),
    PARAMETRIC1D("Parametric1D", "par", "Parametric_Extrusion_1D", "dataset_parametric_extrusion.png"),
    PARAMETRIC2D("Parametric2D", "par", "Parametric_Extrusion_2D", "dataset_parametric_extrusion2d.png"),
    PARCURVE2D("ParCurve2D", "pc", "Parameterized_curve_2D", "dataset_parametrized_curve2d.png"),
    PARCURVE3D("ParCurve3D", "pc", "Parameterized_curve_3D", "dataset_parametrized_curve3d.png"),
    PARSURFACE("ParSurface", "ps", "Parameterized_surface", "dataset_parametrized_surface.png"),
    PARTICLE("Particle", "part", "Particle", "dataset_particle.png"),
    PARTICLEBIN("ParticleBin", "pbin", "Particle_bin", "dataset_particle_bin.png"),
    RAY("Ray", "ray", "Ray", "dataset_ray.png"),
    RAYBIN("RayBin", "rbin", "Ray_bin", "dataset_ray_bin.png"),
    RECEIVER2D("Receiver2D", "re", "Receiver_2D", "dataset_receiver2d.png"),
    RECEIVER3D("Receiver3D", "re", "Receiver_3D", "dataset_receiver3d.png"),
    RESPONSESPECTRUM2D("ResponseSpectrum2D", "rs", "Response_spectrum_2D", "dataset_response_spectrum.png"),
    RESPONSESPECTRUM3D("ResponseSpectrum3D", "rs", "Response_spectrum_3D", "dataset_response_spectrum.png"),
    REVOLVE1D("Revolve1D", "rev", "Revolution_1D", "dataset_revolution1d.png"),
    REVOLVE2D("Revolve2D", "rev", "Revolution_2D", "dataset_revolution2d.png"),
    SECTOR2D("Sector2D", "sec", "Sector_2D", "dataset_sector2d.png"),
    SECTOR3D("Sector3D", "sec", "Sector_3D", "dataset_sector3d.png"),
    SHELL("Shell", "shl", "Shell", "dataset_shell.png"),
    SOLUTION("Solution", "dset", "Solution", "dataset_solution.png"),
    SURFACE("Surface", "surf", "Surface", "dataset_surface.png"),
    TIMEAVERAGE("TimeAverage", "tavg", "Time_average", "cpl_time_average.png"),
    TIMEINTEGRAL("TimeIntegral", "tint", "Time_integral", "cpl_time_integration.png");

    private final String idString;
    private final String shortName;
    private final String descr;
    private final String icon;
    public static final String[] NONE;
    private static final Map<String, DatasetOperationID> a;

    static {
        NONE = new String[0];
        a = new HashMap<String, DatasetOperationID>();
        DatasetOperationID[] datasetOperationIDArray = DatasetOperationID.values();
        int n2 = datasetOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DatasetOperationID datasetOperationID = datasetOperationIDArray[n3];
            a.put(datasetOperationID.id(), datasetOperationID);
            ++n3;
        }
    }

    private DatasetOperationID(String string2, String string3, String string4, String string5) {
        this.idString = string2;
        this.shortName = string3;
        this.descr = string4;
        this.icon = string5;
    }

    public String toString() {
        return this.idString;
    }

    public String getMenuActionTag() {
        return "dataset_" + this.id();
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof DatasetFeature && this.id().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }

    public static boolean isOfType(PropFeature propFeature, DatasetOperationID ... datasetOperationIDArray) {
        DatasetOperationID[] datasetOperationIDArray2 = datasetOperationIDArray;
        int n2 = datasetOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            DatasetOperationID datasetOperationID = datasetOperationIDArray2[n3];
            if (datasetOperationID.isOfType(propFeature)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public static String[][] getMajor() {
        return new String[][]{{SOLUTION.toString(), MESH.toString(), JOIN.toString(), FILTER.toString()}, {CUTPLANE.toString(), CUTLINE3D.toString(), CUTPOINT3D.toString(), SURFACE.toString(), EDGE3D.toString()}, {CUTLINE2D.toString(), CUTPOINT2D.toString(), EDGE2D.toString(), REVOLVE2D.toString()}, {CUTPOINT1D.toString(), REVOLVE1D.toString()}};
    }

    public static String[][] getMinor3D() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        FlStringList flStringList = new FlStringList();
        if (DatasetOperationID.allowShell()) {
            flStringList.add(SHELL.toString());
        }
        flStringList.add(ARRAY3D.toString());
        flStringList.add(MIRROR3D.toString());
        flStringList.add(SECTOR3D.toString());
        flStringList.add(ISOSURFACE.toString());
        flStringList.add(PARSURFACE.toString());
        flStringList.add(PARCURVE3D.toString());
        flStringList.add(GRID3D.toString());
        if (DatasetOperationID.allowIntersectionPoint()) {
            flStringList.add(INTERSECTIONPOINT3D.toString());
        }
        if (DatasetOperationID.allowReceiver()) {
            flStringList.add(RECEIVER3D.toString());
        }
        if (DatasetOperationID.allowResponseSpectrum()) {
            flStringList.add(RESPONSESPECTRUM3D.toString());
        }
        arrayList.add(flStringList.toArray());
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public static String[][] getMinor2D() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        FlStringList flStringList = new FlStringList();
        flStringList.add(ARRAY2D.toString());
        flStringList.add(MIRROR2D.toString());
        flStringList.add(SECTOR2D.toString());
        flStringList.add(EXTRUDE2D.toString());
        flStringList.add(CONTOUR.toString());
        flStringList.add(PARAMETRIC2D.toString());
        flStringList.add(PARCURVE2D.toString());
        flStringList.add(GRID2D.toString());
        if (DatasetOperationID.allowIntersectionPoint()) {
            flStringList.add(INTERSECTIONPOINT2D.toString());
        }
        if (DatasetOperationID.allowReceiver()) {
            flStringList.add(RECEIVER2D.toString());
        }
        if (DatasetOperationID.allowResponseSpectrum()) {
            flStringList.add(RESPONSESPECTRUM2D.toString());
        }
        arrayList.add(flStringList.toArray());
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public static String[][] getMinorOther() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        FlStringList flStringList = new FlStringList();
        if (DatasetOperationID.allowParticle()) {
            flStringList.add(PARTICLE.toString());
            flStringList.add(PARTICLEBIN.toString());
        }
        if (DatasetOperationID.allowRay()) {
            flStringList.add(RAY.toString());
            flStringList.add(RAYBIN.toString());
        }
        if (DatasetOperationID.allowLayeredShell()) {
            flStringList.add(LAYEREDMATERIAL.toString());
        }
        if (flStringList.size() > 0) {
            arrayList.add(flStringList.toArray());
        }
        flStringList = new FlStringList();
        flStringList.add(ARRAY1D.toString());
        flStringList.add(EXTRUDE1D.toString());
        flStringList.add(PARAMETRIC1D.toString());
        flStringList.add(GRID1D.toString());
        arrayList.add(flStringList.toArray());
        flStringList = new FlStringList();
        flStringList.add(AVERAGE.toString());
        flStringList.add(INTEGRAL.toString());
        flStringList.add(MAXIMUM.toString());
        flStringList.add(MINIMUM.toString());
        flStringList.add(TIMEAVERAGE.toString());
        flStringList.add(TIMEINTEGRAL.toString());
        arrayList.add(flStringList.toArray());
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public static boolean allowIntersectionPoint() {
        return d.a((LicenseType[])new LicenseType[]{LicenseType.PARTICLETRACING, LicenseType.RAYOPTICS, LicenseType.ACOUSTICS});
    }

    public static boolean allowShell() {
        return d.a((LicenseType)LicenseType.STRUCTURALMECHANICS);
    }

    public static boolean allowLayeredShell() {
        return d.a((LicenseType[])((LicenseType[])q.b((Object[][])new LicenseType[][]{LayeredShellData.licenseRequired, {LicenseType.STRUCTURALMECHANICS}})));
    }

    public static boolean allowParticle() {
        return d.a((LicenseType[])new LicenseType[]{LicenseType.PARTICLETRACING, LicenseType.PLASMA});
    }

    public static boolean allowRay() {
        return d.a((LicenseType[])new LicenseType[]{LicenseType.RAYOPTICS, LicenseType.ACOUSTICS});
    }

    public static boolean allowReceiver() {
        return d.a((LicenseType)LicenseType.ACOUSTICS);
    }

    public static boolean allowResponseSpectrum() {
        return d.a((LicenseType)LicenseType.STRUCTURALMECHANICS);
    }

    public static String[] getGalleryGrouped(int n2, boolean bl2) {
        FlStringList flStringList = new FlStringList();
        if (bl2) {
            flStringList.add("Base_data_sets");
            flStringList.add(new String[]{SOLUTION.toString(), MESH.toString(), JOIN.toString(), FILTER.toString()});
            if (DatasetOperationID.allowParticle()) {
                flStringList.add(PARTICLE.toString());
                flStringList.add(PARTICLEBIN.toString());
            }
            if (DatasetOperationID.allowRay()) {
                flStringList.add(RAY.toString());
                flStringList.add(RAYBIN.toString());
            }
            return flStringList.toArray();
        }
        flStringList.add(String.valueOf(n2) + "D_data_sets");
        switch (n2) {
            case 1: {
                flStringList.add(DatasetOperationID.d());
                break;
            }
            case 2: {
                flStringList.add(DatasetOperationID.c());
                break;
            }
            case 3: {
                flStringList.add(DatasetOperationID.b());
            }
        }
        return flStringList.toArray();
    }

    private static String[] b() {
        FlStringList flStringList = new FlStringList(new String[]{SURFACE.toString(), EDGE3D.toString()});
        if (DatasetOperationID.allowShell()) {
            flStringList.add(SHELL.toString());
        }
        if (DatasetOperationID.allowLayeredShell()) {
            flStringList.add(LAYEREDMATERIAL.toString());
        }
        flStringList.add(new String[]{ARRAY3D.toString(), MIRROR3D.toString(), SECTOR3D.toString(), ISOSURFACE.toString(), PARSURFACE.toString(), PARCURVE3D.toString()});
        if (DatasetOperationID.allowIntersectionPoint()) {
            flStringList.add(INTERSECTIONPOINT3D.toString());
        }
        if (DatasetOperationID.allowReceiver()) {
            flStringList.add(RECEIVER3D.toString());
        }
        return flStringList.toArray();
    }

    private static String[] c() {
        FlStringList flStringList = new FlStringList(new String[]{EDGE2D.toString(), REVOLVE2D.toString(), ARRAY2D.toString(), MIRROR2D.toString(), SECTOR2D.toString(), EXTRUDE2D.toString(), CONTOUR.toString(), PARAMETRIC2D.toString(), PARCURVE2D.toString()});
        if (DatasetOperationID.allowIntersectionPoint()) {
            flStringList.add(INTERSECTIONPOINT2D.toString());
        }
        if (DatasetOperationID.allowReceiver()) {
            flStringList.add(RECEIVER2D.toString());
        }
        return flStringList.toArray();
    }

    private static String[] d() {
        return new String[]{CUTPOINT1D.toString(), REVOLVE1D.toString(), ARRAY1D.toString(), EXTRUDE1D.toString(), PARAMETRIC1D.toString()};
    }

    public static String[] getEval() {
        return new String[]{AVERAGE.toString(), INTEGRAL.toString(), MAXIMUM.toString(), TIMEAVERAGE.toString(), TIMEINTEGRAL.toString(), MINIMUM.toString()};
    }

    public static String[] getGrid() {
        return new String[]{GRID3D.toString(), GRID2D.toString(), GRID1D.toString()};
    }

    public static final String[] ALL() {
        DatasetOperationID[] datasetOperationIDArray = DatasetOperationID.values();
        String[] stringArray = new String[datasetOperationIDArray.length];
        int n2 = 0;
        while (n2 < datasetOperationIDArray.length) {
            stringArray[n2] = datasetOperationIDArray[n2].toString();
            ++n2;
        }
        return stringArray;
    }

    public static final boolean isEvaluation(PropFeature propFeature) {
        return DatasetOperationID.isOfType(propFeature, AVERAGE, INTEGRAL, MAXIMUM, MINIMUM);
    }

    public static final boolean isCutLine(PropFeature propFeature) {
        return DatasetOperationID.isOfType(propFeature, CUTLINE2D, CUTLINE3D);
    }

    public static final boolean isCutPoint(PropFeature propFeature) {
        return DatasetOperationID.isOfType(propFeature, CUTPOINT1D, CUTPOINT2D, CUTPOINT3D);
    }

    public static final boolean supportsPreviewPlot(String string) {
        return !q.a((Object[])new String[]{DatasetOperationID.AVERAGE.idString, DatasetOperationID.EDGE2D.idString, DatasetOperationID.EDGE3D.idString, DatasetOperationID.INTEGRAL.idString, DatasetOperationID.MAXIMUM.idString, DatasetOperationID.MINIMUM.idString, DatasetOperationID.SURFACE.idString}, (Object)string);
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.idString;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    public static DatasetOperationID fromID(String string) {
        return a.get(string);
    }

    public static int[] getAllowedCoordDims(DatasetOperationID datasetOperationID) {
        switch (datasetOperationID) {
            case AVERAGE: 
            case INTEGRAL: 
            case MAXIMUM: 
            case MINIMUM: {
                return new int[1];
            }
            case CUTPOINT1D: {
                int[] nArray = new int[2];
                nArray[1] = 1;
                return nArray;
            }
            case CUTPOINT2D: {
                int[] nArray = new int[2];
                nArray[1] = 2;
                return nArray;
            }
            case CUTPOINT3D: {
                int[] nArray = new int[2];
                nArray[1] = 3;
                return nArray;
            }
            case ARRAY1D: 
            case GRID1D: {
                return new int[]{1};
            }
            case CUTLINE2D: 
            case EDGE2D: 
            case PARCURVE2D: {
                return new int[]{1, 2};
            }
            case CUTLINE3D: 
            case EDGE3D: 
            case PARCURVE3D: {
                return new int[]{1, 3};
            }
            case ARRAY2D: 
            case CONTOUR: 
            case EXTRUDE1D: 
            case GRID2D: 
            case INTERSECTIONPOINT2D: 
            case MIRROR2D: 
            case PARAMETRIC1D: 
            case RECEIVER2D: 
            case REVOLVE1D: 
            case SECTOR2D: {
                return new int[]{2};
            }
            case CUTPLANE: 
            case LAYEREDMATERIAL: 
            case PARSURFACE: 
            case SURFACE: {
                return new int[]{2, 3};
            }
            case ARRAY3D: 
            case EXTRUDE2D: 
            case GRID3D: 
            case INTERSECTIONPOINT3D: 
            case ISOSURFACE: 
            case MIRROR3D: 
            case PARAMETRIC2D: 
            case RECEIVER3D: 
            case REVOLVE2D: 
            case SECTOR3D: 
            case SHELL: {
                return new int[]{3};
            }
            case RESPONSESPECTRUM2D: {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                return nArray;
            }
        }
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        return nArray;
    }

    public static int[] getAllowedSpaceDims(DatasetOperationID datasetOperationID) {
        switch (datasetOperationID) {
            case AVERAGE: 
            case CUTPOINT1D: 
            case CUTPOINT2D: 
            case CUTPOINT3D: 
            case INTEGRAL: 
            case INTERSECTIONPOINT2D: 
            case INTERSECTIONPOINT3D: 
            case MAXIMUM: 
            case MINIMUM: 
            case RECEIVER2D: 
            case RECEIVER3D: {
                return new int[1];
            }
            case ARRAY1D: 
            case CONTOUR: 
            case CUTLINE2D: 
            case CUTLINE3D: 
            case EDGE2D: 
            case EDGE3D: 
            case GRID1D: 
            case PARCURVE2D: 
            case PARCURVE3D: {
                return new int[]{1};
            }
            case ARRAY2D: 
            case CUTPLANE: 
            case EXTRUDE1D: 
            case GRID2D: 
            case ISOSURFACE: 
            case MIRROR2D: 
            case PARAMETRIC1D: 
            case PARSURFACE: 
            case REVOLVE1D: 
            case SECTOR2D: 
            case SHELL: 
            case SURFACE: {
                return new int[]{2};
            }
            case LAYEREDMATERIAL: {
                return new int[]{2, 3};
            }
            case ARRAY3D: 
            case EXTRUDE2D: 
            case GRID3D: 
            case MIRROR3D: 
            case PARAMETRIC2D: 
            case REVOLVE2D: 
            case SECTOR3D: {
                return new int[]{3};
            }
            case RESPONSESPECTRUM2D: {
                int[] nArray = new int[3];
                nArray[1] = 1;
                nArray[2] = 2;
                return nArray;
            }
        }
        int[] nArray = new int[4];
        nArray[1] = 1;
        nArray[2] = 2;
        nArray[3] = 3;
        return nArray;
    }
}

