/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.dbimodel.EvaluationFeature;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import java.util.stream.Stream;

public enum EvaluationOperationID implements IOperationID
{
    AVLINE("AvLine", "av", "Line_average", "cpl_average.png"),
    AVSURFACE("AvSurface", "av", "Surface_average", "cpl_average.png"),
    AVVOLUME("AvVolume", "av", "Volume_average[numerical]", "cpl_average.png"),
    EVALABERRATION("EvalAberration", "oae", "Aberration_evaluation", "numerical_aberration.png"),
    EVALGLOBAL("EvalGlobal", "gev", "Global_evaluation", "numerical_evalglobal.png"),
    EVALGLOBALMATRIX("EvalGlobalMatrix", "gmev", "Global_matrix_evaluation", "numerical_evalglobalmatrix.png"),
    EVALGLOBALSWEEP("EvalGlobalSweep", "gevs", "Global_evaluation_sweep", "numerical_evalglobalsweep.png"),
    EVALPOINT("EvalPoint", "pev", "Point_evaluation", "numerical_results.png"),
    EVALPOINTMATRIX("EvalPointMatrix", "gpev", "Point_matrix_evaluation", "numerical_evalpointmatrix.png"),
    INTLINE("IntLine", "int", "Line_integration", "post_line_integral.png"),
    INTSURFACE("IntSurface", "int", "Surface_integration", "post_surface_integral.png"),
    INTVOLUME("IntVolume", "int", "Volume_integration", "post_volume_integral.png"),
    MAXLINE("MaxLine", "max", "Line_maximum", "cpl_maximum.png"),
    MAXSURFACE("MaxSurface", "max", "Surface_maximum", "cpl_maximum.png"),
    MAXVOLUME("MaxVolume", "max", "Volume_maximum", "cpl_maximum.png"),
    MINLINE("MinLine", "min", "Line_minimum", "cpl_minimum.png"),
    MINSURFACE("MinSurface", "min", "Surface_minimum", "cpl_minimum.png"),
    MINVOLUME("MinVolume", "min", "Volume_minimum", "cpl_minimum.png"),
    PARTICLE("Particle", "par", "Particle_evaluation", "numerical_particle.png"),
    RAY("Ray", "ray", "Ray_evaluation", "numerical_ray.png"),
    SYSTEMMATRIX("SystemMatrix", "sys", "System_matrix", "system_matrix.png");

    private final String idString;
    private final String shortName;
    private final String descr;
    private final String icon;

    private EvaluationOperationID(String string2, String string3, String string4, String string5) {
        this.idString = string2;
        this.shortName = string3;
        this.descr = string4;
        this.icon = string5;
    }

    public String toString() {
        return this.idString;
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.idString;
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        return this.icon;
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof EvaluationFeature && this.id().equals(propFeature.getOperationID());
    }

    public static boolean isOfType(PropFeature propFeature, EvaluationOperationID ... evaluationOperationIDArray) {
        EvaluationOperationID[] evaluationOperationIDArray2 = evaluationOperationIDArray;
        int n2 = evaluationOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            EvaluationOperationID evaluationOperationID = evaluationOperationIDArray2[n3];
            if (evaluationOperationID.isOfType(propFeature)) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    @Override
    public boolean isOfType(String string) {
        return this.id().equals(string);
    }

    public static final EvaluationOperationID fromID(String string) {
        return Stream.of(EvaluationOperationID.values()).filter(evaluationOperationID -> string.equals(evaluationOperationID.toString())).findFirst().orElse(null);
    }

    public static final String[] ALL() {
        return (String[])Stream.of(EvaluationOperationID.values()).map(evaluationOperationID -> evaluationOperationID.toString()).toArray(String[]::new);
    }

    public static String[][] getGrouped(boolean bl2) {
        FlStringList flStringList = new FlStringList();
        if (bl2) {
            flStringList.add(EVALPOINT.toString());
            flStringList.add(EVALGLOBAL.toString());
            flStringList.add(EVALPOINTMATRIX.toString());
            flStringList.add(EVALGLOBALMATRIX.toString());
            flStringList.add(SYSTEMMATRIX.toString());
        } else {
            if (d.a((LicenseType[])new LicenseType[]{LicenseType.PARTICLETRACING, LicenseType.PLASMA})) {
                flStringList.add(PARTICLE.toString());
            }
            if (d.a((LicenseType[])new LicenseType[]{LicenseType.RAYOPTICS, LicenseType.ACOUSTICS})) {
                flStringList.add(RAY.toString());
            }
            if (d.a((LicenseType[])new LicenseType[]{LicenseType.RAYOPTICS})) {
                flStringList.add(EVALABERRATION.toString());
            }
            flStringList.add(EVALGLOBALSWEEP.toString());
        }
        return new String[][]{flStringList.toArray()};
    }
}

