/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.operationID.IOperationID;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.license.LicenseType;
import com.comsol.util.license.d;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public enum FunctionOperationID implements IOperationID
{
    ANALYTIC("Analytic", "Analytic", "an"),
    ELEVATION("Elevation", "Elevation_(DEM)", "elev"),
    EXTERNAL("External", "External", "ext"),
    GAUSSIANPULSE("GaussianPulse", "Gaussian_pulse", "gp"),
    IMAGE("Image", "Image", "im"),
    INTERPOLATION("Interpolation", "Interpolation", "int"),
    MATLAB("MATLAB", "MATLAB", "extm"),
    PIECEWISE("Piecewise", "Piecewise", "pw"),
    RAMP("Ramp", "Ramp", "rm"),
    RANDOM("Random", "Random", "rn"),
    RECTANGLE("Rectangle", "Rectangle[function]", "rect"),
    STEP("Step", "Step[function]", "step"),
    TRIANGLE("Triangle", "Triangle[waveform]", "tri"),
    WAVE("Wave", "Waveform", "wv"),
    FUNCTIONSWITCH("FunctionSwitch", "Switch[function]", "sw");

    private final String idString;
    private final String descr;
    private final String shortName;
    public static final String[] NONE;
    private static final Map<String, FunctionOperationID> a;

    static {
        NONE = new String[0];
        a = new HashMap<String, FunctionOperationID>();
        FunctionOperationID[] functionOperationIDArray = FunctionOperationID.values();
        int n2 = functionOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FunctionOperationID functionOperationID = functionOperationIDArray[n3];
            a.put(functionOperationID.getID(), functionOperationID);
            ++n3;
        }
    }

    private FunctionOperationID(String string2, String string3, String string4) {
        this.idString = string2;
        this.descr = string3;
        this.shortName = string4;
    }

    public String toString() {
        return this.idString;
    }

    public String getID() {
        return this.idString;
    }

    public String getMenuActionTag() {
        return "function_" + this.getID();
    }

    public static final String[] ALL_REGARDLESS_OF_LICENSE() {
        FlStringList flStringList = new FlStringList();
        FunctionOperationID[] functionOperationIDArray = FunctionOperationID.values();
        int n2 = functionOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FunctionOperationID functionOperationID = functionOperationIDArray[n3];
            flStringList.add(functionOperationID.toString());
            ++n3;
        }
        return flStringList.toArray();
    }

    public static final String[] ALL() {
        FlStringList flStringList = new FlStringList();
        FunctionOperationID[] functionOperationIDArray = FunctionOperationID.values();
        int n2 = functionOperationIDArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FunctionOperationID functionOperationID = functionOperationIDArray[n3];
            if (!MATLAB.equals(functionOperationID) || d.a((LicenseType)LicenseType.LLMATLAB)) {
                flStringList.add(functionOperationID.toString());
            }
            ++n3;
        }
        return flStringList.toArray();
    }

    public static final String[] SWITCHABLE() {
        return new String[]{ANALYTIC.toString(), INTERPOLATION.toString(), PIECEWISE.toString(), GAUSSIANPULSE.toString(), RAMP.toString(), RECTANGLE.toString(), STEP.toString(), TRIANGLE.toString(), WAVE.toString(), RANDOM.toString()};
    }

    public static String[] getMenuOrder() {
        return new String[]{ANALYTIC.toString(), INTERPOLATION.toString(), PIECEWISE.toString(), GAUSSIANPULSE.toString(), RAMP.toString(), RECTANGLE.toString(), STEP.toString(), TRIANGLE.toString(), WAVE.toString(), RANDOM.toString(), EXTERNAL.toString(), MATLAB.toString(), ELEVATION.toString(), IMAGE.toString(), FUNCTIONSWITCH.toString()};
    }

    @Override
    public String descr() {
        return this.descr;
    }

    @Override
    public String id() {
        return this.getID();
    }

    @Override
    public String shortName() {
        return this.shortName;
    }

    @Override
    public String getIcon() {
        switch (this) {
            case ANALYTIC: 
            case GAUSSIANPULSE: 
            case INTERPOLATION: 
            case PIECEWISE: 
            case RAMP: 
            case RANDOM: 
            case STEP: 
            case TRIANGLE: 
            case WAVE: {
                return "function_" + this.toString().toLowerCase(Locale.ENGLISH) + ".png";
            }
            case RECTANGLE: {
                return "function_tophat.png";
            }
            case EXTERNAL: {
                return "function_external.png";
            }
            case MATLAB: {
                return "function_matlab.png";
            }
            case IMAGE: {
                return "function_image.png";
            }
            case ELEVATION: {
                return "function_elevation.png";
            }
            case FUNCTIONSWITCH: {
                return "function_switch.png";
            }
        }
        return "function.png";
    }

    @Override
    public boolean isOfType(PropFeature propFeature) {
        return propFeature instanceof FunctionFeature && this.getID().equals(propFeature.getOperationID());
    }

    @Override
    public boolean isOfType(String string) {
        return this.getID().equals(string);
    }

    public static FunctionOperationID fromID(String string) {
        return a.get(string);
    }
}

