/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.operations.operationID;

import com.comsol.model.operations.operationID.IOperationID;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Function;

public interface IMaterialOperationID
extends IOperationID {
    public static final Map<String, IMaterialOperationID> idToOperationID = new LinkedHashMap<String, IMaterialOperationID>();
    public static final String[] NONE = new String[0];

    public boolean isGlobal();

    public boolean isLocal();

    public boolean isLayeredMat();

    public boolean isLinkAble();

    public boolean isSwitchAble();

    public boolean canAddToMatLib();

    public boolean allowAddFromMatLib();

    public int getWeight();

    public static IMaterialOperationID getID(String string) {
        return idToOperationID.get(string);
    }

    public static String[] ALL() {
        return idToOperationID.keySet().toArray(new String[idToOperationID.keySet().size()]);
    }

    public static String[] SWITCHABLE() {
        return IMaterialOperationID.filterOperationID(iMaterialOperationID -> iMaterialOperationID.isSwitchAble());
    }

    public static String[] GLOBAL() {
        return IMaterialOperationID.filterOperationID(iMaterialOperationID -> iMaterialOperationID.isGlobal());
    }

    public static String[] LOCAL() {
        return IMaterialOperationID.filterOperationID(iMaterialOperationID -> iMaterialOperationID.isLocal());
    }

    public static String[] LAYERED() {
        return IMaterialOperationID.filterOperationID(iMaterialOperationID -> iMaterialOperationID.isLayeredMat());
    }

    public static String[] LINKABLE() {
        return IMaterialOperationID.filterOperationID(iMaterialOperationID -> iMaterialOperationID.isLinkAble());
    }

    public static String[] filterOperationID(Function<IMaterialOperationID, Boolean> function) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Map.Entry<String, IMaterialOperationID> entry : idToOperationID.entrySet()) {
            if (!function.apply(entry.getValue()).booleanValue()) continue;
            arrayList.add(entry.getKey());
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }
}

