/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.simple;

import com.comsol.model.applapi.IPhysicalQuantity;
import com.comsol.model.applapi.MaterialDB;
import com.comsol.model.applapi.MaterialPropSychronizationRule;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.applapi.PhysicalQuantityManager;
import com.comsol.model.dbimodel.FunctionFeature;
import com.comsol.model.dbimodel.FunctionFeatureList;
import com.comsol.model.dbimodel.Information;
import com.comsol.model.dbimodel.InformationList;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.MaterialModel;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.external.ExternalMaterialModel;
import com.comsol.model.method.MaterialModelMethod;
import com.comsol.model.method.ParamValueUtil;
import com.comsol.model.operations.IPropertyGroupOperation;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.param.ScalarSpec;
import com.comsol.model.simple.SimpleFunctionFeatureList;
import com.comsol.model.simple.SimpleInformationList;
import com.comsol.model.simple.SimpleModelEntity;
import com.comsol.model.simple.SimplePropSet;
import com.comsol.nativeutil.properties.PropAnnotationInfo;
import com.comsol.util.classes.CsUniqueList;
import com.comsol.util.classes.StringStringPair;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlLocale;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class SimpleMaterialModel
extends SimpleModelEntity
implements ExternalMaterialModel {
    private static final long serialVersionUID = -3170016567330371685L;
    private final SimplePropSet propSet = new SimplePropSet();
    private Map<String, ParamSpec> outputSpecs = null;
    private Map<String, MaterialPropSychronizationRule> synchRules = null;
    private Map<String, String> identityRules = null;
    private EnumSet<ModelEntity.Flags> entityFlags = EnumSet.noneOf(ModelEntity.Flags.class);
    private String identifier = null;
    private SimpleInformationList info = null;
    private List<String> inputs = null;
    private SimpleFunctionFeatureList functions;
    private Map<String, String> propertyInfo = null;
    private Map<String, String> localDescr = null;

    public SimpleMaterialModel(String string) {
        super(string);
        this.identifier = string;
    }

    protected SimpleMaterialModel(MaterialModel materialModel) {
        super(materialModel);
        String string;
        this.identifier = materialModel.getIdentifier();
        String[] stringArray = materialModel.input();
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            this.addInput(string);
            ++n3;
        }
        stringArray = materialModel.output();
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            this.setOutput(string, materialModel.getSpec(string).copy());
            ++n3;
        }
        stringArray = materialModel.param();
        n2 = stringArray.length;
        n3 = 0;
        while (n3 < n2) {
            string = stringArray[n3];
            this.set(string, materialModel.getDblStringArray(string));
            if (materialModel.isOutput(string)) {
                String string2 = materialModel.getPropertyInfo(string);
                if (!string2.isEmpty()) {
                    this.setPropertyInfo(string, string2);
                }
            } else if (materialModel.hasParam("DESCR_PREFIX:" + string)) {
                this.descr(string, materialModel.descr(string));
            }
            ++n3;
        }
        if (materialModel.info().size() > 0) {
            this.info = (SimpleInformationList)new SimpleInformationList(materialModel.info()).c(this);
        }
        if (materialModel.func().size() > 0) {
            this.functions = (SimpleFunctionFeatureList)new SimpleFunctionFeatureList(materialModel.func()).c(this);
        }
    }

    @Override
    public IPropertyGroupOperation getOperation() {
        return (IPropertyGroupOperation)PhysicalQuantityManager.createMultiphysicsInstance(this);
    }

    @Override
    public Model getModel() {
        if (this.getContainer() == null) {
            throw new RuntimeException("Found_an_entity_that_doesn't_belong_to_a_model");
        }
        return this.getContainer().getModel();
    }

    @Override
    public boolean isInModel() {
        return this.getContainer() != null && this.getContainer().isInModel();
    }

    @Override
    public IUnitConverter getConverter() {
        return super.getConverter();
    }

    @Override
    public void addFlag(ModelEntity.Flags flags) {
        this.entityFlags.add(flags);
    }

    @Override
    public void removeFlag(ModelEntity.Flags flags) {
        this.entityFlags.remove((Object)flags);
    }

    @Override
    public boolean hasFlag(ModelEntity.Flags flags) {
        return this.entityFlags.contains((Object)flags);
    }

    @Override
    public String[] param() {
        return this.propSet.getAllProperties();
    }

    @Override
    public boolean hasParam(String string) {
        return this.propSet.hasProp(string);
    }

    @Override
    public SimpleMaterialModel set(String string, String string2) {
        ParamSpec paramSpec = this.getSpec(string);
        String[][] stringArray = paramSpec.expand(new String[][]{{string2}}, true);
        this.propSet.set(string, stringArray);
        return this;
    }

    @Override
    public SimpleMaterialModel set(String string, String[] stringArray) {
        ParamSpec paramSpec = this.getSpec(string);
        String[][] stringArray2 = paramSpec.expand(ParamValueUtil.makeLevel2(stringArray), true);
        this.propSet.set(string, stringArray2);
        return this;
    }

    @Override
    public SimpleMaterialModel set(String string, String[][] stringArray) {
        ParamSpec paramSpec = this.getSpec(string);
        String[][] stringArray2 = paramSpec.expand(stringArray, true);
        this.propSet.set(string, stringArray2);
        return this;
    }

    @Override
    public String getString(String string) {
        SimplePropSet.SimpleProp simpleProp = this.propSet.a(string);
        return simpleProp.getStringMatrix()[0][0];
    }

    @Override
    public String[] getStringArray(String string) {
        SimplePropSet.SimpleProp simpleProp = this.propSet.a(string);
        String[][] stringArray = simpleProp.getStringMatrix();
        ParamSpec paramSpec = this.getSpec(string);
        String[][] stringArray2 = paramSpec.shrink(stringArray, null);
        String[] stringArray3 = new String[stringArray2.length];
        int n2 = 0;
        while (n2 < stringArray3.length) {
            if (stringArray2[n2].length == 0) {
                throw new FlException("Not_a_vector");
            }
            stringArray3[n2] = stringArray2[n2][0];
            ++n2;
        }
        return stringArray3;
    }

    @Override
    public String[][] getStringMatrix(String string) {
        SimplePropSet.SimpleProp simpleProp = this.propSet.a(string);
        String[][] stringArray = simpleProp.getStringMatrix();
        ParamSpec paramSpec = this.getSpec(string);
        return paramSpec.shrink(stringArray, null);
    }

    @Override
    public InformationList<? extends Information> info() {
        if (this.info == null) {
            this.info = new SimpleInformationList("info");
            this.info.c(this);
        }
        return this.info;
    }

    @Override
    public Information info(String string) {
        return (Information)this.info().get(string);
    }

    @Override
    public List<String> getInput() {
        if (this.inputs == null) {
            this.inputs = new CsUniqueList();
        }
        return this.inputs;
    }

    @Override
    public MaterialModel addInput(String string) {
        PhysicalQuantityManager.getID(string);
        this.getInput().add(string);
        return this;
    }

    @Override
    public String[] input() {
        return this.getInput().toArray(new String[0]);
    }

    @Override
    public void setIdentifier(String string) {
        this.identifier = string;
    }

    @Override
    public MaterialModel identifier(String string) {
        this.setIdentifier(string);
        return this;
    }

    @Override
    public String identifier() {
        return this.identifier;
    }

    @Override
    public String getIdentifier() {
        return this.identifier();
    }

    private Map<String, ParamSpec> a() {
        if (this.outputSpecs == null) {
            this.outputSpecs = new LinkedHashMap<String, ParamSpec>();
        }
        return this.outputSpecs;
    }

    @Override
    public MaterialModel setOutput(String string, ParamSpec paramSpec) {
        if (paramSpec.getCheck(this) == ParamSpec.emptyExpressionCheck) {
            paramSpec.setCheck(null);
        }
        this.a().put(string, paramSpec);
        this.set(string, "");
        return this;
    }

    @Override
    public boolean isOutput(String string) {
        return PhysicalQuantityManager.isID(string) || this.a().containsKey(string);
    }

    @Override
    public boolean isLocalParameter(String string) {
        return !this.isOutput(string) && !string.endsWith(MaterialDB.MatRes._symmetry.name());
    }

    @Override
    public String[] output() {
        return this.a().keySet().toArray(new String[0]);
    }

    @Override
    public ParamSpec getSpec(String string) {
        ParamSpec paramSpec = this.a().get(string);
        if (paramSpec != null) {
            return paramSpec;
        }
        if (PhysicalQuantityManager.isID(string)) {
            IPhysicalQuantity iPhysicalQuantity = PhysicalQuantityManager.getID(string);
            paramSpec = ParamSpec.fromMaterialProperty(iPhysicalQuantity);
            if (iPhysicalQuantity.hasSameID(PhysicalQuantityID.PRESSURE)) {
                paramSpec.setDescr("Absolute_pressure");
            }
        } else {
            String string2 = this.localDescr == null || !this.localDescr.containsKey(string) ? "#" + string : this.localDescr.get(string);
            paramSpec = new ScalarSpec(string2);
        }
        if (paramSpec.getCheck(this) == ParamSpec.emptyExpressionCheck) {
            paramSpec.setCheck(null);
        }
        return paramSpec;
    }

    private Map<String, MaterialPropSychronizationRule> b() {
        if (this.synchRules == null) {
            this.synchRules = new HashMap<String, MaterialPropSychronizationRule>();
        }
        return this.synchRules;
    }

    @Override
    public void setSynchronizationRule(String string, String[] stringArray, Map<String, String> map, Map<String, PropAnnotationInfo.EditFieldInfo.MatrixSymmetry> map2) {
        this.b().put(string, new MaterialPropSychronizationRule(stringArray, map, map2));
    }

    @Override
    public MaterialPropSychronizationRule getSynchronizationRule(String string, String string2) {
        if (this.b().containsKey(string)) {
            return this.b().get(string);
        }
        return null;
    }

    @Override
    public Map<String, MaterialPropSychronizationRule> getAllSynchronizationRules() {
        return this.b();
    }

    @Override
    public Map<String, String> getAllIdentityRules() {
        return this.d();
    }

    private Map<String, String> d() {
        if (this.identityRules == null) {
            this.identityRules = new LinkedHashMap<String, String>();
        }
        return this.identityRules;
    }

    @Override
    public void setIdentityRule(StringStringPair[] stringStringPairArray, String string) {
        StringStringPair[] stringStringPairArray2 = stringStringPairArray;
        int n2 = stringStringPairArray.length;
        int n3 = 0;
        while (n3 < n2) {
            StringStringPair stringStringPair = stringStringPairArray2[n3];
            this.d().putIfAbsent(String.valueOf(stringStringPair.first) + ":" + stringStringPair.second, string);
            ++n3;
        }
    }

    @Override
    public String getIdentityRule(String string, String string2) {
        if (this.d().containsKey(String.valueOf(string) + ":" + string2)) {
            return this.identityRules.get(String.valueOf(string) + ":" + string2);
        }
        return null;
    }

    @Override
    public FunctionFeatureList<? extends FunctionFeature> func() {
        if (this.functions == null) {
            this.functions = new SimpleFunctionFeatureList("func");
            this.functions.c(this);
        }
        return this.functions;
    }

    @Override
    public FunctionFeature func(String string) {
        return this.functions != null ? (FunctionFeature)this.functions.get(string) : null;
    }

    @Override
    public MaterialModel setPropertyInfo(String string, String string2) {
        if (this.propertyInfo == null) {
            this.propertyInfo = new HashMap<String, String>(3);
        }
        this.propertyInfo.put(string, string2);
        return this;
    }

    @Override
    public String getPropertyInfo(String string) {
        return this.propertyInfo != null ? this.propertyInfo.get(string) : null;
    }

    @Override
    public String descr(String string) {
        return FlLocale.getString((String)this.getSpec(string).getDescr());
    }

    @Override
    public MaterialModel descr(String string, String string2) {
        if (!this.isOutput(string)) {
            if (this.localDescr == null) {
                this.localDescr = new HashMap<String, String>(3);
            }
        } else {
            throw new FlException("Cannot_set_the_description_of_property_X#" + string);
        }
        this.localDescr.put(string, string2);
        return this;
    }

    @Override
    public Material getMaterial() {
        PrimitiveModelEntity primitiveModelEntity = this;
        while ((primitiveModelEntity = primitiveModelEntity.getContainer()) != null) {
            if (!(primitiveModelEntity instanceof Material)) continue;
            return (Material)primitiveModelEntity;
        }
        return null;
    }

    @Override
    public MaterialModelMethod method() {
        throw new UnsupportedOperationException();
    }
}

