/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.util.classes.ab;
import com.comsol.util.classes.aw;
import com.comsol.util.classes.bg;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CompilationResult {
    private List<bg<String, byte[]>> a;
    private boolean b;
    private List<CompilationProblem> c = new ArrayList<CompilationProblem>();

    public CompilationResult(List<bg<String, byte[]>> list, List<CompilationProblem> list2) {
        this(list, list2, true);
    }

    public CompilationResult(List<bg<String, byte[]>> list, List<CompilationProblem> list2, boolean bl2) {
        this.a = list;
        this.c = Collections.unmodifiableList(list2);
        if (bl2) {
            for (CompilationProblem compilationProblem : list2) {
                if (compilationProblem.type != ProblemType.ERROR) continue;
                bl2 = false;
                break;
            }
        }
        this.b = bl2;
    }

    public void setClassBytes(List<bg<String, byte[]>> list) {
        this.a = list;
    }

    public List<bg<String, byte[]>> getClassNameByteCodePairs() {
        return this.a;
    }

    public boolean succeeded() {
        return this.b;
    }

    public List<CompilationProblem> getCompilationProblems() {
        return this.c;
    }

    public void shiftProblemPositions(ab ab2) {
        for (CompilationProblem compilationProblem : this.c) {
            int n2 = compilationProblem.range.a;
            int n3 = compilationProblem.range.b - n2;
            if (n2 < 0) continue;
            aw aw2 = ab2.a(n2, n3);
            compilationProblem.range = new aw(aw2.a, aw2.a + aw2.b);
        }
    }

    public String[][] getProblemsArray() {
        ArrayList<String[]> arrayList = new ArrayList<String[]>();
        for (CompilationProblem compilationProblem : this.c) {
            arrayList.add(compilationProblem.getValue());
        }
        return (String[][])arrayList.toArray((T[])new String[arrayList.size()][]);
    }

    public boolean hasHiddenProblems() {
        for (CompilationProblem compilationProblem : this.getCompilationProblems()) {
            if (!compilationProblem.isHiddenProblem()) continue;
            return true;
        }
        return false;
    }

    public static class CompilationProblem {
        public final ProblemType type;
        public final int line;
        public aw range;
        public final String message;
        public final Boolean hidden;

        public CompilationProblem(int n2, int n3, int n4, ProblemType problemType, String string) {
            this(n2, n3, n4, problemType, string, null);
        }

        public CompilationProblem(int n2, int n3, int n4, ProblemType problemType, String string, Boolean bl2) {
            this.line = n2;
            this.range = new aw(n3, n4);
            this.type = problemType;
            this.message = string;
            this.hidden = bl2;
        }

        public String[] getValue() {
            return new String[]{Integer.toString(this.line), Integer.toString(this.range.a), Integer.toString(this.range.b), this.type.name(), this.message};
        }

        public static CompilationProblem fromValue(String[] stringArray) {
            int n2 = Integer.parseInt(stringArray[0]);
            int n3 = Integer.parseInt(stringArray[1]);
            int n4 = Integer.parseInt(stringArray[2]);
            ProblemType problemType = ProblemType.valueOf(stringArray[3]);
            return new CompilationProblem(n2, n3, n4, problemType, stringArray[4]);
        }

        public boolean isHiddenProblem() {
            if (this.hidden != null) {
                return this.hidden;
            }
            return this.range.a == this.range.b;
        }
    }

    public static enum ProblemType {
        ERROR,
        WARNING;

    }
}

