/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.util.methods.l;
import com.comsol.util.methods.q;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;

public class DomainInfo {
    public int geom;
    public int edim;
    public int[] domains;
    public boolean meshint;

    public static DomainInfo[] diff(DomainInfo[] domainInfoArray, DomainInfo[] domainInfoArray2) {
        if (domainInfoArray == null || domainInfoArray.length == 0) {
            return domainInfoArray;
        }
        if (domainInfoArray2 == null || domainInfoArray2.length == 0) {
            return domainInfoArray;
        }
        ArrayList<DomainInfo> arrayList = new ArrayList<DomainInfo>(domainInfoArray.length);
        int n2 = 0;
        while (n2 < domainInfoArray.length) {
            DomainInfo domainInfo = new DomainInfo();
            domainInfo.geom = domainInfoArray[n2].geom;
            domainInfo.edim = domainInfoArray[n2].edim;
            domainInfo.domains = domainInfoArray[n2].domains;
            domainInfo.meshint = domainInfoArray[n2].meshint;
            domainInfo.diff(domainInfoArray2);
            if (domainInfo.domains.length > 0) {
                arrayList.add(domainInfo);
            }
            ++n2;
        }
        return arrayList.toArray(new DomainInfo[arrayList.size()]);
    }

    public DomainInfo diff(DomainInfo[] domainInfoArray) {
        if (domainInfoArray == null || domainInfoArray.length == 0) {
            return this;
        }
        int n2 = 0;
        while (n2 < domainInfoArray.length) {
            if (this.geom == domainInfoArray[n2].geom && this.edim == domainInfoArray[n2].edim) {
                this.domains = q.b((int[])this.domains, (int[])domainInfoArray[n2].domains);
                if (this.domains.length == 0) break;
            }
            ++n2;
        }
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Geom ").append(this.geom).append("; ");
        l.a a2 = new l.a(){

            public boolean a() {
                return DomainInfo.this.meshint;
            }

            public int b() {
                return 3;
            }

            public int c() {
                return DomainInfo.this.domains.length;
            }

            public int[] a(int n2) {
                return DomainInfo.this.domains;
            }

            public int d() {
                return DomainInfo.this.edim;
            }
        };
        l.a((StringBuilder)stringBuilder, (l.a)a2);
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object instanceof DomainInfo) {
            DomainInfo domainInfo = (DomainInfo)object;
            if (this.geom != domainInfo.geom || this.edim != domainInfo.edim || this.meshint != domainInfo.meshint) {
                return false;
            }
            return Arrays.equals(this.domains, domainInfo.domains);
        }
        return super.equals(object);
    }

    public SimpleSelection toSimpleSelection(Model model) {
        return model.geom().stream().filter(geomSequence -> geomSequence.getXmeshIndex() == this.geom).findFirst().map(geomSequence -> new SimpleSelection((IGeomSequence)geomSequence, this.edim).set(this.domains)).orElse(null);
    }

    public static boolean dimLargerOrEqual(DomainInfo[] domainInfoArray, DomainInfo[] domainInfoArray2) {
        DomainInfo domainInfo;
        if (domainInfoArray2.length == 0 || domainInfoArray.length == 0) {
            return false;
        }
        HashMap<Integer, Integer> hashMap = new HashMap<Integer, Integer>();
        DomainInfo[] domainInfoArray3 = domainInfoArray2;
        int n2 = domainInfoArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            domainInfo = domainInfoArray3[n3];
            int n4 = hashMap.getOrDefault(domainInfo.geom, domainInfo.edim);
            if (domainInfo.edim >= n4) {
                hashMap.put(domainInfo.geom, domainInfo.edim);
            }
            ++n3;
        }
        domainInfoArray3 = domainInfoArray;
        n2 = domainInfoArray.length;
        n3 = 0;
        while (n3 < n2) {
            domainInfo = domainInfoArray3[n3];
            if (domainInfo.edim >= hashMap.getOrDefault(domainInfo.geom, Integer.MAX_VALUE)) {
                return true;
            }
            ++n3;
        }
        return false;
    }
}

