/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.data.Primitives;
import com.comsol.model.data.RuntimeInfo;
import com.comsol.model.database.DatabaseModelDescriptor;
import com.comsol.model.database.DatabaseMphProviderFactory;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.FileResource;
import com.comsol.model.dbimodel.GEOMSEQUENCE_TYPES;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomNative;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.GeomSubsequence;
import com.comsol.model.dbimodel.GeomSubsequenceCallFeature;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.SavePoint;
import com.comsol.model.dbimodel.SolutionNative;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.WorkPlaneFeature;
import com.comsol.model.dbimodel.XMeshNative;
import com.comsol.model.dbmodel.ModelDb;
import com.comsol.model.method.internal.IModelInternal;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.operations.MissingGeometryBuildData;
import com.comsol.model.operations.operationID.AppOperationID;
import com.comsol.model.plugin.internal.CsPlugin;
import com.comsol.model.savepoint.SpModel;
import com.comsol.model.savepoint.interfaces.IFileResource;
import com.comsol.model.savepoint.interfaces.IGeomSequence;
import com.comsol.model.savepoint.interfaces.IModel;
import com.comsol.model.savepoint.interfaces.IModelEntityList;
import com.comsol.model.simple.SimpleUtil;
import com.comsol.model.util.ApplicationUtil;
import com.comsol.model.util.ExecutableUtil;
import com.comsol.model.util.GeomSequenceUtil;
import com.comsol.model.util.IModelManager;
import com.comsol.model.util.IRecoverySavePointHolder;
import com.comsol.model.util.LibraryNodeType;
import com.comsol.model.util.ModelInternalUtil;
import com.comsol.model.util.ModelManager;
import com.comsol.model.util.ModelObjectNativeAccessor;
import com.comsol.model.util.ModelType;
import com.comsol.model.util.ReInitInfo;
import com.comsol.nativejni.FlNativeException;
import com.comsol.nativejni.NativeModelEntityProvider;
import com.comsol.nativemph.binary.BinaryManager;
import com.comsol.nativemph.binary.BinaryType;
import com.comsol.nativemph.geom.Geom;
import com.comsol.nativemph.geom.Geom3;
import com.comsol.nativemph.util.b;
import com.comsol.nativemph.xmesh.Xmesh;
import com.comsol.nativeutil.d;
import com.comsol.nativeutil.d.b;
import com.comsol.nativeutil.w;
import com.comsol.systemutils.SystemUtil;
import com.comsol.systemutils.f;
import com.comsol.util.classes.CsAbstractPlugin;
import com.comsol.util.classes.CsXMLWriter;
import com.comsol.util.classes.FileManagerUtil;
import com.comsol.util.classes.FlVersion;
import com.comsol.util.classes.StringStringPair;
import com.comsol.util.classes.af;
import com.comsol.util.classes.bg;
import com.comsol.util.classes.by;
import com.comsol.util.exceptions.CadKernelException;
import com.comsol.util.exceptions.FailedMphAccessException;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.LicenseException;
import com.comsol.util.interfaces.c;
import com.comsol.util.interfaces.m;
import com.comsol.util.methods.FlFileUtil;
import com.comsol.util.methods.FlLocale;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.ae;
import com.comsol.util.methods.p;
import de.schlichtherle.util.zip.ZipEntry;
import de.schlichtherle.util.zip.ZipFile;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigInteger;
import java.nio.channels.FileChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystems;
import java.nio.file.StandardOpenOption;
import java.security.AccessControlException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class ModelLoadUtil {
    private static /* synthetic */ int[] a;

    public static void loadSavePointModels(File file, String string, Model model, ISpModelStore iSpModelStore) throws IOException {
        try (com.comsol.util.file.b b2 = null;){
            b2 = new com.comsol.util.file.b(file);
            ModelLoadUtil.loadSavePointModels((ZipFile)b2, string, model, iSpModelStore, true);
        }
    }

    public static void loadSavePointModels(ZipFile zipFile, String string, Model model, ISpModelStore iSpModelStore, boolean bl2) throws IOException {
        Enumeration enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            Object object;
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            String string2 = zipEntry.getName();
            if (string2.endsWith("/savepoint.xml")) {
                object = new SpModel(new InputStreamReader(zipFile.getInputStream(zipEntry)), model);
                iSpModelStore.storeSpModel((IModel)object);
            }
            if (!bl2) continue;
            if (string2.endsWith("/model.xml") || string2.endsWith("/model.zip")) {
                p.a((ZipFile)zipFile, (ZipEntry)zipEntry, (String)string);
            }
            ModelType[] modelTypeArray = ModelType.values();
            int n2 = modelTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = modelTypeArray[n3];
                if (string2.endsWith("/" + ((ModelType)((Object)object)).getKeyFileName())) {
                    p.a((ZipFile)zipFile, (ZipEntry)zipEntry, (String)string);
                }
                ++n3;
            }
        }
    }

    public static void setUpSavePointModelCrossRefsAfterLoad(Map<String, IModel> map) {
        for (IModel iModel : map.values()) {
            ((SpModel)iModel).fromXMLModelCrossRefs(map);
        }
    }

    public static void loadFileResources(IModel iModel, File file, String string, Map<String, String> map, Map<String, String> map2, Set<String> set) throws IOException {
        try (com.comsol.util.file.b b2 = new com.comsol.util.file.b(file);){
            List<a> list = ModelLoadUtil.a(iModel, (ZipFile)b2, map);
            ArrayList<IFileResource> arrayList = new ArrayList<IFileResource>();
            ArrayList<IFileResource> arrayList2 = new ArrayList<IFileResource>();
            for (a a2 : list) {
                if (!a2.a.isCopyToClient()) {
                    a2.f = a2.d ? SystemUtil.createNamedTempFileForModel((String)string, (String)a2.c) : SystemUtil.createTempFileForModel((String)string, (String)a2.c);
                } else {
                    a2.f = SystemUtil.createTempFileForModel((String)string, (String)a2.c);
                    if (!a2.a.isExternal()) {
                        arrayList2.add(a2.a);
                    } else {
                        arrayList.add(a2.a);
                    }
                }
                a2.e = a2.f.getAbsolutePath();
            }
            for (a a2 : list) {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(b2.getInputStream(a2.b));
                FlFileUtil.a((InputStream)bufferedInputStream, (File)a2.f);
                a2.a.resource(a2.e, a2.a.isExternal());
                if (a2.a.isExternal()) continue;
                set.add(a2.e);
            }
            for (a a2 : list) {
                a2.a.setXmeshResource(a2.a.resource());
                map2.put(a2.a.archive(), a2.a.resource());
            }
            ModelLoadUtil.copyResourcesToClient(iModel, string, false, true, arrayList.toArray(new IFileResource[arrayList.size()]));
            ModelLoadUtil.copyResourcesToClient(iModel, string, false, false, arrayList2.toArray(new IFileResource[arrayList2.size()]));
        }
    }

    private static List<a> a(IModel iModel, ZipFile zipFile, Map<String, String> map) {
        ArrayList<a> arrayList = new ArrayList<a>();
        Enumeration enumeration = zipFile.entries();
        while (enumeration.hasMoreElements()) {
            ZipEntry zipEntry = (ZipEntry)enumeration.nextElement();
            String string = zipEntry.getName();
            String string2 = map.get(string);
            if (string2 == null) continue;
            IFileResource iFileResource = iModel.file(string2);
            String string3 = FlFileUtil.e((String)string);
            String string4 = null;
            if (iFileResource.getOriginalPath() != null) {
                string4 = new File(iFileResource.getOriginalPath()).getName();
            }
            if (string4 != null && !string4.isEmpty() && !iFileResource.isExternal()) {
                arrayList.add(new a(iFileResource, zipEntry, string4, true));
                continue;
            }
            arrayList.add(new a(iFileResource, zipEntry, string3, false));
        }
        return arrayList;
    }

    public static Xmesh loadXmeshFromFile(IModel iModel, XMeshNative xMeshNative, File file, boolean bl2, Xmesh.XMESH_DISTR_TYPE xMESH_DISTR_TYPE) throws IOException {
        FlException[] flExceptionArray;
        com.comsol.nativemph.util.b b2 = new com.comsol.nativemph.util.b(file.getAbsolutePath());
        b2.a();
        d[] dArray = b2.c();
        if (dArray.length == 0 || !(dArray[0] instanceof Xmesh)) {
            throw new FlException("Failed_to_restore_xmesh_from_file");
        }
        ArrayList<Xmesh> arrayList = new ArrayList<Xmesh>();
        arrayList.add((Xmesh)dArray[0]);
        String string = "";
        if (iModel.getCurrentModel() != null) {
            string = iModel.getCurrentModel().getSaveLocation().b();
        }
        ModelObjectNativeAccessor modelObjectNativeAccessor = null;
        if (bl2) {
            modelObjectNativeAccessor = new ModelObjectNativeAccessor(iModel);
        }
        if ((flExceptionArray = ModelLoadUtil.restoreXmeshes(iModel, arrayList, string, modelObjectNativeAccessor, xMESH_DISTR_TYPE))[0] != null) {
            throw flExceptionArray[0];
        }
        return (Xmesh)arrayList.get(0);
    }

    public static FlException[] restoreXmeshes(IModel iModel, Collection<Xmesh> collection, Map<String, String> map, String string, boolean bl2, Xmesh.XMESH_DISTR_TYPE xMESH_DISTR_TYPE) throws IOException {
        ModelObjectNativeAccessor modelObjectNativeAccessor = null;
        if (bl2) {
            modelObjectNativeAccessor = new ModelObjectNativeAccessor(iModel);
        }
        return ModelLoadUtil.restoreXmeshes(iModel, collection, map, string, modelObjectNativeAccessor, xMESH_DISTR_TYPE);
    }

    public static FlException[] restoreXmeshes(IModel iModel, Collection<Xmesh> collection, String string, NativeModelEntityProvider.IModelObjectNativeAccessor iModelObjectNativeAccessor, Xmesh.XMESH_DISTR_TYPE xMESH_DISTR_TYPE) throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        for (IFileResource iFileResource : iModel.file()) {
            hashMap.put(iFileResource.tag(), iFileResource.getXmeshResource());
        }
        return ModelLoadUtil.restoreXmeshes(iModel, collection, hashMap, string, iModelObjectNativeAccessor, xMESH_DISTR_TYPE);
    }

    public static FlException[] restoreXmeshes(IModel iModel, Collection<Xmesh> collection, Map<String, String> map, String string, NativeModelEntityProvider.IModelObjectNativeAccessor iModelObjectNativeAccessor, Xmesh.XMESH_DISTR_TYPE xMESH_DISTR_TYPE) throws IOException {
        NativeModelEntityProvider nativeModelEntityProvider = null;
        if (iModelObjectNativeAccessor != null) {
            nativeModelEntityProvider = new NativeModelEntityProvider(iModelObjectNativeAccessor);
        }
        FlException[] flExceptionArray = new FlException[collection.size()];
        int n2 = 0;
        for (Xmesh xmesh : collection) {
            if (xmesh != null) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    xmesh.a(entry.getKey(), entry.getValue());
                }
                if (SystemUtil.isDevelop() && System.getProperty("cs.xmeshdebug") != null) {
                    xmesh.a("dev:xmeshdebug", System.getProperty("cs.xmeshdebug"));
                }
                try {
                    if (iModel != null && iModel.getCurrentModel() != null) {
                        Model model = iModel.getCurrentModel();
                        xmesh.a(model.tag());
                        if (model instanceof ModelDb) {
                            ((ModelDb)model).registerXMeshId(xmesh.b());
                        }
                    }
                    ModelInternalUtil.setXmeshFilePath(xmesh, string, iModel);
                    w w2 = ModelLoadUtil.a(xMESH_DISTR_TYPE);
                    xmesh.a(nativeModelEntityProvider, w2);
                }
                catch (FlNativeException flNativeException) {
                    flExceptionArray[n2] = flNativeException;
                }
            }
            ++n2;
        }
        return flExceptionArray;
    }

    private static w a(Xmesh.XMESH_DISTR_TYPE xMESH_DISTR_TYPE) {
        w w2 = new w();
        switch (ModelLoadUtil.a()[xMESH_DISTR_TYPE.ordinal()]) {
            case 2: {
                w2.a("distrxmesh", "on");
                break;
            }
            case 1: {
                w2.a("distrxmesh", "off");
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new RuntimeException("Internal xmesh error.");
            }
        }
        String string = System.getProperty("cs.clusterdistrpost");
        if (string != null) {
            if (string.equals("on")) {
                w2.a("distrpost", "on");
            } else if (string.equals("off")) {
                w2.a("distrpost", "off");
            }
        }
        return w2;
    }

    public static IModel deserializeSavePointModel(String string, String string2, Model model) {
        SpModel spModel = new SpModel(new StringReader(string), model);
        spModel.spSetTag(string2);
        model.storeSavePointModel(spModel);
        spModel.fromXMLModelCrossRefs(((ModelManager)ModelInternalUtil.getModelManager()).getSavePointModels((IRecoverySavePointHolder)((Object)model)));
        return spModel;
    }

    public static ModelType getModelType(com.comsol.util.interfaces.d d2) {
        String string;
        if (d2 == null) {
            return null;
        }
        com.comsol.util.interfaces.b[] bArray = d2.d();
        if (bArray.length > 0 && (string = bArray[0].b("modelType")) != null) {
            ModelType[] modelTypeArray = ModelType.values();
            int n2 = modelTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                ModelType modelType = modelTypeArray[n3];
                if (modelType.name().equalsIgnoreCase(string)) {
                    return modelType;
                }
                ++n3;
            }
        }
        return null;
    }

    public static boolean isPlaceholderMph(com.comsol.util.interfaces.d d2) {
        com.comsol.util.interfaces.b[] bArray = d2.d();
        return bArray.length > 0 && "placeholder".equals(bArray[0].b("nodeType"));
    }

    public static void disposeUnusedSavePointModels(Model model) {
        HashSet<String> hashSet = new HashSet<String>();
        for (SavePoint savePoint : ModelInternalUtil.getSavePoints(model)) {
            hashSet.add(savePoint.getTag());
        }
        for (IModel iModel : model.getSavePointModels()) {
            if (hashSet.contains(iModel.tag())) continue;
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Disposing obsolete save point model, " + iModel.tag() + ".");
            model.method().preSavePointDispose(iModel.tag(), false, null);
            model.disposeSavePointModel(iModel.tag(), false);
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : model.getSavePointTags()) {
            if (model.getSavePointModel(string) != null) continue;
            arrayList.add(string);
        }
        model.getSavePointTags().removeAll(arrayList);
    }

    public static void disposeSolverSequenceListData(Model model) {
        HashMap<SolutionNative, Integer> hashMap = new HashMap<SolutionNative, Integer>();
        for (SolverSequence solverSequence : model.sol()) {
            SolutionNative solutionNative = solverSequence.getSolutionnative();
            if (hashMap.containsKey(solutionNative)) {
                hashMap.put(solutionNative, (Integer)hashMap.get(solutionNative) + 1);
                continue;
            }
            hashMap.put(solutionNative, 1);
        }
        ArrayList<SolutionNative> arrayList = new ArrayList<SolutionNative>();
        for (SolutionNative solutionNative : model.sol().getSolutions()) {
            if (solutionNative.getNode().isTransient()) continue;
            if (!hashMap.containsKey(solutionNative)) {
                arrayList.add(solutionNative);
                continue;
            }
            if (solutionNative.getCounter() == ((Integer)hashMap.get(solutionNative)).intValue()) continue;
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Wrong count in SolutionNative, " + solutionNative.getTag() + " with counter " + solutionNative.getCounter() + ". Should be " + hashMap.get(solutionNative) + ".");
            solutionNative.setCounter((Integer)hashMap.get(solutionNative));
        }
        for (SolutionNative solutionNative : arrayList) {
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Removing obsolete SolutionNative, " + solutionNative.getTag() + " with counter " + solutionNative.getCounter() + " .");
            solutionNative.setCounter(0);
            model.sol().getSolutions().remove(solutionNative);
        }
        HashMap hashMap2 = new HashMap();
        for (SolverSequence solverSequence : model.sol()) {
            SavePoint savePoint = solverSequence.getSavePoint();
            if (hashMap2.containsKey(savePoint)) {
                hashMap2.put(savePoint, (Integer)hashMap2.get(savePoint) + 1);
                continue;
            }
            hashMap2.put(savePoint, 1);
        }
        ArrayList<SavePoint> arrayList2 = new ArrayList<SavePoint>();
        for (SavePoint savePoint : model.sol().getSavePoints()) {
            if (!hashMap2.containsKey(savePoint)) {
                arrayList2.add(savePoint);
                continue;
            }
            if (savePoint.getCounter() == ((Integer)hashMap2.get(savePoint)).intValue()) continue;
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Wrong count in SavePoint, " + savePoint.getTag() + " with counter " + savePoint.getCounter() + ". Should be " + hashMap2.get(savePoint) + ".");
            savePoint.setCounter((Integer)hashMap2.get(savePoint));
        }
        for (SavePoint savePoint : arrayList2) {
            CsPlugin.log(CsAbstractPlugin.LogLevel.DEBUG, "Removing obsolete SavePoint, " + savePoint.getTag() + ".");
            savePoint.setCounter(1);
            model.sol().getSavePoints().remove(savePoint);
        }
        model.reduced().updateSolverSequences(false, "", "");
    }

    public static void preSaveFileResources(Model model, boolean bl2) {
        ModelInternalUtil.removeUnusedFileResources(model);
    }

    public static List<bg<String, File>> getCadIdsFiles(Model model) {
        ArrayList<bg<String, File>> arrayList = new ArrayList<bg<String, File>>();
        for (GeomSequence geomSequence : model.geom()) {
            for (PropFeature propFeature : geomSequence.feature()) {
                IGeomOperation iGeomOperation = (IGeomOperation)propFeature.getOperation();
                String[] stringArray = iGeomOperation.getCadIdsFileInfo();
                if (stringArray == null) continue;
                String string = stringArray[0];
                String string2 = stringArray[1];
                String string3 = stringArray[2];
                File file = string3.equals("on") ? new File(string2) : ModelInternalUtil.getExistingFile(string2, null);
                if (file == null || !file.exists()) continue;
                arrayList.add((bg<String, File>)bg.a((Object)string, (Object)file));
            }
        }
        return arrayList;
    }

    public static void saveModelAndPartImages(Model model, SaveEntry saveEntry) throws IOException {
        String string;
        File object2;
        ModelLoadUtil.saveStandardModelImage(model, saveEntry);
        if (model.getModelThumbNailPathServer(true) != null && (object2 = new File(string = model.getModelThumbNailPathServer(true))).exists()) {
            saveEntry.save("", "modelimage_large.png", object2, false);
        }
        int n2 = 1;
        for (GeomSequence geomSequence : model.geom()) {
            File file;
            GeomSubsequence geomSubsequence;
            String string2;
            if (!geomSequence.isSubsequence() || (string2 = (geomSubsequence = (GeomSubsequence)geomSequence).getImageFileServer()).isEmpty() || !(file = new File(string2)).exists()) continue;
            String string3 = "partimage" + n2 + ".png";
            saveEntry.save("", string3, file, false);
            geomSubsequence.setImageName(string3);
            ++n2;
        }
    }

    public static void saveStandardModelImage(Model model, SaveEntry saveEntry) throws IOException {
        String string;
        File file;
        if (model.getModelThumbNailPathServer(false) != null && (file = new File(string = model.getModelThumbNailPathServer(false))).exists()) {
            saveEntry.save("", FileManagerUtil.ModelImageType.c.a(), file, false);
        }
    }

    public static void writeModelInfo(BufferedWriter bufferedWriter, Model model, LibraryNodeType libraryNodeType) {
        String string;
        com.comsol.util.interfaces.d d2;
        GeomSubsequence geomSubsequence;
        long l2;
        long l3;
        Object object;
        CsXMLWriter csXMLWriter = new CsXMLWriter(bufferedWriter);
        csXMLWriter.startDocument();
        com.comsol.util.interfaces.d d3 = new com.comsol.util.interfaces.d("xml_root", null);
        com.comsol.util.interfaces.d d4 = new com.comsol.util.interfaces.d("modelInfo", (com.comsol.util.interfaces.b)d3);
        d4.a("comsolVersion", FlVersion.currentVersion().getFullName().replace("COMSOL ", ""));
        d4.a("entityComments", model.getEntityComments());
        ModelLoadUtil.setLoadedTitleFromModelComments((IModelInternal)model, model.getEntityComments());
        String string2 = model.getModelType().name();
        d4.a("modelType", string2);
        d4.a("nodeType", libraryNodeType.id());
        d4.a("isRunnable", String.valueOf(ApplicationUtil.hasRunnableApplication(model)));
        boolean bl2 = libraryNodeType.isPreview();
        if (!bl2) {
            d4.a("pdfResources", ModelLoadUtil.getPdfResources(model));
        }
        d4.a("passwordProtection", model.isPasswordProtected() ? "on" : "off");
        d4.a("startMode", model.getStartMode());
        d4.a("ignoreLicenseErrors", model.isIgnoreLicenseErrors() ? "on" : "off");
        String[] stringArray = FileManagerUtil.d((String)model.comments());
        d4.a("title", stringArray[0] != null ? stringArray[0] : "");
        d4.a("description", stringArray[1]);
        if (model.getModelType() == ModelType.MODEL || model.getModelType() == ModelType.APPLICATION_MODEL) {
            object = model;
            d4.a("runtimeProtection", object.isRuntimePasswordProtected() ? "on" : "off");
            d4.a("windowTitle", ApplicationUtil.getMainWindowTitle((Model)object));
        }
        if (!"en_US".equals(object = FlLocale.getLocaleName())) {
            d4.a("locale", (String)object);
        }
        d4.a("expectedComputationTime", model.getExpectedComputationTime());
        d4.a("lastComputationTime", model.getLastComputationTime("s"));
        String[] stringArray2 = model.getKeywords();
        if (stringArray2.length > 0) {
            d4.a("keywords", FlStringUtil.delimitedString((String[])stringArray2, (String)","));
        }
        if ((l3 = model.getSolvedFileSize()) > -1L) {
            d4.a("solvedFileSize", String.valueOf(l3));
        }
        if ((l2 = model.getCompactFileSize()) > -1L) {
            d4.a("compactFileSize", String.valueOf(l2));
        }
        d4.a("mainPartSDim", (geomSubsequence = model.geom().getMainSubsequence()) != null ? String.valueOf(geomSubsequence.getSDim()) : "None");
        com.comsol.util.interfaces.d d5 = new com.comsol.util.interfaces.d("historyInfo", (com.comsol.util.interfaces.b)d4);
        String[] stringArray3 = ModelInternalUtil.getModelHistoryInfo(model);
        int n2 = 0;
        while (n2 < stringArray3.length) {
            d5.a(stringArray3[n2], stringArray3[n2 + 1]);
            n2 += 2;
        }
        com.comsol.util.interfaces.d d6 = new com.comsol.util.interfaces.d("licenseInfo", (com.comsol.util.interfaces.b)d4);
        d6.a("products", ModelInternalUtil.getRequiredLicences(model));
        com.comsol.util.interfaces.d d7 = new com.comsol.util.interfaces.d("physicsInfo", (com.comsol.util.interfaces.b)d4);
        d7.a("physics", ModelInternalUtil.getPhysics(model));
        com.comsol.util.interfaces.d d8 = new com.comsol.util.interfaces.d("geometryInfo", (com.comsol.util.interfaces.b)d4);
        for (GeomSequence geomSequence : model.geom()) {
            try {
                String string3;
                d2 = new com.comsol.util.interfaces.d("geom", (com.comsol.util.interfaces.b)d8);
                d2.a("tag", geomSequence.tag());
                d2.a("dimension", String.valueOf(geomSequence.getSDim()));
                string = GeomSequenceUtil.getType(geomSequence);
                if (!GEOMSEQUENCE_TYPES.STANDARD.getDisplayName().equals(string)) {
                    d2.a("type", string);
                }
                if ((string3 = GeomSequenceUtil.getLiveLinkNodeType(geomSequence)) != null) {
                    d2.a("hasLiveLink", string3);
                }
                if (GeomSequenceUtil.containsProgrammingNodes(geomSequence)) {
                    d2.a("hasProgramming", "true");
                }
                if (GeomSequenceUtil.containsVirtual(geomSequence)) {
                    d2.a("hasVirtual", "true");
                }
                if (GeomSequenceUtil.containsMeshControl(geomSequence)) {
                    d2.a("hasMeshControl", "true");
                }
                d8.a((com.comsol.util.interfaces.b)d2);
            }
            catch (Throwable throwable) {}
        }
        d3.a((com.comsol.util.interfaces.b)d4);
        d4.a((com.comsol.util.interfaces.b)d5);
        d4.a((com.comsol.util.interfaces.b)d6);
        d4.a((com.comsol.util.interfaces.b)d7);
        d4.a((com.comsol.util.interfaces.b)d8);
        if (!bl2) {
            com.comsol.util.interfaces.d d9 = new com.comsol.util.interfaces.d("batchLicInfo", (com.comsol.util.interfaces.b)d4);
            d9.a("batchLic", ModelInternalUtil.getBatchLicenseKey(model));
            d4.a((com.comsol.util.interfaces.b)d9);
            RuntimeInfo runtimeInfo = model.getRuntimeInfo();
            if (runtimeInfo != null) {
                d2 = new com.comsol.util.interfaces.d("runtimeInfo", (com.comsol.util.interfaces.b)d4);
                ModelLoadUtil.addRuntimeInfoAttributes((com.comsol.util.interfaces.b)d2, runtimeInfo);
                d4.a((com.comsol.util.interfaces.b)d2);
            }
            if ((d2 = ModelLoadUtil.a(model, d4)) != null) {
                d4.a((com.comsol.util.interfaces.b)d2);
            }
            string = new com.comsol.util.interfaces.d("appArgumentInfo", (com.comsol.util.interfaces.b)d4);
            model.appBuilderFeature().stream().filter(propFeature -> AppOperationID.isOfType(propFeature, AppOperationID.APP_ARGUMENT)).forEach(arg_0 -> ModelLoadUtil.a((com.comsol.util.interfaces.d)string, arg_0));
            d4.a((com.comsol.util.interfaces.b)string);
        }
        ae.a((CsXMLWriter)csXMLWriter, (com.comsol.util.interfaces.b)d4, (boolean)false);
        csXMLWriter.endDocument();
    }

    public static void setLoadedTitleFromModelComments(IModelInternal iModelInternal, String string) {
        String string2;
        int n2;
        if (string != null && FileManagerUtil.k((String)(string = string.trim())) && (n2 = (string2 = FlLocale.getString((String)string)).indexOf("\n\n")) > 0 && n2 < 120) {
            if (string2.charAt(n2 - 1) == '.') {
                --n2;
            }
            iModelInternal.setLoadedTitle(string2.substring(0, n2));
        }
        iModelInternal.setLoadedTitle(null);
    }

    public static String getPdfResources(Model model) {
        StringBuilder stringBuilder = new StringBuilder();
        IModelEntityList iModelEntityList = model.file();
        for (FileResource fileResource : iModelEntityList) {
            String string = fileResource.archive();
            if (string == null || !string.toLowerCase(Locale.ENGLISH).endsWith(".pdf")) continue;
            stringBuilder.append(string).append(' ');
        }
        return stringBuilder.toString().trim();
    }

    public static void addRuntimeInfoAttributes(com.comsol.util.interfaces.b b2, RuntimeInfo runtimeInfo) {
        CharSequence[] charSequenceArray = runtimeInfo.getAndResetCompilerLicenses();
        String string = runtimeInfo.getAndResetExpirationDate();
        if (!b.l()) {
            b.e((String[])charSequenceArray);
        }
        b2.a("compiled", "yes");
        b2.a("licenses", String.join((CharSequence)",", charSequenceArray));
        b2.a("expiration", f.b((String)("date:" + string)));
    }

    private static com.comsol.util.interfaces.d a(Model model, com.comsol.util.interfaces.d d2) {
        if (ApplicationUtil.getMainWindow(model) == null) {
            return null;
        }
        PropFeature propFeature2 = model.appBuilderFeature().stream().filter(propFeature -> AppOperationID.isOfType(propFeature, AppOperationID.EXECUTABLE_APPLICATION)).findFirst().orElse(null);
        com.comsol.util.interfaces.d d3 = new com.comsol.util.interfaces.d("compilerData", (com.comsol.util.interfaces.b)d2);
        if (propFeature2 != null) {
            String[] stringArray = new String[]{"outputdir", "platwin", "platlinux", "platosx", "splash_preview", "testdata", "ownrt", "distr", "windata", ApplicationUtil.ResourcePairs.ICONCOMPILERWINDOWS.getProp(), ApplicationUtil.ResourcePairs.ICONCOMPILERLINUX.getProp(), ApplicationUtil.ResourcePairs.ICONCOMPILERMACOS.getProp()};
            String[] stringArray2 = propFeature2.properties();
            int n2 = stringArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                String string = stringArray2[n3];
                if (!FlStringUtil.contains((String[])stringArray, (String)string)) {
                    d3.a(string, propFeature2.getString(string));
                }
                ++n3;
            }
            d3.a("iconwindows", ExecutableUtil.getAppIconPathByFilename(model, propFeature2.getString(ApplicationUtil.ResourcePairs.ICONCOMPILERWINDOWS.getProp()), true));
            d3.a("iconlinux", ExecutableUtil.getAppIconPathByFilename(model, propFeature2.getString(ApplicationUtil.ResourcePairs.ICONCOMPILERLINUX.getProp()), true));
            d3.a("iconmacos", ExecutableUtil.getAppIconPathByFilename(model, propFeature2.getString(ApplicationUtil.ResourcePairs.ICONCOMPILERMACOS.getProp()), true));
            d3.a("icon", ExecutableUtil.getAppIconPath(model, true));
            d3.a("splash", ExecutableUtil.getFileNameAndUpdatesSplash(propFeature2, fileResource -> {}, true));
        }
        d3.a("batchorcluster", ExecutableUtil.validateNoClusterBatch(model, false));
        d3.a("applicationtitle", ModelInternalUtil.getModelTitle(model, model.getSaveLocation().b()));
        return d3;
    }

    public static void copyResourcesToClient(IModel iModel, String string, boolean bl2, boolean bl3, IFileResource ... iFileResourceArray) {
        Object object;
        String[] stringArray;
        if (iFileResourceArray == null || iFileResourceArray.length == 0) {
            return;
        }
        m m2 = af.g();
        ArrayList<by> arrayList = new ArrayList<by>();
        Object object2 = iFileResourceArray;
        int n2 = iFileResourceArray.length;
        int n3 = 0;
        while (n3 < n2) {
            stringArray = object2[n3];
            object = new by((Object)"", (Object)false);
            if (bl3) {
                object.a((Object)FlFileUtil.e((String)stringArray.resource()));
            }
            arrayList.add((by)object);
            ++n3;
        }
        stringArray = string != null ? m2.a(string, arrayList) : m2.a(arrayList);
        ArrayList<by> arrayList2 = new ArrayList<by>();
        n2 = 0;
        while (n2 < stringArray.length) {
            object2 = iFileResourceArray[n2];
            object = stringArray[n2];
            File file = new File(object2.resource());
            arrayList2.add(new by(object, (Object)file));
            object2.setClientPath((String)object);
            ++n2;
        }
        m2.a(arrayList2, iModel.getTag(), bl2, false);
    }

    public static void copyResourcesToClient(IModel iModel) {
        ArrayList<IFileResource> arrayList = new ArrayList<IFileResource>();
        for (IFileResource iFileResource : iModel.file()) {
            if (iFileResource.isExternal() || !iFileResource.isCopyToClient() || iFileResource.resource() == null || !new File(iFileResource.resource()).exists()) continue;
            arrayList.add(iFileResource);
        }
        ModelLoadUtil.copyResourcesToClient(iModel, iModel.getCurrentModel().tag(), false, false, arrayList.toArray(new IFileResource[arrayList.size()]));
    }

    public static void copyResourcesToClient(IModel iModel, boolean bl2, String ... stringArray) {
        IFileResource[] iFileResourceArray = new IFileResource[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            iFileResourceArray[n2] = iModel.file(stringArray[n2]);
            ++n2;
        }
        ModelLoadUtil.copyResourcesToClient(iModel, iModel.getCurrentModel().tag(), false, bl2, iFileResourceArray);
    }

    public static void checkForCad(Model model, b.b b2) {
        boolean bl2 = false;
        for (GeomSequence geomSequence : model.geom()) {
            if (geomSequence.isDefinedByMesh()) continue;
            if (geomSequence.geomRep().equals("cadps")) {
                bl2 = true;
                break;
            }
            for (PropFeature propFeature : geomSequence.feature()) {
                PropValue propValue;
                GeomFeature geomFeature = (GeomFeature)propFeature;
                if (!"Import".equals(geomFeature.getOperationID()) || (propValue = geomFeature.getPropValueInternal("type")) == null || !"cad".equals(propValue.getValue())) continue;
                bl2 = true;
                break;
            }
            if (bl2) break;
        }
        if (bl2) {
            b2.a(true);
            b2.a();
            b2.a(false);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static ArrayList<bg<String, String>> clearSavePointsWithMissingGeometry(Model model, boolean bl2) {
        ArrayList<bg<String, String>> arrayList = new ArrayList<bg<String, String>>();
        for (SolverSequence solverSequence : model.sol()) {
            void var8_10;
            IModel iModel;
            SavePoint savePoint = solverSequence.getSavePoint();
            if (savePoint == null || (iModel = bl2 ? model.getSavePointModel(savePoint.getTag()) : model.getCompleteSavePointModel(savePoint.getTag())) == null) continue;
            boolean bl3 = false;
            for (IGeomSequence iGeomSequence : iModel.geom()) {
                if (iGeomSequence.hasGeom() || iGeomSequence.isDefinedByMesh()) continue;
                bl3 = true;
                break;
            }
            if (!bl3) continue;
            int n2 = savePoint.nXmeshes() - 1;
            while (var8_10 >= 0) {
                savePoint.removeXmeshNative((int)var8_10);
                --var8_10;
            }
            arrayList.add((bg<String, String>)new bg((Object)solverSequence.tag(), (Object)savePoint.getTag()));
        }
        return arrayList;
    }

    public static void fixupCadImportType(Model model, b.b b2) {
        b2.a(true);
        for (GeomSequence geomSequence : model.geom()) {
            for (PropFeature propFeature : geomSequence.feature()) {
                PropValue propValue;
                GeomFeature geomFeature = (GeomFeature)propFeature;
                IGeomOperation iGeomOperation = geomFeature.getOperation();
                if (!"Import".equals(iGeomOperation.getID()) || (propValue = geomFeature.getPropValueInternal("type")) == null || !"cad".equals(propValue.getValue()) || !b2.b()) continue;
                propValue.setValue("file");
            }
        }
    }

    public static void setMissingGeom(GeomNative geomNative) {
        geomNative.setFakeGeomInfo();
        PrimitiveModelEntity primitiveModelEntity = geomNative.getContainer();
        while (primitiveModelEntity != null) {
            if (primitiveModelEntity instanceof GeomSequence) {
                GeomSequence geomSequence = (GeomSequence)primitiveModelEntity;
                MissingGeometryBuildData missingGeometryBuildData = geomSequence.getMissingGeometryBuildData();
                missingGeometryBuildData.missingGeom = true;
                break;
            }
            primitiveModelEntity = primitiveModelEntity.getContainer();
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public static void rebuildGeom(Model var0, b.b var1_1) {
        var2_2 = var1_1.f() != false && var1_1.b() != false && var1_1.e() == false;
        try {
            var0.hist().disable();
            var3_3 = null;
            var4_4 = null;
            block10: for (Object var5_6 : var0.geom()) {
                block29: {
                    if (var5_6.getSDim() != 3) continue;
                    var7_7 = false;
                    var8_8 = var5_6.getMissingGeometryBuildData();
                    var9_9 = var8_8.missingGeom;
                    if (var9_9) {
                        var7_7 = true;
                    }
                    if (var2_2 && "cadps".equals(var5_6.geomRep())) {
                        var7_7 = true;
                        var5_6.setGeomrep("comsol");
                        var8_8.changedGeomRepToComsol = true;
                    }
                    block11: for (ModelEntity var10_10 : var5_6.feature()) {
                        var12_15 = (GeomFeature)var10_10;
                        if (var2_2 && var12_15.hasPropValue("geomrep") && "cadps".equals(var12_15.getString("geomrep"))) {
                            var7_7 = true;
                            var12_15.set("geomrep", "comsol");
                            var8_8.changedGeomRepToComsol = true;
                        }
                        if (var12_15.getStatus() != FEATURE_STATUS.BUILT) continue;
                        var13_16 = var12_15.getOperation();
                        if ((!var2_2 || !var13_16.requireCad() && (!var13_16.isNativeImport() || !var9_9)) && (!var9_9 || !var13_16.isVirtual())) continue;
                        for (ModelEntity var14_17 : var12_15.getGeom()) {
                            if (var14_17.hasGeom() || !var14_17.exists()) continue;
                            var7_7 = true;
                            var12_15.setStatus(FEATURE_STATUS.NEEDS_REBUILD);
                            var12_15.setBuildStatus(FEATURE_STATUS.NEEDS_REBUILD);
                            if (!var13_16.isVirtual()) continue block11;
                            var8_8.missingVirtual = true;
                            continue block11;
                        }
                    }
                    if (var7_7) {
                        var8_8.somethingChanged = true;
                    }
                    if (!var9_9) continue;
                    var8_8.somethingChanged = true;
                    for (ModelEntity var10_10 : var0.view()) {
                        if (var10_10.getGeomSequence() != var5_6) continue;
                        var10_10.hideObjects().clear();
                    }
                    if (var2_2) {
                        var10_10 = var5_6.getFeature();
                        var11_14 = 0;
                        while (var11_14 < var10_10.size()) {
                            var12_15 = (GeomFeature)var10_10.get(var11_14);
                            if (var12_15.isActive() && var12_15.getOperation().requireCad()) {
                                var4_4 = var12_15;
                                var5_6.run("");
                                GeomSequenceUtil.throwCadKernelException((GeomFeature)var4_4);
                            }
                            ++var11_14;
                        }
                    }
                    if (!var1_1.h()) break block29;
                    return;
                }
                try {
                    try {
                        if (var2_2) {
                            var5_6.setAllowAutoSwitchToCad(false);
                        }
                        var5_6.run();
                        continue;
                    }
                    finally {
                        if (var2_2) {
                            var5_6.setAllowAutoSwitchToCad(true);
                        }
                    }
                }
                catch (FlException var10_12) {
                    if (var3_3 == null) {
                        var3_3 = var10_12;
                    }
                    var8_8.buildFailed = true;
                    if (!var5_6.hasFinalizedGeometry()) continue;
                    var11_13 = new Geom3(-1);
                    var12_15 = new int[4];
                    var13_16 = var5_6.geomManagerNative().getGeomManagerNewVersion();
                    var13_16.a(new Geom[]{var11_13}, new int[][]{(int[])var12_15}, new int[0][], 0);
                    var5_6.setGeomAndAssoc(0L, (Geom)var11_13, (int[])var12_15, false);
                    var17_21 = var0.mesh().getListView().toArray(new MeshSequence[0]);
                    var16_20 = var17_21.length;
                    var15_19 = 0;
                    ** while (var15_19 < var16_20)
                }
lbl-1000:
                // 1 sources

                {
                    var14_17 = var17_21[var15_19];
                    if (var5_6.equals(var14_17.getGeom())) {
                        var14_17.notifyGeometryChanged();
                    }
                    ++var15_19;
                    continue;
lbl89:
                    // 1 sources

                }
            }
            if (var3_3 != null) {
                if (var3_3 instanceof LicenseException || var3_3 instanceof CadKernelException) {
                    var5_6 = "#" + FlLocale.getString((String)"This_feature_requires_the_CAD_kernel");
                    if (var4_4 != null) {
                        var5_6 = String.valueOf(var5_6) + "\n" + FlLocale.getString((String)("Feature_X#" + var4_4.label()));
                    }
                    var5_6 = String.valueOf(var5_6) + "\n" + FlLocale.getString((String)"Cleared_all_solutions") + " " + FlLocale.getString((String)"Cleared_selections_on_the_finalized_geometry");
                    throw new FlException((String)var5_6);
                }
                throw var3_3;
            }
        }
        finally {
            var0.hist().enable();
        }
    }

    public static void fixGeomConstrDim(Model model, b.b b2) {
        if (b2.h()) {
            return;
        }
        try {
            model.hist().disable();
            for (GeomSequence geomSequence : model.geom()) {
                ModelLoadUtil.a(geomSequence, b2);
            }
        }
        finally {
            model.hist().enable();
        }
    }

    private static void a(GeomSequence geomSequence, b.b b2) {
        if (geomSequence.getSDim() == 1) {
            return;
        }
        for (GeomFeature geomFeature : geomSequence.feature()) {
            GeomSubsequence geomSubsequence;
            if (geomFeature instanceof WorkPlaneFeature) {
                ModelLoadUtil.a(((WorkPlaneFeature)geomFeature).getSequence2D(), b2);
                continue;
            }
            if (!(geomFeature instanceof GeomSubsequenceCallFeature)) continue;
            GeomSubsequence geomSubsequence2 = ((GeomSubsequenceCallFeature)geomFeature).getLocalSubsequence();
            if (geomSubsequence2 != null) {
                ModelLoadUtil.a((GeomSequence)geomSubsequence2, b2);
            }
            if ((geomSubsequence = ((GeomSubsequenceCallFeature)geomFeature).getStoredLocalSubsequence()) == null) continue;
            ModelLoadUtil.a((GeomSequence)geomSubsequence, b2);
        }
        if (geomSequence.useConstrDim() && !geomSequence.isDefinedByMesh()) {
            b2.c();
            if (b2.k()) {
                geomSequence.useConstrDim(false);
            }
        }
    }

    public static List<GeomNative> getAllGeomNative(Model model) {
        ArrayList<GeomNative> arrayList = new ArrayList<GeomNative>();
        for (GeomSequence geomSequence : model.geom()) {
            ModelLoadUtil.a(geomSequence, arrayList);
        }
        return arrayList;
    }

    private static void a(GeomSequence geomSequence, List<GeomNative> list) {
        GeomNative geomNative = geomSequence.getGeomnative();
        if (geomNative != null) {
            list.add(geomNative);
        }
        for (PropFeature propFeature : geomSequence.feature()) {
            Object object;
            Object object2;
            GeomFeature geomFeature = (GeomFeature)propFeature;
            for (GeomObject geomObject : geomFeature.getGeom()) {
                geomNative = geomObject.getGeomnative();
                if (geomNative == null) continue;
                list.add(geomNative);
            }
            List<? extends GeomObject> list22 = geomFeature.getImportedGeom();
            if (list22 != null) {
                object2 = list22.iterator();
                while (object2.hasNext()) {
                    object = object2.next();
                    geomNative = object.getGeomnative();
                    if (geomNative == null) continue;
                    list.add(geomNative);
                }
            }
            if (geomFeature instanceof WorkPlaneFeature) {
                ModelLoadUtil.a(((WorkPlaneFeature)geomFeature).getSequence2D(), list);
                continue;
            }
            if (!(geomFeature instanceof GeomSubsequenceCallFeature)) continue;
            object = ((GeomSubsequenceCallFeature)geomFeature).getLocalSubsequence();
            if (object != null) {
                ModelLoadUtil.a((GeomSequence)object, list);
            }
            if ((object2 = ((GeomSubsequenceCallFeature)geomFeature).getStoredLocalSubsequence()) == null) continue;
            ModelLoadUtil.a((GeomSequence)object2, list);
        }
    }

    public static void prepareRecoveryLoading(String string) throws IOException {
        com.comsol.util.interfaces.d d2 = ModelLoadUtil.readRecoveryXml(string);
        com.comsol.util.interfaces.b[] bArray = d2.a("MPHRecovery");
        if (bArray.length > 0) {
            com.comsol.util.interfaces.b b2 = bArray[0];
            com.comsol.util.interfaces.b[] bArray2 = b2.a("ZipFile");
            com.comsol.util.interfaces.b[] bArray3 = b2.a("Database");
            if (bArray2.length > 0) {
                String string2 = bArray2[0].b("path");
                if (string2 != null) {
                    File file = new File(string2);
                    if (file.exists()) {
                        try (com.comsol.util.file.b b3 = new com.comsol.util.file.b(file);){
                            com.comsol.util.interfaces.b[] bArray4 = b2.a("ZippedResource");
                            Map<StringStringPair, String> map = null;
                            if (bArray4.length > 0) {
                                try {
                                    map = ModelLoadUtil.a(b3);
                                }
                                catch (IOException iOException) {
                                    map = new HashMap<StringStringPair, String>();
                                }
                            }
                            ModelLoadUtil.a(b2, b3, string, bArray4, map);
                            ModelLoadUtil.a(b2, b3, string, map);
                        }
                        ModelLoadUtil.a(string, bArray);
                    } else if (b2.a("ZippedResource").length > 0) {
                        throw new FailedMphAccessException(string2, (IOException)new FileNotFoundException(FlLocale.getErrorString((String)"File_not_found")));
                    }
                }
            } else if (bArray3.length > 0) {
                com.comsol.util.interfaces.b b4 = bArray3[0];
                DatabaseModelDescriptor databaseModelDescriptor = DatabaseModelDescriptor.fromAttributes(b4);
                com.comsol.util.interfaces.b[] bArray5 = b2.a("DatabaseResource");
                com.comsol.util.interfaces.b[] bArray6 = b2.a("DatabaseSavePoint");
                ModelLoadUtil.a(b2, databaseModelDescriptor, string, bArray5);
                ModelLoadUtil.b(b2, databaseModelDescriptor, string, bArray6);
                ModelLoadUtil.a(string, bArray);
            }
        }
    }

    private static Map<StringStringPair, String> a(com.comsol.util.file.b b2) throws IOException {
        HashMap<StringStringPair, String> hashMap = new HashMap<StringStringPair, String>();
        ZipEntry zipEntry = b2.getEntry("fileids.xml");
        if (zipEntry != null) {
            com.comsol.util.interfaces.d d2 = new com.comsol.util.interfaces.d("xml-root", null);
            com.comsol.util.interfaces.b[] bArray = null;
            com.comsol.util.interfaces.b b3 = null;
            try (InputStreamReader inputStreamReader = new InputStreamReader(b2.getInputStream(zipEntry), StandardCharsets.UTF_8);){
                ae.a((Reader)inputStreamReader, (c)d2);
            }
            catch (Throwable object) {
                if (bArray == null) {
                    bArray = object;
                } else if (bArray != object) {
                    bArray.addSuppressed((Throwable)object);
                }
                throw bArray;
            }
            bArray = d2.a("FileIDs");
            if (bArray.length > 0) {
                String string;
                String string2;
                com.comsol.util.interfaces.b[] bArray2 = bArray[0].a("BinaryResource");
                int n2 = bArray2.length;
                int n3 = 0;
                while (n3 < n2) {
                    b3 = bArray2[n3];
                    string2 = b3.b("file");
                    string = b3.b("fileid");
                    if (string2 != null && string != null) {
                        hashMap.put(new StringStringPair("Binary", string2), string);
                    }
                    ++n3;
                }
                bArray2 = bArray[0].a("SavePoint");
                n2 = bArray2.length;
                n3 = 0;
                while (n3 < n2) {
                    b3 = bArray2[n3];
                    string2 = b3.b("tag");
                    string = b3.b("fileid");
                    if (string2 != null && string != null) {
                        hashMap.put(new StringStringPair("SavePoint", string2), string);
                    }
                    ++n3;
                }
            }
        }
        return hashMap;
    }

    private static void a(com.comsol.util.interfaces.b b2, com.comsol.util.file.b b3, String string, com.comsol.util.interfaces.b[] bArray, Map<StringStringPair, String> map) {
        com.comsol.util.interfaces.b[] bArray2 = bArray;
        int n2 = bArray.length;
        int n3 = 0;
        while (n3 < n2) {
            ZipEntry zipEntry;
            com.comsol.util.interfaces.b b4 = bArray2[n3];
            String string2 = b4.b("file");
            String string3 = b4.b("fileid");
            if (string2 != null && string3 != null && string3.equals(map.get(new StringStringPair("Binary", string2))) && (zipEntry = b3.getEntry(string2)) != null) {
                try {
                    InputStream inputStream = b3.getInputStream(zipEntry);
                    ModelLoadUtil.a(b2, string, b4, inputStream);
                }
                catch (IOException iOException) {}
            }
            ++n3;
        }
    }

    private static void a(com.comsol.util.interfaces.b b2, DatabaseModelDescriptor databaseModelDescriptor, String string, com.comsol.util.interfaces.b[] bArray) {
        com.comsol.util.interfaces.b[] bArray2 = bArray;
        int n2 = bArray.length;
        int n3 = 0;
        while (n3 < n2) {
            com.comsol.util.interfaces.b b3 = bArray2[n3];
            String string2 = b3.b("checksum");
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream inputStream = DatabaseMphProviderFactory.getInstance().getModelResourceInputStream(databaseModelDescriptor, string2);){
                    ModelLoadUtil.a(b2, string, b3, inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "Failed to read binary resource from database.", iOException);
            }
            ++n3;
        }
    }

    private static void a(com.comsol.util.interfaces.b b2, String string, com.comsol.util.interfaces.b b3, InputStream inputStream) throws IOException {
        File file = File.createTempFile("resource", ".mphbin", new File(string));
        FlFileUtil.a((InputStream)inputStream, (File)file);
        b2.b(b3);
        com.comsol.util.interfaces.b b4 = new com.comsol.util.interfaces.b("FileResource", b2);
        b2.a(b4);
        String[] stringArray = new String[]{"class", "tag", "version", "index"};
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray[n3];
            String string3 = b3.b(string2);
            if (string3 != null) {
                b4.a(string2, string3);
            }
            ++n3;
        }
        b4.a("file", file.getName());
    }

    private static void b(com.comsol.util.interfaces.b b2, DatabaseModelDescriptor databaseModelDescriptor, String string, com.comsol.util.interfaces.b[] bArray) {
        com.comsol.util.interfaces.b[] bArray2 = bArray;
        int n2 = bArray.length;
        int n3 = 0;
        while (n3 < n2) {
            com.comsol.util.interfaces.b b3 = bArray2[n3];
            String string2 = b3.b("checksum");
            try {
                Throwable throwable = null;
                Object var10_12 = null;
                try (InputStream inputStream = DatabaseMphProviderFactory.getInstance().getModelResourceInputStream(databaseModelDescriptor, string2);){
                    ModelLoadUtil.b(b2, string, b3, inputStream);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (IOException iOException) {
                CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "Failed to read save point resource from database.", iOException);
            }
            ++n3;
        }
    }

    private static void b(com.comsol.util.interfaces.b b2, String string, com.comsol.util.interfaces.b b3, InputStream inputStream) throws IOException {
        String string2 = b3.b("tag");
        File file = new File(string, string2);
        file.mkdirs();
        String string3 = b3.b("name");
        FlFileUtil.a((InputStream)inputStream, (File)new File(file, string3));
        b2.b(b3);
    }

    private static void a(com.comsol.util.interfaces.b b2, com.comsol.util.file.b b3, String string, Map<StringStringPair, String> map) {
        com.comsol.util.interfaces.b[] bArray = b2.a("SavePoint");
        int n2 = bArray.length;
        int n3 = 0;
        while (n3 < n2) {
            com.comsol.util.interfaces.b b4 = bArray[n3];
            b2.b(b4);
            String string2 = b4.b("tag");
            String string3 = b4.b("fileid");
            if (string2 != null && string3 != null && string3.equals(map.get(new StringStringPair("SavePoint", string2)))) {
                File file = new File(string, string2);
                file.mkdirs();
                ZipEntry zipEntry = b3.getEntry(String.valueOf(string2) + "/model.zip");
                try {
                    if (zipEntry != null) {
                        FlFileUtil.a((InputStream)b3.getInputStream(zipEntry), (File)new File(file, "model.zip"));
                    } else {
                        zipEntry = b3.getEntry(String.valueOf(string2) + "/model.xml");
                        if (zipEntry != null) {
                            FlFileUtil.a((InputStream)b3.getInputStream(zipEntry), (File)new File(file, "model.xml"));
                            ModelType[] modelTypeArray = ModelType.values();
                            int n4 = modelTypeArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                ModelType modelType = modelTypeArray[n5];
                                zipEntry = b3.getEntry(String.valueOf(string2) + "/" + modelType.getKeyFileName());
                                if (zipEntry != null) {
                                    FlFileUtil.a((InputStream)b3.getInputStream(zipEntry), (File)new File(file, modelType.getKeyFileName()));
                                }
                                ++n5;
                            }
                        }
                    }
                }
                catch (IOException iOException) {}
            }
            ++n3;
        }
    }

    public static com.comsol.util.interfaces.d readRecoveryXml(String string) throws IOException {
        com.comsol.util.interfaces.d d2 = new com.comsol.util.interfaces.d("xml-root", null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader fileReader = new FileReader(new File(string, "recovery.xml"));){
            ae.a((Reader)fileReader, (c)d2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return d2;
    }

    private static void a(String string, com.comsol.util.interfaces.b[] bArray) throws IOException {
        CsXMLWriter csXMLWriter = new CsXMLWriter(FlFileUtil.z((File)new File(string, "recovery.xml")));
        csXMLWriter.startDocument();
        bArray[0].a(csXMLWriter);
        csXMLWriter.endDocument();
    }

    public static com.comsol.util.interfaces.d readRecoveryDModelXml(String string) throws IOException {
        com.comsol.util.interfaces.d d2 = new com.comsol.util.interfaces.d("xml-root", null);
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileReader fileReader = new FileReader(new File(string, "dmodel.xml"));){
            ae.a((Reader)fileReader, (c)d2);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return d2;
    }

    public static Map<BinaryManager.g, String> getKeyToFileMap(com.comsol.util.interfaces.b b2, String string) {
        HashMap<BinaryManager.g, String> hashMap = new HashMap<BinaryManager.g, String>();
        com.comsol.util.interfaces.b[] bArray = b2.a("MPHRecovery");
        if (bArray.length > 0) {
            com.comsol.util.interfaces.b[] bArray2 = bArray[0].a("FileResource");
            int n2 = bArray2.length;
            int n3 = 0;
            while (n3 < n2) {
                com.comsol.util.interfaces.b b3 = bArray2[n3];
                String string2 = b3.b("class");
                String string3 = b3.b("tag");
                String string4 = b3.b("file");
                String string5 = b3.b("index");
                int n4 = -1;
                if (string5 != null) {
                    try {
                        n4 = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "Error reading recovery.xml", numberFormatException);
                    }
                }
                if (string3 != null && string4 != null) {
                    try {
                        hashMap.put(new BinaryManager.g(new BigInteger(string3, 16).longValue(), n4, BinaryType.valueOf((String)string2)), new File(string, string4).getAbsolutePath());
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        CsPlugin.log(CsAbstractPlugin.LogLevel.ERROR, "Error reading recovery.xml", illegalArgumentException);
                    }
                }
                ++n3;
            }
        }
        return hashMap;
    }

    public static Map<String, StringLongPair> getFileNameMap(String string, Map<BinaryManager.g, String> map, Object ... objectArray) throws IOException {
        HashMap<String, StringLongPair> hashMap = new HashMap<String, StringLongPair>();
        InputStream inputStream = new FileInputStream(new File(string, "dmodel.xml"));
        if (objectArray != null && objectArray.length > 0) {
            inputStream = SimpleUtil.convertInputStream(inputStream, true, (String)objectArray[1]);
        }
        com.comsol.util.interfaces.d d2 = new com.comsol.util.interfaces.d("xml-root", null);
        ae.a((InputStream)inputStream, (c)d2, (String)StandardCharsets.UTF_8.name());
        ModelLoadUtil.a((com.comsol.util.interfaces.b)d2, map, hashMap);
        return hashMap;
    }

    private static void a(com.comsol.util.interfaces.b b2, Map<BinaryManager.g, String> map, Map<String, StringLongPair> map2) {
        for (com.comsol.util.interfaces.b b3 : b2.e()) {
            String string = b3.b("T");
            if (string != null && Primitives.getPrimitive(Integer.parseInt(string)) == Primitives.NATIVE) {
                String string2 = b3.b("class");
                String string3 = b3.b("id");
                String string4 = b3.b("resource");
                String string5 = b3.b("fileid");
                String string6 = b3.b("index");
                int n2 = 0;
                if (string6 != null) {
                    try {
                        n2 = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                if (string2 != null && string3 != null && string4 != null && string5 != null) {
                    try {
                        BinaryManager.g g2 = new BinaryManager.g(new BigInteger(string3, 16).longValue(), n2, BinaryType.valueOf((String)string2));
                        String string7 = map.get(g2);
                        if (string7 == null) {
                            g2 = new BinaryManager.g(new BigInteger(string3, 16).longValue(), -1, BinaryType.valueOf((String)string2));
                            string7 = map.get(g2);
                        }
                        if (string7 != null && !map2.containsKey(string7)) {
                            map2.put(string7, new StringLongPair(string4, new BigInteger(string5, 16).longValue()));
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            ModelLoadUtil.a(b3, map, map2);
        }
    }

    public static FileVersion extractFileVersion(String string) {
        int n2;
        FileVersion fileVersion = new FileVersion();
        if (string != null && (n2 = string.indexOf(58)) > 0) {
            try {
                fileVersion.version = Integer.parseInt(string.substring(0, n2));
            }
            catch (NumberFormatException numberFormatException) {}
            fileVersion.versionHuman = string.substring(n2 + 1);
        }
        return fileVersion;
    }

    public static void checkFileVersion(FileVersion fileVersion, int n2) {
        if (fileVersion.version == 0) {
            throw new FlException("COMSOL_Multiphysics_model_file_is_damaged_or_not_valid");
        }
        if (fileVersion.version > n2) {
            throw new FlException("File_created_with_a_later_version_of_COMSOL_Multiphysics").addParameterPair("Version", fileVersion.versionHuman);
        }
    }

    public static Locking testIfLocked(String string, IModelManager iModelManager) {
        if (iModelManager.isLocked(string)) {
            return Locking.LOCKEDBYME;
        }
        try {
            Throwable throwable = null;
            Object var3_4 = null;
            try (FileChannel fileChannel = FileChannel.open(FileSystems.getDefault().getPath(string, new String[0]), StandardOpenOption.READ, StandardOpenOption.WRITE);){
                return Locking.UNLOCKED;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (AccessDeniedException accessDeniedException) {
            return Locking.UNLOCKED;
        }
        catch (FileSystemException fileSystemException) {
            return Locking.LOCKEDBYOTHER;
        }
        catch (AccessControlException accessControlException) {
            return Locking.NOACCESS;
        }
        catch (IOException | UnsupportedOperationException exception) {
            return Locking.UNLOCKED;
        }
    }

    static /* synthetic */ int[] a() {
        if (a != null) {
            return a;
        }
        int[] nArray = new int[Xmesh.XMESH_DISTR_TYPE.values().length];
        try {
            nArray[Xmesh.XMESH_DISTR_TYPE.b.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Xmesh.XMESH_DISTR_TYPE.a.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[Xmesh.XMESH_DISTR_TYPE.c.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        a = nArray;
        return nArray;
    }

    private static /* synthetic */ void a(com.comsol.util.interfaces.d d2, PropFeature propFeature) {
        com.comsol.util.interfaces.d d3 = new com.comsol.util.interfaces.d("appArgument", (com.comsol.util.interfaces.b)d2);
        d3.a("name", propFeature.tag());
        d3.a("help", propFeature.getString("helptext"));
        d2.a((com.comsol.util.interfaces.b)d3);
    }

    public static class FileVersion {
        public int version;
        public String versionHuman = "";
    }

    public static class GeomReInitializer {
        private boolean a = false;
        private final Model b;

        public GeomReInitializer(Model model) {
            this.b = model;
        }

        public boolean modified() {
            if (!this.a) {
                this.b.reInitialize(ReInitInfo.noChildren);
                this.b.param().reInitialize(ReInitInfo.allChildren);
                this.b.func().reInitialize(ReInitInfo.allChildren);
                this.b.view().reInitialize(ReInitInfo.allChildren);
                this.b.geom().reInitialize(ReInitInfo.allChildren);
                this.b.mesh().reInitialize(ReInitInfo.allChildren);
                this.b.study().reInitialize(ReInitInfo.allChildren);
                this.b.sol().reInitialize(ReInitInfo.allChildren);
                this.b.batch().reInitialize(ReInitInfo.allChildren);
                this.b.probe().reInitialize(ReInitInfo.allChildren);
                this.b.massProp().reInitialize(ReInitInfo.allChildren);
                this.b.result().reInitialize(ReInitInfo.allChildren);
                this.b.coordSystem().reInitialize(ReInitInfo.allChildren);
                this.a = true;
            }
            return true;
        }
    }

    public static interface ISpModelStore {
        public void storeSpModel(IModel var1);
    }

    public static enum Locking {
        UNLOCKED,
        LOCKEDBYOTHER,
        LOCKEDBYME,
        NOACCESS;

    }

    private static class a {
        IFileResource a;
        ZipEntry b;
        String c;
        boolean d;
        String e;
        File f;

        a(IFileResource iFileResource, ZipEntry zipEntry, String string, boolean bl2) {
            this.a = iFileResource;
            this.b = zipEntry;
            this.c = string;
            this.d = bl2;
        }
    }

    public static interface SaveEntry {
        public void save(String var1, String var2, File var3, boolean var4) throws IOException;
    }

    public static class StringLongPair
    extends com.comsol.util.classes.a<String, Long> {
        public StringLongPair(String string, Long l2) {
            super((Object)string, (Object)l2);
        }

        public String getString() {
            return (String)this.a;
        }

        public long getLong() {
            return (Long)this.b;
        }
    }
}

