/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.util;

import com.comsol.model.dbimodel.Expression;
import com.comsol.model.dbimodel.ExpressionBase;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ParameterContainer;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.operations.operationID.AppOperationID;
import com.comsol.model.param.ParamSpec;
import com.comsol.model.util.ModelDataAccessUtil;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.nativeutil.properties.Property;
import com.comsol.nativeutil.properties.i;
import com.comsol.util.classes.StringStringPair;
import com.comsol.util.methods.FlStringUtil;
import java.util.regex.Pattern;

public class ModelPath {
    private static final Pattern a = Pattern.compile("^\\/FormFeatureList\\/\\w+\\/\\w+\\/AppBuilderFeatureList\\/.+");
    private static final Pattern b = Pattern.compile("^\\/FormFeatureList\\/\\w+\\/\\w+\\/AppBuilderFeatureList\\/.+\\/AppBuilderFeatureList\\/.+|^\\/AppBuilderFeatureList\\/.+\\/AppBuilderFeatureList\\/.+");
    private String c;
    private String[] d;

    public ModelPath(ModelEntity modelEntity, String string) {
        this.c = String.valueOf(ModelEntityUtil.getEntityPath(modelEntity)) + ":" + string;
        this.d = this.c.split(":");
    }

    public ModelPath(ModelEntity modelEntity, String string, int ... nArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(ModelEntityUtil.getEntityPath(modelEntity));
        stringBuilder.append(':');
        stringBuilder.append(string);
        int[] nArray2 = nArray;
        int n2 = nArray.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 < 0) {
                throw new RuntimeException("Negative index not allowed");
            }
            stringBuilder.append(':');
            stringBuilder.append(n4 + 1);
            ++n3;
        }
        this.c = stringBuilder.toString();
        this.d = this.c.split(":");
    }

    public ModelPath(String string) {
        this.c = string;
        this.d = string.split(":");
    }

    public void setEntityRef(ModelEntity modelEntity) {
        this.d[0] = ModelEntityUtil.getEntityPath(modelEntity);
        this.c = FlStringUtil.delimitedString((String[])this.d, (String)":");
    }

    public ModelEntity findEntity(Model model) {
        return ModelEntityUtil.findEntity(null, model, this.d[0].split("/"), 1);
    }

    public boolean hasAttribute() {
        return this.d.length > 1;
    }

    public String getAttribute() {
        return this.d[1];
    }

    public void setAttribute(String string) {
        this.d[1] = string;
    }

    public int numIndices() {
        return this.d.length - 2;
    }

    public int getIndexValue(int n2) {
        return Integer.parseInt(this.d[2 + n2]) - 1;
    }

    public boolean isAppBuilderFeature() {
        return this.c.startsWith("/AppBuilderFeatureList/") || a.matcher(this.c).matches();
    }

    public boolean isDeclaration(ModelEntity modelEntity) {
        if (!this.isAppBuilderFeature()) {
            return false;
        }
        ModelEntity modelEntity2 = modelEntity instanceof Model ? this.findEntity((Model)modelEntity) : modelEntity;
        return modelEntity2 instanceof PropFeature && AppOperationID.isOfType((PropFeature)modelEntity2, AppOperationID.DATA);
    }

    public boolean isFormLocalFeature() {
        return b.matcher(this.c).matches();
    }

    public Property getProperty(ModelEntity modelEntity) {
        if (!this.hasAttribute()) {
            return null;
        }
        ModelEntity modelEntity2 = modelEntity instanceof Model ? this.findEntity((Model)modelEntity) : modelEntity;
        if (!(modelEntity2 instanceof PropFeature)) {
            return null;
        }
        PropFeature propFeature = (PropFeature)modelEntity2;
        return propFeature.getOperation().getPropSet().getFromAllProperty(this.getAttribute());
    }

    public Property.PropertyType getEquivalentType(ModelEntity modelEntity) {
        return this.getEquivalentType(modelEntity, false);
    }

    public Property.PropertyType getEquivalentType(ModelEntity modelEntity, boolean bl2) {
        ModelEntity modelEntity2 = modelEntity instanceof Model ? this.findEntity((Model)modelEntity) : modelEntity;
        if (this.hasAttribute() && this.isDeclaration(modelEntity2)) {
            return AppOperationID.fromID(((PropFeature)modelEntity2).getOperationID()).toPropertyType(false);
        }
        Property property = this.getProperty(modelEntity2);
        if (bl2 && property instanceof i) {
            return Property.PropertyType.k;
        }
        if (property != null) {
            return property.getType();
        }
        ParamSpec paramSpec = this.getParamSpec(modelEntity2);
        if (paramSpec != null) {
            Property.PropertyType propertyType = ModelDataAccessUtil.paramSpecToPropertyType(paramSpec);
            if (bl2 && propertyType == Property.PropertyType.a && paramSpec.isBoolean()) {
                return Property.PropertyType.k;
            }
            return propertyType;
        }
        return null;
    }

    public ParamSpec getParamSpec(ModelEntity modelEntity) {
        ParameterContainer parameterContainer;
        if (!this.hasAttribute()) {
            return null;
        }
        ModelEntity modelEntity2 = modelEntity instanceof Model ? this.findEntity((Model)modelEntity) : modelEntity;
        String string = this.getAttribute();
        if (modelEntity2 instanceof Physics) {
            StringStringPair stringStringPair = ModelDataAccessUtil.getPhysicsProp((Physics)modelEntity2, string);
            parameterContainer = ((Physics)modelEntity2).prop(stringStringPair.first);
            string = stringStringPair.second;
        } else if (modelEntity2 instanceof ParameterContainer) {
            parameterContainer = (ParameterContainer)((Object)modelEntity2);
        } else {
            return null;
        }
        return parameterContainer.getSpec(string);
    }

    public ParameterContainer getParameterContainer(ModelEntity modelEntity) {
        ModelEntity modelEntity2 = modelEntity instanceof Model ? this.findEntity((Model)modelEntity) : modelEntity;
        if (modelEntity2 instanceof Physics) {
            StringStringPair stringStringPair = ModelDataAccessUtil.getPhysicsProp((Physics)modelEntity2, this.getAttribute());
            return ((Physics)modelEntity2).prop(stringStringPair.first);
        }
        if (modelEntity2 instanceof ParameterContainer) {
            return (ParameterContainer)((Object)modelEntity2);
        }
        return null;
    }

    public Expression getExpression(ExpressionBase expressionBase) {
        return expressionBase.getExpression(this.getAttribute());
    }

    public ModelPath getParent() {
        int n2 = this.c.lastIndexOf(47);
        if (n2 > 0) {
            return new ModelPath(this.c.substring(0, n2));
        }
        return null;
    }

    public String getString() {
        return this.c;
    }

    public String toString() {
        return this.getString();
    }

    public String getEntityString() {
        return this.d[0];
    }

    public String getEntityTag() {
        return this.d[0].substring(this.d[0].lastIndexOf("/") + 1);
    }
}

