/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.guimph.prop;

import com.comsol.guimph.MphDesktopWindow;
import com.comsol.guimph.prop.PropBlockFeatureGroup;
import com.comsol.model.data.events.IEventHandler;
import com.comsol.model.data.events.NodeEvent;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.operations.ICoordsysOperation;
import com.comsol.model.operations.IGeomOperation;
import com.comsol.model.operations.IPropBlock;
import com.comsol.model.util.EventManagerWrapper;
import com.comsol.model.util.MetaModelUtil;
import com.comsol.nativeutil.data.RenderDataEvent;
import com.comsol.nativeutil.data.RenderWorkPlane;
import com.comsol.nativeutil.data.RepaintRenderDataEvent;
import com.comsol.propwidgets.au;
import com.comsol.widgets.CsWidget;
import java.util.Collection;

public class WorkPlanePropBlockFeatureGroup
extends PropBlockFeatureGroup {
    private final PropFeature f;

    public WorkPlanePropBlockFeatureGroup(IPropBlock iPropBlock, PropFeature propFeature, CsWidget csWidget, Collection<au.e> collection) {
        super(iPropBlock, propFeature, csWidget, collection);
        this.f = propFeature;
    }

    public void onShow() {
        super.onShow();
        Model model = this.getDesktop().getModel();
        EventManagerWrapper eventManagerWrapper = new EventManagerWrapper((PrimitiveModelEntity)model);
        for (String string : this.e.getPropertiesAffectingWorkplaneRendering()) {
            eventManagerWrapper.addPropertyQueuedEventHandler(this.f, "update_workplane_rendering%" + string, (IEventHandler)this, MetaModelUtil.META_EVENT_INFO.READ_PERMANENT, new String[]{string});
        }
    }

    public void onHide() {
        Model model = this.getDesktop().getModel();
        EventManagerWrapper eventManagerWrapper = new EventManagerWrapper((PrimitiveModelEntity)model);
        for (String string : this.e.getPropertiesAffectingWorkplaneRendering()) {
            eventManagerWrapper.removePropertyQueuedEventHandler(this.f, "update_workplane_rendering%" + string, (IEventHandler)this, MetaModelUtil.META_EVENT_INFO.READ_PERMANENT, new String[]{string});
        }
        super.onHide();
    }

    @Override
    public void handleEvent(NodeEvent nodeEvent) {
        String string = nodeEvent.getTag();
        if (string.startsWith("update_workplane_rendering")) {
            this.a();
        }
    }

    private void a() {
        ICoordsysOperation iCoordsysOperation;
        MphDesktopWindow mphDesktopWindow = this.getDesktop();
        RenderWorkPlane renderWorkPlane = null;
        if (this.f.getOperation() instanceof ICoordsysOperation) {
            iCoordsysOperation = (ICoordsysOperation)this.f.getOperation();
            renderWorkPlane = iCoordsysOperation.getRenderWorkPlane();
        } else if (this.f.getOperation() instanceof IGeomOperation) {
            iCoordsysOperation = (IGeomOperation)this.f.getOperation();
            renderWorkPlane = iCoordsysOperation.getRenderWorkPlane();
        }
        if (renderWorkPlane != null) {
            mphDesktopWindow.getGuiEventManager().fireAddWorkPlane(renderWorkPlane);
        } else {
            mphDesktopWindow.getGuiEventManager().fireClearWorkPlane(mphDesktopWindow.getGuiViewType());
        }
        iCoordsysOperation = mphDesktopWindow.getRenderingDataEventManager();
        RepaintRenderDataEvent repaintRenderDataEvent = new RepaintRenderDataEvent(mphDesktopWindow.getMainAxisTargetAxis());
        iCoordsysOperation.fireRenderingEvent((RenderDataEvent)repaintRenderDataEvent);
    }
}

