/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.analysis;

import com.comsol.model.analysis.SolverType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public enum OptimizationSolver {
    coordsearch("Coordinate_search", OptType.OUTER, BinOpt.BOTH, BinOpt.NO, BinOpt.BOTH, BinOpt.YES, BinOpt.YES, new MultiObjType[]{MultiObjType.sum, MultiObjType.min, MultiObjType.max}, new MultiObjTypeList(MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max)),
    montecarlo("Monte_Carlo", OptType.OUTER, BinOpt.BOTH, BinOpt.NO, BinOpt.BOTH, BinOpt.YES, BinOpt.YES, new MultiObjType[]{MultiObjType.sum, MultiObjType.min, MultiObjType.max}, new MultiObjTypeList(MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max)),
    neldermead("Nelder_Mead", OptType.OUTER, BinOpt.BOTH, BinOpt.NO, BinOpt.BOTH, BinOpt.YES, BinOpt.YES, new MultiObjType[]{MultiObjType.sum, MultiObjType.min, MultiObjType.max}, new MultiObjTypeList(MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max)),
    bobyqa("BOBYQA", OptType.OUTER, BinOpt.BOTH, BinOpt.NO, BinOpt.BOTH, BinOpt.YES, BinOpt.YES, new MultiObjType[]{MultiObjType.sum, MultiObjType.min, MultiObjType.max}, new MultiObjTypeList(MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max)),
    cobyla("COBYLA", OptType.OUTER, BinOpt.BOTH, BinOpt.NO, BinOpt.BOTH, BinOpt.YES, BinOpt.YES, new MultiObjType[]{MultiObjType.sum, MultiObjType.min, MultiObjType.max}, new MultiObjTypeList(MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max)),
    snopt("SNOPT", OptType.INNER, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, new MultiObjType[]{MultiObjType.sum}, new MultiObjTypeList(MultiObjType.auto)),
    mma("MMA", OptType.INNER, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, BinOpt.BOTH, new MultiObjType[]{MultiObjType.sum}, new MMAMultiObjTypes()),
    lm("Levenberg-Marquardt", OptType.INNER, BinOpt.YES, BinOpt.BOTH, BinOpt.NONE, BinOpt.NO, BinOpt.NO, new MultiObjType[]{MultiObjType.sum}, new MultiObjTypeList(MultiObjType.auto));

    private String description;
    private OptType type;
    private BinOpt leastSquares;
    private BinOpt field;
    private BinOpt inequality;
    private BinOpt nonlinear;
    private BinOpt solutionDependency;
    private List<String> multiObjTypeNames;
    private List<String> multiObjTypeDescrs;
    private MultiObjTypeProvider multiSolTypeProvider;

    private OptimizationSolver(String string2, OptType optType, BinOpt binOpt, BinOpt binOpt2, BinOpt binOpt3, BinOpt binOpt4, BinOpt binOpt5, MultiObjType[] multiObjTypeArray, MultiObjTypeProvider multiObjTypeProvider) {
        this.description = string2;
        this.type = optType;
        this.leastSquares = binOpt;
        this.field = binOpt2;
        this.inequality = binOpt3;
        this.nonlinear = binOpt4;
        this.solutionDependency = binOpt5;
        this.multiSolTypeProvider = multiObjTypeProvider;
        this.multiObjTypeNames = new ArrayList<String>();
        this.multiObjTypeDescrs = new ArrayList<String>();
        MultiObjType[] multiObjTypeArray2 = multiObjTypeArray;
        int n3 = multiObjTypeArray.length;
        int n4 = 0;
        while (n4 < n3) {
            MultiObjType multiObjType = multiObjTypeArray2[n4];
            this.multiObjTypeNames.add(multiObjType.name());
            this.multiObjTypeDescrs.add(multiObjType.getDescription());
            ++n4;
        }
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isOuterType() {
        return this.type == OptType.OUTER;
    }

    public boolean isInnerType() {
        return this.type == OptType.INNER;
    }

    public boolean allowsObjective(boolean bl2) {
        return this.leastSquares.handles(bl2);
    }

    public boolean allowsControlVariable(boolean bl2) {
        return this.field.handles(bl2);
    }

    public boolean allowsConstraint(boolean bl2, boolean bl3, boolean bl4) {
        return this.inequality.handles(bl2) && this.nonlinear.handles(bl3) && this.solutionDependency.handles(bl4);
    }

    public List<String> getMultiobjectiveActions() {
        return this.multiObjTypeNames;
    }

    public List<String> getMultiobjectiveActionDescriptions() {
        return this.multiObjTypeDescrs;
    }

    public List<String> getMultisolutionActions(SolverType solverType) {
        return this.multiSolTypeProvider.getTypeNames(solverType);
    }

    public List<String> getMultisolutionActionDescriptions(SolverType solverType) {
        return this.multiSolTypeProvider.getTypeDescrs(solverType);
    }

    public static enum BinOpt {
        BOTH,
        NO,
        YES,
        NONE;


        public boolean handles(boolean bl2) {
            switch (this) {
                case BOTH: {
                    return true;
                }
                case NO: {
                    return !bl2;
                }
                case YES: {
                    return bl2;
                }
            }
            return false;
        }
    }

    public static class MMAMultiObjTypes
    implements MultiObjTypeProvider {
        private List<String> a = new ArrayList<String>();
        private List<String> b = new ArrayList<String>();

        public MMAMultiObjTypes() {
            MultiObjType[] multiObjTypeArray = new MultiObjType[]{MultiObjType.auto, MultiObjType.first, MultiObjType.last, MultiObjType.sum, MultiObjType.min, MultiObjType.max};
            int n2 = multiObjTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MultiObjType multiObjType = multiObjTypeArray[n3];
                this.a.add(multiObjType.name());
                this.b.add(multiObjType.getDescription());
                ++n3;
            }
        }

        @Override
        public List<String> getTypeNames(SolverType solverType) {
            if (SolverType.Transient.equals((Object)solverType)) {
                return Arrays.asList(MultiObjType.auto.name());
            }
            return this.a;
        }

        @Override
        public List<String> getTypeDescrs(SolverType solverType) {
            if (SolverType.Transient.equals((Object)solverType)) {
                return Arrays.asList(MultiObjType.auto.getDescription());
            }
            return this.b;
        }
    }

    public static enum MultiObjType {
        sum("Sum_of_objectives"),
        min("Minimum_of_objectives"),
        max("Maximum_of_objectives"),
        auto("Auto"),
        first("Use_first"),
        last("Use_last"),
        all("All");

        private String descr;

        private MultiObjType(String string2) {
            this.descr = string2;
        }

        public String getDescription() {
            return this.descr;
        }
    }

    public static class MultiObjTypeList
    implements MultiObjTypeProvider {
        private List<String> a = new ArrayList<String>();
        private List<String> b = new ArrayList<String>();

        public MultiObjTypeList(MultiObjType ... multiObjTypeArray) {
            MultiObjType[] multiObjTypeArray2 = multiObjTypeArray;
            int n2 = multiObjTypeArray.length;
            int n3 = 0;
            while (n3 < n2) {
                MultiObjType multiObjType = multiObjTypeArray2[n3];
                this.a.add(multiObjType.name());
                this.b.add(multiObjType.getDescription());
                ++n3;
            }
        }

        @Override
        public List<String> getTypeNames(SolverType solverType) {
            return this.a;
        }

        @Override
        public List<String> getTypeDescrs(SolverType solverType) {
            return this.b;
        }
    }

    public static interface MultiObjTypeProvider {
        public List<String> getTypeNames(SolverType var1);

        public List<String> getTypeDescrs(SolverType var1);
    }

    public static enum OptType {
        INNER,
        OUTER;

    }
}

