/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.applapi;

import com.comsol.model.applapi.DomainType;
import com.comsol.model.applapi.PhysicalQuantityID;
import com.comsol.model.applapi.SimpleSelection;
import com.comsol.model.applapi.TransformedInfo;
import com.comsol.model.dbimodel.Material;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ParameterEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropValue;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbimodel.physics.PhysicsProp;
import com.comsol.model.matlib.LayeredShellPropID;
import com.comsol.model.util.ForcedUnitConverter;
import com.comsol.model.util.IParamDatabase;
import com.comsol.model.util.ModelEntityUtil;
import com.comsol.nativeutil.constants.b;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.exceptions.PhysicsAPIException;
import com.comsol.util.license.LicenseType;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.stream.DoubleStream;
import java.util.stream.Stream;

public abstract class LayeredShellData {
    public static final LicenseType[] licenseRequired = new LicenseType[]{LicenseType.COMPOSITEMATERIALS, LicenseType.ACDC, LicenseType.HEATTRANSFER};
    public static final String[] NONE = new String[0];
    public static final int ALL_DIMENSIONS = -1;
    public static final int NON_LAYERED_DIMENSION = -2;
    public static final int INTERFACE_DIMENSION = 0;
    public static final int LAYER_DIMENSION = 1;
    public static final String shellType = "shell";
    public static final boolean allowVoids = false;
    private a a;
    protected final Material b;
    protected final TransformedInfo c;

    public LayeredShellData(Material material) {
        this.b = material;
        this.c = LayeredShellData.getTransformInfo(material);
        try {
            this.a = new a(material, this.size(0));
        }
        catch (Exception exception) {
            this.a = null;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof LayeredShellData) {
            String[] stringArray;
            LayeredShellData layeredShellData = (LayeredShellData)object;
            String[] stringArray2 = this.a();
            if (stringArray2.length != (stringArray = layeredShellData.a()).length) {
                return false;
            }
            int n2 = 0;
            while (n2 < stringArray2.length) {
                if (!this.a(stringArray2[n2], stringArray[n2])) {
                    return false;
                }
                ++n2;
            }
            if (!Arrays.deepEquals(this.o(), layeredShellData.o())) {
                return false;
            }
            return this.c.equals(layeredShellData.c);
        }
        return false;
    }

    private boolean a(String string, String string2) {
        return string.equals(string2);
    }

    public final String[] getCompositeTags() {
        return LayeredShellData.transformStack(this.b, this.m(), (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedTag(string, transformedInfo, true), 1);
    }

    public final String[] getThicknessScale() {
        return LayeredShellData.transformStack(this.b, this.f(), (T string, TransformedInfo transformedInfo) -> string, 1);
    }

    protected String[] f() {
        return new String[]{LayeredShellPropID.THICKNESS_SCALE.getDefault()};
    }

    public int size(int n2) {
        if (n2 == -2) {
            return 1;
        }
        String[] stringArray = this.a();
        if (n2 == 1) {
            return this.c.getSize(stringArray.length, n2);
        }
        if (n2 == 0) {
            return stringArray.length == 0 ? 0 : this.c.getSize(stringArray.length, 1) + 1;
        }
        throw new RuntimeException("Incorect parameter");
    }

    public String[] getLayerTags(int n2) {
        if (n2 == -2) {
            return new String[]{"offLayer"};
        }
        String[] stringArray = this.a();
        if (n2 == 1) {
            return LayeredShellData.transformStack(stringArray, this.c, (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedTag(string, transformedInfo, true), n2);
        }
        if (n2 == 0) {
            int n3 = stringArray.length;
            if (n3 > 0) {
                String[] stringArray2 = new String[n3 + 1];
                stringArray2[0] = stringArray[0];
                int n4 = 1;
                while (n4 < n3) {
                    stringArray2[n4] = String.valueOf(stringArray[n4 - 1]) + "-" + stringArray[n4];
                    ++n4;
                }
                stringArray2[n4] = stringArray[n4 - 1];
                return LayeredShellData.transformStack(stringArray2, this.c, (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedTag(string, transformedInfo, true), 0);
            }
            return new String[0];
        }
        throw new RuntimeException("Incorect parameter");
    }

    public String[] getLayerLabels() {
        return LayeredShellData.transformStack(this.c(), this.c, (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedLabel(string, transformedInfo), 1);
    }

    public static String getTransformedLabel(String string, TransformedInfo transformedInfo) {
        switch (transformedInfo.getType()) {
            case symmetry: {
                return string.concat(" (sym)");
            }
            case antisymmetry: {
                return string.concat(" (asym)");
            }
            case repeated: {
                return string.concat(" (rep").concat(Integer.toString(transformedInfo.getCurrentPos() + 1)).concat(")");
            }
        }
        return string;
    }

    public static String getTransformedTag(String string, TransformedInfo transformedInfo, boolean bl2) {
        String string2 = bl2 ? "##" : "";
        switch (transformedInfo.getType()) {
            case symmetry: {
                return string.concat("#sym").concat(string2);
            }
            case antisymmetry: {
                return string.concat("#asym").concat(string2);
            }
            case repeated: {
                return string.concat("#rep").concat(Integer.toString(transformedInfo.getCurrentPos() + 1)).concat(string2);
            }
        }
        return string;
    }

    public String[] getMaterials(int n2) {
        if (n2 == -1) {
            return (String[])q.b((Object[][])new String[][]{this.d(), this.k()});
        }
        if (n2 == 1) {
            return LayeredShellData.transformStack(this.d(), this.c, (T string, TransformedInfo transformedInfo) -> string, 1);
        }
        if (n2 == 0) {
            return LayeredShellData.transformStack(this.k(), this.c, (T string, TransformedInfo transformedInfo) -> string, 0);
        }
        if (n2 == -2) {
            return new String[]{this.b()};
        }
        throw new RuntimeException("Internal error");
    }

    public int[] getStackIdx() {
        return LayeredShellData.getStackIndex(this.l(), this.c);
    }

    public static int[] getStackIndex(int[] nArray, TransformedInfo transformedInfo2) {
        int n2 = q.b((int[])nArray);
        int n3 = q.c((int[])nArray) - 1;
        Integer[] integerArray = LayeredShellData.transformStack(q.i((int[])nArray), transformedInfo2, (T n4, TransformedInfo transformedInfo) -> {
            if (transformedInfo.getType() == TRANSFORM_TYPE.repeated) {
                return n4 + transformedInfo.getCurrentPos() * (n2 - n3);
            }
            return n4;
        }, 1);
        return q.b((Integer[])integerArray);
    }

    public String[] getStackLabels() {
        return LayeredShellData.transformStack(this.n(), this.c, (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedLabel(string, transformedInfo), 1);
    }

    public TransformedInfo[] getStackTransformInfo() {
        int n2 = this.getStackSize();
        TransformedInfo[] transformedInfoArray = new TransformedInfo[n2];
        int n3 = 0;
        while (n3 < n2) {
            transformedInfoArray[n3] = TransformedInfo.none;
            ++n3;
        }
        return transformedInfoArray;
    }

    public String[] getRotations() {
        return LayeredShellData.transformStack(LayeredShellData.getRotations(this.b, this.e()), this.c, (T string, TransformedInfo transformedInfo) -> transformedInfo.getType() == TRANSFORM_TYPE.antisymmetry ? "-(" + string + ")" : string, 1);
    }

    public static String[] getRotations(Material material, String[] stringArray) {
        IParamDatabase iParamDatabase = material.getModel().getParamDatabase();
        ForcedUnitConverter forcedUnitConverter = new ForcedUnitConverter(material.getModel(), null, "rotate_angle", "deg");
        double d2 = forcedUnitConverter.getSIFactor("deg");
        String[] stringArray2 = new String[stringArray.length];
        int n2 = 0;
        while (n2 < stringArray.length) {
            double d3 = 0.0;
            String string = null;
            if (ParseUtil.b((String)stringArray[n2])) {
                d3 = ParseUtil.c((String)stringArray[n2]);
            } else {
                b.b[] bArray = iParamDatabase.a(null, stringArray[n2], forcedUnitConverter, material.scopeDot());
                if (bArray != null && bArray.length == 1) {
                    if (bArray[0].b == null) {
                        d3 = bArray[0].a();
                    } else {
                        string = bArray[0].b.toString();
                    }
                } else {
                    FlException flException = new FlException("Expression_does_not_evaluate_to_a_scalar");
                    flException.addParameterPair("Expression", stringArray[n2]);
                    throw flException;
                }
            }
            stringArray2[n2] = string == null ? Double.toString(d3 * d2) : string;
            ++n2;
        }
        return stringArray2;
    }

    public String[] getNumElem() {
        return LayeredShellData.transformStack(this.i(), this.c, (T string, TransformedInfo transformedInfo) -> string, 1);
    }

    public int[] layerEntities(String string, int n2, SimpleSelection simpleSelection) {
        Object object = this.size(n2);
        Object object2 = 1;
        if (simpleSelection != null) {
            Object object3;
            block42: {
                int n3 = simpleSelection.getDim();
                if (n3 > n2) {
                    Model model = simpleSelection.getModel();
                    try {
                        String[] stringArray;
                        boolean bl2;
                        model.hist().disable();
                        Selection selection = model.createSelection();
                        boolean bl3 = bl2 = DomainType.EXTERIOR.getValue().equals(string) || DomainType.INTERIOR.getValue().equals(string);
                        if (bl2) {
                            String[] stringArray2 = new String[1];
                            stringArray = stringArray2;
                            stringArray2[0] = string;
                        } else {
                            String[] stringArray3 = new String[2];
                            stringArray3[0] = DomainType.EXTERIOR.getValue();
                            stringArray = stringArray3;
                            stringArray3[1] = DomainType.INTERIOR.getValue();
                        }
                        String[] stringArray4 = stringArray;
                        selection.geom(simpleSelection.geom(), n3, n2, stringArray4).set(simpleSelection.entities(n3));
                        object3 = selection.entities(n2);
                        if (bl2) {
                            Object object4 = object3;
                            return object4;
                        }
                        break block42;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new PhysicsAPIException(illegalArgumentException.getMessage(), (Throwable)illegalArgumentException);
                    }
                    finally {
                        model.hist().enable();
                    }
                }
                object3 = n3 == n2 ? (Object)simpleSelection.entities(n2) : (Object)simpleSelection.adjSel(n2, false).entities(n2);
            }
            if (((Object)object3).length > 0) {
                object2 = object3[0];
                object = object3[((Object)object3).length - 1];
            }
        }
        switch (string) {
            case "all": {
                return q.a((int)object2, (int)1, (int)object);
            }
            case "top": {
                int[] nArray;
                if (object >= object2) {
                    int[] nArray2 = new int[1];
                    nArray = nArray2;
                    nArray2[0] = object;
                } else {
                    nArray = new int[]{};
                }
                return nArray;
            }
            case "bottom": {
                int[] nArray;
                if (object >= object2) {
                    int[] nArray3 = new int[1];
                    nArray = nArray3;
                    nArray3[0] = object2;
                } else {
                    nArray = new int[]{};
                }
                return nArray;
            }
            case "exterior": 
            case "extgeom": 
            case "masterslave": {
                if (object >= 2) {
                    return new int[]{object2, object};
                }
                if (object == 1) {
                    return new int[]{object2, object2};
                }
                return new int[0];
            }
            case "interior": {
                if (object == 0) {
                    return new int[0];
                }
                if (object <= 2) {
                    return q.a((int)object2, (int)1, (int)object);
                }
                return q.a((int)(object2 + 1), (int)1, (int)(object - 1));
            }
        }
        return new int[0];
    }

    public int[] entities(int n2, int n3) {
        int[] nArray;
        if (n2 == -1) {
            int n4 = this.isAttachPointInserted() ? this.size(n3) + 1 : this.size(n3);
            return q.a((int)1, (int)1, (int)n4);
        }
        if (this.a != null) {
            nArray = this.a.a(n2, n3);
        } else {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = n2;
        }
        return nArray;
    }

    public String[] getPositions() {
        return LayeredShellData.getPositionFromThickness(this.getThickness(), false);
    }

    public int getStackSize() {
        return this.c.getSize((int)Stream.of(this.m()).distinct().count(), 1);
    }

    public String[] getStackPositions() {
        String[] stringArray = this.getPositions();
        String[] stringArray2 = this.getLayerTags(1);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            stringArray2[n2] = stringArray2[n2].substring(stringArray2[n2].indexOf("#") + 1);
            ++n2;
        }
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add(stringArray[0]);
        int n3 = 0;
        while (n3 < stringArray2.length - 1) {
            if (!stringArray2[n3].equals(stringArray2[n3 + 1])) {
                arrayList.add(stringArray[n3 + 1]);
            }
            ++n3;
        }
        arrayList.add(stringArray[stringArray.length - 1]);
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public double[] evaluatethickness() {
        return q.c((Double[])LayeredShellData.transformStack(q.x((double[])this.h()), this.c, (T d2, TransformedInfo transformedInfo) -> d2, 1));
    }

    public String[] getThickness() {
        return LayeredShellData.transformStack(this.g(), this.c, (T string, TransformedInfo transformedInfo) -> string, 1);
    }

    public String thicknessTotal(boolean bl2) {
        String[] stringArray;
        String[] stringArray2 = stringArray = bl2 ? LayeredShellData.getPositionFromThickness(this.evaluatethickness()) : this.getPositions();
        if (stringArray.length > 1) {
            return stringArray[stringArray.length - 1];
        }
        return "0";
    }

    public String[] getInterfaceLabels() {
        return LayeredShellData.transformStack(this.j(), this.c, (T string, TransformedInfo transformedInfo) -> LayeredShellData.getTransformedLabel(string, transformedInfo), 0);
    }

    public double attachPoint() {
        return this.a != null ? this.a.a(this) : 0.0;
    }

    public String attachPosition() {
        return this.a != null ? this.a.b(this) : "0";
    }

    public String midplaneOffset() {
        return this.a != null ? String.valueOf(this.a.c(this)) : "0.0";
    }

    public double midplaneOffsetValue() {
        return this.a != null ? this.a.c(this) : 0.0;
    }

    public boolean isAttachPointInserted() {
        return false;
    }

    public static double getDoubleValue(String string, ModelEntity modelEntity) {
        b.b[] bArray = modelEntity.getModel().paramDatabase().a(null, string, modelEntity.getConverter(), modelEntity.scopeDot());
        if (bArray.length == 1) {
            if (bArray[0].a == null) {
                return Double.MAX_VALUE;
            }
            return bArray[0].a();
        }
        return Double.MAX_VALUE;
    }

    /*
     * Unable to fully structure code
     */
    public static double[] getDoubleValue(String[] var0, ModelEntity var1_1) {
        var2_2 = var1_1.getModel().paramDatabase();
        var3_3 = new double[var0.length];
        var4_4 = 0;
        while (var4_4 < var0.length) {
            block5: {
                block3: {
                    block4: {
                        var5_5 = var1_1.getModel().getConverter();
                        var6_6 = var2_2.a(null, var0[var4_4], var5_5, var1_1.scopeDot());
                        if (var6_6.length != 1) break block3;
                        if (var6_6[0].a != null) break block4;
                        var3_3[var4_4] = 1.7976931348623157E308;
                        break block5;
                    }
                    if (!var5_5.handlesSeveralSystems()) ** GOTO lbl-1000
                    var7_7 = var1_1.getConverter();
                    var8_8 = var7_7.getUnitExpr(var0[var4_4], 1);
                    if (var7_7.useUnitSystems() && var5_5.useUnitSystems() && var8_8 != null && !var8_8.equals(var5_5.toString(PhysicalQuantityID.LENGTH.fieldName()))) {
                        var3_3[var4_4] = var5_5.convertToUnit(var6_6[0].a(), var8_8);
                    } else lbl-1000:
                    // 2 sources

                    {
                        var3_3[var4_4] = var6_6[0].a();
                    }
                    break block5;
                }
                var3_3[var4_4] = 1.7976931348623157E308;
            }
            ++var4_4;
        }
        return var3_3;
    }

    public static boolean isLayeredMaterialEntity(PrimitiveModelEntity primitiveModelEntity) {
        if (primitiveModelEntity instanceof PhysicsFeature && ((PhysicsFeature)primitiveModelEntity).getApplfeature().isLayeredMaterialFeature((PhysicsFeature)primitiveModelEntity, null)) {
            return true;
        }
        if (primitiveModelEntity instanceof MultiphysicsCoupling && ((MultiphysicsCoupling)primitiveModelEntity).getMultiphysicsCoupling().isLayeredMaterialFeature((MultiphysicsCoupling)primitiveModelEntity)) {
            return true;
        }
        if (primitiveModelEntity instanceof Physics) {
            return LayeredShellData.getLayeredProperty((Physics)primitiveModelEntity) != null;
        }
        return primitiveModelEntity instanceof PhysicsProp && ((PhysicsProp)primitiveModelEntity).getProp().isLayeredMaterialApplProp((PhysicsProp)primitiveModelEntity);
    }

    public static ParameterEntity getLayeredProperty(Physics physics) {
        for (PhysicsProp physicsProp : physics.prop()) {
            if (!physicsProp.getProp().isLayeredMaterialApplProp(null)) continue;
            return (ParameterEntity)((Object)physicsProp);
        }
        return null;
    }

    public static TransformedInfo getTransformInfo(Material material) {
        if (material.hasPropValue("transform")) {
            TRANSFORM_TYPE tRANSFORM_TYPE = TRANSFORM_TYPE.valueOf(material.getString("transform"));
            TRANSFORM_POS tRANSFORM_POS = TRANSFORM_POS.valueOf(material.getString("mirror"));
            int n2 = 1;
            PropValue propValue = material.getPropValueInternal("repeated");
            if (propValue.getArrayErrorValue() == null) {
                n2 = Math.max(1, material.getInt("repeated"));
            }
            TransformedInfo transformedInfo = new TransformedInfo(tRANSFORM_TYPE, tRANSFORM_POS, material.getBoolean("merge"), n2);
            return transformedInfo;
        }
        return TransformedInfo.none;
    }

    public String[] getErrorMessage() {
        return this.p();
    }

    public static Material findMaterial(Model model, String string) {
        Object object;
        String string2 = "";
        String[] stringArray = FlStringUtil.split((CharSequence)string, (char)'.', (boolean)false);
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            object = stringArray[n3];
            string2 = String.valueOf(string2) + "/MaterialList/" + (String)object;
            ++n3;
        }
        object = ModelEntityUtil.findEntity(model, string2);
        return object instanceof Material ? (Material)object : null;
    }

    public static String getMatTag(Material material) {
        return ModelEntityUtil.getShortEntityPath(material, false).replace("/", ".");
    }

    public static <T> T[] transformStack(Material material, T[] TArray, BiFunction<T, TransformedInfo, T> biFunction, int n2) {
        return LayeredShellData.transformStack(TArray, LayeredShellData.getTransformInfo(material), biFunction, n2);
    }

    public static <T> T[] transformStack(T[] TArray, TransformedInfo transformedInfo, BiFunction<T, TransformedInfo, T> biFunction, int n2) {
        if (transformedInfo.getType() == TRANSFORM_TYPE.none) {
            return TArray;
        }
        Class<?> clazz = TArray.getClass().getComponentType();
        int n3 = TArray.length;
        Object[] objectArray = (Object[])Array.newInstance(clazz, transformedInfo.getSize(n3, n2));
        switch (transformedInfo.getType()) {
            case symmetry: 
            case antisymmetry: {
                switch (transformedInfo.pos) {
                    case top: {
                        int n4 = 1 - n2;
                        if (transformedInfo.mergeLayers) {
                            ++n4;
                        }
                        int n5 = 0;
                        while (n5 < n3) {
                            objectArray[n5] = TArray[n5];
                            ++n5;
                        }
                        n5 = 0;
                        while (n5 < n3 - n4) {
                            objectArray[n5 + n3] = biFunction.apply(TArray[n3 - n5 - (n4 + 1)], transformedInfo);
                            ++n5;
                        }
                        break;
                    }
                    case bottom: {
                        int n6 = n3 - (1 - n2);
                        if (transformedInfo.mergeLayers) {
                            --n6;
                        }
                        int n7 = 0;
                        while (n7 < n3) {
                            objectArray[n7 + n6] = TArray[n7];
                            ++n7;
                        }
                        n7 = 0;
                        while (n7 < n6) {
                            objectArray[n7] = biFunction.apply(TArray[n3 - n7 - 1], transformedInfo);
                            ++n7;
                        }
                        break;
                    }
                }
                return objectArray;
            }
            case repeated: {
                int n8 = 0;
                int n9 = 0;
                while (n9 < n3) {
                    objectArray[n8++] = TArray[n9];
                    ++n9;
                }
                Iterator<Integer> iterator = transformedInfo.getIterator();
                while (iterator.hasNext()) {
                    iterator.next();
                    int n10 = 0;
                    while (n10 < n3 - (1 - n2)) {
                        objectArray[n8++] = biFunction.apply(TArray[n10 + (1 - n2)], transformedInfo);
                        ++n10;
                    }
                }
                return objectArray;
            }
        }
        return TArray;
    }

    public static String[] getPositionFromThickness(String[] stringArray, boolean bl2) {
        String[] stringArray2 = new String[stringArray.length + 1];
        stringArray2[0] = "0";
        if (stringArray.length > 0) {
            stringArray2[1] = stringArray[0];
            int n2 = 2;
            while (n2 < stringArray2.length) {
                stringArray2[n2] = LayeredShellData.mergeExpressions("+", stringArray2[n2 - 1], stringArray[n2 - 1]);
                if (bl2 || stringArray2.length > 50) {
                    stringArray2[n2] = o.a((String)stringArray2[n2]);
                }
                ++n2;
            }
        }
        return stringArray2;
    }

    public static String[] getPositionFromThickness(double[] dArray) {
        double[] dArray2 = new double[dArray.length + 1];
        dArray2[0] = 0.0;
        int n2 = 1;
        while (n2 < dArray2.length) {
            dArray2[n2] = dArray2[n2 - 1] + dArray[n2 - 1];
            ++n2;
        }
        return (String[])DoubleStream.of(dArray2).boxed().map(String::valueOf).toArray(String[]::new);
    }

    public static String mergeExpressions(String string, String ... stringArray) {
        StringBuffer stringBuffer = new StringBuffer();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            String string2 = stringArray2[n3];
            if (string2 != null && !string2.isEmpty()) {
                FlStringUtil.ExpressionPart expressionPart = FlStringUtil.getExpressionPart((CharSequence)string2, (boolean)true);
                if (stringBuffer.length() != 0) {
                    stringBuffer.append(string);
                }
                if (expressionPart == FlStringUtil.ExpressionPart.j) {
                    stringBuffer.append("(").append(string2).append(")");
                } else {
                    stringBuffer.append(string2);
                }
            }
            ++n3;
        }
        return stringBuffer.toString();
    }

    public static String[] mergeExpressions(String string, String[] ... stringArray) {
        String[] stringArray2 = new String[stringArray.length];
        String[][] stringArray3 = q.d((String[][])stringArray);
        String[] stringArray4 = new String[stringArray3.length];
        int n2 = 0;
        while (n2 < stringArray3.length) {
            int n3 = 0;
            while (n3 < stringArray.length) {
                stringArray2[n3] = stringArray3[n2][n3];
                ++n3;
            }
            stringArray4[n2] = LayeredShellData.mergeExpressions(string, stringArray2);
            ++n2;
        }
        return stringArray4;
    }

    protected abstract String[] a();

    protected abstract String b();

    protected abstract String[] c();

    protected abstract String[] d();

    protected abstract String[] e();

    protected abstract String[] g();

    protected abstract double[] h();

    protected abstract String[] i();

    protected abstract String[] j();

    protected abstract String[] k();

    protected abstract String[] m();

    protected abstract String[] n();

    protected abstract int[] l();

    protected abstract TransformedInfo[] o();

    protected String[] p() {
        return null;
    }

    private static class a {
        private double a;
        private double b;

        public a(Material material, int n2) {
            block21: {
                block22: {
                    if (n2 == 0) {
                        this.a = 0.0;
                        this.b = 0.0;
                        return;
                    }
                    if (!material.hasPropValue("middlePlane")) break block22;
                    try {
                        switch (material.getString("middlePlane")) {
                            case "top": {
                                this.b = -1.0;
                                break;
                            }
                            case "bottom": {
                                this.b = 1.0;
                                break;
                            }
                            case "middle": {
                                this.b = 0.0;
                                break;
                            }
                            case "userDef": {
                                this.b = LayeredShellData.getDoubleValue(material.getString("offset"), (ModelEntity)material);
                                break;
                            }
                            default: {
                                this.a();
                            }
                        }
                        this.a = (this.b + 1.0) * (double)(n2 - 1);
                        if (this.a < 0.0) {
                            this.a = 0.0;
                        }
                        if (this.a > (double)(n2 - 1)) {
                            this.a = n2 - 1;
                        }
                        break block21;
                    }
                    catch (NumberFormatException numberFormatException) {
                        this.a();
                    }
                    break block21;
                }
                this.a();
            }
        }

        private void a() {
            this.a = 1.0;
            this.b = 0.0;
        }

        public int[] a(int n2, int n3) {
            return new int[]{n2};
        }

        public double a(LayeredShellData layeredShellData) {
            return this.a;
        }

        public String b(LayeredShellData layeredShellData) {
            String string = "(" + layeredShellData.thicknessTotal(true) + ")*0.5";
            String string2 = "(" + string + ")+(" + string + ")*(" + this.c(layeredShellData) + ")";
            try {
                double d2 = ParseUtil.c((String)string2);
                string2 = Double.toString(d2);
            }
            catch (FlException flException) {}
            return string2;
        }

        public double c(LayeredShellData layeredShellData) {
            return this.b;
        }
    }

    public static enum TRANSFORM_POS {
        bottom,
        top;

    }

    public static enum TRANSFORM_TYPE {
        none,
        symmetry,
        antisymmetry,
        repeated;

    }
}

