/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.automodeling;

import com.comsol.model.automodeling.IAutoMeshProvider;
import com.comsol.model.automodeling.IAutoMeshSuggestion;
import com.comsol.model.dbimodel.FEATURE_STATUS;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.MESH_TYPES;
import com.comsol.model.dbimodel.MeshFeature;
import com.comsol.model.dbimodel.MeshFeatureList;
import com.comsol.model.dbimodel.MeshSequence;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Selection;
import com.comsol.model.method.MeshSequenceMethod;
import com.comsol.model.operations.HAutoTable;
import com.comsol.model.operations.IPredefinedTable;
import com.comsol.nativemph.mesh.Mesh;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.w;
import com.comsol.util.classes.CsBitSet;
import com.comsol.util.classes.an;
import com.comsol.util.exceptions.FlException;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlNumberUtil;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;

public class AutoMeshManager {
    List<IAutoMeshProvider> a;
    private boolean c;
    private boolean d;
    private boolean e;
    private IAutoMeshSuggestion.MeshOptimizationLevel f = IAutoMeshSuggestion.MeshOptimizationLevel.Basic;
    private static /* synthetic */ int[] g;

    public void registerProvider(IAutoMeshProvider iAutoMeshProvider) {
        if (this.a == null) {
            this.a = new LinkedList<IAutoMeshProvider>();
        }
        if (!this.a.contains(iAutoMeshProvider)) {
            this.a.add(iAutoMeshProvider);
        }
    }

    public void unregisterProvider(IAutoMeshProvider iAutoMeshProvider) {
        if (this.a == null) {
            return;
        }
        this.a.remove(iAutoMeshProvider);
    }

    public void generateSequence(MeshSequence meshSequence) {
        int n2;
        CsBitSet csBitSet;
        IAutoMeshSuggestion[] iAutoMeshSuggestionArray;
        GeomSequence geomSequence = meshSequence.getGeom();
        MeshFeatureList<? extends MeshFeature> meshFeatureList = meshSequence.feature();
        if (geomSequence.isEmpty() && meshFeatureList.size() > 0) {
            throw new FlException("There_is_no_geometry_to_mesh");
        }
        if (meshSequence.isLockedMesh()) {
            throw new FlException("Unsupported_operation");
        }
        double d2 = Double.valueOf(meshSequence.getToolsSize()) - 5.0;
        meshFeatureList.clearKeepDefaultFeatures();
        MeshSequenceMethod meshSequenceMethod = meshSequence.method();
        if (!geomSequence.isEmpty() && !meshSequenceMethod.hasSizeDefaults()) {
            meshSequenceMethod.createMeshSizeDefaults(null);
        }
        MeshFeature meshFeature = meshSequenceMethod.getSizeDefaultFeature();
        meshSequence.setCurrentFeature(meshFeature);
        meshSequence.setLastBuiltFeature(null);
        if (geomSequence.isEmpty()) {
            return;
        }
        LinkedList<IAutoMeshSuggestion> linkedList = new LinkedList<IAutoMeshSuggestion>();
        this.c = false;
        this.d = false;
        this.e = false;
        this.f = IAutoMeshSuggestion.MeshOptimizationLevel.Basic;
        if (this.a != null) {
            for (IAutoMeshProvider object2 : this.a) {
                iAutoMeshSuggestionArray = object2.getMeshSuggestion(geomSequence);
                if (iAutoMeshSuggestionArray == null) continue;
                csBitSet = iAutoMeshSuggestionArray;
                int nArray = iAutoMeshSuggestionArray.length;
                n2 = 0;
                while (n2 < nArray) {
                    IAutoMeshSuggestion n5 = csBitSet[n2];
                    linkedList.add(n5);
                    if (n5.getOptimizeSecondOrder()) {
                        this.c = true;
                    }
                    if (n5.getOptimizeAvoidTooSmall()) {
                        this.d = true;
                    }
                    if (n5.getOptimizeAvoidTooLarge()) {
                        this.e = true;
                    }
                    if (n5.getOptimizationLevel().ordinal() > this.f.ordinal()) {
                        this.f = n5.getOptimizationLevel();
                    }
                    ++n2;
                }
            }
        }
        int[][] nArray = this.c(meshSequence, linkedList);
        meshSequence.method();
        this.a(meshSequence, linkedList);
        this.a(meshSequence, geomSequence, linkedList, d2);
        int n4 = geomSequence.getSDim();
        iAutoMeshSuggestionArray = this.a(meshSequence, geomSequence, linkedList, nArray[n4]);
        this.a(meshSequence, geomSequence, linkedList, (CsBitSet[])iAutoMeshSuggestionArray, true);
        int csBitSet2 = n4;
        while (csBitSet2 > 0) {
            n2 = csBitSet2 - 1;
            while (n2 >= 0) {
                this.a((CsBitSet)iAutoMeshSuggestionArray[csBitSet2], (CsBitSet)iAutoMeshSuggestionArray[n2], geomSequence.getAdjMesh(csBitSet2, n2));
                --n2;
            }
            --csBitSet2;
        }
        CsBitSet csBitSet3 = iAutoMeshSuggestionArray[n4].j();
        csBitSet3.g(nArray[n4]);
        csBitSet3.a(0);
        n2 = 0;
        int[] nArray2 = csBitSet3.h();
        if (nArray2.length > 0) {
            csBitSet = this.a(n4, meshSequence);
            this.a(linkedList, geomSequence, meshSequence, (CsBitSet[])iAutoMeshSuggestionArray);
            csBitSet3 = iAutoMeshSuggestionArray[n4].j();
            csBitSet3.g(nArray[n4]);
            csBitSet3.a(0);
            nArray2 = csBitSet3.h();
            if (nArray2.length > 0) {
                csBitSet.selection().geom(n4).set(nArray2);
                iAutoMeshSuggestionArray[n4].a(nArray2);
            } else {
                meshSequence.feature().remove(csBitSet.tag());
            }
            if (nArray2.length == geomSequence.getNEntitiesMesh()[n4]) {
                csBitSet.selection().remaining();
                n2 = 1;
            }
            int nArray22 = n4 - 1;
            while (nArray22 >= 0) {
                this.a((CsBitSet)iAutoMeshSuggestionArray[n4], (CsBitSet)iAutoMeshSuggestionArray[nArray22], geomSequence.getAdjMesh(n4, nArray22));
                --nArray22;
            }
        }
        if (n2 == 0) {
            Object object;
            csBitSet = iAutoMeshSuggestionArray[n4 - 1].j();
            csBitSet.g(nArray[n4 - 1]);
            csBitSet.a(0);
            int[] nArray3 = csBitSet.h();
            if (nArray3.length > 0) {
                object = this.a(n4 - 1, meshSequence);
                object.selection().geom(n4 - 1).set(nArray3);
                iAutoMeshSuggestionArray[n4 - 1].a(nArray3);
                int nArray32 = n4 - 2;
                while (nArray32 >= 0) {
                    this.a((CsBitSet)iAutoMeshSuggestionArray[n4 - 1], (CsBitSet)iAutoMeshSuggestionArray[nArray32], geomSequence.getAdjMesh(n4 - 1, nArray32));
                    --nArray32;
                }
            }
            if (n4 == 3) {
                object = iAutoMeshSuggestionArray[1].j();
                object.g(nArray[1]);
                object.a(0);
                int[] meshFeature3 = object.h();
                if (meshFeature3.length > 0) {
                    MeshFeature meshFeature2 = this.a(1, meshSequence);
                    meshFeature2.selection().geom(1).set(meshFeature3);
                    iAutoMeshSuggestionArray[1].a(meshFeature3);
                }
            }
            if (n4 > 1) {
                iAutoMeshSuggestionArray[0].g(nArray[0]);
                iAutoMeshSuggestionArray[0].a(0);
                this.a((CsBitSet)iAutoMeshSuggestionArray[1], (CsBitSet)iAutoMeshSuggestionArray[0], geomSequence.getAdjMesh(1, 0));
                object = iAutoMeshSuggestionArray[0].h();
                if (((Object)object).length > 0) {
                    MeshFeature meshFeature3 = this.a(0, meshSequence);
                    meshFeature3.selection().geom(0).set((int[])object);
                    iAutoMeshSuggestionArray[0].a((int[])object);
                }
            }
        }
        this.a(meshSequence, geomSequence, linkedList, (CsBitSet[])iAutoMeshSuggestionArray, false);
        this.b(meshSequence, linkedList);
    }

    private void a(MeshSequence meshSequence, List<IAutoMeshSuggestion> list) {
        Object object;
        TreeMap<Integer, Integer> treeMap = new TreeMap<Integer, Integer>();
        GeomSequence geomSequence = meshSequence.getGeom();
        int n2 = geomSequence.getSDim();
        for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
            IAutoMeshSuggestion.EdgeDistribution[] edgeDistributionArray = iAutoMeshSuggestion.getEdgeDistributions();
            if (edgeDistributionArray == null) continue;
            Object object2 = edgeDistributionArray;
            int n3 = ((Object)object2).length;
            int n4 = 0;
            while (n4 < n3) {
                object = object2[n4];
                int[] nArray = geomSequence.mapGeomToMeshGeom(1, ((IAutoMeshSuggestion.EdgeDistribution)object).a);
                int n5 = nArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    int n7 = nArray[n6];
                    if (!(((IAutoMeshSuggestion.EdgeDistribution)object).c && (n2 == 3 && geomSequence.getAdjMesh(1, 3, n7).length > 0 || n2 == 2 && geomSequence.getAdjMesh(1, 2, n7).length > 0))) {
                        if (treeMap.containsKey(n7)) {
                            treeMap.put(n7, Math.max(((IAutoMeshSuggestion.EdgeDistribution)object).b, (Integer)treeMap.get(n7)));
                        } else {
                            treeMap.put(n7, ((IAutoMeshSuggestion.EdgeDistribution)object).b);
                        }
                    }
                    ++n6;
                }
                ++n4;
            }
        }
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        for (Map.Entry entry : treeMap.entrySet()) {
            object = (MeshFeature)hashMap.get(entry.getValue());
            if (object == null) {
                object = meshSequence.create(meshSequence.feature().uniquetag("distr"), "Distribution");
                object.selection().geom(1);
                object.set("numelem", (Integer)entry.getValue());
                hashMap.put((Integer)entry.getValue(), object);
            }
            object.selection().add((Integer)entry.getKey());
        }
    }

    private void a(CsBitSet csBitSet, CsBitSet csBitSet2, int[][] nArray) {
        int[] nArray2 = csBitSet.g();
        int n2 = nArray2.length;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray2[n3];
            if (n4 > 0) {
                csBitSet2.h(nArray[n4]);
            }
            ++n3;
        }
    }

    private void a(List<IAutoMeshSuggestion> list, GeomSequence geomSequence, MeshSequence meshSequence, CsBitSet[] csBitSetArray) {
        int n2 = geomSequence.getSDim();
        MeshFeature meshFeature = null;
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        ArrayList<IAutoMeshSuggestion.LayerDomains> arrayList = new ArrayList<IAutoMeshSuggestion.LayerDomains>();
        for (IAutoMeshSuggestion object : list) {
            if (object.getStructuredLayerDomain() == null) continue;
            for (IAutoMeshSuggestion.LayerDomains layerDomains : object.getStructuredLayerDomain()) {
                arrayList.add(layerDomains);
            }
        }
        Collections.sort(arrayList);
        for (IAutoMeshSuggestion.LayerDomains layerDomains : arrayList) {
            if (meshFeature == null) {
                meshFeature = this.a(n2, meshSequence.feature(), layerDomains);
                if (n2 == 2) {
                    meshFeature.set("adjustedgdistr", "on");
                }
                meshFeature.selection().geom(n2);
            }
            int[] nArray = geomSequence.info().mapGeomToMeshGeom(n2, layerDomains.a);
            meshFeature.selection().add(nArray);
            csBitSetArray[n2].a(nArray);
            if (n2 != 3 || layerDomains.b <= 0) continue;
            if (!hashMap.containsKey(layerDomains.b)) {
                MeshFeature meshFeature2 = meshFeature.create(meshFeature.feature().uniquetag("dis"), "Distribution");
                meshFeature2.selection().geom(n2);
                meshFeature2.set("numelem", layerDomains.b);
                hashMap.put(layerDomains.b, meshFeature2);
            }
            ((MeshFeature)hashMap.get(layerDomains.b)).selection().add(nArray);
        }
    }

    CsBitSet[] a(GeomSequence geomSequence) {
        CsBitSet[] csBitSetArray = new CsBitSet[geomSequence.getSDim() + 1];
        int[] nArray = geomSequence.getNEntitiesMesh();
        int n2 = 0;
        while (n2 < csBitSetArray.length) {
            csBitSetArray[n2] = new CsBitSet(nArray[n2] + 1);
            ++n2;
        }
        return csBitSetArray;
    }

    private CsBitSet[] a(MeshSequence meshSequence, GeomSequence geomSequence, List<IAutoMeshSuggestion> list, int[] nArray) {
        int[] nArray2;
        int n2;
        int n3;
        int n4;
        int[] nArray3;
        CsBitSet csBitSet;
        Object object;
        Object object2;
        HashSet<Integer> hashSet;
        int n5 = geomSequence.getSDim();
        if (n5 <= 1) {
            return this.a(geomSequence);
        }
        HashSet[] hashSetArray = new HashSet[n5];
        boolean[] blArray = new boolean[geomSequence.getNEntities()[2] + 1];
        LinkedHashSet[] linkedHashSetArray = new LinkedHashSet[n5];
        int n6 = 1;
        while (n6 < n5) {
            hashSetArray[n6] = hashSet = new HashSet<Integer>();
            object2 = new LinkedHashSet();
            linkedHashSetArray[n6] = object2;
            for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
                Object object3;
                Object object4;
                object = iAutoMeshSuggestion.getBoundaryIdentitySets(n5, n6);
                if (object != null) {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        int[] nArray4;
                        object4 = (IAutoMeshSuggestion.BoundaryIdentitySet)iterator.next();
                        int[] nArray5 = geomSequence.mapGeomToMeshGeom(n6, object4.a);
                        if (nArray5.length < (nArray4 = geomSequence.mapGeomToMeshGeom(n6, object4.b)).length) {
                            object4 = new IAutoMeshSuggestion.BoundaryIdentitySet(object4.b, object4.a);
                            object3 = nArray5;
                            nArray5 = nArray4;
                            nArray4 = object3;
                        }
                        object3 = this.a(meshSequence, n6, new IAutoMeshSuggestion.BoundaryIdentitySet(nArray5, nArray4));
                        csBitSet = null;
                        if (object3.l("successTargets")) {
                            csBitSet = (CsBitSet)object3.H("successTargets");
                        }
                        if (csBitSet == null || ((Object)csBitSet).length != nArray4.length) continue;
                        nArray3 = object4.b;
                        n4 = object4.b.length;
                        n3 = 0;
                        while (n3 < n4) {
                            n2 = nArray3[n3];
                            hashSet.add(n2);
                            ++n3;
                        }
                        object2.add(object4);
                    }
                }
                if (n6 != n5 - 1 || (object4 = iAutoMeshSuggestion.getStructuredMeshEntities(2)) == null) continue;
                object3 = object4;
                int n7 = ((int[])object4).length;
                int n8 = 0;
                while (n8 < n7) {
                    int n9 = object3[n8];
                    blArray[n9] = true;
                    ++n8;
                }
            }
            ++n6;
        }
        int[] nArray6 = this.a(list, geomSequence);
        hashSet = new HashSet();
        object = nArray;
        int n10 = nArray.length;
        int n11 = 0;
        while (n11 < n10) {
            int n12 = object[n11];
            hashSet.add(n12);
            ++n11;
        }
        object2 = this.a(nArray6, hashSet, geomSequence);
        int[] nArray7 = this.a(nArray6, hashSet, (boolean[])object2, geomSequence);
        boolean[] blArray2 = null;
        if (n5 == 3) {
            blArray2 = this.a(nArray6, nArray7, geomSequence);
        }
        object = new ArrayList[n5];
        int n13 = 1;
        while (n13 < n5) {
            object[n13] = new ArrayList();
            while (!linkedHashSetArray[n13].isEmpty()) {
                Iterator iterator;
                boolean bl2 = false;
                csBitSet = linkedHashSetArray[n13].toArray(new IAutoMeshSuggestion.BoundaryIdentitySet[0]);
                int n14 = ((IAutoMeshSuggestion.BoundaryIdentitySet[])csBitSet).length;
                int n15 = 0;
                while (n15 < n14) {
                    iterator = csBitSet[n15];
                    n2 = 1;
                    nArray2 = ((IAutoMeshSuggestion.BoundaryIdentitySet)((Object)iterator)).a;
                    int n16 = ((IAutoMeshSuggestion.BoundaryIdentitySet)((Object)iterator)).a.length;
                    n4 = 0;
                    while (n4 < n16) {
                        n3 = nArray2[n4];
                        if (hashSetArray[n13].contains(n3)) {
                            n2 = 0;
                            break;
                        }
                        ++n4;
                    }
                    if (n2 != 0) {
                        bl2 = true;
                        object[n13].add(iterator);
                        nArray2 = ((IAutoMeshSuggestion.BoundaryIdentitySet)((Object)iterator)).b;
                        n16 = ((IAutoMeshSuggestion.BoundaryIdentitySet)((Object)iterator)).b.length;
                        n4 = 0;
                        while (n4 < n16) {
                            n3 = nArray2[n4];
                            hashSetArray[n13].remove(n3);
                            ++n4;
                        }
                        linkedHashSetArray[n13].remove(iterator);
                    }
                    ++n15;
                }
                if (bl2) continue;
                iterator = linkedHashSetArray[n13].iterator();
                object[n13].add((IAutoMeshSuggestion.BoundaryIdentitySet)iterator.next());
                iterator.remove();
            }
            ++n13;
        }
        CsBitSet[] csBitSetArray = this.a(geomSequence);
        int n17 = 1;
        while (n17 < nArray7.length) {
            if (nArray7[n17] > 0) {
                MeshFeature meshFeature = meshSequence.create(meshSequence.feature().uniquetag("dis"), "Distribution");
                meshFeature.selection().geom(1);
                int n18 = nArray7[n17];
                meshFeature.set("type", "predefined");
                meshFeature.set("elemcount", n18);
                int n19 = n17;
                while (n19 < nArray7.length) {
                    if (nArray7[n19] == n18) {
                        meshFeature.selection().add(n19);
                        nArray7[n19] = -1;
                    }
                    ++n19;
                }
            }
            ++n17;
        }
        MeshFeatureList<? extends MeshFeature> meshFeatureList = meshSequence.feature();
        if (n5 == 3) {
            MeshFeature meshFeature = null;
            CsBitSet csBitSet2 = csBitSetArray[1];
            csBitSet = object[1].iterator();
            while (csBitSet.hasNext()) {
                IAutoMeshSuggestion.BoundaryIdentitySet boundaryIdentitySet = (IAutoMeshSuggestion.BoundaryIdentitySet)csBitSet.next();
                if (boundaryIdentitySet.b.length == 0) continue;
                nArray3 = boundaryIdentitySet.a;
                n4 = boundaryIdentitySet.a.length;
                int n20 = 0;
                while (n20 < n4) {
                    int n21 = nArray3[n20];
                    if (!csBitSet2.b(n21)) {
                        nArray2 = geomSequence.mapGeomToMeshGeom(1, new int[]{n21});
                        if (meshFeature == null) {
                            meshFeature = this.a(1, meshSequence);
                        }
                        meshFeature.selection().add(nArray2);
                    }
                    ++n20;
                }
                if (csBitSet2.b(boundaryIdentitySet.b[0])) continue;
                int[] nArray8 = geomSequence.mapGeomToMeshGeom(1, boundaryIdentitySet.b);
                MeshFeature meshFeature2 = meshFeatureList.create(meshFeatureList.uniquetag("copy"), "Copy");
                meshFeature2.set("dimension", 1);
                meshFeature2.selection("source").set(geomSequence.mapGeomToMeshGeom(1, boundaryIdentitySet.a));
                meshFeature2.selection("destination").set(nArray8);
                csBitSet2.a(nArray8);
            }
        }
        CsBitSet csBitSet3 = csBitSetArray[n5 - 1];
        MeshFeature meshFeature = null;
        MeshFeature meshFeature3 = this.a(n5 - 1, meshSequence);
        meshFeature3.selection().geom(n5 - 1);
        csBitSet = new CsBitSet(geomSequence.getNEdges() + 1);
        Iterator iterator = object[n5 - 1].iterator();
        while (iterator.hasNext()) {
            IAutoMeshSuggestion.BoundaryIdentitySet boundaryIdentitySet = (IAutoMeshSuggestion.BoundaryIdentitySet)iterator.next();
            if (boundaryIdentitySet.b.length == 0) continue;
            n4 = 0;
            int[] nArray9 = boundaryIdentitySet.a;
            int n22 = boundaryIdentitySet.a.length;
            int n23 = 0;
            while (n23 < n22) {
                int n24 = nArray9[n23];
                if (!csBitSet3.b(n24)) {
                    int[] nArray10 = geomSequence.mapGeomToMeshGeom(n5 - 1, new int[]{n24});
                    boolean bl3 = false;
                    if (n5 == 3) {
                        int[] nArray11 = geomSequence.getAdj(2, 1, n24);
                        int n25 = nArray11.length;
                        int n26 = 0;
                        while (n26 < n25) {
                            int n27 = nArray11[n26];
                            if (csBitSet.b(n27)) {
                                bl3 = true;
                            }
                            ++n26;
                        }
                    }
                    if (bl3 && n4 == 0) {
                        meshFeature3 = this.a(2, meshSequence);
                        meshFeature = null;
                        n4 = 1;
                    }
                    if (n5 == 3 && (blArray[n24] || blArray2[n24])) {
                        if (meshFeature == null) {
                            meshFeature = this.a(meshSequence);
                        }
                        meshFeature.selection().add(nArray10);
                    } else {
                        meshFeature3.selection().add(nArray10);
                    }
                    csBitSet3.a(nArray10);
                }
                ++n23;
            }
            if (csBitSet3.b(boundaryIdentitySet.b[0])) continue;
            int[] nArray12 = geomSequence.mapGeomToMeshGeom(n5 - 1, boundaryIdentitySet.b);
            MeshFeature meshFeature4 = meshFeatureList.create(meshFeatureList.uniquetag("copy"), "Copy");
            meshFeature4.set("dimension", n5 - 1);
            meshFeature4.selection("source").set(geomSequence.mapGeomToMeshGeom(n5 - 1, boundaryIdentitySet.a));
            meshFeature4.selection("destination").set(nArray12);
            csBitSet3.a(nArray12);
            if (n5 != 3) continue;
            int[] nArray13 = boundaryIdentitySet.b;
            int n28 = boundaryIdentitySet.b.length;
            int n29 = 0;
            while (n29 < n28) {
                n22 = nArray13[n29];
                csBitSet.h(geomSequence.getAdj(2, 1, n22));
                ++n29;
            }
        }
        if (meshFeature3.selection().isEmpty()) {
            meshSequence.feature().remove(meshFeature3.tag());
        }
        meshFeature3 = null;
        meshFeature = null;
        int n30 = 1;
        while (n30 < blArray.length) {
            if (blArray[n30] && !csBitSetArray[2].b(n30)) {
                if (meshFeature == null) {
                    meshFeature = this.a(meshSequence);
                }
                meshFeature.selection().add(n30);
            }
            ++n30;
        }
        return csBitSetArray;
    }

    private w a(MeshSequence meshSequence, int n2, IAutoMeshSuggestion.BoundaryIdentitySet boundaryIdentitySet) {
        int n3 = meshSequence.getSDim();
        if (boundaryIdentitySet.a.length < boundaryIdentitySet.b.length) {
            boundaryIdentitySet = new IAutoMeshSuggestion.BoundaryIdentitySet(boundaryIdentitySet.b, boundaryIdentitySet.a);
        }
        w w2 = new w();
        try {
            Mesh mesh = new Mesh(n3);
            w w3 = new w();
            int[] nArray = (int[])boundaryIdentitySet.a.clone();
            int[] nArray2 = (int[])boundaryIdentitySet.b.clone();
            int n4 = 0;
            while (n4 < nArray.length) {
                int n5 = n4++;
                nArray[n5] = nArray[n5] - 1;
            }
            n4 = 0;
            while (n4 < nArray2.length) {
                int n6 = n4++;
                nArray2[n6] = nArray2[n6] - 1;
            }
            w3.a("target", nArray2);
            w3.a("source", nArray);
            w3.b("copydimension", n2);
            w3.b("setupmappingonly", "on");
            mesh.a(meshSequence.getGeom().getGeom(), w3, w2, null);
        }
        catch (FlException flException) {}
        return w2;
    }

    private int[] a(int[] nArray, HashSet hashSet, boolean[] blArray, GeomSequence geomSequence) {
        int[] nArray2;
        int n2;
        int n3;
        int n4 = geomSequence.getSDim();
        int[][] nArray3 = geomSequence.getAdj(1, n4);
        HashSet<Integer> hashSet2 = new HashSet<Integer>();
        int[][] nArray4 = geomSequence.getAdj(0, 1);
        int n5 = 1;
        while (n5 < blArray.length) {
            if (blArray[n5]) {
                int n6 = 0;
                while (n6 < nArray4[n5].length) {
                    hashSet2.add(nArray4[n5][n6]);
                    ++n6;
                }
            }
            ++n5;
        }
        an an2 = new an();
        an an3 = new an();
        int[] nArray5 = new int[nArray3.length];
        int n7 = 1;
        while (n7 < nArray5.length) {
            int[] nArray6 = nArray3[n7];
            boolean bl2 = true;
            n3 = 0;
            while (n3 < nArray6.length) {
                n2 = nArray6[n3];
                if (n2 > 0 && hashSet.contains(n2) && nArray[n2] == 0) {
                    bl2 = false;
                    break;
                }
                ++n3;
            }
            if (bl2) {
                an2.add(n7);
                if (hashSet2.contains(n7)) {
                    an3.add(n7);
                }
            }
            ++n7;
        }
        double d2 = Math.PI * 5 / (180.0 * geomSequence.getRadians(1.0));
        int[] nArray7 = nArray2 = geomSequence.fillContinuousAdjacencyClasses(an3.toArray(), d2, 1, an2.toArray());
        int n8 = nArray2.length;
        n2 = 0;
        while (n2 < n8) {
            n3 = nArray7[n2];
            int[] nArray8 = nArray3[n3];
            int n9 = -1;
            int n10 = 0;
            while (n10 < nArray8.length) {
                int n11 = nArray8[n10];
                if (n11 > 0 && hashSet.contains(n11)) {
                    assert (nArray[n11] != 0);
                    n9 = Math.max(n9, nArray[n11]);
                }
                ++n10;
            }
            nArray5[n3] = n9;
            ++n2;
        }
        return nArray5;
    }

    private boolean[] a(int[] nArray, int[] nArray2, GeomSequence geomSequence) {
        int[][] nArray3 = geomSequence.getUpDown();
        boolean[] blArray = new boolean[nArray3[0].length + 1];
        int n2 = 1;
        while (n2 <= nArray3[0].length) {
            if (nArray3[0][n2 - 1] != nArray3[1][n2 - 1]) {
                boolean bl2;
                boolean bl3 = nArray3[0][n2 - 1] == 0 || nArray[nArray3[0][n2 - 1]] != 0;
                boolean bl4 = bl2 = nArray3[1][n2 - 1] == 0 || nArray[nArray3[1][n2 - 1]] != 0;
                if (bl3 && bl2) {
                    int[] nArray4 = geomSequence.getAdj(2, 1, n2);
                    int n3 = 0;
                    while (n3 < nArray4.length) {
                        if (nArray2[nArray4[n3]] != 0) {
                            blArray[n2] = true;
                            break;
                        }
                        ++n3;
                    }
                }
            }
            ++n2;
        }
        return blArray;
    }

    private boolean[] a(int[] nArray, HashSet hashSet, GeomSequence geomSequence) {
        int n2 = geomSequence.getSDim();
        int[][] nArray2 = geomSequence.getAdj(0, n2);
        boolean[] blArray = new boolean[nArray2.length];
        int n3 = 1;
        while (n3 < blArray.length) {
            int[] nArray3 = nArray2[n3];
            boolean bl2 = false;
            boolean bl3 = false;
            int n4 = 0;
            while (n4 < nArray3.length) {
                int n5 = nArray3[n4];
                if (n5 > 0) {
                    if (nArray[n5] != 0) {
                        bl2 = true;
                    } else if (hashSet.contains(n5)) {
                        bl3 = true;
                    }
                }
                ++n4;
            }
            if (bl3 && bl2) {
                blArray[n3] = true;
            }
            ++n3;
        }
        return blArray;
    }

    private int[] a(List<IAutoMeshSuggestion> list, GeomSequence geomSequence) {
        int[] nArray = new int[geomSequence.getNDomains() + 1];
        for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
            if (iAutoMeshSuggestion.getStructuredLayerDomain() == null) continue;
            for (IAutoMeshSuggestion.LayerDomains layerDomains : iAutoMeshSuggestion.getStructuredLayerDomain()) {
                int[] nArray2 = layerDomains.a;
                int n2 = layerDomains.a.length;
                int n3 = 0;
                while (n3 < n2) {
                    int n4 = nArray2[n3];
                    if (layerDomains.b > 0) {
                        nArray[n4] = Math.max(nArray[n4], layerDomains.b);
                    } else if (nArray[n4] == 0) {
                        nArray[n4] = -1;
                    }
                    ++n3;
                }
            }
        }
        return nArray;
    }

    /*
     * WARNING - void declaration
     */
    private void a(MeshSequence meshSequence, GeomSequence geomSequence, List<IAutoMeshSuggestion> list, CsBitSet[] csBitSetArray, boolean bl2) {
        void var14_19;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        Object object6;
        Object object7;
        int n3 = geomSequence.getSDim();
        TreeMap treeMap = new TreeMap();
        int[][] nArray = null;
        HashMap hashMap = new HashMap();
        HashMap hashMap2 = new HashMap();
        HashMap<Integer, IAutoMeshSuggestion.SharpCornersMethod> hashMap3 = new HashMap<Integer, IAutoMeshSuggestion.SharpCornersMethod>();
        MeshFeature meshFeature = null;
        MeshFeatureList<? extends MeshFeature> meshFeatureList = meshSequence.feature();
        for (IAutoMeshSuggestion object82 : list) {
            object7 = object82.getBoundaryLayers();
            if (object7 == null) continue;
            object6 = object7;
            int n4 = ((IAutoMeshSuggestion.BoundaryLayer[])object7).length;
            int n5 = 0;
            while (n5 < n4) {
                object5 = object6[n5];
                object4 = geomSequence.mapGeomToMeshGeom(n3, ((IAutoMeshSuggestion.BoundaryLayer)object5).getDomain());
                if (((IAutoMeshSuggestion.BoundaryLayer)object5).f && bl2) {
                    if (meshFeature == null) {
                        meshFeature = meshFeatureList.create(meshFeatureList.uniquetag("cr"), "CornerRefinement");
                        meshFeature.selection().geom(n3);
                        hashMap2.put(meshFeature.selection(), new HashSet());
                        hashMap2.put(meshFeature.selection("boundary"), new HashSet());
                    }
                    ((HashSet)hashMap2.get(meshFeature.selection())).addAll(Arrays.stream((int[])object4).boxed().collect(Collectors.toList()));
                    object3 = geomSequence.mapGeomToMeshGeom(n3 - 1, ((IAutoMeshSuggestion.BoundaryLayer)object5).getBoundaries());
                    ((HashSet)hashMap2.get(meshFeature.selection("boundary"))).addAll(Arrays.stream((int[])object3).boxed().collect(Collectors.toList()));
                }
                object2 = object4;
                int n6 = ((int[])object4).length;
                int n7 = 0;
                while (n7 < n6) {
                    int n8;
                    int n9;
                    int n10 = object2[n7];
                    hashMap3.put(n10, ((IAutoMeshSuggestion.BoundaryLayer)object5).e);
                    object = (HashSet<Integer>)hashMap.get(n10);
                    if (object == null) {
                        if (nArray == null) {
                            nArray = geomSequence.getAdjMesh(geomSequence.getSDim(), geomSequence.getSDim() - 1);
                        }
                        object = new HashSet<Integer>();
                        void var30_51 = nArray[n10];
                        n9 = ((void)var30_51).length;
                        n8 = 0;
                        while (n8 < n9) {
                            void var27_43 = var30_51[n8];
                            ((HashSet)object).add((int)var27_43);
                            ++n8;
                        }
                        hashMap.put(n10, object);
                    }
                    if (treeMap.get(n10) == null) {
                        treeMap.put(n10, new TreeMap());
                    }
                    Object object8 = (Map)treeMap.get(n10);
                    int[] nArray2 = geomSequence.mapGeomToMeshGeom(n3 - 1, ((IAutoMeshSuggestion.BoundaryLayer)object5).getBoundaries());
                    int n11 = nArray2.length;
                    n9 = 0;
                    while (n9 < n11) {
                        n8 = nArray2[n9];
                        if (((HashSet)object).contains(n8)) {
                            object8.put(n8, object5);
                        }
                        ++n9;
                    }
                    ++n7;
                }
                ++n5;
            }
        }
        if (bl2) {
            for (Map.Entry entry : hashMap2.entrySet()) {
                object7 = ((HashSet)entry.getValue()).stream().mapToInt(n2 -> n2).toArray();
                ((Selection)entry.getKey()).add((int[])object7);
            }
            return;
        }
        Object var14_18 = null;
        Object object10 = null;
        object7 = new HashSet();
        object5 = new HashMap();
        for (Map.Entry entry : treeMap.entrySet()) {
            object6 = (Map)entry.getValue();
            object4 = (Object)((IAutoMeshSuggestion.SharpCornersMethod)((Object)hashMap3.get(entry.getKey())));
            object3 = null;
            switch (AutoMeshManager.a()[((Enum)object4).ordinal()]) {
                case 1: {
                    object3 = "split";
                    break;
                }
                case 2: {
                    object3 = "trim";
                    break;
                }
                case 3: {
                    object3 = "none";
                }
            }
            Object object9 = object7.iterator();
            while (object9.hasNext()) {
                Integer n12 = (Integer)object9.next();
                if (!object6.containsKey(n12)) continue;
                if (var14_19 != null && var14_19.selection().isEmpty()) {
                    meshSequence.feature().remove(var14_19.tag());
                }
                Object var14_20 = null;
                object10 = null;
                break;
            }
            if (object10 != null && !object10.getString("sharpcorners").equals(object3)) {
                object10 = null;
            }
            if (var14_19 == null) {
                MeshFeature meshFeature2 = this.a(geomSequence.getSDim(), meshSequence);
                meshFeature2.selection().geom(n3);
                hashMap2.put(meshFeature2.selection(), new HashSet());
            }
            if (object10 == null) {
                object10 = meshFeatureList.create(meshFeatureList.uniquetag("bl"), "BndLayer");
                object10.selection().geom(n3);
                hashMap2.put(object10.selection(), new HashSet());
                object10.set("sharpcorners", (String)object3);
                object7.clear();
                ((HashMap)object5).clear();
            }
            if (!csBitSetArray[n3].b(((Integer)entry.getKey()).intValue())) {
                ((HashSet)hashMap2.get(var14_19.selection())).add((Integer)entry.getKey());
            }
            ((HashSet)hashMap2.get(object10.selection())).add((Integer)entry.getKey());
            csBitSetArray[n3].a(((Integer)entry.getKey()).intValue());
            LinkedHashSet linkedHashSet = new LinkedHashSet();
            linkedHashSet.addAll(object6.values());
            object2 = linkedHashSet.iterator();
            while (object2.hasNext()) {
                object9 = (IAutoMeshSuggestion.BoundaryLayer)object2.next();
                object = (MeshFeature)((HashMap)object5).get(object9);
                if (object == null) {
                    object = object10.create(object10.feature().uniquetag("blp"), "BndLayerProp");
                    object.selection().geom(n3 - 1);
                    hashMap2.put(object.selection(), new HashSet());
                    object.set("blnlayers", ((IAutoMeshSuggestion.BoundaryLayer)object9).b);
                    object.set("blstretch", ((IAutoMeshSuggestion.BoundaryLayer)object9).a);
                    if (((IAutoMeshSuggestion.BoundaryLayer)object9).d == null) {
                        object.set("blhminfact", ((IAutoMeshSuggestion.BoundaryLayer)object9).c);
                    } else {
                        object.set("inittype", "blhmin");
                        object.set("blhmin", ((IAutoMeshSuggestion.BoundaryLayer)object9).d);
                    }
                    ((HashMap)object5).put(object9, object);
                }
                for (Object object8 : object6.keySet()) {
                    IAutoMeshSuggestion.BoundaryLayer boundaryLayer = (IAutoMeshSuggestion.BoundaryLayer)object6.get(object8);
                    if (!boundaryLayer.equals(object9)) continue;
                    ((HashSet)hashMap2.get(object.selection())).add(object8);
                }
            }
        }
        for (Map.Entry entry : hashMap2.entrySet()) {
            object6 = ((HashSet)entry.getValue()).stream().mapToInt(n2 -> n2).toArray();
            ((Selection)entry.getKey()).add((int[])object6);
        }
        if (var14_19 != null && var14_19.selection().isEmpty()) {
            meshSequence.feature().remove(var14_19.tag());
        }
    }

    /*
     * WARNING - void declaration
     */
    private void a(MeshSequence meshSequence, GeomSequence geomSequence, List<IAutoMeshSuggestion> list, double d2) {
        void var15_19;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        MeshFeatureList<? extends MeshFeature> meshFeatureList = meshSequence.feature();
        int n2 = geomSequence.getSDim();
        double[][] dArrayArray = new double[n2 + 1][];
        String[][] stringArrayArray = new String[n2 + 1][];
        IAutoMeshSuggestion.PreferredTable[][] preferredTableArrayArray = new IAutoMeshSuggestion.PreferredTable[n2 + 1][];
        int[] nArray = geomSequence.getNEntitiesMesh();
        int n3 = 0;
        while (n3 <= n2) {
            dArrayArray[n3] = new double[nArray[n3]];
            int n4 = 0;
            while (n4 < dArrayArray[n3].length) {
                dArrayArray[n3][n4] = Double.POSITIVE_INFINITY;
                ++n4;
            }
            stringArrayArray[n3] = new String[nArray[n3]];
            preferredTableArrayArray[n3] = new IAutoMeshSuggestion.PreferredTable[nArray[n3]];
            ++n3;
        }
        String string = null;
        IAutoMeshSuggestion.PreferredTable preferredTable = null;
        for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
            int treeSet2 = 0;
            while (treeSet2 <= n2) {
                IAutoMeshSuggestion.PreferredTable[] preferredTableArray;
                object5 = this.a(geomSequence, treeSet2, iAutoMeshSuggestion.getMaximalElementsSize(treeSet2));
                if (object5 != null) {
                    void var18_31;
                    boolean bl2 = false;
                    while (var18_31 < ((Object)object5).length) {
                        double d3;
                        if (object5[var18_31] != null && (d3 = Double.parseDouble((String)object5[var18_31])) < dArrayArray[treeSet2][var18_31]) {
                            dArrayArray[treeSet2][var18_31] = d3;
                            String string2 = object5[var18_31];
                            stringArrayArray[treeSet2][var18_31] = string2;
                            string = string2;
                        }
                        ++var18_31;
                    }
                }
                if ((preferredTableArray = this.a(geomSequence, treeSet2, iAutoMeshSuggestion.getPreferredTable(treeSet2))) != null) {
                    int n4 = 0;
                    while (n4 < preferredTableArray.length) {
                        if (preferredTableArray[n4] != null) {
                            preferredTableArray[n4].a(meshSequence, d2);
                            if (preferredTableArrayArray[treeSet2][n4] == null || preferredTableArrayArray[treeSet2][n4].compareTo(preferredTableArray[n4]) < 0) {
                                preferredTableArrayArray[treeSet2][n4] = preferredTableArray[n4];
                            }
                            if (preferredTable == null || preferredTable.compareTo(preferredTableArray[n4]) > 0) {
                                preferredTable = preferredTableArray[n4];
                            }
                        }
                        ++n4;
                    }
                }
                ++treeSet2;
            }
        }
        int n5 = 1;
        while (n5 < n2) {
            for (IAutoMeshSuggestion treeSet : list) {
                object5 = treeSet.getBoundaryIdentitySets(n2, n5);
                if (object5 == null) continue;
                for (IAutoMeshSuggestion.BoundaryIdentitySet boundaryIdentitySet : object5) {
                    int[] nArray2 = geomSequence.mapGeomToMeshGeom(n5, boundaryIdentitySet.a);
                    int[] nArray3 = geomSequence.mapGeomToMeshGeom(n5, boundaryIdentitySet.b);
                    w w2 = this.a(meshSequence, n5, new IAutoMeshSuggestion.BoundaryIdentitySet(nArray2, nArray3));
                    object4 = null;
                    object3 = null;
                    if (!w2.l("successTargets")) continue;
                    object4 = w2.H("successTargets");
                    object3 = w2.N("sourcesForTargets");
                    int n6 = 0;
                    while (n6 < ((int[])object4).length) {
                        Object object6;
                        object2 = q.a((int[][])new int[][]{(int[])object3[n6], {object4[n6]}});
                        object2 = q.b((int[])object2, (int)1);
                        object = null;
                        double d4 = Double.POSITIVE_INFINITY;
                        String string3 = null;
                        Object object7 = n5;
                        while (object7 <= n2) {
                            int[] nArray4 = null;
                            Object object8 = object2;
                            int n7 = ((Object)object8).length;
                            int n8 = 0;
                            while (n8 < n7) {
                                object6 = object8[n8];
                                nArray4 = object7 != n5 ? geomSequence.getAdjMesh(n5, (int)object7, (int)object6) : new int[]{object6};
                                int[] nArray5 = nArray4;
                                int n9 = nArray4.length;
                                int n10 = 0;
                                while (n10 < n9) {
                                    int n11 = nArray5[n10];
                                    if (preferredTableArrayArray[object7][n11 - 1] != null && (object == null || object.compareTo(preferredTableArrayArray[object7][n11 - 1]) < 0)) {
                                        object = preferredTableArrayArray[object7][n11 - 1];
                                    }
                                    if (dArrayArray[object7][n11 - 1] < d4) {
                                        d4 = dArrayArray[object7][n11 - 1];
                                        string3 = stringArrayArray[object7][n11 - 1];
                                    }
                                    ++n10;
                                }
                                ++n8;
                            }
                            ++object7;
                        }
                        Object object9 = object2;
                        object6 = ((Object)object9).length;
                        int n12 = 0;
                        while (n12 < object6) {
                            object7 = object9[n12];
                            if (object != null && (preferredTableArrayArray[n5][object7 - 1] == null || preferredTableArrayArray[n5][object7 - 1].compareTo((IAutoMeshSuggestion.PreferredTable)object) < 0)) {
                                preferredTableArrayArray[n5][object7 - 1] = object;
                            }
                            if (d4 < dArrayArray[n5][object7 - 1]) {
                                dArrayArray[n5][object7 - 1] = d4;
                                stringArrayArray[n5][object7 - 1] = string3;
                            }
                            ++n12;
                        }
                        ++n6;
                    }
                }
            }
            ++n5;
        }
        IAutoMeshSuggestion.PreferredTable preferredTable2 = new IAutoMeshSuggestion.PreferredTable(0, new int[0], 5, HAutoTable.PredefinedTables.DEFAULT);
        preferredTable2.a(meshSequence, d2);
        boolean bl3 = false;
        while (var15_19 < preferredTableArrayArray[n2].length) {
            if (preferredTableArrayArray[n2][var15_19] == null) {
                preferredTableArrayArray[n2][var15_19] = preferredTable2;
            }
            ++var15_19;
        }
        TreeSet<Double> treeSet = new TreeSet<Double>(new Comparator<Double>(){

            public int a(Double d2, Double d3) {
                return d3.compareTo(d2);
            }

            @Override
            public /* synthetic */ int compare(Object object, Object object2) {
                return this.a((Double)object, (Double)object2);
            }
        });
        TreeSet<Object> treeSet2 = new TreeSet<Object>();
        object5 = new boolean[n2 + 1];
        boolean[] blArray = new boolean[n2 + 1];
        int n13 = 0;
        while (n13 <= n2) {
            object3 = dArrayArray[n13];
            int n14 = ((double[])object3).length;
            int n15 = 0;
            while (n15 < n14) {
                double d5 = object3[n15];
                if (d5 < Double.POSITIVE_INFINITY) {
                    treeSet.add(d5);
                    blArray[n13] = true;
                } else {
                    object5[n13] = (String)true;
                }
                ++n15;
            }
            IAutoMeshSuggestion.PreferredTable[] preferredTableArray = preferredTableArrayArray[n13];
            object4 = preferredTableArray;
            n15 = preferredTableArray.length;
            int n16 = 0;
            while (n16 < n15) {
                int n17 = object4[n16];
                if (n17 != null) {
                    treeSet2.add(n17);
                    blArray[n13] = true;
                }
                ++n16;
            }
            ++n13;
        }
        if (treeSet.size() == 0 && treeSet2.size() == 0) {
            ((PropFeature)meshFeatureList.get("size")).set("hauto", 5.0 + d2);
            return;
        }
        n13 = 0;
        if (preferredTable == null) {
            n13 = 1;
            preferredTable = new IAutoMeshSuggestion.PreferredTable(0, new int[0], 5, HAutoTable.PredefinedTables.DEFAULT);
            preferredTable.a(meshSequence, d2);
            treeSet2.add(preferredTable);
        }
        int n18 = 0;
        while (n18 <= n2) {
            int n19 = 0;
            while (n19 < preferredTableArrayArray[n18].length) {
                if (preferredTableArrayArray[n18][n19] == null && stringArrayArray[n18][n19] != null) {
                    preferredTableArrayArray[n18][n19] = preferredTable;
                }
                ++n19;
            }
            ++n18;
        }
        if (treeSet.size() <= 1 && treeSet2.size() <= 1 && object5[n2] == false) {
            MeshFeature meshFeature = (MeshFeature)meshFeatureList.get("size");
            if (treeSet2.size() == 1) {
                meshFeature.set("table", preferredTable.getTableName());
                double d6 = this.a(preferredTable.getHAuto(), d2);
                meshFeature.set("hauto", d6);
                if (preferredTable.useCustomSize()) {
                    object4 = preferredTable.getTable();
                    object3 = object4.getTable(n2);
                    double d7 = ((HAutoTable.HAutoCollection)object3).getGeomFactor(meshSequence.getGeomDimension());
                    HAutoTable.setMeshParameters(d6, meshFeature, (HAutoTable.HAutoCollection)object3, d7);
                }
            }
            if (string != null) {
                if (n13 != 0) {
                    meshFeature.set("hmax", this.a(meshSequence, string));
                } else {
                    meshFeature.set("hmax", this.a(meshSequence, "min(" + string + "," + meshFeature.getString("hmax") + ")"));
                }
                meshFeature.set("hmin", this.a(meshSequence, "min(" + this.a(string) + "," + meshFeature.getString("hmin") + ")"));
            }
        } else {
            object4 = object5;
            int n20 = ((String[])object5).length;
            int n21 = 0;
            while (n21 < n20) {
                n18 = object4[n21];
                if (n18 != 0) {
                    treeSet.add(Double.POSITIVE_INFINITY);
                    break;
                }
                ++n21;
            }
            n18 = 1;
            n21 = n2;
            while (n21 >= 0) {
                if (blArray[n21]) {
                    object3 = treeSet.iterator();
                    while (object3.hasNext()) {
                        double d8 = (Double)object3.next();
                        object2 = treeSet2.iterator();
                        while (object2.hasNext()) {
                            MeshFeature meshFeature;
                            IAutoMeshSuggestion.PreferredTable preferredTable3 = (IAutoMeshSuggestion.PreferredTable)object2.next();
                            object = this.a(dArrayArray[n21], preferredTableArrayArray[n21], d8, preferredTable3);
                            if (object == null) continue;
                            if (n18 != 0 && n21 == n2) {
                                meshFeature = (MeshFeature)meshFeatureList.get("size");
                                n18 = 0;
                            } else {
                                meshFeature = meshFeatureList.create(meshFeatureList.uniquetag("size"), "Size");
                                meshFeature.selection().geom(n21).set((int)object);
                            }
                            meshFeature.set("table", preferredTable3.getTableName());
                            double d9 = this.a(preferredTable3.getHAuto(), d2);
                            meshFeature.set("hauto", d9);
                            if (preferredTable3.useCustomSize()) {
                                IPredefinedTable iPredefinedTable = preferredTable3.getTable();
                                HAutoTable.HAutoCollection hAutoCollection = iPredefinedTable.getTable(n2);
                                double d10 = hAutoCollection.getGeomFactor(meshSequence.getGeomDimension());
                                HAutoTable.setMeshParameters(d9, meshFeature, hAutoCollection, d10);
                            }
                            if (!(d8 < Double.POSITIVE_INFINITY)) continue;
                            if (n13 != 0) {
                                meshFeature.set("hmax", this.a(meshSequence, stringArrayArray[n21][object[0] - 1]));
                            } else {
                                meshFeature.set("hmax", this.a(meshSequence, "min(" + stringArrayArray[n21][object[0] - 1] + "," + meshFeature.getString("hmax") + ")"));
                            }
                            meshFeature.set("hmin", this.a(meshSequence, "min(" + this.a(stringArrayArray[n21][object[0] - 1]) + "," + meshFeature.getString("hmin") + ")"));
                        }
                    }
                }
                --n21;
            }
        }
    }

    private String a(MeshSequence meshSequence, String string) {
        try {
            string = o.a((String)string);
            double d2 = ParseUtil.a((String)string, (IUnitConverter)meshSequence.getConverter());
            double d3 = meshSequence.getGeomDimension()[0];
            d2 = FlNumberUtil.a((double)d2, (int)4, (double)(d3 * 1.0E-10));
            return FlNumberUtil.a((double)d2, (int)5);
        }
        catch (FlException flException) {
            return string;
        }
    }

    private String a(String string) {
        return String.valueOf(string) + "*3E-2";
    }

    private void b(MeshSequence meshSequence, List<IAutoMeshSuggestion> list) {
        FlException flException = null;
        ArrayList<IAutoMeshSuggestion.SequenceSetupError> arrayList = new ArrayList<IAutoMeshSuggestion.SequenceSetupError>();
        for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
            Collection<IAutoMeshSuggestion.SequenceSetupError> collection = iAutoMeshSuggestion.getSetupErrors();
            if (collection == null) continue;
            for (IAutoMeshSuggestion.SequenceSetupError sequenceSetupError : collection) {
                if (!sequenceSetupError.process(arrayList)) continue;
                MeshFeature meshFeature = meshSequence.getSizeDefaultFeature();
                FlException flException2 = sequenceSetupError.getDetailException(meshSequence.getSDim());
                meshFeature.resetProblems();
                meshFeature.getOperation().addError(meshFeature, flException2);
                meshSequence.setType(MESH_TYPES.MANUAL);
                meshSequence.refresh();
                meshFeature.setBuildStatus(FEATURE_STATUS.ERROR);
                meshSequence.setCurrentFeature(meshFeature);
                if (flException != null) continue;
                flException = sequenceSetupError.getExectionToThrow();
            }
        }
        if (flException != null) {
            throw flException;
        }
    }

    private <T> T[] a(GeomSequence geomSequence, int n2, T[] TArray) {
        int[] nArray;
        if (TArray == null) {
            return null;
        }
        int[] nArray2 = geomSequence.getNEntities();
        if (nArray2[n2] == (nArray = geomSequence.getNEntitiesMesh())[n2]) {
            return TArray;
        }
        Object[] objectArray = (Object[])Array.newInstance(TArray.getClass().getComponentType(), nArray[n2]);
        HashMap<T, an> hashMap = new HashMap<T, an>();
        int n3 = 0;
        while (n3 < TArray.length) {
            if (TArray[n3] != null) {
                an an2 = (an)hashMap.get(TArray[n3]);
                if (an2 == null) {
                    an2 = new an();
                    hashMap.put(TArray[n3], an2);
                }
                an2.add(n3 + 1);
            }
            ++n3;
        }
        for (Map.Entry entry : hashMap.entrySet()) {
            int[] nArray3;
            int[] nArray4 = nArray3 = geomSequence.mapGeomToMeshGeom(n2, ((an)entry.getValue()).toArray());
            int n4 = nArray3.length;
            int n5 = 0;
            while (n5 < n4) {
                int n6 = nArray4[n5];
                objectArray[n6 - 1] = entry.getKey();
                ++n5;
            }
        }
        return objectArray;
    }

    private double a(int n2, double d2) {
        if ((n2 = (int)((double)n2 + d2)) < 1) {
            n2 = 1;
        } else if (n2 > 9) {
            n2 = 9;
        }
        return n2;
    }

    private int[] a(double[] dArray, IAutoMeshSuggestion.PreferredTable[] preferredTableArray, double d2, IAutoMeshSuggestion.PreferredTable preferredTable) {
        int n2 = 0;
        int n3 = 0;
        while (n3 < dArray.length) {
            if (dArray[n3] == d2 && preferredTableArray[n3] != null && preferredTableArray[n3].equals(preferredTable)) {
                ++n2;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        int[] nArray = new int[n2];
        n2 = 0;
        int n4 = 0;
        while (n4 < dArray.length) {
            if (dArray[n4] == d2 && preferredTableArray[n4] != null && preferredTableArray[n4].equals(preferredTable)) {
                nArray[n2++] = n4 + 1;
            }
            ++n4;
        }
        return nArray;
    }

    private MeshFeature a(int n2, MeshSequence meshSequence) {
        int n3 = meshSequence.getGeom().getNDomains();
        if (n3 == 0 && n2 >= 1 && n2 == meshSequence.getSDim()) {
            --n2;
        }
        switch (n2) {
            case 3: {
                MeshFeature meshFeature = meshSequence.create(meshSequence.feature().uniquetag("ftet"), "FreeTet");
                meshFeature.set("optlarge", this.e && !this.d);
                meshFeature.set("optsmall", this.d);
                meshFeature.set("optcurved", this.c);
                meshFeature.set("optlevel", this.f.name().toLowerCase(Locale.ENGLISH));
                return meshFeature;
            }
            case 2: {
                return meshSequence.create(meshSequence.feature().uniquetag("ftri"), "FreeTri");
            }
            case 1: {
                return meshSequence.create(meshSequence.feature().uniquetag("edg"), "Edge");
            }
            case 0: {
                return meshSequence.create(meshSequence.feature().uniquetag("pnt"), "Point");
            }
        }
        throw new RuntimeException("Unexpected space dimension");
    }

    private MeshFeature a(MeshSequence meshSequence) {
        MeshFeature meshFeature = meshSequence.create(meshSequence.getFeature().uniquetag("map"), "Map");
        meshFeature.selection().geom(2);
        return meshFeature;
    }

    private MeshFeature a(int n2, MeshFeatureList meshFeatureList, IAutoMeshSuggestion.LayerDomains layerDomains) {
        int n3 = ((MeshSequence)meshFeatureList.getContainer()).getGeom().getNDomains();
        if (n3 == 0 && n2 > 1) {
            throw new RuntimeException("There_is_no_domain_defined_in_pefectly_matched_layer");
        }
        switch (n2) {
            case 3: {
                MeshFeature meshFeature = meshFeatureList.create(meshFeatureList.uniquetag("swe"), "Sweep");
                if (layerDomains.c) {
                    meshFeature.set("facemethod", "tri");
                }
                if (layerDomains.d != null) {
                    meshFeature.selection("sourceface").set(layerDomains.d);
                }
                return meshFeature;
            }
            case 2: {
                return meshFeatureList.create(meshFeatureList.uniquetag("map"), "Map");
            }
        }
        throw new RuntimeException("Unexpected space dimension");
    }

    private int[][] c(MeshSequence meshSequence, List<IAutoMeshSuggestion> list) {
        Object object;
        CsBitSet csBitSet = new CsBitSet[meshSequence.getSDim() + 1];
        int[] nArray = meshSequence.getGeom().getNEntities();
        int n2 = 0;
        while (n2 < ((CsBitSet[])csBitSet).length) {
            csBitSet[n2] = new CsBitSet(nArray[n2] + 1);
            ++n2;
        }
        n2 = 0;
        for (IAutoMeshSuggestion iAutoMeshSuggestion : list) {
            int n3;
            int n4;
            int[][] nArray2 = iAutoMeshSuggestion.entitiesToMesh();
            if (nArray2 == null) continue;
            n2 = 1;
            if (nArray2.length == 0) {
                CsBitSet csBitSet2 = csBitSet;
                n4 = ((CsBitSet[])csBitSet2).length;
                n3 = 0;
                while (n3 < n4) {
                    object = csBitSet2[n3];
                    object.a(true);
                    ++n3;
                }
                continue;
            }
            int n5 = 0;
            while (n5 < ((CsBitSet[])csBitSet).length) {
                if (nArray2[n5] != null) {
                    int[] nArray3 = nArray2[n5];
                    int n6 = nArray3.length;
                    n4 = 0;
                    while (n4 < n6) {
                        n3 = nArray3[n4];
                        if (n3 >= csBitSet[n5].c()) {
                            csBitSet[n5].a(n3);
                        }
                        ++n4;
                    }
                }
                ++n5;
            }
        }
        if (n2 == 0) {
            object = csBitSet;
            int n7 = ((CsBitSet[])object).length;
            int n8 = 0;
            while (n8 < n7) {
                IAutoMeshSuggestion iAutoMeshSuggestion;
                iAutoMeshSuggestion = object[n8];
                iAutoMeshSuggestion.a(true);
                ++n8;
            }
        }
        int n9 = 0;
        while (n9 < nArray.length - 1) {
            CsBitSet csBitSet3 = new CsBitSet(csBitSet[n9].b());
            int n10 = n9 + 1;
            while (n10 < nArray.length) {
                object = meshSequence.getGeom().getAdj(n10, n9);
                this.a(csBitSet[n10], csBitSet3, (int[][])object);
                ++n10;
            }
            csBitSet[n9].c(csBitSet3.h());
            ++n9;
        }
        int[][] nArrayArray = new int[meshSequence.getSDim() + 1][];
        int n11 = 0;
        while (n11 < nArrayArray.length) {
            nArrayArray[n11] = meshSequence.getGeom().info().mapGeomToMeshGeom(n11, csBitSet[n11].g());
            ++n11;
        }
        return nArrayArray;
    }

    static /* synthetic */ int[] a() {
        if (g != null) {
            return g;
        }
        int[] nArray = new int[IAutoMeshSuggestion.SharpCornersMethod.values().length];
        try {
            nArray[IAutoMeshSuggestion.SharpCornersMethod.NONE.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IAutoMeshSuggestion.SharpCornersMethod.SPLIT.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[IAutoMeshSuggestion.SharpCornersMethod.TRIM.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        g = nArray;
        return nArray;
    }
}

