/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.automodeling;

import com.comsol.model.analysis.ComAnalysisID;
import com.comsol.model.analysis.IAnalysisOperation;
import com.comsol.model.analysis.SolverType;
import com.comsol.model.analysis.SpecialAnalysisID;
import com.comsol.model.applapi.IVariableData;
import com.comsol.model.automodeling.AutoSolverProvider;
import com.comsol.model.automodeling.AutoSolverSuggestion;
import com.comsol.model.automodeling.IAutoSolverSuggestion;
import com.comsol.model.automodeling.SolverOperationNames;
import com.comsol.model.automodeling.VarGrp;
import com.comsol.model.automodeling.VarGrpNLSettings;
import com.comsol.model.automodeling.WeakCouplingSuggestion;
import com.comsol.model.dbimodel.CommonFeature;
import com.comsol.model.dbimodel.DEPVAR_TYPE;
import com.comsol.model.dbimodel.Field;
import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.Model;
import com.comsol.model.dbimodel.ModelEntity;
import com.comsol.model.dbimodel.ModelEntityList;
import com.comsol.model.dbimodel.ModelTags;
import com.comsol.model.dbimodel.Ode;
import com.comsol.model.dbimodel.ParameterEntity;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeature;
import com.comsol.model.dbimodel.Shape;
import com.comsol.model.dbimodel.SolverFeature;
import com.comsol.model.dbimodel.SolverFeatureList;
import com.comsol.model.dbimodel.SolverSequence;
import com.comsol.model.dbimodel.Study;
import com.comsol.model.dbimodel.StudyFeature;
import com.comsol.model.dbimodel.StudyFeatureList;
import com.comsol.model.dbimodel.physics.MultiphysicsCoupling;
import com.comsol.model.dbimodel.physics.Physics;
import com.comsol.model.dbimodel.physics.PhysicsFeature;
import com.comsol.model.dbmodel.ParameterEntityDb;
import com.comsol.model.dbmodel.PrimitiveModelEntityDb;
import com.comsol.model.dbmodel.physics.PhysicsPropDb;
import com.comsol.model.operations.IOperation;
import com.comsol.model.properties.StudyStepProperties;
import com.comsol.model.util.UnitUtil;
import com.comsol.nativeutil.parser.ParseUtil;
import com.comsol.nativeutil.properties.de;
import com.comsol.util.classes.FlStringList;
import com.comsol.util.interfaces.IUnitConverter;
import com.comsol.util.methods.FlStringUtil;
import com.comsol.util.methods.o;
import com.comsol.util.methods.q;
import com.comsol.util.methods.x;
import java.util.HashMap;
import java.util.List;

public class AutoSolverSuggestionUtil {
    public static void copyLinSettings(IAutoSolverSuggestion iAutoSolverSuggestion, VarGrpNLSettings varGrpNLSettings, String string) {
        if (iAutoSolverSuggestion instanceof WeakCouplingSuggestion) {
            WeakCouplingSuggestion weakCouplingSuggestion = (WeakCouplingSuggestion)iAutoSolverSuggestion;
            String string2 = weakCouplingSuggestion.getLinSettingsId(string);
            if (string2 != null) {
                varGrpNLSettings.setLinSettings(iAutoSolverSuggestion);
            }
            varGrpNLSettings.setDefaultLinearSolver(varGrpNLSettings.addTag(string2));
        } else {
            varGrpNLSettings.setLinSettings(iAutoSolverSuggestion);
            if (iAutoSolverSuggestion.getDefaultSolver() != null) {
                varGrpNLSettings.setDefaultLinearSolver(varGrpNLSettings.addTag(iAutoSolverSuggestion.getDefaultSolver()));
            }
        }
    }

    public static void copyNlinSettings(AutoSolverSuggestion autoSolverSuggestion, VarGrpNLSettings varGrpNLSettings) {
        IAutoSolverSuggestion.NlinType[] nlinTypeArray = IAutoSolverSuggestion.NlinType.values();
        int n2 = nlinTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            IAutoSolverSuggestion.NlinType nlinType = nlinTypeArray[n3];
            de de2 = autoSolverSuggestion.getNlinSettings(nlinType);
            if (de2 != null) {
                varGrpNLSettings.setNlinSettings(nlinType, de2);
            }
            ++n3;
        }
    }

    public static boolean useParametricForFrequency(PropFeature propFeature) {
        Object object;
        Object object2;
        String[] stringArray3;
        StudyFeature studyFeature = (StudyFeature)propFeature;
        StudyFeatureList studyFeatureList = (StudyFeatureList)studyFeature.getContainer();
        if (studyFeatureList.size() == 1 || propFeature.getDoubleArray(StudyStepProperties.StudyExtensionsProps.plist.name()).length != 1) {
            return true;
        }
        int n2 = 0;
        String string = propFeature.getString(StudyStepProperties.StudyExtensionsProps.plist.name());
        boolean bl2 = false;
        String[] stringArray2 = null;
        FlStringList flStringList = new FlStringList();
        for (String[] stringArray3 : studyFeatureList) {
            if (!stringArray3.isActive()) continue;
            if (((IAnalysisOperation)stringArray3.getOperation()).contributesPhysics()) {
                ++n2;
            } else {
                flStringList.add(stringArray3.tag());
            }
            object2 = ((IAnalysisOperation)((StudyFeature)stringArray3).getOperation()).getSolverType();
            if (!SolverType.Parametric.equals(object2) || !stringArray3.hasPropValue(StudyStepProperties.StudyExtensionsProps.pname.name())) continue;
            if (FlStringUtil.contains((String[])stringArray3.getStringArray(StudyStepProperties.StudyExtensionsProps.pname.name()), (String)string)) {
                return true;
            }
            stringArray2 = stringArray3;
            bl2 = true;
        }
        if (n2 > 1 || !bl2) {
            return true;
        }
        if ("off".equals(stringArray2.getString("paramselect"))) {
            return true;
        }
        stringArray3 = stringArray2.getStringArray(StudyStepProperties.StudyExtensionsProps.pname.name());
        Model model = propFeature.getModel();
        if (model.isGeometryMeshDependent(stringArray3) || model.isFunctionDependent(stringArray3) || model.isPairDependent(stringArray3) || model.isMaterialDependent(stringArray3)) {
            return true;
        }
        object2 = studyFeature;
        while (object2 != null && !(object2 instanceof Study)) {
            object2 = object2.getContainer();
        }
        if (object2 != null && model.isStudyDependent(object2.getTag(), stringArray3, flStringList.toArray())) {
            return true;
        }
        FlStringList flStringList2 = new FlStringList();
        String[] stringArray4 = ((MatchTagContainer)((Object)propFeature)).getmatchtag(ModelTags.Analysis.name());
        AutoSolverProvider autoSolverProvider = propFeature.getModel().method().getSolverSuggestion(stringArray4[0]);
        Object[] objectArray = autoSolverProvider.getSolverSuggestions((StudyFeature)propFeature);
        int n3 = objectArray.length;
        int n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            if (object.getJobParameters() != null) {
                flStringList2.add(object.getJobParameters());
            }
            ++n4;
        }
        objectArray = stringArray3;
        n3 = stringArray3.length;
        n4 = 0;
        while (n4 < n3) {
            object = objectArray[n4];
            if (flStringList2.contains((String)object)) {
                return true;
            }
            ++n4;
        }
        return propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.awe.name()) && ("on".equals(propFeature.getString(StudyStepProperties.StudyExtensionsProps.awe.name())) || propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.pname_aux.name()) && propFeature.getStringArray(StudyStepProperties.StudyExtensionsProps.pname_aux.name()).length != 0 || propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.useparam.name()) && !"off".equals(propFeature.getString(StudyStepProperties.StudyExtensionsProps.useparam.name())) || propFeature.getDoubleArray(StudyStepProperties.StudyExtensionsProps.plist.name()).length != 1);
    }

    public static void mergeFrequencyAndContinuation(PropFeature propFeature, PropFeature propFeature2) {
        Object[] objectArray = propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.pname_aux.name()) ? propFeature2.getStringArray(StudyStepProperties.StudyExtensionsProps.pname_aux.name()) : new String[]{};
        boolean bl2 = SpecialAnalysisID.Wavelength.id().equals(propFeature2.getOperationID());
        if ((!propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.awe.name()) || !"on".equals(propFeature2.getString(StudyStepProperties.StudyExtensionsProps.awe.name()))) && propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.useparam.name()) && "on".equals(propFeature2.getString(StudyStepProperties.StudyExtensionsProps.useparam.name())) && objectArray.length > 0) {
            Object object;
            String string = bl2 ? "lambda0" : "freq";
            propFeature.set(StudyStepProperties.StudyExtensionsProps.pname.name(), (String[])q.b((Object[][])new String[][]{{string}, objectArray}));
            String[][] stringArray = AutoSolverSuggestionUtil.a(propFeature2, propFeature);
            if (stringArray != null && stringArray.length == objectArray.length) {
                if (objectArray.length == 1 || propFeature2.getString(StudyStepProperties.StudyExtensionsProps.sweeptype.name()).equals("filled")) {
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.sweeptype.name(), "filled");
                    object = propFeature2.getStringArray(StudyStepProperties.StudyExtensionsProps.plistarr_aux.name());
                    String[] stringArray2 = new String[((String[])object).length + 1];
                    stringArray2[0] = propFeature2.getString(StudyStepProperties.StudyExtensionsProps.plist.name());
                    int n2 = 0;
                    while (n2 < ((String[])object).length) {
                        stringArray2[n2 + 1] = object[n2];
                        ++n2;
                    }
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.plistarr.name(), stringArray2);
                } else {
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.sweeptype.name(), "sparse");
                    object = AutoSolverSuggestionUtil.a(propFeature2);
                    int n3 = x.a((double[][])propFeature2.getDoubleMatrix(StudyStepProperties.StudyExtensionsProps.plistarr_aux.name()), (String)"sparse", (boolean)false);
                    if (n3 > 0) {
                        int n4 = ((String[])object).length * n3;
                        String[][] stringArray3 = new String[objectArray.length + 1][n4];
                        int n5 = 0;
                        while (n5 < n3) {
                            int n6 = 0;
                            while (n6 < ((String[])object).length) {
                                stringArray3[0][n5 * ((String[])object).length + n6] = object[n6];
                                int n7 = 0;
                                while (n7 < objectArray.length) {
                                    stringArray3[n7 + 1][n5 * ((String[])object).length + n6] = stringArray[n7][n5];
                                    ++n7;
                                }
                                ++n6;
                            }
                            ++n5;
                        }
                        propFeature.set(StudyStepProperties.StudyExtensionsProps.plistarr.name(), stringArray3);
                    }
                }
            }
            propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name(), propFeature2.getString(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name()));
            Object object2 = object = propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.pcontinuation.name()) ? propFeature2.getString(StudyStepProperties.StudyExtensionsProps.pcontinuation.name()) : "";
            if (!q.a((Object[])objectArray, (Object)object) && !string.equals(object)) {
                object = "";
            }
            propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuation.name(), (String)object);
        } else {
            String string = bl2 ? "lambda0" : "freq";
            propFeature.set(StudyStepProperties.StudyExtensionsProps.pname.name(), new String[]{string});
            propFeature.set(StudyStepProperties.StudyExtensionsProps.plistarr.name(), new String[]{propFeature2.getString(StudyStepProperties.StudyExtensionsProps.plist.name())});
            propFeature.set(StudyStepProperties.StudyExtensionsProps.punit.name(), new String[]{propFeature2.getString(StudyStepProperties.StudyExtensionsProps.punit.name())});
            if (propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.useparam.name()) && "on".equals(propFeature2.getString(StudyStepProperties.StudyExtensionsProps.useparam.name()))) {
                String string2;
                String string3 = string2 = propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.pcontinuation.name()) ? propFeature2.getString(StudyStepProperties.StudyExtensionsProps.pcontinuation.name()) : "";
                if (!string.equals(string2)) {
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name(), "no");
                } else {
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name(), propFeature2.getString(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name()));
                    propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuation.name(), string2);
                }
            } else {
                propFeature.set(StudyStepProperties.StudyExtensionsProps.pcontinuationmode.name(), "no");
            }
        }
        if (propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.preusesol.name())) {
            propFeature.set(StudyStepProperties.StudyExtensionsProps.preusesol.name(), propFeature2.getString(StudyStepProperties.StudyExtensionsProps.preusesol.name()));
        }
        if (propFeature2.hasProperty("pdistrib")) {
            propFeature.set("pdistrib", propFeature2.getString("pdistrib"));
        }
    }

    private static String[][] a(PropFeature propFeature, PropFeature propFeature2) {
        String[] stringArray = propFeature.getStringArray(StudyStepProperties.StudyExtensionsProps.plistarr_aux.name());
        String[][] stringArray2 = propFeature.getStringMatrix(StudyStepProperties.StudyExtensionsProps.plistarr_aux.name());
        String[] stringArray3 = propFeature.getStringArray(StudyStepProperties.StudyExtensionsProps.pname_aux.name());
        if (stringArray2 != null && stringArray2.length == stringArray3.length) {
            String[] stringArray4 = propFeature.getStringArray(StudyStepProperties.StudyExtensionsProps.punit_aux.name());
            if (stringArray4 == null || stringArray4.length == 0) {
                stringArray4 = new String[stringArray3.length];
            }
            String[] stringArray5 = stringArray4;
            IUnitConverter iUnitConverter = propFeature.getConverter();
            int n2 = 0;
            while (n2 < stringArray2.length) {
                String[] stringArray6 = ParseUtil.i((String)stringArray[n2]);
                int n3 = 0;
                String[] stringArray7 = stringArray6;
                int n4 = stringArray6.length;
                int n5 = 0;
                while (n5 < n4) {
                    String string = stringArray7[n5];
                    String string2 = null;
                    try {
                        string2 = iUnitConverter.getUnitExpr(string, 0);
                    }
                    catch (Exception exception) {}
                    String string3 = propFeature.getModel().getParamDatabase().a(null, string);
                    double[][] dArray = ParseUtil.a((String[])new String[]{o.a((String)string3, (IUnitConverter)iUnitConverter, (boolean[])new boolean[]{true})}, (String)StudyStepProperties.StudyExtensionsProps.plistarr_aux.name());
                    if (string2 != null && stringArray4[n2] != null && !stringArray4[n2].trim().isEmpty()) {
                        int n6 = 0;
                        while (n6 < dArray[0].length) {
                            stringArray2[n2][n3++] = o.a((String)(String.valueOf(dArray[0][n6]) + "[1/(" + stringArray4[n2] + ")]"), (IUnitConverter)iUnitConverter, (boolean[])new boolean[]{true});
                            ++n6;
                        }
                    } else if (string2 != null && (stringArray4[n2] == null || stringArray4[n2].trim().isEmpty())) {
                        stringArray5[n2] = string2;
                        n3 += dArray[0].length;
                    } else {
                        n3 += dArray[0].length;
                    }
                    ++n5;
                }
                ++n2;
            }
            propFeature2.set(StudyStepProperties.StudyExtensionsProps.punit.name(), (String[])q.b((Object[][])new String[][]{{propFeature.getString(StudyStepProperties.StudyExtensionsProps.punit.name())}, stringArray5}));
        }
        return stringArray2;
    }

    private static String[] a(PropFeature propFeature) {
        String string = propFeature.getString(StudyStepProperties.StudyExtensionsProps.plist.name());
        String[] stringArray = propFeature.getStringArray(StudyStepProperties.StudyExtensionsProps.plist.name());
        String string2 = propFeature.getString(StudyStepProperties.StudyExtensionsProps.punit.name());
        if (string2 != null && !string2.trim().isEmpty()) {
            IUnitConverter iUnitConverter = propFeature.getConverter();
            String[] stringArray2 = ParseUtil.i((String)string);
            int n2 = 0;
            String[] stringArray3 = stringArray2;
            int n3 = stringArray2.length;
            int n4 = 0;
            while (n4 < n3) {
                String string3 = stringArray3[n4];
                String string4 = propFeature.getModel().getParamDatabase().a(null, string3);
                double[][] dArray = ParseUtil.a((String[])new String[]{o.a((String)string4, (IUnitConverter)iUnitConverter, (boolean[])new boolean[]{true})}, (String)StudyStepProperties.StudyExtensionsProps.plistarr.name());
                if (UnitUtil.hasExprUnit(string3, iUnitConverter)) {
                    int n5 = 0;
                    while (n5 < dArray[0].length) {
                        stringArray[n2++] = o.a((String)(String.valueOf(dArray[0][n5]) + "[1/(" + string2 + ")]"), (IUnitConverter)iUnitConverter, (boolean[])new boolean[]{true});
                        ++n5;
                    }
                } else {
                    n2 += dArray.length;
                }
                ++n4;
            }
        }
        return stringArray;
    }

    public static boolean isFrequencyAndContinuation(String string, PropFeature propFeature, PropFeature propFeature2) {
        IOperation iOperation = propFeature2.getOperation();
        if (iOperation instanceof IAnalysisOperation) {
            return ((IAnalysisOperation)iOperation).getAnalysisID().isSpecialCaseOf(ComAnalysisID.Frequency.id()) && q.a((Object[])new String[]{StudyStepProperties.StudyExtensionsProps.plist.name(), StudyStepProperties.StudyExtensionsProps.pname.name(), StudyStepProperties.StudyExtensionsProps.punit.name(), StudyStepProperties.StudyExtensionsProps.pname_aux.name(), StudyStepProperties.StudyExtensionsProps.punit_aux.name(), StudyStepProperties.StudyExtensionsProps.useparam.name(), StudyStepProperties.StudyExtensionsProps.awe.name(), StudyStepProperties.StudyExtensionsProps.plistarr_aux.name(), StudyStepProperties.StudyExtensionsProps.sweeptype.name(), StudyStepProperties.StudyExtensionsProps.pcontinuation.name()}, (Object)string) && propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.pname.name()) && propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.plistarr.name()) && propFeature.hasProperty(StudyStepProperties.StudyExtensionsProps.punit.name()) && propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.useparam.name()) && propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.pname_aux.name()) && propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.plistarr_aux.name()) && propFeature2.hasProperty(StudyStepProperties.StudyExtensionsProps.punit_aux.name());
        }
        return false;
    }

    public static SolverFeature getSolverFeature(SolverFeatureList<? extends PropFeature> solverFeatureList, SolverOperationNames.Names names) {
        for (PropFeature propFeature : solverFeatureList) {
            if (!names.getPrimaryName().equals(propFeature.getOperation().getID())) continue;
            return (SolverFeature)propFeature;
        }
        return AutoSolverSuggestionUtil.createSolverFeature(solverFeatureList, names);
    }

    public static HashMap<String, VarGrp> appModeGrouping(StudyFeature studyFeature, ModelEntityList<?> modelEntityList, ModelEntityList<?> modelEntityList2, FlStringList flStringList, boolean bl2, boolean bl3) {
        String string;
        ModelEntityList<?> modelEntityList3 = modelEntityList;
        ModelEntityList<?> modelEntityList4 = modelEntityList2;
        String[] stringArray = studyFeature != null ? AutoSolverSuggestionUtil.getBEMVars(studyFeature.getModel()) : new String[]{};
        HashMap<String, VarGrp> hashMap = new HashMap<String, VarGrp>();
        flStringList.setSize(0);
        IAnalysisOperation iAnalysisOperation = studyFeature == null ? null : (IAnalysisOperation)studyFeature.getOperation();
        for (ModelEntity modelEntity : modelEntityList3) {
            if ((!modelEntity.isSolveFor() || AutoSolverSuggestionUtil.a((Field)modelEntity) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            AutoSolverSuggestionUtil.a(hashMap, (Field)modelEntity, bl3, stringArray);
            string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
            flStringList.add(string);
        }
        for (ModelEntity modelEntity : modelEntityList4) {
            if ((!modelEntity.isSolveFor() || AutoSolverSuggestionUtil.a((Ode)modelEntity) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            AutoSolverSuggestionUtil.a(hashMap, (Ode)modelEntity, bl3);
            string = AutoSolverSuggestionUtil.getName(bl3, (Ode)modelEntity);
            flStringList.add(string);
        }
        return hashMap;
    }

    private static boolean a(Field field) {
        if (field.getXmeshVarsStatic() == null && field.getXmeshVars() == null) {
            return false;
        }
        String[] stringArray = new String[]{};
        if (field.getXmeshVars() != null) {
            stringArray = field.getXmeshVars();
            if (field.getXmeshVarsStatic() != null) {
                stringArray = (String[])q.b((Object[][])new String[][]{field.getXmeshVarsStatic(), stringArray});
            }
        } else {
            stringArray = field.getXmeshVarsStatic();
            if (field.getXmeshVars() != null) {
                stringArray = (String[])q.b((Object[][])new String[][]{stringArray, field.getXmeshVars()});
            }
        }
        String[] stringArray2 = stringArray = FlStringUtil.unique((String[])stringArray);
        String[] stringArray3 = field.shape();
        int n2 = stringArray3.length;
        int n3 = 0;
        while (n3 < n2) {
            String string = stringArray3[n3];
            if (field.getModel().shape().hasTag(string) && field.getModel().shape(string).fieldVariable() != null) {
                stringArray2 = (String[])q.b((Object[][])new String[][]{stringArray2, field.getModel().shape(string).fieldVariable()});
            }
            ++n3;
        }
        stringArray2 = FlStringUtil.unique((String[])stringArray2);
        boolean bl2 = FlStringUtil.equals((String[])stringArray2, (String[])stringArray);
        return bl2;
    }

    private static boolean a(Ode ode) {
        if (ode.getXmeshVarsStatic() == null && ode.getXmeshVars() == null) {
            return false;
        }
        String[] stringArray = new String[]{};
        if (ode.getXmeshVars() != null) {
            stringArray = ode.getXmeshVars();
            if (ode.getXmeshVarsStatic() != null) {
                stringArray = (String[])q.b((Object[][])new String[][]{ode.getXmeshVarsStatic(), stringArray});
            }
        } else {
            stringArray = ode.getXmeshVarsStatic();
            if (ode.getXmeshVars() != null) {
                stringArray = (String[])q.b((Object[][])new String[][]{stringArray, ode.getXmeshVars()});
            }
        }
        stringArray = FlStringUtil.unique((String[])stringArray);
        boolean bl2 = FlStringUtil.equals((String[])FlStringUtil.getXmeshVarName((String[])ode.state()), (String[])stringArray);
        return bl2;
    }

    public static String[] getBEMVars(Model model) {
        IVariableData iVariableData = model.physics().getVarData();
        FlStringList flStringList = new FlStringList();
        for (PropFeature propFeature : model.bem()) {
            AutoSolverSuggestionUtil.a("varname", iVariableData, flStringList, propFeature);
            AutoSolverSuggestionUtil.a("varnamefront", iVariableData, flStringList, propFeature);
            AutoSolverSuggestionUtil.a("varnameback", iVariableData, flStringList, propFeature);
            AutoSolverSuggestionUtil.a("fluxname", iVariableData, flStringList, propFeature);
            AutoSolverSuggestionUtil.a("edgefluxname", iVariableData, flStringList, propFeature);
            AutoSolverSuggestionUtil.a("edgegradname", iVariableData, flStringList, propFeature);
        }
        return flStringList.toArray();
    }

    private static void a(String string, IVariableData iVariableData, FlStringList flStringList, PropFeature propFeature) {
        if (propFeature.hasPropValue(string) && propFeature.getStringArray(string) != null && propFeature.getStringArray(string).length > 0) {
            String[] stringArray = propFeature.getStringArray(string);
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                String string2 = stringArray[n3];
                if (!string2.isEmpty()) {
                    flStringList.add(iVariableData.checkRemoveRoot(string2, true));
                }
                ++n3;
            }
        }
    }

    public static void appModeGroupingBidirectionallyCoupled(StudyFeature studyFeature, ModelEntityList<?> modelEntityList, ModelEntityList<?> modelEntityList2, boolean bl2, boolean bl3, FlStringList flStringList, FlStringList flStringList2, FlStringList flStringList3, HashMap<String, VarGrp> hashMap, HashMap<String, VarGrp> hashMap2, HashMap<String, VarGrp> hashMap3) {
        ModelEntityList<?> modelEntityList3 = modelEntityList;
        ModelEntityList<?> modelEntityList4 = modelEntityList2;
        flStringList.setSize(0);
        flStringList2.setSize(0);
        flStringList3.setSize(0);
        IAnalysisOperation iAnalysisOperation = studyFeature == null ? null : (IAnalysisOperation)studyFeature.getOperation();
        String[] stringArray = new String[]{"MathParticle", "ChargedParticleTracing", "FluidParticleTracing", "DropletSprays", "GeometricalOptics", "RayAcoustics", "ElectricParticleFieldInteraction", "MagneticParticleFieldInteraction", "RayHeatSource", "FluidParticleInteraction"};
        String[] stringArray2 = studyFeature != null ? AutoSolverSuggestionUtil.getBEMVars(studyFeature.getModel()) : new String[]{};
        for (ModelEntity modelEntity : modelEntityList3) {
            String string;
            boolean bl4 = false;
            boolean bl5 = false;
            if (modelEntity.getDerivedFrom() != null) {
                string = "";
                ModelEntity modelEntity2 = modelEntity.getDerivedFrom();
                if (modelEntity2 instanceof Physics) {
                    string = ((Physics)modelEntity2).getApplmodeID();
                } else if (modelEntity2 instanceof MultiphysicsCoupling) {
                    string = ((MultiphysicsCoupling)modelEntity2).getCouplingID();
                } else if (modelEntity2 instanceof PhysicsFeature) {
                    PhysicsFeature physicsFeature = (PhysicsFeature)modelEntity2;
                    while (physicsFeature instanceof PhysicsFeature) {
                        PrimitiveModelEntity primitiveModelEntity = physicsFeature.getContainer().getContainer();
                        if (primitiveModelEntity instanceof PhysicsFeature) {
                            physicsFeature = (PhysicsFeature)primitiveModelEntity;
                            continue;
                        }
                        if (!(primitiveModelEntity instanceof Physics)) break;
                        string = ((Physics)primitiveModelEntity).getApplmodeID();
                        break;
                    }
                }
                if (FlStringUtil.contains((String[])stringArray, (String)string)) {
                    if (modelEntity.getDerivedFrom() instanceof MultiphysicsCoupling && modelEntity.field().contains("rhoscum_accum")) {
                        bl5 = true;
                    } else {
                        bl4 = true;
                    }
                }
            }
            if ((!modelEntity.isSolveFor() || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            if (bl4) {
                AutoSolverSuggestionUtil.a(hashMap2, (Field)modelEntity, bl3, stringArray2);
                string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
                flStringList2.add(string);
                continue;
            }
            if (bl5) {
                AutoSolverSuggestionUtil.a(hashMap3, (Field)modelEntity, bl3, stringArray2);
                string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
                flStringList3.add(string);
                continue;
            }
            AutoSolverSuggestionUtil.a(hashMap, (Field)modelEntity, bl3, stringArray2);
            string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
            flStringList.add(string);
        }
        for (ModelEntity modelEntity : modelEntityList4) {
            if ((!modelEntity.isSolveFor() || AutoSolverSuggestionUtil.a((Ode)modelEntity) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            AutoSolverSuggestionUtil.a(hashMap, (Ode)modelEntity, bl3);
            String string = AutoSolverSuggestionUtil.getName(bl3, (Ode)modelEntity);
            flStringList.add(string);
        }
    }

    public static void appModeGroupingPoissonSchrodinger(StudyFeature studyFeature, ModelEntityList<?> modelEntityList, ModelEntityList<?> modelEntityList2, boolean bl2, boolean bl3, FlStringList flStringList, FlStringList flStringList2, FlStringList flStringList3, FlStringList flStringList4, HashMap<String, VarGrp> hashMap, HashMap<String, VarGrp> hashMap2, HashMap<String, VarGrp> hashMap3, HashMap<String, VarGrp> hashMap4) {
        ModelEntityList<?> modelEntityList3 = modelEntityList;
        ModelEntityList<?> modelEntityList4 = modelEntityList2;
        flStringList.setSize(0);
        flStringList2.setSize(0);
        flStringList3.setSize(0);
        flStringList4.setSize(0);
        IAnalysisOperation iAnalysisOperation = studyFeature == null ? null : (IAnalysisOperation)studyFeature.getOperation();
        String[] stringArray = new String[]{"SchrodingerEquation", "SchrodingerPoissonCoupling"};
        String[] stringArray2 = studyFeature != null ? AutoSolverSuggestionUtil.getBEMVars(studyFeature.getModel()) : new String[]{};
        for (ModelEntity modelEntity : modelEntityList3) {
            String string;
            boolean bl4 = false;
            boolean bl5 = false;
            boolean bl6 = false;
            if (modelEntity.getDerivedFrom() != null) {
                PrimitiveModelEntity primitiveModelEntity;
                ParameterEntity parameterEntity;
                string = "";
                ModelEntity modelEntity2 = modelEntity.getDerivedFrom();
                if (modelEntity2 instanceof Physics) {
                    string = ((Physics)modelEntity2).getApplmodeID();
                } else if (modelEntity2 instanceof MultiphysicsCoupling) {
                    string = ((MultiphysicsCoupling)modelEntity2).getCouplingID();
                } else if (modelEntity2 instanceof PhysicsPropDb) {
                    parameterEntity = (PhysicsPropDb)modelEntity2;
                    primitiveModelEntity = (Physics)((Object)((PrimitiveModelEntityDb)((ParameterEntityDb)parameterEntity).getContainer()).getContainer());
                    string = primitiveModelEntity.getApplmodeID();
                } else if (modelEntity2 instanceof PhysicsFeature) {
                    parameterEntity = (PhysicsFeature)modelEntity2;
                    while (parameterEntity instanceof PhysicsFeature) {
                        primitiveModelEntity = parameterEntity.getContainer().getContainer();
                        if (primitiveModelEntity instanceof PhysicsFeature) {
                            parameterEntity = (PhysicsFeature)primitiveModelEntity;
                            continue;
                        }
                        if (!(primitiveModelEntity instanceof Physics)) break;
                        string = primitiveModelEntity.getApplmodeID();
                        break;
                    }
                }
                if (FlStringUtil.contains((String[])stringArray, (String)string)) {
                    if (modelEntity.getDerivedFrom() instanceof MultiphysicsCoupling) {
                        if (modelEntity.field().contains("n_sum")) {
                            bl6 = true;
                        } else if (modelEntity.field().contains("V_old") || modelEntity.field().contains("rhoq_old")) {
                            bl5 = true;
                        }
                    } else if (string.equals("SchrodingerEquation")) {
                        bl4 = true;
                    }
                }
            }
            if ((!modelEntity.isSolveFor() || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            if (bl4) {
                AutoSolverSuggestionUtil.a(hashMap2, (Field)modelEntity, bl3, stringArray2);
                string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
                flStringList2.add(string);
                continue;
            }
            if (bl6) {
                AutoSolverSuggestionUtil.a(hashMap3, (Field)modelEntity, bl3, stringArray2);
                string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
                flStringList3.add(string);
                continue;
            }
            if (bl5) {
                AutoSolverSuggestionUtil.a(hashMap4, (Field)modelEntity, bl3, stringArray2);
                string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
                flStringList4.add(string);
                continue;
            }
            AutoSolverSuggestionUtil.a(hashMap, (Field)modelEntity, bl3, stringArray2);
            string = AutoSolverSuggestionUtil.getName(bl3, (Field)modelEntity);
            flStringList.add(string);
        }
        for (ModelEntity modelEntity : modelEntityList4) {
            if ((!modelEntity.isSolveFor() || AutoSolverSuggestionUtil.a((Ode)modelEntity) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) && !bl2) continue;
            AutoSolverSuggestionUtil.a(hashMap, (Ode)modelEntity, bl3);
            String string = AutoSolverSuggestionUtil.getName(bl3, (Ode)modelEntity);
            flStringList.add(string);
        }
    }

    public static String getName(boolean bl2, Ode ode) {
        String string = String.valueOf(ode.shortScopeDot()) + ode.tag();
        string = FlStringUtil.getXmeshVarName((String)string);
        if (!bl2) {
            string = string.replace(".", "_");
        }
        return string;
    }

    public static HashMap<String, VarGrp> appModeGrouping(StudyFeature studyFeature, List<Field> list, List<Ode> list2, FlStringList flStringList) {
        String string;
        HashMap<String, VarGrp> hashMap = new HashMap<String, VarGrp>();
        flStringList.setSize(0);
        IAnalysisOperation iAnalysisOperation = studyFeature == null ? null : (IAnalysisOperation)studyFeature.getOperation();
        String[] stringArray = studyFeature != null ? AutoSolverSuggestionUtil.getBEMVars(studyFeature.getModel()) : new String[]{};
        for (Field modelEntity : list) {
            if (!modelEntity.isSolveFor() || AutoSolverSuggestionUtil.a(modelEntity) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(modelEntity)) continue;
            AutoSolverSuggestionUtil.a(hashMap, modelEntity, false, stringArray);
            string = AutoSolverSuggestionUtil.getName(true, modelEntity);
            flStringList.add(string);
        }
        for (Ode ode : list2) {
            if (!ode.isSolveFor() || AutoSolverSuggestionUtil.a(ode) || iAnalysisOperation != null && !iAnalysisOperation.solveFor(ode)) continue;
            AutoSolverSuggestionUtil.a(hashMap, ode, false);
            string = AutoSolverSuggestionUtil.getName(true, ode);
            flStringList.add(string);
        }
        return hashMap;
    }

    public static String getName(boolean bl2, Field field) {
        String string = String.valueOf(field.shortScopeDot()) + field.field();
        string = FlStringUtil.getXmeshVarName((String)string);
        if (!bl2) {
            string = string.replace(".", "_");
        }
        return string;
    }

    static void a(HashMap<String, VarGrp> hashMap, Ode ode, boolean bl2) {
        VarGrp varGrp;
        String string;
        if (ode.expandedState().length == 0) {
            return;
        }
        String string2 = String.valueOf(ode.shortXmeshScopeDot()) + ode.tag();
        if (!bl2) {
            string2 = string2.replace(".", "_");
        }
        if ((string = AutoSolverSuggestionUtil.a((ModelEntity)ode)) == null) {
            string = "NonPhysics";
        }
        if ((varGrp = hashMap.get(string)) == null) {
            FlStringList flStringList = new FlStringList();
            FlStringList flStringList2 = new FlStringList();
            if (DEPVAR_TYPE.CONTROL == ode.getType()) {
                flStringList2.add(string2);
            } else {
                flStringList.add(string2);
            }
            varGrp = new VarGrp(flStringList.toArray(), flStringList2.toArray(), true);
            varGrp.addPhysicsFieldID(string2, ode.getPhysicsFieldID());
        } else {
            if (DEPVAR_TYPE.CONTROL == ode.getType()) {
                varGrp.addControlVars(new String[]{string2});
            } else {
                varGrp.addVars(new String[]{string2});
            }
            varGrp.addPhysicsFieldID(string2, ode.getPhysicsFieldID());
        }
        hashMap.put(string, varGrp);
    }

    static void a(HashMap<String, VarGrp> hashMap, Field field, boolean bl2, String[] stringArray) {
        Object object;
        List<? extends Shape> list = field.getShapes();
        if (list.size() == 0) {
            return;
        }
        boolean bl3 = true;
        boolean bl4 = false;
        for (Shape object22 : list) {
            if (!object22.isInModel()) continue;
            object = object22.getSelection().dimension();
            int[] nArray = object;
            int n2 = ((int[])object).length;
            int flStringList2 = 0;
            while (flStringList2 < n2) {
                int flStringList = nArray[flStringList2];
                if (flStringList > 2) {
                    bl3 = false;
                } else if (flStringList == 2 && stringArray.length > 0 && FlStringUtil.containsAny((String[])stringArray, (String[])object22.fieldVariable())) {
                    bl3 = false;
                }
                ++flStringList2;
            }
        }
        String string = AutoSolverSuggestionUtil.getName(bl2, field);
        Object object3 = AutoSolverSuggestionUtil.a((ModelEntity)field);
        if (object3 != null && field.getModel().multiphysics().hasTag((String)object3)) {
            bl4 = true;
        }
        if (object3 == null) {
            object3 = "NonPhysics";
        }
        if ((object = (Object)hashMap.get(object3)) == null) {
            FlStringList flStringList = new FlStringList();
            FlStringList flStringList2 = new FlStringList();
            if (DEPVAR_TYPE.CONTROL == field.getType()) {
                flStringList2.add(string);
            } else {
                flStringList.add(string);
            }
            object = new VarGrp(flStringList.toArray(), flStringList2.toArray(), bl3);
            ((VarGrp)object).setCoupling(bl4);
            if (!bl4) {
                ((VarGrp)object).addPhysicsFieldID(string, field.getPhysicsFieldID());
            }
        } else {
            bl3 = bl3 && ((VarGrp)object).getMergable();
            ((VarGrp)object).setMergable(bl3);
            bl4 = bl4 && ((VarGrp)object).getCoupling();
            ((VarGrp)object).setCoupling(bl4);
            if (DEPVAR_TYPE.CONTROL == field.getType() && !FlStringUtil.contains((String[])((VarGrp)object).getControlVars(), (String)string)) {
                ((VarGrp)object).addControlVars(new String[]{string});
            } else if (!FlStringUtil.contains((String[])((VarGrp)object).getVars(), (String)string)) {
                ((VarGrp)object).addVars(new String[]{string});
            }
            if (!bl4) {
                ((VarGrp)object).addPhysicsFieldID(string, field.getPhysicsFieldID());
            }
        }
        hashMap.put((String)object3, (VarGrp)object);
    }

    /*
     * Unable to fully structure code
     */
    static String a(ModelEntity var0) {
        var1_1 = var0.getDerivedFrom();
        if (var1_1 != null && var1_1.getContainer() != null && var1_1.getContainer().getContainer() != null) ** GOTO lbl10
        return null;
lbl-1000:
        // 1 sources

        {
            if (var1_1 instanceof Physics || var1_1 instanceof MultiphysicsCoupling || var1_1 instanceof Frame) {
                return var1_1.tag();
            }
            if (var1_1 instanceof CommonFeature) {
                return ((CommonFeature)var1_1).getOperation().getFieldGroupTag();
            }
            if (var1_1 instanceof Model) break;
            var1_1 = (ModelEntity)var1_1.getContainer();
lbl10:
            // 2 sources

            ** while (var1_1 != null)
        }
lbl11:
        // 2 sources

        return null;
    }

    public static void cleanUpParametric(SolverFeature solverFeature, SolverType solverType) {
        String string;
        String string2 = solverType.equals((Object)SolverType.Transient) ? SolverOperationNames.Names.TIMEPARAM.getDefaultOpCode() : (string = solverType.equals((Object)SolverType.Eigenvalue) ? SolverOperationNames.Names.EIGPARAM.getDefaultOpCode() : SolverOperationNames.Names.PARAM.getDefaultOpCode());
        if (solverFeature.feature().index(string) > -1 && solverFeature.feature(string).isRemovable()) {
            solverFeature.feature().remove(string);
        }
    }

    public static SolverFeature createSolverFeature(SolverFeatureList solverFeatureList, SolverOperationNames.Names names) {
        if (solverFeatureList.getContainer() instanceof SolverSequence) {
            return ((SolverSequence)solverFeatureList.getContainer()).create(solverFeatureList.uniquetag(names.getOpCode()), names.getPrimaryName());
        }
        if (solverFeatureList.getContainer() instanceof SolverFeature) {
            return ((SolverFeature)solverFeatureList.getContainer()).create(solverFeatureList.uniquetag(names.getOpCode()), names.getPrimaryName());
        }
        return solverFeatureList.create(solverFeatureList.uniquetag(names.getOpCode()), names.getPrimaryName());
    }

    public static void resultWhileSolving(PropFeature propFeature, PropFeature propFeature2) {
        propFeature2.set("plot", propFeature.getString("plot"));
        String string = propFeature.getString("plotgroup");
        if (string != null) {
            propFeature2.set("plotgroup", string);
        }
        propFeature2.set("probesel", propFeature.getString("probesel"));
        propFeature2.set("probes", propFeature.getStringArray("probes"));
    }

    public static String[] physicsSolvedFor(StudyFeature studyFeature) {
        String string;
        Model model = studyFeature.getModel();
        FlStringList flStringList = new FlStringList();
        IAnalysisOperation iAnalysisOperation = (IAnalysisOperation)studyFeature.getOperation();
        for (Field object2 : model.field()) {
            if (!object2.isSolveFor() || iAnalysisOperation != null && !iAnalysisOperation.solveFor(object2)) continue;
            string = AutoSolverSuggestionUtil.a((ModelEntity)object2);
            if (string == null) {
                string = "NonPhysics";
            }
            flStringList.add(string);
        }
        for (Ode ode : model.ode()) {
            if (!ode.isSolveFor() || iAnalysisOperation != null && !iAnalysisOperation.solveFor(ode)) continue;
            string = AutoSolverSuggestionUtil.a((ModelEntity)ode);
            if (string == null) {
                string = "NonPhysics";
            }
            flStringList.add(string);
        }
        String[] stringArray = FlStringUtil.unique((String[])flStringList.toArray());
        return stringArray;
    }
}

