/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.automodeling;

import com.comsol.model.automodeling.AutoSolverType;
import com.comsol.model.automodeling.VarGrpNLSettings;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.PropFeatureList;
import com.comsol.model.dbimodel.SolverFeature;
import com.comsol.nativeutil.properties.de;
import com.comsol.util.methods.FlStringUtil;
import java.util.HashMap;

public interface IAutoSolverSuggestion {
    public double getHighPerformance();

    public de getSettings(SettingType var1);

    public de getTimeSettings();

    public de getEigSettings();

    public de getStationarySettings();

    public de getParametricSettings();

    public de getPreviousSettings();

    public de getNlinSettings(NlinType var1);

    public de getSegStepSettings();

    public de getVariableSettings();

    public de getStudyStepSettings();

    public VarGrpNLSettings[] getSegGroups();

    public LinSetting getLinSettings(LinType var1);

    public LinSetting getLinSettings(LinType var1, String var2);

    public String[] getAllLinSettings();

    public String getLinSolverName(String var1);

    public String getDefaultSolver();

    public de getAdvancedSettings();

    public de getLowerLimitSettings();

    public de getUpperLimitSettings();

    public de getOptSettings();

    public de getAdapSettings();

    public de getTAdapSettings();

    public de getRemeshSettings();

    public de getStopcondSettings();

    public String getAppl();

    public void setAppl(String var1);

    public void setJobParameters(String[] var1);

    public String[] getJobParameters();

    public AutoSolverType getType();

    public void clearVariableSettings();

    public void clearSegStepSettings();

    public void clearLinSettings();

    public int compareTo(IAutoSolverSuggestion var1);

    public HashMap<String, String> getVarsToLabel();

    public String getLabel();

    public String getPrevSolver();

    public void setPrevSolver(String var1);

    public Boolean getMergeable();

    public void setMergeable(Boolean var1);

    public int getMainGroupPosition();

    public static class LinSetting {
        public String[] feature;
        public String[] label;
        public de[] props;
        public LinSolverType linSolverType;

        private LinSetting(de[] deArray, String[] stringArray, String[] stringArray2, LinSolverType linSolverType) {
            if (deArray != null && stringArray != null && deArray.length != stringArray.length || deArray != null && stringArray2 != null && deArray.length != stringArray2.length || stringArray != null && stringArray2 != null && stringArray.length != stringArray2.length) {
                throw new IllegalStateException("All arrays must have same length");
            }
            this.feature = stringArray;
            this.props = deArray;
            this.label = stringArray2;
            this.linSolverType = linSolverType == null ? LinSolverType.standard : linSolverType;
        }

        private LinSetting(de[] deArray, String string, String string2, LinSolverType linSolverType) {
            this(deArray, string != null ? FlStringUtil.array((int)(deArray != null ? deArray.length : 1), (String)string) : null, string2 != null ? FlStringUtil.array((int)(deArray != null ? deArray.length : 1), (String)string2) : null, linSolverType);
        }

        public LinSetting(String string, de de2) {
            this(string, null, de2, null);
        }

        public LinSetting(String string, de de2, LinSolverType linSolverType) {
            this(string, null, de2, linSolverType);
        }

        public LinSetting(String string, String string2, de de2) {
            de[] deArray;
            if (de2 == null) {
                deArray = null;
            } else {
                de[] deArray2 = new de[1];
                deArray = deArray2;
                deArray2[0] = de2;
            }
            this(deArray, string, string2, null);
        }

        public LinSetting(String string, String string2, de de2, LinSolverType linSolverType) {
            de[] deArray;
            if (de2 == null) {
                deArray = null;
            } else {
                de[] deArray2 = new de[1];
                deArray = deArray2;
                deArray2[0] = de2;
            }
            this(deArray, string, string2, linSolverType);
        }

        public static LinSetting MultiPropFactory(String string, de[] deArray) {
            return LinSetting.MultiPropFactory(string, null, deArray);
        }

        public static LinSetting MultiPropFactory(String string, String string2, de[] deArray) {
            return new LinSetting(deArray, string, string2, null);
        }

        public static LinSetting MultiPropFactory(String[] stringArray, de[] deArray) {
            return LinSetting.MultiPropFactory(stringArray, null, deArray);
        }

        public static LinSetting MultiPropFactory(String[] stringArray, String[] stringArray2, de[] deArray) {
            return new LinSetting(deArray, stringArray, stringArray2, null);
        }

        public static LinSetting MultiPropFactory(String[] stringArray, String[] stringArray2, de[] deArray, LinSolverType linSolverType) {
            return new LinSetting(deArray, stringArray, stringArray2, linSolverType);
        }

        protected void a(SolverFeature solverFeature, int n2) {
            if (this.label == null) {
                return;
            }
            PrimitiveModelEntity primitiveModelEntity = solverFeature.getContainer();
            if (!(primitiveModelEntity instanceof PropFeatureList)) {
                return;
            }
            String string = ((PropFeatureList)primitiveModelEntity).getUniqueName(this.label[0]);
            solverFeature.label(string);
        }

        public String getPropKey() {
            StringBuilder stringBuilder = new StringBuilder();
            if (this.props != null) {
                int n2 = 0;
                while (n2 < this.props.length) {
                    stringBuilder.append(String.valueOf(this.feature[n2]) + this.props[n2].getKey());
                    ++n2;
                }
            }
            return stringBuilder.toString();
        }
    }

    public static enum LinSolverType {
        standard,
        schwarz,
        schur;

    }

    public static enum LinType {
        main,
        prefun,
        prefunpre,
        presmooth,
        presmoothpre,
        postsmooth,
        postsmoothpre,
        coarse,
        coarsepre,
        domain,
        domainpre,
        schur,
        schurpre;

    }

    public static enum NlinType {
        fullycoupled,
        segregated;

    }

    public static enum SettingType {
        time,
        eigenvalue,
        stationary,
        param,
        prev,
        vars,
        segstep,
        advanced,
        lowerlimit,
        upperlimit,
        opt,
        adap,
        tadap,
        remesh,
        stopcond,
        studystep;

    }
}

