/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.data;

import com.comsol.model.data.IBinarySerializer;
import com.comsol.model.data.IXMLSerializer;
import com.comsol.model.data.Node;
import com.comsol.model.data.Primitives;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class EnumSerializer
implements IBinarySerializer,
IXMLSerializer {
    private final Class<? extends Enum> a;
    private final Object[] b;

    EnumSerializer(Class<? extends Enum> clazz) {
        this.a = clazz;
        this.b = clazz.getEnumConstants();
    }

    @Override
    public boolean checkType(Primitives primitives, Object object) {
        return this.a == object.getClass();
    }

    @Override
    public String toAttribute(Primitives primitives, Object object) {
        return ((Enum)object).name();
    }

    @Override
    public Object fromAttribute(Primitives primitives, String string) {
        return Enum.valueOf(this.a, string);
    }

    @Override
    public void toBinary(Primitives primitives, DataOutputStream dataOutputStream, Object object) throws IOException {
        Enum enum_ = (Enum)object;
        dataOutputStream.writeInt(enum_.ordinal());
    }

    @Override
    public Object fromBinary(Node node, Primitives primitives, DataInputStream dataInputStream) throws IOException {
        int n2 = dataInputStream.readInt();
        return this.b[n2];
    }

    @Override
    public boolean isXMLBuilder() {
        return false;
    }

    @Override
    public Object construct() {
        throw new UnsupportedOperationException();
    }

    @Override
    public long checkSum(Primitives primitives, Object object) {
        Enum enum_ = (Enum)object;
        return enum_.ordinal() + 1000;
    }

    Class<? extends Enum> a() {
        return this.a;
    }
}

