/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ELEM_TYPES;
import com.comsol.model.dbimodel.ElemFeatureList;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.SelectionEntity;

@PrimitiveModelEntity.TypeDoc(value="Element feature")
public interface ElemFeature
extends SelectionEntity {
    public String getValue();

    public void setValue(String var1);

    public ELEM_TYPES getType();

    public void setType(ELEM_TYPES var1);

    public ElemFeatureList<? extends ElemFeature> getField();

    @PrimitiveModelEntity.MethodDoc(doc="Returns all element features from <code>field</code>", ret="List of element features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ElemFeatureList<? extends ElemFeature> field();

    @PrimitiveModelEntity.MethodDoc(doc="Returns an element feature from <code>field</code>", ret="Element feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ElemFeature field(@PrimitiveModelEntity.ParamDoc(name="name", doc="<code>field</code> tag") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns all element features from <code>pos</code>", ret="List of element features", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ElemFeatureList<? extends ElemFeature> pos();

    @PrimitiveModelEntity.MethodDoc(doc="Returns an element feature from <code>pos</code>", ret="Element feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ElemFeature pos(@PrimitiveModelEntity.ParamDoc(name="index", doc="Position index") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns a value from an element feature", ret="Value", type=PrimitiveModelEntity.MethodType.READ)
    public String value();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the value for an element feature", ret="Element feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ElemFeature value(@PrimitiveModelEntity.ParamDoc(name="value", doc="Value to set") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns true if a string value represents an expression", ret="true or false", type=PrimitiveModelEntity.MethodType.READ)
    public boolean isExpression();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the expression flag for a string value", ret="Element feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ElemFeature isExpression(@PrimitiveModelEntity.ParamDoc(name="isExpr", doc="Expression flag") boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns the value of the modifier flag. Seethe setModifier method for information about the supported flags.", ret="true or false", type=PrimitiveModelEntity.MethodType.READ)
    public boolean getModifier(@PrimitiveModelEntity.ParamDoc(name="bit", doc="Flag's bit position") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the modifier flags for this element. Internally, each flag represents a bitin an integer value. The meaning of each supported flag is summarized below, andin some contexts the flag isn't used.<br>Bit 0: Flag is true when a string value represents an expression. See also isExpression.<br>Bit 1: Use record in standard selection elements (default is set).<br>Bit 2: Use record in extra-dimension selection elements (default is cleared).<br>Bit 3: Flag is true when a string value represents a geometry tag.<br>", ret="Element feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ElemFeature setModifier(@PrimitiveModelEntity.ParamDoc(name="flag", doc="Flag's value") boolean var1, @PrimitiveModelEntity.ParamDoc(name="bit", doc="Flag's bit position") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a property to a string value in an element feature", ret="Element feature", type=PrimitiveModelEntity.MethodType.ACCESS)
    public ElemFeature set(@PrimitiveModelEntity.ParamDoc(name="name", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a property to a string vector value in an element feature", ret="Element feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ElemFeature set(@PrimitiveModelEntity.ParamDoc(name="name", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a property to a string vector value in an element feature", ret="Element feature", type=PrimitiveModelEntity.MethodType.WRITE)
    public ElemFeature set(@PrimitiveModelEntity.ParamDoc(name="name", doc="Property name") String var1, @PrimitiveModelEntity.ParamDoc(name="value", doc="Property value") String[][] var2);

    public void createReset(ElemFeature var1, boolean var2);
}

