/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.ExpressionEntity;
import com.comsol.model.dbimodel.MatchTagContainer;
import com.comsol.model.dbimodel.MultiphysicsContributor;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.dbimodel.XDLocalSelection;
import com.comsol.model.method.ExprMethod;

@PrimitiveModelEntity.TypeDoc(value="Variable collection")
public interface Expr
extends ExpressionEntity,
MatchTagContainer,
MultiphysicsContributor {
    public boolean isEdited();

    @Override
    public ExprMethod method();

    public void setEdited(boolean var1);

    public boolean isDisabled();

    public boolean setDisabled(boolean var1);

    @Override
    @PrimitiveModelEntity.MethodDoc(doc="Returns the variable collection selection", ret="Selection", type=PrimitiveModelEntity.MethodType.ACCESS)
    public XDLocalSelection selection();

    @PrimitiveModelEntity.MethodDoc(doc="Moves a variable to the variable feature with the given tag", ret="The variable feature the variable moved to.", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Expr move(@PrimitiveModelEntity.ParamDoc(name="varName", doc="Variable name") String var1, @PrimitiveModelEntity.ParamDoc(name="targetTag", doc="Target variable feature tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Moves variables to the variable feature with the given tag", ret="The variable feature the variables moved to.", type=PrimitiveModelEntity.MethodType.ACCESS)
    public Expr move(@PrimitiveModelEntity.ParamDoc(name="varNames", doc="Variable names") String[] var1, @PrimitiveModelEntity.ParamDoc(name="targetTag", doc="Target variable feature tag") String var2);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from a file using a specified delimiter.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use. Inputting an empty string means using the first sheet.") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell. Can be given as a cell coordinate (e.g. C3) of the top left cell, a range (e.g. C3:E10), or empty, in which case the sheet is read from the top left corner (A1).") String var3);

    @PrimitiveModelEntity.MethodDoc(doc="Loads from an Excel-file with a specified range to read, or a cell to start from, in the specified sheet.")
    public void loadFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var4);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to a file using a specified delimiter.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="delim", doc="Delimiter to use") char var2, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var3);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use. Inputting an empty string means using the first sheet.") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell. Can be given as a cell coordinate (e.g. C3) of the top left cell, a range (e.g. C3:E10), or empty, in which case the sheet is written from the top left corner (A1).") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5);

    @PrimitiveModelEntity.MethodDoc(doc="Saves to an Excel-file in a specified range, or at a cell to start from, in a specified sheet.")
    public void saveFile(@PrimitiveModelEntity.ParamDoc(name="path", doc="Path to file") String var1, @PrimitiveModelEntity.ParamDoc(name="sheet", doc="The Excel-sheet to use") String var2, @PrimitiveModelEntity.ParamDoc(name="range", doc="The range, or a starting cell") String var3, @PrimitiveModelEntity.ParamDoc(name="includeHeaders", doc="True if column headers are to be written") boolean var4, @PrimitiveModelEntity.ParamDoc(name="overwrite", doc="True if an existing file is to be overwritten, or if an error should be cast in that instance.") boolean var5, @PrimitiveModelEntity.ParamDoc(name="separateUnitColumns", doc="True to split expression columns into expression and unit") boolean var6);

    public int getSortedColumn();

    public void setSortedColumn(int var1);
}

