/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.Frame;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.savepoint.interfaces.IFrame;
import com.comsol.model.savepoint.interfaces.IGeomSequence;

public enum FrameType {
    mesh("Mesh_frame"),
    geometry("Geometry_frame"),
    material("Material_frame", "Material_coordinate", "Material_coordinate_x", "Material_mesh_displacement", "Material_mesh_displacement_x"),
    spatial("Spatial_frame", "Spatial_coordinate", "Spatial_coordinate_x", "Spatial_mesh_displacement", "Spatial_mesh_displacement_x");

    private final String descr;
    private final String coordinateDescr;
    private final String coordinateComponentDescr;
    private final String displacementDescr;
    private final String displacementComponentDescr;
    public static final FrameType[] VALUES;

    static {
        VALUES = FrameType.values();
    }

    private FrameType(String string2) {
        this(string2, null, null, null, null);
    }

    private FrameType(String string2, String string3, String string4, String string5, String string6) {
        this.descr = string2;
        this.coordinateDescr = string3;
        this.coordinateComponentDescr = string4;
        this.displacementDescr = string5;
        this.displacementComponentDescr = string6;
    }

    public String descr() {
        return this.descr;
    }

    public String getCoordinateDescr() {
        return this.coordinateDescr;
    }

    public String getCoordinateComponentDescr() {
        return this.coordinateComponentDescr;
    }

    public String getDisplacementDescr() {
        return this.displacementDescr;
    }

    public String getDisplacementComponentDescr() {
        return this.displacementComponentDescr;
    }

    public String getScope() {
        return this.name();
    }

    public static String[] getNames() {
        FrameType[] frameTypeArray = FrameType.values();
        String[] stringArray = new String[frameTypeArray.length];
        int n2 = 0;
        while (n2 < frameTypeArray.length) {
            stringArray[n2] = frameTypeArray[n2].name();
            ++n2;
        }
        return stringArray;
    }

    public Frame getFrame(GeomSequence geomSequence) {
        return (Frame)this.getFrame((IGeomSequence)geomSequence);
    }

    public IFrame getFrame(IGeomSequence iGeomSequence) {
        if (iGeomSequence != null) {
            switch (this) {
                case spatial: {
                    return iGeomSequence.getSpatialFrame();
                }
                case material: {
                    return iGeomSequence.getMaterialFrame();
                }
                case mesh: {
                    return iGeomSequence.getMeshFrame();
                }
                case geometry: {
                    return iGeomSequence.getGeometryFrame();
                }
            }
            throw new RuntimeException("Internal frame error.");
        }
        throw new RuntimeException("No frame defined for null geometries");
    }

    public String getFrameInfo(IGeomSequence iGeomSequence) {
        if (iGeomSequence == null) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        switch (this) {
            case spatial: {
                stringBuilder.append("_").append(this.name());
                if (this.isSplitFrames(material, iGeomSequence)) {
                    return stringBuilder.append("[frame]").toString();
                }
                if (material.isSplitFrames(geometry, iGeomSequence)) {
                    return stringBuilder.append("_").append(material.name()).append("[frame]").toString();
                }
                return "";
            }
            case material: {
                if (!spatial.isSplitFrames(material, iGeomSequence)) {
                    stringBuilder.append("_").append(spatial.name());
                    if (!this.isSplitFrames(geometry, iGeomSequence)) {
                        return "";
                    }
                    return stringBuilder.append("_").append(this.name()).append("[frame]").toString();
                }
                stringBuilder.append("_").append(this.name());
                if (!material.isSplitFrames(geometry, iGeomSequence)) {
                    stringBuilder.append("_").append(geometry.name());
                }
                return stringBuilder.append("[frame]").toString();
            }
            case geometry: {
                if (this.isSplitFrames(material, iGeomSequence)) {
                    return stringBuilder.append("_").append(this.name()).append("[frame]").toString();
                }
                if (spatial.isSplitFrames(material, iGeomSequence)) {
                    stringBuilder.append("_").append(material.name());
                    return stringBuilder.append("_").append(this.name()).append("[frame]").toString();
                }
                return "";
            }
            case mesh: {
                if (this.isSplitFrames(geometry, iGeomSequence)) {
                    return stringBuilder.append("_").append(mesh.name()).append("[frame]").toString();
                }
                return geometry.getFrameInfo(iGeomSequence);
            }
        }
        return "";
    }

    public boolean isSplitFrames(FrameType frameType, IGeomSequence iGeomSequence) {
        IFrame iFrame = this.getFrame(iGeomSequence);
        IFrame iFrame2 = frameType.getFrame(iGeomSequence);
        return iFrame.isSplitFromFrame(iFrame2);
    }

    public static FrameType getFrameType(IFrame iFrame) {
        if (iFrame.isMaterialFrame()) {
            return material;
        }
        if (iFrame.isGeometryFrame()) {
            return geometry;
        }
        if (iFrame.isMeshFrame()) {
            return mesh;
        }
        return spatial;
    }

    public static IFrame getFrame(IGeomSequence iGeomSequence, String string) {
        FrameType[] frameTypeArray = FrameType.values();
        int n2 = frameTypeArray.length;
        int n3 = 0;
        while (n3 < n2) {
            FrameType object = frameTypeArray[n3];
            if (object.name().equals(string)) {
                return object.getFrame(iGeomSequence);
            }
            ++n3;
        }
        for (IFrame iFrame : iGeomSequence.getModel().frame()) {
            if (!iFrame.tag().equals(string) || !iFrame.geom().equals(iGeomSequence.tag())) continue;
            return iFrame;
        }
        return null;
    }
}

