/*
 * Decompiled with CFR 0.152.
 */
package com.comsol.model.dbimodel;

import com.comsol.model.dbimodel.AbstractSelection;
import com.comsol.model.dbimodel.DrawObject;
import com.comsol.model.dbimodel.GeomEntitySet;
import com.comsol.model.dbimodel.GeomFeature;
import com.comsol.model.dbimodel.GeomObject;
import com.comsol.model.dbimodel.GeomSequence;
import com.comsol.model.dbimodel.PrimitiveModelEntity;
import com.comsol.model.selections.GeomObjectSelectionData;
import com.comsol.model.selections.GeomObjectSelectionMethod;
import com.comsol.model.util.DrawTopo;
import com.comsol.util.classes.an;
import com.comsol.util.exceptions.FlException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;

@PrimitiveModelEntity.TypeDoc(value="Geometry object selection")
public interface GeomObjectSelection
extends AbstractSelection {
    public static final int NICELOG_LIMIT = 5;

    public GeomObjectSelection getInternalSelection();

    public GeomSequence getGeom();

    public GeomFeature getOwner();

    public int getDim();

    public int[][] getMappedSelection(String var1, GeomObject[] var2, int var3, DrawTopo var4);

    public GeomObjectSelectionData getMappedSelection(String var1, DrawTopo var2);

    public int[][] getMappedSelection2(String var1, int[][] var2);

    public void mapSelectionToOtherDrawTopo(GeomObjectSelection var1);

    public int[] getMappedObjects(String var1, GeomObject[] var2);

    public GeomObject[] getMappedObjects(String var1);

    public int[] getMappedObjects2(String var1, int[][] var2);

    public int[][][] getMappedEntitiesFromObjectSelection(String var1, GeomObject[] var2);

    public int[] mapEntitiesToFinalizedGeometry(boolean var1);

    public int[][] mapToFinalizedGeometry(boolean var1);

    public boolean isPermissive();

    public void setPermissive(boolean var1);

    @PrimitiveModelEntity.MethodDoc(doc="If the selection is a set of geometry objects, return the names of the objects", ret="Vector of geometry object names", type=PrimitiveModelEntity.MethodType.READ)
    public String[] objects();

    @PrimitiveModelEntity.MethodDoc(doc="If the selection is on a geometry object, return the entities of the given dimension", ret="Vector of geometric entities", type=PrimitiveModelEntity.MethodType.ACCESS)
    public int[] entities(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Geometry object name") String var1, @PrimitiveModelEntity.ParamDoc(name="dim", doc="Dimension to analyze") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be an empty selection of whole objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection init();

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be an empty selection of geometric entities in the specified dimension", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection init(@PrimitiveModelEntity.ParamDoc(name="dim", doc="Entity dimension") int var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets a selection of whole objects to be the given objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection set(String ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Adds the given objects to a selection of whole objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection add(String ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the given objects from a selection of whole objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection remove(String ... var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be all entities of the given object. Does not affect the selection on other objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection all(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be all entities of the given objects. Does not affect the selection on other objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection all(@PrimitiveModelEntity.ParamDoc(name="onames", doc="Object names") String[] var1);

    public GeomObjectSelection allObjects(GeomObject[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection on given object to be an entity. Does not affect the selection on other objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be the given entities of the given object. Does not affect the selection on other objects", ret=" Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be the given entities of the given object. Does not affect the selection on other objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection set(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Sets the selection to be the given entities of the given objects. Does not affect the selection on other objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection set(@PrimitiveModelEntity.ParamDoc(name="onames", doc="Object names") String[] var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices for each object") int[][] var2);

    public GeomObjectSelection setNiceLog(String[] var1, int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Adds the entities to the selection on given object", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection add(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Adds the given entities of the given object to the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection add(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object names") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @PrimitiveModelEntity.MethodDoc(doc="Adds the entities to the selection on given objects", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection add(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String[] var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices for each object") int[][] var2);

    public GeomObjectSelection addNiceLog(String[] var1, int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the given entities of the given object from the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection remove(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entity", doc="Entity index") int var2, int ... var3);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the given entities of the given object from the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection remove(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices") int[] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Removes the given entities of the given objects from the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection remove(@PrimitiveModelEntity.ParamDoc(name="onames", doc="Object names") String[] var1, @PrimitiveModelEntity.ParamDoc(name="entities", doc="Entity indices for each object") int[][] var2);

    public GeomObjectSelection removeNiceLog(String[] var1, int[][] var2);

    @PrimitiveModelEntity.MethodDoc(doc="Clears all entities of the given object from the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection clear(@PrimitiveModelEntity.ParamDoc(name="oname", doc="Object name") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Clears all entities of the given objects from the selection.", ret="Geometry object selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection clear(@PrimitiveModelEntity.ParamDoc(name="onames", doc="Object name") String[] var1);

    public void copySelectionFrom(GeomObjectSelection var1);

    public LinkedHashSet<GeomFeature> getFeatures();

    public List<? extends DrawObject> getDrawObjects();

    public List<? extends GeomObject> getGeomObjects();

    public List<? extends GeomObject> getGeomObjectsInPrecedingState(String var1);

    public int[] getEntities(DrawObject var1);

    public int[][] getEntities(DrawObject[] var1);

    public int[][] getUnfilteredEntities(DrawObject[] var1);

    public void checkSingleObjectInFeatures();

    public void createReset(AbstractSelection var1, boolean var2);

    public void setAssocAdjInfo(Collection<GeomEntitySet> var1);

    public void expandContinuousTangentSelection();

    public int[][] entities(String[] var1, int var2);

    public boolean usesGroupByContTang();

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #init()} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public GeomObjectSelection object(String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Use {@link #init(int)} instead", type=PrimitiveModelEntity.MethodType.WRITE)
    @Deprecated
    public GeomObjectSelection object(String var1, int var2);

    @Override
    public GeomObjectSelectionMethod selectionMethod();

    public Iterable<? extends GeomEntitySet> getSetsReadOnly();

    public Iterable<? extends GeomEntitySet> getSetsForUpdate();

    public void removeInvalidSets(String var1);

    public GeomObjectSelection setObjects(GeomObject ... var1);

    public GeomObjectSelection setObjects(GeomObject[] var1, int[][] var2);

    public String objectEntKey(int[] var1);

    @PrimitiveModelEntity.MethodDoc(doc="Let the selection refer to a named selection. If selTag is empty, it means that the selection becomes manual, that is, it does no longer refer to a named selection.", ret="The selection", type=PrimitiveModelEntity.MethodType.WRITE)
    public GeomObjectSelection named(@PrimitiveModelEntity.ParamDoc(name="selTag", doc="Tag of named selection") String var1);

    @PrimitiveModelEntity.MethodDoc(doc="Returns named selection referred to. An empty string means that the selection is manual, that is, it does not refer to a named selection.", ret="Tag of named selection", type=PrimitiveModelEntity.MethodType.READ)
    public String named();

    public boolean isLocalSelection();

    public FlException updateToCurrentState();

    public void checkTouched(String var1);

    public void updateFromCGHandler(HashMap<an, HashSet<Integer>> var1, int var2);

    public void assocObjectUpdateFromCGHandler(int[][] var1);

    public DrawTopo getDrawTopo();

    public boolean selectsInvalidObject();

    public static class SelectionInfo {
        public String[] onames;
        public int[][] entities;
    }
}

